/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Observation10_30 {
    public static Observation convertObservation(org.hl7.fhir.dstu2.model.Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation tgt = new Observation();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation10_30.convertObservationStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_30.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_10_30.convertCodeableConcept(src.getInterpretation()));
        }
        if (src.hasCommentsElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentsElement()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_30.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_10_30.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_30.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_30.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Observation.ObservationRelatedComponent observationRelatedComponent : src.getRelated()) {
            tgt.addRelated(Observation10_30.convertObservationRelatedComponent(observationRelatedComponent));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation10_30.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Observation tgt = new org.hl7.fhir.dstu2.model.Observation();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Observation10_30.convertObservationStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_30.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_10_30.convertCodeableConcept(src.getInterpretation()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_10_30.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_10_30.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_10_30.convertReference(src.getDevice()));
        }
        for (Observation.ObservationReferenceRangeComponent observationReferenceRangeComponent : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_30.convertObservationReferenceRangeComponent(observationReferenceRangeComponent));
        }
        for (Observation.ObservationRelatedComponent observationRelatedComponent : src.getRelated()) {
            tgt.addRelated(Observation10_30.convertObservationRelatedComponent(observationRelatedComponent));
        }
        for (Observation.ObservationComponentComponent observationComponentComponent : src.getComponent()) {
            tgt.addComponent(Observation10_30.convertObservationComponentComponent(observationComponentComponent));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_30.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_30.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_10_30.convertCodeableConcept(src.getDataAbsentReason()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(Observation10_30.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_30.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasMeaning()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getMeaning()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_30.convertRange(src.getAge()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_30.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_30.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setMeaning(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_10_30.convertRange(src.getAge()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static Observation.ObservationRelatedComponent convertObservationRelatedComponent(Observation.ObservationRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Observation10_30.convertObservationRelationshipType(src.getTypeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static Observation.ObservationRelatedComponent convertObservationRelatedComponent(Observation.ObservationRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(Observation10_30.convertObservationRelationshipType(src.getTypeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_10_30.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationRelationshipType> convertObservationRelationshipType(Enumeration<Observation.ObservationRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationRelationshipType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationRelationshipType>(new Observation.ObservationRelationshipTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Observation.ObservationRelationshipType)((Object)src.getValue())) {
            case HASMEMBER: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.HASMEMBER);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.DERIVEDFROM);
                break;
            }
            case SEQUELTO: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.SEQUELTO);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.REPLACES);
                break;
            }
            case QUALIFIEDBY: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.QUALIFIEDBY);
                break;
            }
            case INTERFEREDBY: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.INTERFEREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Observation.ObservationRelationshipType> convertObservationRelationshipType(org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Observation.ObservationRelationshipType> tgt = new Enumeration<Observation.ObservationRelationshipType>(new Observation.ObservationRelationshipTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Observation.ObservationRelationshipType)((Object)src.getValue())) {
            case HASMEMBER: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.HASMEMBER);
                break;
            }
            case DERIVEDFROM: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.DERIVEDFROM);
                break;
            }
            case SEQUELTO: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.SEQUELTO);
                break;
            }
            case REPLACES: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.REPLACES);
                break;
            }
            case QUALIFIEDBY: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.QUALIFIEDBY);
                break;
            }
            case INTERFEREDBY: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.INTERFEREDBY);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Observation.ObservationStatus> convertObservationStatus(org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Observation.ObservationStatus> tgt = new Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> convertObservationStatus(Enumeration<Observation.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Observation.ObservationStatus>(new Observation.ObservationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Observation.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Observation.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Observation.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Observation.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Observation.ObservationStatus.AMENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Observation.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Observation.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Observation.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Observation.ObservationStatus.NULL);
            }
        }
        return tgt;
    }
}

