/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.NamingSystem;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;

public class NamingSystem10_30 {
    public static org.hl7.fhir.dstu3.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.NamingSystem tgt = new org.hl7.fhir.dstu3.model.NamingSystem();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem10_30.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (NamingSystem.NamingSystemContactComponent namingSystemContactComponent : src.getContact()) {
            tgt.addContact(NamingSystem10_30.convertNamingSystemContactComponent(namingSystemContactComponent));
        }
        if (src.hasResponsibleElement()) {
            tgt.setResponsibleElement(VersionConvertor_10_30.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeableConcept codeableConcept : src.getUseContext()) {
            if (VersionConvertor_10_30.isJurisdiction(codeableConcept)) {
                tgt.addJurisdiction(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
                continue;
            }
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConceptToUsageContext(codeableConcept));
        }
        if (src.hasUsageElement()) {
            tgt.setUsageElement(VersionConvertor_10_30.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem10_30.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        if (src.hasReplacedBy()) {
            tgt.setReplacedBy(VersionConvertor_10_30.convertReference(src.getReplacedBy()));
        }
        return tgt;
    }

    public static NamingSystem convertNamingSystem(org.hl7.fhir.dstu3.model.NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_30.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasKind()) {
            tgt.setKindElement(NamingSystem10_30.convertNamingSystemType(src.getKindElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_30.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_30.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(NamingSystem10_30.convertNamingSystemContactComponent(contactDetail));
        }
        if (src.hasResponsibleElement()) {
            tgt.setResponsibleElement(VersionConvertor_10_30.convertString(src.getResponsibleElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasUsageElement()) {
            tgt.setUsageElement(VersionConvertor_10_30.convertString(src.getUsageElement()));
        }
        for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : src.getUniqueId()) {
            tgt.addUniqueId(NamingSystem10_30.convertNamingSystemUniqueIdComponent(namingSystemUniqueIdComponent));
        }
        if (src.hasReplacedBy()) {
            tgt.setReplacedBy(VersionConvertor_10_30.convertReference(src.getReplacedBy()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemContactComponent convertNamingSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemContactComponent tgt = new NamingSystem.NamingSystemContactComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertNamingSystemContactComponent(NamingSystem.NamingSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.dstu2.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_30.convertContactPoint(t));
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> convertNamingSystemIdentifierType(Enumeration<NamingSystem.NamingSystemIdentifierType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemIdentifierType>(new NamingSystem.NamingSystemIdentifierTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((NamingSystem.NamingSystemIdentifierType)((Object)src.getValue())) {
            case OID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OID);
                break;
            }
            case UUID: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.UUID);
                break;
            }
            case URI: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.URI);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemIdentifierType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<NamingSystem.NamingSystemType> convertNamingSystemType(org.hl7.fhir.dstu3.model.Enumeration<NamingSystem.NamingSystemType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<NamingSystem.NamingSystemType> tgt = new Enumeration<NamingSystem.NamingSystemType>(new NamingSystem.NamingSystemTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((NamingSystem.NamingSystemType)((Object)src.getValue())) {
            case CODESYSTEM: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.CODESYSTEM);
                break;
            }
            case IDENTIFIER: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.IDENTIFIER);
                break;
            }
            case ROOT: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.ROOT);
                break;
            }
            default: {
                tgt.setValue((Object)NamingSystem.NamingSystemType.NULL);
            }
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem10_30.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_30.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasType()) {
            tgt.setTypeElement(NamingSystem10_30.convertNamingSystemIdentifierType(src.getTypeElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_30.convertString(src.getValueElement()));
        }
        if (src.hasPreferredElement()) {
            tgt.setPreferredElement(VersionConvertor_10_30.convertBoolean(src.getPreferredElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }
}

