/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class MedicationStatement10_30 {
    public static org.hl7.fhir.dstu3.model.MedicationStatement convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationStatement tgt = new org.hl7.fhir.dstu3.model.MedicationStatement();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement10_30.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_30.convertType(src.getMedication()));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_10_30.convertReference(src.getInformationSource()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSupportingInformation()) {
            tgt.addDerivedFrom(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_10_30.convertDateTime(src.getDateAssertedElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReasonNotTaken()) {
            tgt.addReasonNotTaken(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (MedicationStatement.MedicationStatementDosageComponent medicationStatementDosageComponent : src.getDosage()) {
            tgt.addDosage(MedicationStatement10_30.convertMedicationStatementDosageComponent(medicationStatementDosageComponent));
        }
        return tgt;
    }

    public static MedicationStatement convertMedicationStatement(org.hl7.fhir.dstu3.model.MedicationStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement10_30.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_10_30.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_10_30.convertReference(src.getInformationSource()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addSupportingInformation(VersionConvertor_10_30.convertReference(reference));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_10_30.convertDateTime(src.getDateAssertedElement()));
        }
        for (CodeableConcept codeableConcept : src.getReasonNotTaken()) {
            tgt.addReasonNotTaken(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.setNote(annotation.getText());
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(MedicationStatement10_30.convertMedicationStatementDosageComponent(dosage));
        }
        return tgt;
    }

    public static Dosage convertMedicationStatementDosageComponent(MedicationStatement.MedicationStatementDosageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_30.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationStatement.MedicationStatementDosageComponent convertMedicationStatementDosageComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement.MedicationStatementDosageComponent tgt = new MedicationStatement.MedicationStatementDosageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_30.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_30.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_30.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_10_30.convertType(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_30.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_30.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_10_30.convertType(src.getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_30.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

