/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;

public class Group10_30 {
    public static Group convertGroup(org.hl7.fhir.dstu3.model.Group src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group tgt = new Group();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Group10_30.convertGroupType(src.getTypeElement()));
        }
        if (src.hasActualElement()) {
            tgt.setActualElement(VersionConvertor_10_30.convertBoolean(src.getActualElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasQuantityElement()) {
            tgt.setQuantityElement(VersionConvertor_10_30.convertUnsignedInt(src.getQuantityElement()));
        }
        for (Group.GroupCharacteristicComponent groupCharacteristicComponent : src.getCharacteristic()) {
            tgt.addCharacteristic(Group10_30.convertGroupCharacteristicComponent(groupCharacteristicComponent));
        }
        for (Group.GroupMemberComponent groupMemberComponent : src.getMember()) {
            tgt.addMember(Group10_30.convertGroupMemberComponent(groupMemberComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Group convertGroup(Group src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Group tgt = new org.hl7.fhir.dstu3.model.Group();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Group10_30.convertGroupType(src.getTypeElement()));
        }
        if (src.hasActualElement()) {
            tgt.setActualElement(VersionConvertor_10_30.convertBoolean(src.getActualElement()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasQuantityElement()) {
            tgt.setQuantityElement(VersionConvertor_10_30.convertUnsignedInt(src.getQuantityElement()));
        }
        for (Group.GroupCharacteristicComponent groupCharacteristicComponent : src.getCharacteristic()) {
            tgt.addCharacteristic(Group10_30.convertGroupCharacteristicComponent(groupCharacteristicComponent));
        }
        for (Group.GroupMemberComponent groupMemberComponent : src.getMember()) {
            tgt.addMember(Group10_30.convertGroupMemberComponent(groupMemberComponent));
        }
        return tgt;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasExcludeElement()) {
            tgt.setExcludeElement(VersionConvertor_10_30.convertBoolean(src.getExcludeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_30.convertType(src.getValue()));
        }
        if (src.hasExcludeElement()) {
            tgt.setExcludeElement(VersionConvertor_10_30.convertBoolean(src.getExcludeElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactiveElement()) {
            tgt.setInactiveElement(VersionConvertor_10_30.convertBoolean(src.getInactiveElement()));
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_10_30.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_30.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactiveElement()) {
            tgt.setInactiveElement(VersionConvertor_10_30.convertBoolean(src.getInactiveElement()));
        }
        return tgt;
    }

    public static Enumeration<Group.GroupType> convertGroupType(org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Group.GroupType> tgt = new Enumeration<Group.GroupType>(new Group.GroupTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Group.GroupType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)Group.GroupType.PERSON);
                break;
            }
            case ANIMAL: {
                tgt.setValue((Object)Group.GroupType.ANIMAL);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Group.GroupType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Group.GroupType.DEVICE);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)Group.GroupType.MEDICATION);
                break;
            }
            case SUBSTANCE: {
                tgt.setValue((Object)Group.GroupType.SUBSTANCE);
                break;
            }
            default: {
                tgt.setValue((Object)Group.GroupType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> convertGroupType(Enumeration<Group.GroupType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Group.GroupType>(new Group.GroupTypeEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Group.GroupType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)Group.GroupType.PERSON);
                break;
            }
            case ANIMAL: {
                tgt.setValue((Object)Group.GroupType.ANIMAL);
                break;
            }
            case PRACTITIONER: {
                tgt.setValue((Object)Group.GroupType.PRACTITIONER);
                break;
            }
            case DEVICE: {
                tgt.setValue((Object)Group.GroupType.DEVICE);
                break;
            }
            case MEDICATION: {
                tgt.setValue((Object)Group.GroupType.MEDICATION);
                break;
            }
            case SUBSTANCE: {
                tgt.setValue((Object)Group.GroupType.SUBSTANCE);
                break;
            }
            default: {
                tgt.setValue((Object)Group.GroupType.NULL);
            }
        }
        return tgt;
    }
}

