/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.DiagnosticReport;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class DiagnosticReport10_30 {
    public static DiagnosticReport convertDiagnosticReport(org.hl7.fhir.dstu3.model.DiagnosticReport src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport tgt = new DiagnosticReport();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport10_30.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertInstant(src.getIssuedElement()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addRequest(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getResult()) {
            tgt.addResult(VersionConvertor_10_30.convertReference(reference));
        }
        for (Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_10_30.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : src.getImage()) {
            tgt.addImage(DiagnosticReport10_30.convertDiagnosticReportImageComponent(diagnosticReportImageComponent));
        }
        if (src.hasConclusionElement()) {
            tgt.setConclusionElement(VersionConvertor_10_30.convertString(src.getConclusionElement()));
        }
        for (CodeableConcept codeableConcept : src.getCodedDiagnosis()) {
            tgt.addCodedDiagnosis(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_10_30.convertAttachment(attachment));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DiagnosticReport convertDiagnosticReport(DiagnosticReport src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DiagnosticReport tgt = new org.hl7.fhir.dstu3.model.DiagnosticReport();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(DiagnosticReport10_30.convertDiagnosticReportStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_10_30.convertType(src.getEffective()));
        }
        if (src.hasIssuedElement()) {
            tgt.setIssuedElement(VersionConvertor_10_30.convertInstant(src.getIssuedElement()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getRequest()) {
            tgt.addBasedOn(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getResult()) {
            tgt.addResult(VersionConvertor_10_30.convertReference(reference));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_10_30.convertReference(reference));
        }
        for (DiagnosticReport.DiagnosticReportImageComponent diagnosticReportImageComponent : src.getImage()) {
            tgt.addImage(DiagnosticReport10_30.convertDiagnosticReportImageComponent(diagnosticReportImageComponent));
        }
        if (src.hasConclusionElement()) {
            tgt.setConclusionElement(VersionConvertor_10_30.convertString(src.getConclusionElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getCodedDiagnosis()) {
            tgt.addCodedDiagnosis(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu2.model.Attachment attachment : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_10_30.convertAttachment(attachment));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportImageComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportImageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport.DiagnosticReportImageComponent tgt = new DiagnosticReport.DiagnosticReportImageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_10_30.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportImageComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportImageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport.DiagnosticReportImageComponent tgt = new DiagnosticReport.DiagnosticReportImageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasCommentElement()) {
            tgt.setCommentElement(VersionConvertor_10_30.convertString(src.getCommentElement()));
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_10_30.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DiagnosticReport.DiagnosticReportStatus> convertDiagnosticReportStatus(org.hl7.fhir.dstu3.model.Enumeration<DiagnosticReport.DiagnosticReportStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DiagnosticReport.DiagnosticReportStatus> tgt = new Enumeration<DiagnosticReport.DiagnosticReportStatus>(new DiagnosticReport.DiagnosticReportStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((DiagnosticReport.DiagnosticReportStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.REGISTERED);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.PARTIAL);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.FINAL);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CORRECTED);
                break;
            }
            case APPENDED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.APPENDED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DiagnosticReport.DiagnosticReportStatus.NULL);
            }
        }
        return tgt;
    }
}

