/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;

public class Device10_30 {
    public static org.hl7.fhir.dstu2.model.Device convertDevice(Device src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Device tgt = new org.hl7.fhir.dstu2.model.Device();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasUdi()) {
            tgt.setUdi(src.getUdi().getDeviceIdentifier());
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device10_30.convertDeviceStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasLotNumberElement()) {
            tgt.setLotNumberElement(VersionConvertor_10_30.convertString(src.getLotNumberElement()));
        }
        if (src.hasManufacturerElement()) {
            tgt.setManufacturerElement(VersionConvertor_10_30.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDateElement()) {
            tgt.setManufactureDateElement(VersionConvertor_10_30.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpirationDateElement()) {
            tgt.setExpiryElement(VersionConvertor_10_30.convertDateTime(src.getExpirationDateElement()));
        }
        if (src.hasModelElement()) {
            tgt.setModelElement(VersionConvertor_10_30.convertString(src.getModelElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(VersionConvertor_10_30.convertReference(src.getOwner()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_10_30.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Device convertDevice(org.hl7.fhir.dstu2.model.Device src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Device tgt = new Device();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasUdi()) {
            tgt.setUdi(new Device.DeviceUdiComponent().setDeviceIdentifier(src.getUdi()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Device10_30.convertDeviceStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasLotNumberElement()) {
            tgt.setLotNumberElement(VersionConvertor_10_30.convertString(src.getLotNumberElement()));
        }
        if (src.hasManufacturerElement()) {
            tgt.setManufacturerElement(VersionConvertor_10_30.convertString(src.getManufacturerElement()));
        }
        if (src.hasManufactureDateElement()) {
            tgt.setManufactureDateElement(VersionConvertor_10_30.convertDateTime(src.getManufactureDateElement()));
        }
        if (src.hasExpiryElement()) {
            tgt.setExpirationDateElement(VersionConvertor_10_30.convertDateTime(src.getExpiryElement()));
        }
        if (src.hasModelElement()) {
            tgt.setModelElement(VersionConvertor_10_30.convertString(src.getModelElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_30.convertString(src.getVersionElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(VersionConvertor_10_30.convertReference(src.getOwner()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(VersionConvertor_10_30.convertContactPoint(contactPoint));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_10_30.convertReference(src.getLocation()));
        }
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_30.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.dstu2.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_10_30.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> convertDeviceStatus(Enumeration<Device.DeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus>(new Device.FHIRDeviceStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Device.DeviceStatus)((Object)src.getValue())) {
            case AVAILABLE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ACTIVE);
                break;
            }
            case NOTAVAILABLE: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Device.FHIRDeviceStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Device.DeviceStatus> convertDeviceStatus(org.hl7.fhir.dstu3.model.Enumeration<Device.FHIRDeviceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Device.DeviceStatus> tgt = new Enumeration<Device.DeviceStatus>(new Device.DeviceStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Device.FHIRDeviceStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Device.DeviceStatus.AVAILABLE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Device.DeviceStatus.NOTAVAILABLE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Device.DeviceStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Device.DeviceStatus.NULL);
            }
        }
        return tgt;
    }
}

