/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Condition10_30 {
    public static Condition convertCondition(org.hl7.fhir.dstu2.model.Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition tgt = new Condition();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasPatient()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_10_30.convertReference(src.getAsserter()));
        }
        if (src.hasDateRecorded()) {
            tgt.setAssertedDate(src.getDateRecorded());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        try {
            if (src.hasClinicalStatus()) {
                tgt.setClinicalStatus(Condition.ConditionClinicalStatus.fromCode(src.getClinicalStatus()));
            }
        }
        catch (FHIRException e) {
            throw new FHIRException(e);
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatusElement(Condition10_30.convertConditionVerificationStatus(src.getVerificationStatusElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_10_30.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_30.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_10_30.convertType(src.getAbatement()));
        }
        if (src.hasStage()) {
            tgt.setStage(Condition10_30.convertConditionStageComponent(src.getStage()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition10_30.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Condition tgt = new org.hl7.fhir.dstu2.model.Condition();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasSubject()) {
            tgt.setPatient(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_10_30.convertReference(src.getAsserter()));
        }
        if (src.hasAssertedDate()) {
            tgt.setDateRecorded(src.getAssertedDate());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        tgt.setClinicalStatus(src.getClinicalStatus().toCode());
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatusElement(Condition10_30.convertConditionVerificationStatus(src.getVerificationStatusElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_10_30.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_10_30.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_10_30.convertType(src.getAbatement()));
        }
        if (src.hasStage()) {
            tgt.setStage(Condition10_30.convertConditionStageComponent(src.getStage()));
        }
        for (Condition.ConditionEvidenceComponent conditionEvidenceComponent : src.getEvidence()) {
            tgt.addEvidence(Condition10_30.convertConditionEvidenceComponent(conditionEvidenceComponent));
        }
        for (CodeableConcept codeableConcept : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        for (CodeableConcept cc : src.getCode()) {
            tgt.setCode(VersionConvertor_10_30.convertCodeableConcept(cc));
        }
        for (Reference t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasCode()) {
            tgt.addCode(VersionConvertor_10_30.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_10_30.convertCodeableConcept(src.getSummary()));
        }
        for (org.hl7.fhir.dstu2.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_10_30.convertCodeableConcept(src.getSummary()));
        }
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_10_30.convertReference(t));
        }
        return tgt;
    }

    public static Enumeration<Condition.ConditionVerificationStatus> convertConditionVerificationStatus(org.hl7.fhir.dstu3.model.Enumeration<Condition.ConditionVerificationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Condition.ConditionVerificationStatus> tgt = new Enumeration<Condition.ConditionVerificationStatus>(new Condition.ConditionVerificationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Condition.ConditionVerificationStatus)((Object)src.getValue())) {
            case PROVISIONAL: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.PROVISIONAL);
                break;
            }
            case DIFFERENTIAL: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.DIFFERENTIAL);
                break;
            }
            case CONFIRMED: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.CONFIRMED);
                break;
            }
            case REFUTED: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.REFUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Condition.ConditionVerificationStatus> convertConditionVerificationStatus(Enumeration<Condition.ConditionVerificationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Condition.ConditionVerificationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Condition.ConditionVerificationStatus>(new Condition.ConditionVerificationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Condition.ConditionVerificationStatus)((Object)src.getValue())) {
            case PROVISIONAL: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.PROVISIONAL);
                break;
            }
            case DIFFERENTIAL: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.DIFFERENTIAL);
                break;
            }
            case CONFIRMED: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.CONFIRMED);
                break;
            }
            case REFUTED: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.REFUTED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Condition.ConditionVerificationStatus.NULL);
            }
        }
        return tgt;
    }
}

