/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.CommunicationRequest;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class CommunicationRequest10_30 {
    public static CommunicationRequest convertCommunicationRequest(org.hl7.fhir.dstu3.model.CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest tgt = new CommunicationRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_30.convertReference(src.getSender()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest10_30.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        tgt.setRequester(VersionConvertor_10_30.convertReference(src.getRequester().getAgent()));
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest10_30.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setScheduled(VersionConvertor_10_30.convertType(src.getOccurrence()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAuthoredOnElement()) {
            tgt.setRequestedOnElement(VersionConvertor_10_30.convertDateTime(src.getAuthoredOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CommunicationRequest10_30.convertPriorityCode(src.getPriority()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CommunicationRequest convertCommunicationRequest(CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CommunicationRequest tgt = new org.hl7.fhir.dstu3.model.CommunicationRequest();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_30.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        for (CommunicationRequest.CommunicationRequestPayloadComponent communicationRequestPayloadComponent : src.getPayload()) {
            tgt.addPayload(CommunicationRequest10_30.convertCommunicationRequestPayloadComponent(communicationRequestPayloadComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        tgt.getRequester().setAgent(VersionConvertor_10_30.convertReference(src.getRequester()));
        if (src.hasStatus()) {
            tgt.setStatusElement(CommunicationRequest10_30.convertCommunicationRequestStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasScheduled()) {
            tgt.setOccurrence(VersionConvertor_10_30.convertType(src.getScheduled()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasRequestedOnElement()) {
            tgt.setAuthoredOnElement(VersionConvertor_10_30.convertDateTime(src.getRequestedOnElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(CommunicationRequest10_30.convertPriorityCode(src.getPriority()));
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CommunicationRequest.CommunicationRequestStatus> convertCommunicationRequestStatus(Enumeration<CommunicationRequest.CommunicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CommunicationRequest.CommunicationRequestStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CommunicationRequest.CommunicationRequestStatus>(new CommunicationRequest.CommunicationRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((CommunicationRequest.CommunicationRequestStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.DRAFT);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case REQUESTED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case RECEIVED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.SUSPENDED);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CommunicationRequest.CommunicationRequestStatus> convertCommunicationRequestStatus(org.hl7.fhir.dstu3.model.Enumeration<CommunicationRequest.CommunicationRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CommunicationRequest.CommunicationRequestStatus> tgt = new Enumeration<CommunicationRequest.CommunicationRequestStatus>(new CommunicationRequest.CommunicationRequestStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((CommunicationRequest.CommunicationRequestStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.SUSPENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)CommunicationRequest.CommunicationRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CodeableConcept convertPriorityCode(CommunicationRequest.CommunicationPriority priority) {
        org.hl7.fhir.dstu2.model.CodeableConcept cc = new org.hl7.fhir.dstu2.model.CodeableConcept();
        switch (priority) {
            case ROUTINE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("routine");
                break;
            }
            case URGENT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("urgent");
                break;
            }
            case STAT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("stat");
                break;
            }
            case ASAP: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("asap");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public static CommunicationRequest.CommunicationPriority convertPriorityCode(org.hl7.fhir.dstu2.model.CodeableConcept priority) {
        for (Coding c : priority.getCoding()) {
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "routine".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.ROUTINE;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "urgent".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.URGENT;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "stat".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.STAT;
            }
            if (!"http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) || !"asap".equals(c.getCode())) continue;
            return CommunicationRequest.CommunicationPriority.ASAP;
        }
        return null;
    }
}

