/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;

public class Communication10_30 {
    public static Communication convertCommunication(org.hl7.fhir.dstu2.model.Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication tgt = new Communication();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_30.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.dstu2.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication10_30.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication10_30.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_10_30.convertReference(src.getEncounter()));
        }
        if (src.hasSentElement()) {
            tgt.setSentElement(VersionConvertor_10_30.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceivedElement()) {
            tgt.setReceivedElement(VersionConvertor_10_30.convertDateTime(src.getReceivedElement()));
        }
        for (org.hl7.fhir.dstu2.model.CodeableConcept codeableConcept : src.getReason()) {
            tgt.addReasonCode(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Communication tgt = new org.hl7.fhir.dstu2.model.Communication();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(identifier));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_10_30.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_10_30.convertReference(src.getSender()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_10_30.convertReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication10_30.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Communication10_30.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_10_30.convertReference(src.getContext()));
        }
        if (src.hasSentElement()) {
            tgt.setSentElement(VersionConvertor_10_30.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceivedElement()) {
            tgt.setReceivedElement(VersionConvertor_10_30.convertDateTime(src.getReceivedElement()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_10_30.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_10_30.copyElement(src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_10_30.copyElement(src, tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_10_30.convertType(src.getContent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus>(new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Communication.CommunicationStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Communication.CommunicationStatus.SUSPENDED);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Communication.CommunicationStatus.ENTEREDINERROR);
                break;
            }
            case FAILED: {
                tgt.setValue((Object)Communication.CommunicationStatus.ABORTED);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Communication.CommunicationStatus> tgt = new Enumeration<Communication.CommunicationStatus>(new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Communication.CommunicationStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Communication.CommunicationStatus.SUSPENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Communication.CommunicationStatus.REJECTED);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)Communication.CommunicationStatus.FAILED);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }
}

