/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_30;

import org.hl7.fhir.convertors.VersionConvertor_10_30;
import org.hl7.fhir.dstu2.model.Account;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;

public class Account10_30 {
    public static Account convertAccount(org.hl7.fhir.dstu3.model.Account src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Account tgt = new Account();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account10_30.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasActive()) {
            tgt.setActivePeriod(VersionConvertor_10_30.convertPeriod(src.getActive()));
        }
        if (src.hasBalance()) {
            tgt.setBalance(VersionConvertor_10_30.convertMoney(src.getBalance()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(VersionConvertor_10_30.convertReference(src.getOwner()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Account convertAccount(Account src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Account tgt = new org.hl7.fhir.dstu3.model.Account();
        VersionConvertor_10_30.copyDomainResource(src, tgt);
        for (org.hl7.fhir.dstu2.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_10_30.convertIdentifier(t));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_10_30.convertString(src.getNameElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_30.convertCodeableConcept(src.getType()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Account10_30.convertAccountStatus(src.getStatusElement()));
        }
        if (src.hasActivePeriod()) {
            tgt.setActive(VersionConvertor_10_30.convertPeriod(src.getActivePeriod()));
        }
        if (src.hasBalance()) {
            tgt.setBalance(VersionConvertor_10_30.convertMoney(src.getBalance()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_10_30.convertReference(src.getSubject()));
        }
        if (src.hasOwner()) {
            tgt.setOwner(VersionConvertor_10_30.convertReference(src.getOwner()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_30.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> convertAccountStatus(Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Account.AccountStatus> convertAccountStatus(org.hl7.fhir.dstu3.model.Enumeration<Account.AccountStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Account.AccountStatus> tgt = new Enumeration<Account.AccountStatus>(new Account.AccountStatusEnumFactory());
        VersionConvertor_10_30.copyElement(src, tgt);
        switch ((Account.AccountStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Account.AccountStatus.INACTIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Account.AccountStatus.NULL);
            }
        }
        return tgt;
    }
}

