/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertorAdvisor50;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.convertors.conv10_50.Appointment10_50;
import org.hl7.fhir.convertors.conv10_50.AppointmentResponse10_50;
import org.hl7.fhir.convertors.conv10_50.AuditEvent10_50;
import org.hl7.fhir.convertors.conv10_50.Basic10_50;
import org.hl7.fhir.convertors.conv10_50.Binary10_50;
import org.hl7.fhir.convertors.conv10_50.Bundle10_50;
import org.hl7.fhir.convertors.conv10_50.CarePlan10_50;
import org.hl7.fhir.convertors.conv10_50.Communication10_50;
import org.hl7.fhir.convertors.conv10_50.CommunicationRequest10_50;
import org.hl7.fhir.convertors.conv10_50.Composition10_50;
import org.hl7.fhir.convertors.conv10_50.ConceptMap10_50;
import org.hl7.fhir.convertors.conv10_50.Condition10_50;
import org.hl7.fhir.convertors.conv10_50.Conformance10_50;
import org.hl7.fhir.convertors.conv10_50.DataElement10_50;
import org.hl7.fhir.convertors.conv10_50.DetectedIssue10_50;
import org.hl7.fhir.convertors.conv10_50.DeviceMetric10_50;
import org.hl7.fhir.convertors.conv10_50.DeviceUseStatement10_50;
import org.hl7.fhir.convertors.conv10_50.DiagnosticReport10_50;
import org.hl7.fhir.convertors.conv10_50.DocumentReference10_50;
import org.hl7.fhir.convertors.conv10_50.Encounter10_50;
import org.hl7.fhir.convertors.conv10_50.EnrollmentRequest10_50;
import org.hl7.fhir.convertors.conv10_50.EnrollmentResponse10_50;
import org.hl7.fhir.convertors.conv10_50.EpisodeOfCare10_50;
import org.hl7.fhir.convertors.conv10_50.FamilyMemberHistory10_50;
import org.hl7.fhir.convertors.conv10_50.Flag10_50;
import org.hl7.fhir.convertors.conv10_50.Group10_50;
import org.hl7.fhir.convertors.conv10_50.HealthcareService10_50;
import org.hl7.fhir.convertors.conv10_50.ImplementationGuide10_50;
import org.hl7.fhir.convertors.conv10_50.List10_50;
import org.hl7.fhir.convertors.conv10_50.Location10_50;
import org.hl7.fhir.convertors.conv10_50.MedicationDispense10_50;
import org.hl7.fhir.convertors.conv10_50.MedicationStatement10_50;
import org.hl7.fhir.convertors.conv10_50.MessageHeader10_50;
import org.hl7.fhir.convertors.conv10_50.NamingSystem10_50;
import org.hl7.fhir.convertors.conv10_50.Observation10_50;
import org.hl7.fhir.convertors.conv10_50.OperationDefinition10_50;
import org.hl7.fhir.convertors.conv10_50.OperationOutcome10_50;
import org.hl7.fhir.convertors.conv10_50.Organization10_50;
import org.hl7.fhir.convertors.conv10_50.Parameters10_50;
import org.hl7.fhir.convertors.conv10_50.Patient10_50;
import org.hl7.fhir.convertors.conv10_50.Person10_50;
import org.hl7.fhir.convertors.conv10_50.Practitioner10_50;
import org.hl7.fhir.convertors.conv10_50.Provenance10_50;
import org.hl7.fhir.convertors.conv10_50.Questionnaire10_50;
import org.hl7.fhir.convertors.conv10_50.QuestionnaireResponse10_50;
import org.hl7.fhir.convertors.conv10_50.RiskAssessment10_50;
import org.hl7.fhir.convertors.conv10_50.Schedule10_50;
import org.hl7.fhir.convertors.conv10_50.SearchParameter10_50;
import org.hl7.fhir.convertors.conv10_50.Slot10_50;
import org.hl7.fhir.convertors.conv10_50.StructureDefinition10_50;
import org.hl7.fhir.convertors.conv10_50.Substance10_50;
import org.hl7.fhir.convertors.conv10_50.SupplyDelivery10_50;
import org.hl7.fhir.convertors.conv10_50.SupplyRequest10_50;
import org.hl7.fhir.convertors.conv10_50.TestScript10_50;
import org.hl7.fhir.convertors.conv10_50.ValueSet10_50;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Age;
import org.hl7.fhir.dstu2.model.Appointment;
import org.hl7.fhir.dstu2.model.AppointmentResponse;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.Base64BinaryType;
import org.hl7.fhir.dstu2.model.Basic;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.CarePlan;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Communication;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Count;
import org.hl7.fhir.dstu2.model.DataElement;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DetectedIssue;
import org.hl7.fhir.dstu2.model.DeviceMetric;
import org.hl7.fhir.dstu2.model.DeviceUseStatement;
import org.hl7.fhir.dstu2.model.Distance;
import org.hl7.fhir.dstu2.model.DocumentManifest;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnrollmentResponse;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.EpisodeOfCare;
import org.hl7.fhir.dstu2.model.Flag;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.List_;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.MedicationOrder;
import org.hl7.fhir.dstu2.model.MedicationStatement;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.OperationDefinition;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Provenance;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.Ratio;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RiskAssessment;
import org.hl7.fhir.dstu2.model.Signature;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.Slot;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.SupplyRequest;
import org.hl7.fhir.dstu2.model.TestScript;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.UuidType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_10_50 {
    public static List<String> CANONICAL_URLS = new ArrayList<String>();

    public static void copyElement(org.hl7.fhir.dstu2.model.Element src, Element tgt, String ... extensionsToIgnore) throws FHIRException {
        tgt.setId(src.getId());
        for (org.hl7.fhir.dstu2.model.Extension e : src.getExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_10_50.convertExtension(e));
        }
    }

    public static void copyElement(Element src, org.hl7.fhir.dstu2.model.Element tgt, String ... extensionsToIgnore) throws FHIRException {
        tgt.setId(src.getId());
        for (Extension e : src.getExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_10_50.convertExtension(e));
        }
    }

    public static void copyElement(DomainResource src, org.hl7.fhir.dstu2.model.Element tgt, String ... extensionsToIgnore) throws FHIRException {
        tgt.setId(src.getId());
        for (Extension e : src.getExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(e.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_10_50.convertExtension(e));
        }
    }

    public static org.hl7.fhir.r5.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.r5.model.Base64BinaryType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.Base64BinaryType((byte[])src.getValue()) : new org.hl7.fhir.r5.model.Base64BinaryType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.r5.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = src.hasValue() ? new Base64BinaryType(src.getValue()) : new Base64BinaryType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.dstu2.model.BooleanType src) throws FHIRException {
        BooleanType tgt = src.hasValue() ? new BooleanType((Boolean)src.getValue()) : new BooleanType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.BooleanType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.BooleanType((Boolean)src.getValue()) : new org.hl7.fhir.dstu2.model.BooleanType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.CodeType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.CodeType((String)src.getValue()) : new org.hl7.fhir.r5.model.CodeType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.r5.model.CodeType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UriType convertCodeToUri(CodeType src) throws FHIRException {
        org.hl7.fhir.r5.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UriType((String)src.getValue()) : new org.hl7.fhir.r5.model.UriType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static CodeType convertUriToCode(org.hl7.fhir.r5.model.UriType src) throws FHIRException {
        CodeType tgt = src.hasValue() ? new CodeType((String)src.getValue()) : new CodeType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu2.model.DateType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu2.model.DateTimeType src) throws FHIRException {
        DateType tgt = src.hasValue() ? new DateType(src.getValueAsString()) : new DateType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateToDateTime(org.hl7.fhir.dstu2.model.DateType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateType convertDateTimeToDate(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateType convertDate(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu2.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = src.hasValue() ? new DateTimeType(src.getValueAsString()) : new DateTimeType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.DateTimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.DateTimeType(src.getValueAsString()) : new org.hl7.fhir.dstu2.model.DateTimeType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.r5.model.DecimalType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.DecimalType((BigDecimal)src.getValue()) : new org.hl7.fhir.r5.model.DecimalType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.r5.model.DecimalType src) throws FHIRException {
        DecimalType tgt = src.hasValue() ? new DecimalType((BigDecimal)src.getValue()) : new DecimalType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu2.model.IdType src) throws FHIRException {
        IdType tgt = src.hasValue() ? new IdType(src.getValue()) : new IdType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.IdType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.IdType(src.getValue()) : new org.hl7.fhir.dstu2.model.IdType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu2.model.InstantType src) throws FHIRException {
        InstantType tgt = src.hasValue() ? new InstantType((Date)src.getValue()) : new InstantType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.InstantType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.InstantType((Date)src.getValue()) : new org.hl7.fhir.dstu2.model.InstantType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.dstu2.model.IntegerType src) throws FHIRException {
        IntegerType tgt = src.hasValue() ? new IntegerType((Integer)src.getValue()) : new IntegerType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.IntegerType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.IntegerType((Integer)src.getValue()) : new org.hl7.fhir.dstu2.model.IntegerType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.dstu2.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = src.hasValue() ? new MarkdownType((String)src.getValue()) : new MarkdownType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.MarkdownType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.MarkdownType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.MarkdownType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu2.model.OidType src) throws FHIRException {
        OidType tgt = src.hasValue() ? new OidType((String)src.getValue()) : new OidType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.OidType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.OidType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.OidType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.r5.model.PositiveIntType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.PositiveIntType((Integer)src.getValue()) : new org.hl7.fhir.r5.model.PositiveIntType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.r5.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = src.hasValue() ? new PositiveIntType((Integer)src.getValue()) : new PositiveIntType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu2.model.StringType src) throws FHIRException {
        StringType tgt = src.hasValue() ? new StringType((String)src.getValue()) : new StringType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.StringType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.StringType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.StringType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu2.model.TimeType src) throws FHIRException {
        TimeType tgt = src.hasValue() ? new TimeType((String)src.getValue()) : new TimeType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.TimeType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.TimeType((String)src.getValue()) : new org.hl7.fhir.dstu2.model.TimeType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu2.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = src.hasValue() ? new UnsignedIntType((Integer)src.getValue()) : new UnsignedIntType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu2.model.UnsignedIntType tgt = src.hasValue() ? new org.hl7.fhir.dstu2.model.UnsignedIntType((Integer)src.getValue()) : new org.hl7.fhir.dstu2.model.UnsignedIntType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.r5.model.UriType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UriType((String)src.getValue()) : new org.hl7.fhir.r5.model.UriType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.r5.model.UriType src) throws FHIRException {
        UriType tgt = src.hasValue() ? new UriType((String)src.getValue()) : new UriType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static org.hl7.fhir.r5.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r5.model.UuidType tgt = src.hasValue() ? new org.hl7.fhir.r5.model.UuidType((String)src.getValue()) : new org.hl7.fhir.r5.model.UuidType();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.r5.model.UuidType src) throws FHIRException {
        UuidType tgt = src.hasValue() ? new UuidType((String)src.getValue()) : new UuidType();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu2.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof Reference) {
                tgt.setValue(VersionConvertor_10_50.convertReferenceToCanonical((Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Extension tgt = new org.hl7.fhir.dstu2.model.Extension();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue(VersionConvertor_10_50.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else if (src.hasValue()) {
                tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
            }
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_10_50.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Narrative tgt = new org.hl7.fhir.r5.model.Narrative();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.r5.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertNarrativeStatus(src.getStatusElement()));
        }
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Narrative.NarrativeStatus> convertNarrativeStatus(org.hl7.fhir.r5.model.Enumeration<Narrative.NarrativeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Narrative.NarrativeStatus> tgt = new Enumeration<Narrative.NarrativeStatus>(new Narrative.NarrativeStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Narrative.NarrativeStatus)((Object)src.getValue())) {
            case GENERATED: {
                tgt.setValue((Object)Narrative.NarrativeStatus.GENERATED);
                break;
            }
            case EXTENSIONS: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EXTENSIONS);
                break;
            }
            case ADDITIONAL: {
                tgt.setValue((Object)Narrative.NarrativeStatus.ADDITIONAL);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)Narrative.NarrativeStatus.EMPTY);
                break;
            }
            default: {
                tgt.setValue((Object)Narrative.NarrativeStatus.NULL);
            }
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.dstu2.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_50.convertType(src.getAuthor()));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Annotation tgt = new org.hl7.fhir.dstu2.model.Annotation();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_10_50.convertType(src.getAuthor()));
        }
        if (src.hasTimeElement()) {
            tgt.setTimeElement(VersionConvertor_10_50.convertDateTime(src.getTimeElement()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Attachment tgt = new org.hl7.fhir.r5.model.Attachment();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHashElement()) {
            tgt.setHashElement(VersionConvertor_10_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreationElement()) {
            tgt.setCreationElement(VersionConvertor_10_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.r5.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasContentTypeElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_50.convertBase64Binary(src.getDataElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(Math.toIntExact(src.getSize()));
        }
        if (src.hasHashElement()) {
            tgt.setHashElement(VersionConvertor_10_50.convertBase64Binary(src.getHashElement()));
        }
        if (src.hasTitleElement()) {
            tgt.setTitleElement(VersionConvertor_10_50.convertString(src.getTitleElement()));
        }
        if (src.hasCreationElement()) {
            tgt.setCreationElement(VersionConvertor_10_50.convertDateTime(src.getCreationElement()));
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.dstu2.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_10_50.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.CodeableConcept tgt = new org.hl7.fhir.dstu2.model.CodeableConcept();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_10_50.convertCoding(t));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Coding tgt = new org.hl7.fhir.r5.model.Coding();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelectedElement()) {
            tgt.setUserSelectedElement(VersionConvertor_10_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r5.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUserSelectedElement()) {
            tgt.setUserSelectedElement(VersionConvertor_10_50.convertBoolean(src.getUserSelectedElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Identifier tgt = new org.hl7.fhir.r5.model.Identifier();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_10_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.r5.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertIdentifierUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_10_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_10_50.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> convertIdentifierUse(Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Identifier.IdentifierUse> convertIdentifierUse(org.hl7.fhir.r5.model.Enumeration<Identifier.IdentifierUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Identifier.IdentifierUse> tgt = new Enumeration<Identifier.IdentifierUse>(new Identifier.IdentifierUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Identifier.IdentifierUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)Identifier.IdentifierUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Identifier.IdentifierUse.TEMP);
                break;
            }
            case SECONDARY: {
                tgt.setValue((Object)Identifier.IdentifierUse.SECONDARY);
                break;
            }
            default: {
                tgt.setValue((Object)Identifier.IdentifierUse.NULL);
            }
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu2.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Period tgt = new org.hl7.fhir.dstu2.model.Period();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasStartElement()) {
            tgt.setStartElement(VersionConvertor_10_50.convertDateTime(src.getStartElement()));
        }
        if (src.hasEndElement()) {
            tgt.setEndElement(VersionConvertor_10_50.convertDateTime(src.getEndElement()));
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu2.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Quantity tgt = new org.hl7.fhir.dstu2.model.Quantity();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> convertQuantityComparator(Enumeration<Quantity.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator>(new Enumerations.QuantityComparatorEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Quantity.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Enumerations.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Enumerations.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Enumerations.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Quantity.QuantityComparator> convertQuantityComparator(org.hl7.fhir.r5.model.Enumeration<Enumerations.QuantityComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Quantity.QuantityComparator> tgt = new Enumeration<Quantity.QuantityComparator>(new Quantity.QuantityComparatorEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.QuantityComparator)((Object)src.getValue())) {
            case LESS_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_THAN);
                break;
            }
            case LESS_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.LESS_OR_EQUAL);
                break;
            }
            case GREATER_OR_EQUAL: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                tgt.setValue((Object)Quantity.QuantityComparator.GREATER_THAN);
                break;
            }
            default: {
                tgt.setValue((Object)Quantity.QuantityComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Range tgt = new org.hl7.fhir.r5.model.Range();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r5.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_10_50.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_10_50.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Ratio tgt = new org.hl7.fhir.r5.model.Ratio();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_10_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_10_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r5.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_10_50.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_10_50.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Reference tgt = new org.hl7.fhir.r5.model.Reference();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        tgt.setReference(src.getReference());
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.r5.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        tgt.setReference(src.getReference());
        if (src.hasDisplayElement()) {
            tgt.setDisplayElement(VersionConvertor_10_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu2.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimitElement()) {
            tgt.setLowerLimitElement(VersionConvertor_10_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimitElement()) {
            tgt.setUpperLimitElement(VersionConvertor_10_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_10_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.SampledData tgt = new org.hl7.fhir.dstu2.model.SampledData();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_10_50.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasFactorElement()) {
            tgt.setFactorElement(VersionConvertor_10_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasLowerLimitElement()) {
            tgt.setLowerLimitElement(VersionConvertor_10_50.convertDecimal(src.getLowerLimitElement()));
        }
        if (src.hasUpperLimitElement()) {
            tgt.setUpperLimitElement(VersionConvertor_10_50.convertDecimal(src.getUpperLimitElement()));
        }
        if (src.hasDimensionsElement()) {
            tgt.setDimensionsElement(VersionConvertor_10_50.convertPositiveInt(src.getDimensionsElement()));
        }
        if (src.hasDataElement()) {
            tgt.setDataElement(VersionConvertor_10_50.convertString(src.getDataElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Signature tgt = new org.hl7.fhir.r5.model.Signature();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_10_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWhoUriType()) {
            tgt.setWho(new org.hl7.fhir.r5.model.Reference((String)src.getWhoUriType().getValue()));
        } else {
            tgt.setWho(VersionConvertor_10_50.convertReference(src.getWhoReference()));
        }
        if (src.hasContentTypeElement()) {
            tgt.setSigFormatElement(VersionConvertor_10_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasBlobElement()) {
            tgt.setDataElement(VersionConvertor_10_50.convertBase64Binary(src.getBlobElement()));
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.r5.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_10_50.convertCoding(t));
        }
        if (src.hasWhenElement()) {
            tgt.setWhenElement(VersionConvertor_10_50.convertInstant(src.getWhenElement()));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_10_50.convertType(src.getWho()));
        }
        if (src.hasSigFormatElement()) {
            tgt.setContentTypeElement(VersionConvertor_10_50.convertCode(src.getSigFormatElement()));
        }
        if (src.hasDataElement()) {
            tgt.setBlobElement(VersionConvertor_10_50.convertBase64Binary(src.getDataElement()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.dstu2.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCityElement()) {
            tgt.setCityElement(VersionConvertor_10_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrictElement()) {
            tgt.setDistrictElement(VersionConvertor_10_50.convertString(src.getDistrictElement()));
        }
        if (src.hasStateElement()) {
            tgt.setStateElement(VersionConvertor_10_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCodeElement()) {
            tgt.setPostalCodeElement(VersionConvertor_10_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountryElement()) {
            tgt.setCountryElement(VersionConvertor_10_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Address tgt = new org.hl7.fhir.dstu2.model.Address();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertAddressUse(src.getUseElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertAddressType(src.getTypeElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCityElement()) {
            tgt.setCityElement(VersionConvertor_10_50.convertString(src.getCityElement()));
        }
        if (src.hasDistrictElement()) {
            tgt.setDistrictElement(VersionConvertor_10_50.convertString(src.getDistrictElement()));
        }
        if (src.hasStateElement()) {
            tgt.setStateElement(VersionConvertor_10_50.convertString(src.getStateElement()));
        }
        if (src.hasPostalCodeElement()) {
            tgt.setPostalCodeElement(VersionConvertor_10_50.convertString(src.getPostalCodeElement()));
        }
        if (src.hasCountryElement()) {
            tgt.setCountryElement(VersionConvertor_10_50.convertString(src.getCountryElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> convertAddressUse(Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> tgt = new org.hl7.fhir.r5.model.Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressUse> convertAddressUse(org.hl7.fhir.r5.model.Enumeration<Address.AddressUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressUse> tgt = new Enumeration<Address.AddressUse>(new Address.AddressUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)Address.AddressUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)Address.AddressUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)Address.AddressUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)Address.AddressUse.OLD);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressUse.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Address.AddressType> convertAddressType(Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Address.AddressType> tgt = new org.hl7.fhir.r5.model.Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Address.AddressType> convertAddressType(org.hl7.fhir.r5.model.Enumeration<Address.AddressType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Address.AddressType> tgt = new Enumeration<Address.AddressType>(new Address.AddressTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Address.AddressType)((Object)src.getValue())) {
            case POSTAL: {
                tgt.setValue((Object)Address.AddressType.POSTAL);
                break;
            }
            case PHYSICAL: {
                tgt.setValue((Object)Address.AddressType.PHYSICAL);
                break;
            }
            case BOTH: {
                tgt.setValue((Object)Address.AddressType.BOTH);
                break;
            }
            default: {
                tgt.setValue((Object)Address.AddressType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.ContactPoint tgt = new org.hl7.fhir.r5.model.ContactPoint();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRankElement()) {
            tgt.setRankElement(VersionConvertor_10_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.r5.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasSystem()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertContactPointSystem(src.getSystemElement()));
        }
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertString(src.getValueElement()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertContactPointUse(src.getUseElement()));
        }
        if (src.hasRankElement()) {
            tgt.setRankElement(VersionConvertor_10_50.convertPositiveInt(src.getRankElement()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> tgt = new org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointSystem> convertContactPointSystem(org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointSystem> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointSystem> tgt = new Enumeration<ContactPoint.ContactPointSystem>(new ContactPoint.ContactPointSystemEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointSystem)((Object)src.getValue())) {
            case PHONE: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PHONE);
                break;
            }
            case FAX: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.FAX);
                break;
            }
            case EMAIL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.EMAIL);
                break;
            }
            case PAGER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.PAGER);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            case URL: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointSystem.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> tgt = new org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ContactPoint.ContactPointUse> convertContactPointUse(org.hl7.fhir.r5.model.Enumeration<ContactPoint.ContactPointUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ContactPoint.ContactPointUse> tgt = new Enumeration<ContactPoint.ContactPointUse>(new ContactPoint.ContactPointUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ContactPoint.ContactPointUse)((Object)src.getValue())) {
            case HOME: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.HOME);
                break;
            }
            case WORK: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.WORK);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.TEMP);
                break;
            }
            case OLD: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.OLD);
                break;
            }
            case MOBILE: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.MOBILE);
                break;
            }
            default: {
                tgt.setValue((Object)ContactPoint.ContactPointUse.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.dstu2.model.ElementDefinition src, List<String> slicePaths, List<org.hl7.fhir.dstu2.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_10_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasName()) {
            if (slicePaths.contains(src.getPath())) {
                tgt.setSliceNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
            }
            if (src.hasNameElement()) {
                tgt.setIdElement(VersionConvertor_10_50.convertString(src.getNameElement()));
            }
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        for (Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_10_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_10_50.convertElementDefinitionSlicingComponent(src.getSlicing(), context, pos));
        }
        if (src.hasShort()) {
            tgt.setShortElement(VersionConvertor_10_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_10_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasComments()) {
            tgt.setCommentElement(VersionConvertor_10_50.convertMarkdown(src.getCommentsElement()));
        }
        if (src.hasRequirements()) {
            tgt.setRequirementsElement(VersionConvertor_10_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (org.hl7.fhir.dstu2.model.StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_10_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasNameReference()) {
            tgt.setContentReference("#" + src.getNameReference());
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_10_50.convertElementDefinitionTypeComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_10_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_10_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_10_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_10_50.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(VersionConvertor_10_50.convertType(src.getExample()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_10_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_10_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLengthElement(VersionConvertor_10_50.convertInteger(src.getMaxLengthElement()));
        }
        for (org.hl7.fhir.dstu2.model.IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_10_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupportElement(VersionConvertor_10_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifierElement(VersionConvertor_10_50.convertBoolean(src.getIsModifierElement()));
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension(src, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString(reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummaryElement(VersionConvertor_10_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_10_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        if (!tgt.hasId()) {
            tgt.setId(tgt.getPath());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.ElementDefinition tgt = new org.hl7.fhir.dstu2.model.ElementDefinition();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        tgt.setRepresentation(src.getRepresentation().stream().map(VersionConvertor_10_50::convertPropertyRepresentation).collect(Collectors.toList()));
        if (src.hasSliceName()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getSliceNameElement()));
        } else {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getIdElement()));
        }
        if (src.hasLabelElement()) {
            tgt.setLabelElement(VersionConvertor_10_50.convertString(src.getLabelElement()));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getCode()) {
            tgt.addCode(VersionConvertor_10_50.convertCoding(coding));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_10_50.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShortElement()) {
            tgt.setShortElement(VersionConvertor_10_50.convertString(src.getShortElement()));
        }
        if (src.hasDefinitionElement()) {
            tgt.setDefinitionElement(VersionConvertor_10_50.convertMarkdown(src.getDefinitionElement()));
        }
        if (src.hasCommentElement()) {
            tgt.setCommentsElement(VersionConvertor_10_50.convertMarkdown(src.getCommentElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_50.convertMarkdown(src.getRequirementsElement()));
        }
        for (StringType stringType : src.getAlias()) {
            tgt.addAlias((String)stringType.getValue());
        }
        tgt.setMin(src.getMin());
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_10_50.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setNameReference(src.getContentReference().substring(1));
        }
        for (ElementDefinition.TypeRefComponent typeRefComponent : src.getType()) {
            VersionConvertor_10_50.convertElementDefinitionTypeComponent(typeRefComponent, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_10_50.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissingElement()) {
            tgt.setMeaningWhenMissingElement(VersionConvertor_10_50.convertMarkdown(src.getMeaningWhenMissingElement()));
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_10_50.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_10_50.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.setExample(VersionConvertor_10_50.convertType(src.getExampleFirstRep().getValue()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_10_50.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_10_50.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLengthElement()) {
            tgt.setMaxLengthElement(VersionConvertor_10_50.convertInteger(src.getMaxLengthElement()));
        }
        for (IdType idType : src.getCondition()) {
            tgt.addCondition(idType.getValue());
        }
        for (ElementDefinition.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_10_50.convertElementDefinitionConstraintComponent(elementDefinitionConstraintComponent));
        }
        if (src.hasMustSupportElement()) {
            tgt.setMustSupportElement(VersionConvertor_10_50.convertBoolean(src.getMustSupportElement()));
        }
        if (src.hasIsModifierElement()) {
            tgt.setIsModifierElement(VersionConvertor_10_50.convertBoolean(src.getIsModifierElement()));
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension(tgt, "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", src.getIsModifierReason());
        }
        if (src.hasIsSummaryElement()) {
            tgt.setIsSummaryElement(VersionConvertor_10_50.convertBoolean(src.getIsSummaryElement()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_10_50.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (ElementDefinition.ElementDefinitionMappingComponent elementDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(VersionConvertor_10_50.convertElementDefinitionMappingComponent(elementDefinitionMappingComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.PropertyRepresentation> convertPropertyRepresentation(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.PropertyRepresentation> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.PropertyRepresentation> tgt = new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.PropertyRepresentation)((Object)src.getValue())) {
            case XMLATTR: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.XMLATTR);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.PropertyRepresentation.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src, List<org.hl7.fhir.dstu2.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        org.hl7.fhir.dstu2.model.ElementDefinition slicingElement = context.get(pos);
        for (org.hl7.fhir.dstu2.model.StringType t : src.getDiscriminator()) {
            boolean isExists = false;
            if (!t.asStringValue().contains("@")) {
                int slices = 0;
                boolean existsSlicePresent = false;
                boolean notExistsSlicePresent = false;
                String existsPath = slicingElement.getPath() + "." + t.asStringValue();
                for (int i = pos + 1; i < context.size(); ++i) {
                    org.hl7.fhir.dstu2.model.ElementDefinition e = context.get(i);
                    if (e.getPath().equals(slicingElement.getPath())) {
                        ++slices;
                        continue;
                    }
                    if (!e.getPath().startsWith(slicingElement.getPath() + ".")) break;
                    if (!e.getPath().equals(existsPath)) continue;
                    if (e.hasMin() && e.getMin() > 0) {
                        existsSlicePresent = true;
                        continue;
                    }
                    if (!e.hasMax() || !e.getMax().equals("0")) continue;
                    notExistsSlicePresent = true;
                }
                isExists = slices == 2 && existsSlicePresent && notExistsSlicePresent || slices == 1 && existsSlicePresent != notExistsSlicePresent;
            }
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)t.getValue(), isExists));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrderedElement()) {
            tgt.setOrderedElement(VersionConvertor_10_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_10_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator(t));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasOrderedElement()) {
            tgt.setOrderedElement(VersionConvertor_10_50.convertBoolean(src.getOrderedElement()));
        }
        if (src.hasRules()) {
            tgt.setRulesElement(VersionConvertor_10_50.convertSlicingRules(src.getRulesElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.SlicingRules> convertSlicingRules(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.SlicingRules> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.SlicingRules> tgt = new Enumeration<ElementDefinition.SlicingRules>(new ElementDefinition.SlicingRulesEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.SlicingRules)((Object)src.getValue())) {
            case CLOSED: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.CLOSED);
                break;
            }
            case OPEN: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPEN);
                break;
            }
            case OPENATEND: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.OPENATEND);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.SlicingRules.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasPathElement()) {
            tgt.setPathElement(VersionConvertor_10_50.convertString(src.getPathElement()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMaxElement()) {
            tgt.setMaxElement(VersionConvertor_10_50.convertString(src.getMaxElement()));
        }
        return tgt;
    }

    public static void convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent typeRefComponent : list) {
            if (!typeRefComponent.getCode().equals(src.getCode())) continue;
            tgt = typeRefComponent;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
            tgt.setCode(src.getCode());
        }
        if (tgt.hasTarget()) {
            for (UriType uriType : src.getProfile()) {
                tgt.addTargetProfile((String)uriType.getValue());
            }
        } else {
            for (UriType uriType : src.getProfile()) {
                tgt.addProfile((String)uriType.getValue());
            }
        }
        for (Enumeration enumeration : src.getAggregation()) {
            org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> a = VersionConvertor_10_50.convertAggregationMode(enumeration);
            if (tgt.hasAggregation((ElementDefinition.AggregationMode)((Object)a.getValue()))) continue;
            VersionConvertor_10_50.copyElement(enumeration, tgt.addAggregation((ElementDefinition.AggregationMode)((Object)a.getValue())), new String[0]);
        }
    }

    public static void convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        list.add(tgt);
        if (src.hasTarget()) {
            for (org.hl7.fhir.r5.model.UriType uriType : src.getTargetProfile()) {
                tgt.addProfile((String)uriType.getValue());
            }
        } else {
            for (org.hl7.fhir.r5.model.UriType uriType : src.getProfile()) {
                tgt.addProfile((String)uriType.getValue());
            }
        }
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.AggregationMode> convertAggregationMode(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.AggregationMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.AggregationMode> tgt = new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.AggregationMode)((Object)src.getValue())) {
            case CONTAINED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.CONTAINED);
                break;
            }
            case REFERENCED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.REFERENCED);
                break;
            }
            case BUNDLED: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.BUNDLED);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.AggregationMode.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_10_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_10_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_10_50.convertString(src.getHumanElement()));
        }
        tgt.setExpression(ToolingExtensions.readStringExtension(src, "http://hl7.org/fhir/StructureDefinition/structuredefinition-expression"));
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_50.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasKeyElement()) {
            tgt.setKeyElement(VersionConvertor_10_50.convertId(src.getKeyElement()));
        }
        if (src.hasRequirementsElement()) {
            tgt.setRequirementsElement(VersionConvertor_10_50.convertString(src.getRequirementsElement()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverityElement(VersionConvertor_10_50.convertConstraintSeverity(src.getSeverityElement()));
        }
        if (src.hasHumanElement()) {
            tgt.setHumanElement(VersionConvertor_10_50.convertString(src.getHumanElement()));
        }
        if (src.hasExpression()) {
            ToolingExtensions.addStringExtension(tgt, "http://hl7.org/fhir/StructureDefinition/structuredefinition-expression", src.getExpression());
        }
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_50.convertString(src.getXpathElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> tgt = new org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ElementDefinition.ConstraintSeverity> convertConstraintSeverity(org.hl7.fhir.r5.model.Enumeration<ElementDefinition.ConstraintSeverity> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ElementDefinition.ConstraintSeverity> tgt = new Enumeration<ElementDefinition.ConstraintSeverity>(new ElementDefinition.ConstraintSeverityEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((ElementDefinition.ConstraintSeverity)((Object)src.getValue())) {
            case ERROR: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.ERROR);
                break;
            }
            case WARNING: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.WARNING);
                break;
            }
            default: {
                tgt.setValue((Object)ElementDefinition.ConstraintSeverity.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        DataType vs;
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if ((vs = VersionConvertor_10_50.convertType(src.getValueSet())) != null) {
            tgt.setValueSet(vs instanceof org.hl7.fhir.r5.model.Reference ? ((org.hl7.fhir.r5.model.Reference)vs).getReference() : vs.primitiveValue());
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasStrength()) {
            tgt.setStrengthElement(VersionConvertor_10_50.convertBindingStrength(src.getStrengthElement()));
        }
        if (src.hasDescriptionElement()) {
            tgt.setDescriptionElement(VersionConvertor_10_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet(new UriType(vsr));
            } else {
                tgt.setValueSet(new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> convertBindingStrength(Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.BindingStrength> convertBindingStrength(org.hl7.fhir.r5.model.Enumeration<Enumerations.BindingStrength> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.BindingStrength> tgt = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.BindingStrength)((Object)src.getValue())) {
            case REQUIRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.REQUIRED);
                break;
            }
            case EXTENSIBLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXTENSIBLE);
                break;
            }
            case PREFERRED: {
                tgt.setValue((Object)Enumerations.BindingStrength.PREFERRED);
                break;
            }
            case EXAMPLE: {
                tgt.setValue((Object)Enumerations.BindingStrength.EXAMPLE);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.BindingStrength.NULL);
            }
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_10_50.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasIdentityElement()) {
            tgt.setIdentityElement(VersionConvertor_10_50.convertId(src.getIdentityElement()));
        }
        if (src.hasLanguageElement()) {
            tgt.setLanguageElement(VersionConvertor_10_50.convertCode(src.getLanguageElement()));
        }
        if (src.hasMapElement()) {
            tgt.setMapElement(VersionConvertor_10_50.convertString(src.getMapElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.HumanName tgt = new org.hl7.fhir.r5.model.HumanName();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.r5.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUseElement(VersionConvertor_10_50.convertNameUse(src.getUseElement()));
        }
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_10_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> convertNameUse(Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> tgt = new org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<HumanName.NameUse> convertNameUse(org.hl7.fhir.r5.model.Enumeration<HumanName.NameUse> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<HumanName.NameUse> tgt = new Enumeration<HumanName.NameUse>(new HumanName.NameUseEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((HumanName.NameUse)((Object)src.getValue())) {
            case USUAL: {
                tgt.setValue((Object)HumanName.NameUse.USUAL);
                break;
            }
            case OFFICIAL: {
                tgt.setValue((Object)HumanName.NameUse.OFFICIAL);
                break;
            }
            case TEMP: {
                tgt.setValue((Object)HumanName.NameUse.TEMP);
                break;
            }
            case NICKNAME: {
                tgt.setValue((Object)HumanName.NameUse.NICKNAME);
                break;
            }
            case ANONYMOUS: {
                tgt.setValue((Object)HumanName.NameUse.ANONYMOUS);
                break;
            }
            case OLD: {
                tgt.setValue((Object)HumanName.NameUse.OLD);
                break;
            }
            case MAIDEN: {
                tgt.setValue((Object)HumanName.NameUse.MAIDEN);
                break;
            }
            default: {
                tgt.setValue((Object)HumanName.NameUse.NULL);
            }
        }
        return tgt;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu2.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionIdElement()) {
            tgt.setVersionIdElement(VersionConvertor_10_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdatedElement()) {
            tgt.setLastUpdatedElement(VersionConvertor_10_50.convertInstant(src.getLastUpdatedElement()));
        }
        for (UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_10_50.convertCoding(coding));
        }
        for (Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_10_50.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Meta tgt = new org.hl7.fhir.dstu2.model.Meta();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasVersionIdElement()) {
            tgt.setVersionIdElement(VersionConvertor_10_50.convertId(src.getVersionIdElement()));
        }
        if (src.hasLastUpdatedElement()) {
            tgt.setLastUpdatedElement(VersionConvertor_10_50.convertInstant(src.getLastUpdatedElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getProfile()) {
            tgt.addProfile((String)uriType.getValue());
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_10_50.convertCoding(coding));
        }
        for (org.hl7.fhir.r5.model.Coding coding : src.getTag()) {
            tgt.addTag(VersionConvertor_10_50.convertCoding(coding));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Timing tgt = new org.hl7.fhir.r5.model.Timing();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.dstu2.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_10_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.r5.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_10_50.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_10_50.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_10_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasDurationElement()) {
            tgt.setDurationElement(VersionConvertor_10_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMaxElement()) {
            tgt.setDurationMaxElement(VersionConvertor_10_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnits()) {
            tgt.setDurationUnitElement(VersionConvertor_10_50.convertUnitsOfTime(src.getDurationUnitsElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMaxElement()) {
            tgt.setPeriodMaxElement(VersionConvertor_10_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnits()) {
            tgt.setPeriodUnitElement(VersionConvertor_10_50.convertUnitsOfTime(src.getPeriodUnitsElement()));
        }
        tgt.setWhen(Collections.singletonList(VersionConvertor_10_50.convertEventTiming(src.getWhenElement())));
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_10_50.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasDurationElement()) {
            tgt.setDurationElement(VersionConvertor_10_50.convertDecimal(src.getDurationElement()));
        }
        if (src.hasDurationMaxElement()) {
            tgt.setDurationMaxElement(VersionConvertor_10_50.convertDecimal(src.getDurationMaxElement()));
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnitsElement(VersionConvertor_10_50.convertUnitsOfTime(src.getDurationUnitElement()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriodElement()) {
            tgt.setPeriodElement(VersionConvertor_10_50.convertDecimal(src.getPeriodElement()));
        }
        if (src.hasPeriodMaxElement()) {
            tgt.setPeriodMaxElement(VersionConvertor_10_50.convertDecimal(src.getPeriodMaxElement()));
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnitsElement(VersionConvertor_10_50.convertUnitsOfTime(src.getPeriodUnitElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhenElement(VersionConvertor_10_50.convertEventTiming(src.getWhen().get(0)));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> tgt = new org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.UnitsOfTime> convertUnitsOfTime(org.hl7.fhir.r5.model.Enumeration<Timing.UnitsOfTime> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.UnitsOfTime> tgt = new Enumeration<Timing.UnitsOfTime>(new Timing.UnitsOfTimeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.UnitsOfTime)((Object)src.getValue())) {
            case S: {
                tgt.setValue((Object)Timing.UnitsOfTime.S);
                break;
            }
            case MIN: {
                tgt.setValue((Object)Timing.UnitsOfTime.MIN);
                break;
            }
            case H: {
                tgt.setValue((Object)Timing.UnitsOfTime.H);
                break;
            }
            case D: {
                tgt.setValue((Object)Timing.UnitsOfTime.D);
                break;
            }
            case WK: {
                tgt.setValue((Object)Timing.UnitsOfTime.WK);
                break;
            }
            case MO: {
                tgt.setValue((Object)Timing.UnitsOfTime.MO);
                break;
            }
            case A: {
                tgt.setValue((Object)Timing.UnitsOfTime.A);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.UnitsOfTime.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> convertEventTiming(Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> tgt = new org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Timing.EventTiming> convertEventTiming(org.hl7.fhir.r5.model.Enumeration<Timing.EventTiming> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Timing.EventTiming> tgt = new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Timing.EventTiming)((Object)src.getValue())) {
            case HS: {
                tgt.setValue((Object)Timing.EventTiming.HS);
                break;
            }
            case WAKE: {
                tgt.setValue((Object)Timing.EventTiming.WAKE);
                break;
            }
            case C: {
                tgt.setValue((Object)Timing.EventTiming.C);
                break;
            }
            case CM: {
                tgt.setValue((Object)Timing.EventTiming.CM);
                break;
            }
            case CD: {
                tgt.setValue((Object)Timing.EventTiming.CD);
                break;
            }
            case CV: {
                tgt.setValue((Object)Timing.EventTiming.CV);
                break;
            }
            case AC: {
                tgt.setValue((Object)Timing.EventTiming.AC);
                break;
            }
            case ACM: {
                tgt.setValue((Object)Timing.EventTiming.ACM);
                break;
            }
            case ACD: {
                tgt.setValue((Object)Timing.EventTiming.ACD);
                break;
            }
            case ACV: {
                tgt.setValue((Object)Timing.EventTiming.ACV);
                break;
            }
            case PC: {
                tgt.setValue((Object)Timing.EventTiming.PC);
                break;
            }
            case PCM: {
                tgt.setValue((Object)Timing.EventTiming.PCM);
                break;
            }
            case PCD: {
                tgt.setValue((Object)Timing.EventTiming.PCD);
                break;
            }
            case PCV: {
                tgt.setValue((Object)Timing.EventTiming.PCV);
                break;
            }
            default: {
                tgt.setValue((Object)Timing.EventTiming.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Age tgt = new org.hl7.fhir.r5.model.Age();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Age convertAge(org.hl7.fhir.r5.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Count tgt = new org.hl7.fhir.r5.model.Count();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r5.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Distance tgt = new org.hl7.fhir.r5.model.Distance();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r5.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu2.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Duration tgt = new org.hl7.fhir.dstu2.model.Duration();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.dstu2.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCurrencyElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2.model.Money tgt = new org.hl7.fhir.dstu2.model.Money();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasCurrencyElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCurrencyElement()));
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.SimpleQuantity tgt = new org.hl7.fhir.r5.model.SimpleQuantity();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasValueElement()) {
            tgt.setValueElement(VersionConvertor_10_50.convertDecimal(src.getValueElement()));
        }
        if (src.hasComparator()) {
            tgt.setComparatorElement(VersionConvertor_10_50.convertQuantityComparator(src.getComparatorElement()));
        }
        if (src.hasUnitElement()) {
            tgt.setUnitElement(VersionConvertor_10_50.convertString(src.getUnitElement()));
        }
        if (src.hasSystemElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getSystemElement()));
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        return tgt;
    }

    public static DataType convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_10_50.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.BooleanType) {
            return VersionConvertor_10_50.convertBoolean((org.hl7.fhir.dstu2.model.BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_10_50.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DateType) {
            return VersionConvertor_10_50.convertDate((org.hl7.fhir.dstu2.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DateTimeType) {
            return VersionConvertor_10_50.convertDateTime((org.hl7.fhir.dstu2.model.DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_10_50.convertDecimal((DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.IdType) {
            return VersionConvertor_10_50.convertId((org.hl7.fhir.dstu2.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.InstantType) {
            return VersionConvertor_10_50.convertInstant((org.hl7.fhir.dstu2.model.InstantType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.IntegerType) {
            return VersionConvertor_10_50.convertInteger((org.hl7.fhir.dstu2.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MarkdownType) {
            return VersionConvertor_10_50.convertMarkdown((org.hl7.fhir.dstu2.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.OidType) {
            return VersionConvertor_10_50.convertOid((org.hl7.fhir.dstu2.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_10_50.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.StringType) {
            return VersionConvertor_10_50.convertString((org.hl7.fhir.dstu2.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.TimeType) {
            return VersionConvertor_10_50.convertTime((org.hl7.fhir.dstu2.model.TimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.UnsignedIntType) {
            return VersionConvertor_10_50.convertUnsignedInt((org.hl7.fhir.dstu2.model.UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_10_50.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_10_50.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Extension) {
            return VersionConvertor_10_50.convertExtension((org.hl7.fhir.dstu2.model.Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_10_50.convertNarrative((Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Annotation) {
            return VersionConvertor_10_50.convertAnnotation((org.hl7.fhir.dstu2.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_10_50.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CodeableConcept) {
            return VersionConvertor_10_50.convertCodeableConcept((org.hl7.fhir.dstu2.model.CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_10_50.convertCoding((Coding)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_10_50.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Period) {
            return VersionConvertor_10_50.convertPeriod((org.hl7.fhir.dstu2.model.Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Quantity) {
            return VersionConvertor_10_50.convertQuantity((org.hl7.fhir.dstu2.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_10_50.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_10_50.convertRatio((Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_10_50.convertReference((Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SampledData) {
            return VersionConvertor_10_50.convertSampledData((org.hl7.fhir.dstu2.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_10_50.convertSignature((Signature)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Address) {
            return VersionConvertor_10_50.convertAddress((org.hl7.fhir.dstu2.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_10_50.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_10_50.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Meta) {
            return VersionConvertor_10_50.convertMeta((org.hl7.fhir.dstu2.model.Meta)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_10_50.convertTiming((Timing)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_10_50.convertAge((Age)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_10_50.convertCount((Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_10_50.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Duration) {
            return VersionConvertor_10_50.convertDuration((org.hl7.fhir.dstu2.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Money) {
            return VersionConvertor_10_50.convertMoney((org.hl7.fhir.dstu2.model.Money)src);
        }
        if (src instanceof SimpleQuantity) {
            return VersionConvertor_10_50.convertSimpleQuantity((SimpleQuantity)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static Type convertType(DataType src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r5.model.Base64BinaryType) {
            return VersionConvertor_10_50.convertBase64Binary((org.hl7.fhir.r5.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_10_50.convertBoolean((BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.CodeType) {
            return VersionConvertor_10_50.convertCode((org.hl7.fhir.r5.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_10_50.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_10_50.convertDateTime((DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DecimalType) {
            return VersionConvertor_10_50.convertDecimal((org.hl7.fhir.r5.model.DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_10_50.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_10_50.convertInstant((InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_10_50.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_10_50.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_10_50.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.PositiveIntType) {
            return VersionConvertor_10_50.convertPositiveInt((org.hl7.fhir.r5.model.PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_10_50.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_10_50.convertTime((TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_10_50.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UriType) {
            return VersionConvertor_10_50.convertUri((org.hl7.fhir.r5.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.UuidType) {
            return VersionConvertor_10_50.convertUuid((org.hl7.fhir.r5.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_10_50.convertExtension((Extension)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Narrative) {
            return VersionConvertor_10_50.convertNarrative((org.hl7.fhir.r5.model.Narrative)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_10_50.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Attachment) {
            return VersionConvertor_10_50.convertAttachment((org.hl7.fhir.r5.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_10_50.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Coding) {
            return VersionConvertor_10_50.convertCoding((org.hl7.fhir.r5.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Identifier) {
            return VersionConvertor_10_50.convertIdentifier((org.hl7.fhir.r5.model.Identifier)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_10_50.convertPeriod((Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_10_50.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Range) {
            return VersionConvertor_10_50.convertRange((org.hl7.fhir.r5.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Ratio) {
            return VersionConvertor_10_50.convertRatio((org.hl7.fhir.r5.model.Ratio)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Reference) {
            return VersionConvertor_10_50.convertReference((org.hl7.fhir.r5.model.Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_10_50.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Signature) {
            return VersionConvertor_10_50.convertSignature((org.hl7.fhir.r5.model.Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_10_50.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ContactPoint) {
            return VersionConvertor_10_50.convertContactPoint((org.hl7.fhir.r5.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.HumanName) {
            return VersionConvertor_10_50.convertHumanName((org.hl7.fhir.r5.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_10_50.convertMeta((Meta)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Timing) {
            return VersionConvertor_10_50.convertTiming((org.hl7.fhir.r5.model.Timing)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Age) {
            return VersionConvertor_10_50.convertAge((org.hl7.fhir.r5.model.Age)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Count) {
            return VersionConvertor_10_50.convertCount((org.hl7.fhir.r5.model.Count)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Distance) {
            return VersionConvertor_10_50.convertDistance((org.hl7.fhir.r5.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_10_50.convertDuration((Duration)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_10_50.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.SimpleQuantity) {
            return VersionConvertor_10_50.convertSimpleQuantity((org.hl7.fhir.r5.model.SimpleQuantity)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static boolean isExemptExtension(String url, String[] extensionsToIgnore) {
        boolean ok = false;
        for (String s2 : extensionsToIgnore) {
            if (!s2.equals(url)) continue;
            ok = true;
        }
        return ok;
    }

    public static void copyDomainResource(org.hl7.fhir.dstu2.model.DomainResource src, DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_10_50.copyResource(src, tgt);
        tgt.setText(VersionConvertor_10_50.convertNarrative(src.getText()));
        for (org.hl7.fhir.dstu2.model.Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_10_50.convertResource(resource));
        }
        for (org.hl7.fhir.dstu2.model.Extension extension : src.getExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_10_50.convertExtension(extension));
        }
        for (org.hl7.fhir.dstu2.model.Extension extension : src.getModifierExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_10_50.convertExtension(extension));
        }
    }

    public static void copyDomainResource(DomainResource src, org.hl7.fhir.dstu2.model.DomainResource tgt, String ... extensionsToIgnore) throws FHIRException {
        VersionConvertor_10_50.copyResource(src, tgt);
        tgt.setText(VersionConvertor_10_50.convertNarrative(src.getText()));
        for (Resource resource : src.getContained()) {
            tgt.addContained(VersionConvertor_10_50.convertResource(resource));
        }
        for (Extension extension : src.getExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addExtension(VersionConvertor_10_50.convertExtension(extension));
        }
        for (Extension extension : src.getModifierExtension()) {
            if (VersionConvertor_10_50.isExemptExtension(extension.getUrl(), extensionsToIgnore)) continue;
            tgt.addModifierExtension(VersionConvertor_10_50.convertExtension(extension));
        }
    }

    public static void copyResource(org.hl7.fhir.dstu2.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_10_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static void copyResource(Resource src, org.hl7.fhir.dstu2.model.Resource tgt) throws FHIRException {
        tgt.setId(src.getId());
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_10_50.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
            case MALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                break;
            }
            case FEMALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.AdministrativeGender> convertAdministrativeGender(org.hl7.fhir.r5.model.Enumeration<Enumerations.AdministrativeGender> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.AdministrativeGender> tgt = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.AdministrativeGender)((Object)src.getValue())) {
            case MALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.MALE);
                break;
            }
            case FEMALE: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.FEMALE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.OTHER);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.AdministrativeGender.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> convertSearchParamType(Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.SearchParamType> convertSearchParamType(org.hl7.fhir.r5.model.Enumeration<Enumerations.SearchParamType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.SearchParamType> tgt = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.SearchParamType)((Object)src.getValue())) {
            case NUMBER: {
                tgt.setValue((Object)Enumerations.SearchParamType.NUMBER);
                break;
            }
            case DATE: {
                tgt.setValue((Object)Enumerations.SearchParamType.DATE);
                break;
            }
            case STRING: {
                tgt.setValue((Object)Enumerations.SearchParamType.STRING);
                break;
            }
            case TOKEN: {
                tgt.setValue((Object)Enumerations.SearchParamType.TOKEN);
                break;
            }
            case REFERENCE: {
                tgt.setValue((Object)Enumerations.SearchParamType.REFERENCE);
                break;
            }
            case COMPOSITE: {
                tgt.setValue((Object)Enumerations.SearchParamType.COMPOSITE);
                break;
            }
            case QUANTITY: {
                tgt.setValue((Object)Enumerations.SearchParamType.QUANTITY);
                break;
            }
            case URI: {
                tgt.setValue((Object)Enumerations.SearchParamType.URI);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.SearchParamType.NULL);
            }
        }
        return tgt;
    }

    public static CodeableReference convertCodeableConceptToCodableReference(org.hl7.fhir.dstu2.model.CodeableConcept src) {
        CodeableReference tgt = new CodeableReference();
        tgt.setConcept(VersionConvertor_10_50.convertCodeableConcept(src));
        return tgt;
    }

    public static UsageContext convertCodeableConceptToUsageContext(org.hl7.fhir.dstu2.model.CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue(VersionConvertor_10_50.convertCodeableConcept(t));
        return result;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> convertConformanceResourceStatus(Enumeration<Enumerations.ConformanceResourceStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ConformanceResourceStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.PublicationStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.PublicationStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.PublicationStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.PublicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConformanceResourceStatus> convertConformanceResourceStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.PublicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConformanceResourceStatus> tgt = new Enumeration<Enumerations.ConformanceResourceStatus>(new Enumerations.ConformanceResourceStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.PublicationStatus)((Object)src.getValue())) {
            case DRAFT: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.DRAFT);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.ACTIVE);
                break;
            }
            case RETIRED: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.RETIRED);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConformanceResourceStatus.NULL);
            }
        }
        return tgt;
    }

    public static CanonicalType convertReferenceToCanonical(Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_10_50.copyElement(src, dst, new String[0]);
        return dst;
    }

    public static Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        Reference dst = new Reference((String)src.getValue());
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)dst, new String[0]);
        return dst;
    }

    public static org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> convertConformanceEventMode(Enumeration<Conformance.ConformanceEventMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> tgt = new org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode>(new CapabilityStatement.EventCapabilityModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Conformance.ConformanceEventMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)CapabilityStatement.EventCapabilityMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Conformance.ConformanceEventMode> convertConformanceEventMode(org.hl7.fhir.r5.model.Enumeration<CapabilityStatement.EventCapabilityMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Conformance.ConformanceEventMode> tgt = new Enumeration<Conformance.ConformanceEventMode>(new Conformance.ConformanceEventModeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((CapabilityStatement.EventCapabilityMode)((Object)src.getValue())) {
            case SENDER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.SENDER);
                break;
            }
            case RECEIVER: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.RECEIVER);
                break;
            }
            default: {
                tgt.setValue((Object)Conformance.ConformanceEventMode.NULL);
            }
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_50.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_10_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_10_50.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Reference getPerformer(List<Immunization.ImmunizationPerformerComponent> practitioner) {
        for (Immunization.ImmunizationPerformerComponent p : practitioner) {
            if (!VersionConvertor_10_50.hasConcept(p.getFunction(), "http://hl7.org/fhir/v2/0443", "AP")) continue;
            return p.getActor();
        }
        return null;
    }

    public static org.hl7.fhir.r5.model.Reference getRequester(List<Immunization.ImmunizationPerformerComponent> practitioner) {
        for (Immunization.ImmunizationPerformerComponent p : practitioner) {
            if (!VersionConvertor_10_50.hasConcept(p.getFunction(), "http://hl7.org/fhir/v2/0443", "OP")) continue;
            return p.getActor();
        }
        return null;
    }

    public static boolean hasConcept(CodeableConcept cc, String system, String code) {
        for (org.hl7.fhir.r5.model.Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConcept(org.hl7.fhir.dstu2.model.CodeableConcept cc, String system, String code) {
        for (Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public static Dosage convertMedicationOrderDosageInstructionComponent(MedicationOrder.MedicationOrderDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(VersionConvertor_10_50.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_10_50.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_10_50.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static MedicationOrder.MedicationOrderDosageInstructionComponent convertMedicationOrderDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationOrder.MedicationOrderDosageInstructionComponent tgt = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasTextElement()) {
            tgt.setTextElement(VersionConvertor_10_50.convertString(src.getTextElement()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_10_50.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_10_50.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_10_50.convertType(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_10_50.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_10_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasDose()) {
            tgt.setDose(VersionConvertor_10_50.convertType(src.getDoseAndRate().get(0).getDose()));
        }
        if (src.hasDoseAndRate() && src.getDoseAndRate().get(0).hasRate()) {
            tgt.setRate(VersionConvertor_10_50.convertType(src.getDoseAndRate().get(0).getRate()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_10_50.convertRatio(src.getMaxDosePerPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> convertSlotStatus(Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Slot.SlotStatus> convertSlotStatus(org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Slot.SlotStatus> tgt = new Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus>(new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyRequest.SupplyRequestStatus)((Object)src.getValue())) {
            case REQUESTED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                break;
            }
            case FAILED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SupplyRequest.SupplyRequestStatus> convertSupplyRequestStatus(org.hl7.fhir.r5.model.Enumeration<SupplyRequest.SupplyRequestStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SupplyRequest.SupplyRequestStatus> tgt = new Enumeration<SupplyRequest.SupplyRequestStatus>(new SupplyRequest.SupplyRequestStatusEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((SupplyRequest.SupplyRequestStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.REQUESTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.CANCELLED);
                break;
            }
            default: {
                tgt.setValue((Object)SupplyRequest.SupplyRequestStatus.NULL);
            }
        }
        return tgt;
    }

    public static ValueSet.ValueSetCodeSystemComponent convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetCodeSystemComponent tgt = new ValueSet.ValueSetCodeSystemComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setSystemElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersionElement()) {
            tgt.setVersionElement(VersionConvertor_10_50.convertString(src.getVersionElement()));
        }
        if (src.hasCaseSensitiveElement()) {
            tgt.setCaseSensitiveElement(VersionConvertor_10_50.convertBoolean(src.getCaseSensitiveElement()));
        }
        for (CodeSystem.ConceptDefinitionComponent cc : src.getConcept()) {
            tgt.addConcept(VersionConvertor_10_50.convertCodeSystemConcept(src, cc));
        }
        return tgt;
    }

    public static ValueSet.ConceptDefinitionComponent convertCodeSystemConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionComponent tgt = new ValueSet.ConceptDefinitionComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        tgt.setAbstract(CodeSystemUtilities.isNotSelectable(cs, src));
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : src.getConcept()) {
            tgt.addConcept(VersionConvertor_10_50.convertCodeSystemConcept(cs, conceptDefinitionComponent));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_10_50.convertCodeSystemDesignation(conceptDefinitionDesignationComponent));
        }
        return tgt;
    }

    public static ValueSet.ConceptDefinitionDesignationComponent convertCodeSystemDesignation(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionDesignationComponent tgt = new ValueSet.ConceptDefinitionDesignationComponent();
        VersionConvertor_10_50.copyElement(src, (org.hl7.fhir.dstu2.model.Element)tgt, new String[0]);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_10_50.convertCoding(src.getUse()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static boolean isJurisdiction(org.hl7.fhir.dstu2.model.CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(t.getCoding().get(0).getSystem()) || "urn:iso:std:iso:3166".equals(t.getCoding().get(0).getSystem()) || "https://www.usps.com/".equals(t.getCoding().get(0).getSystem()));
    }

    public static Resource convertResource(org.hl7.fhir.dstu2.model.Resource src, VersionConvertorAdvisor50 advisor) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Parameters) {
            return Parameters10_50.convertParameters((org.hl7.fhir.dstu2.model.Parameters)src);
        }
        if (src instanceof Appointment) {
            return Appointment10_50.convertAppointment((Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return AppointmentResponse10_50.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.AuditEvent) {
            return AuditEvent10_50.convertAuditEvent((org.hl7.fhir.dstu2.model.AuditEvent)src);
        }
        if (src instanceof Basic) {
            return Basic10_50.convertBasic((Basic)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Binary) {
            return Binary10_50.convertBinary((org.hl7.fhir.dstu2.model.Binary)src);
        }
        if (src instanceof Bundle) {
            return Bundle10_50.convertBundle((Bundle)src);
        }
        if (src instanceof CarePlan) {
            return CarePlan10_50.convertCarePlan((CarePlan)src);
        }
        if (src instanceof Communication) {
            return Communication10_50.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.CommunicationRequest) {
            return CommunicationRequest10_50.convertCommunicationRequest((org.hl7.fhir.dstu2.model.CommunicationRequest)src);
        }
        if (src instanceof Composition) {
            return Composition10_50.convertComposition((Composition)src);
        }
        if (src instanceof ConceptMap) {
            return ConceptMap10_50.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof Condition) {
            return Condition10_50.convertCondition((Condition)src);
        }
        if (src instanceof Conformance) {
            return Conformance10_50.convertConformance((Conformance)src);
        }
        if (src instanceof DataElement) {
            return DataElement10_50.convertDataElement((DataElement)src);
        }
        if (src instanceof DetectedIssue) {
            return DetectedIssue10_50.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof DeviceMetric) {
            return DeviceMetric10_50.convertDeviceMetric((DeviceMetric)src);
        }
        if (src instanceof DeviceUseStatement) {
            return DeviceUseStatement10_50.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DiagnosticReport) {
            return DiagnosticReport10_50.convertDiagnosticReport((org.hl7.fhir.dstu2.model.DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.DocumentReference) {
            return DocumentReference10_50.convertDocumentReference((org.hl7.fhir.dstu2.model.DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return Encounter10_50.convertEncounter((Encounter)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.EnrollmentRequest) {
            return EnrollmentRequest10_50.convertEnrollmentRequest((org.hl7.fhir.dstu2.model.EnrollmentRequest)src);
        }
        if (src instanceof EnrollmentResponse) {
            return EnrollmentResponse10_50.convertEnrollmentResponse((EnrollmentResponse)src);
        }
        if (src instanceof EpisodeOfCare) {
            return EpisodeOfCare10_50.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.FamilyMemberHistory) {
            return FamilyMemberHistory10_50.convertFamilyMemberHistory((org.hl7.fhir.dstu2.model.FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return Flag10_50.convertFlag((Flag)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Group) {
            return Group10_50.convertGroup((org.hl7.fhir.dstu2.model.Group)src);
        }
        if (src instanceof HealthcareService) {
            return HealthcareService10_50.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.ImplementationGuide) {
            return ImplementationGuide10_50.convertImplementationGuide((org.hl7.fhir.dstu2.model.ImplementationGuide)src);
        }
        if (src instanceof List_) {
            return List10_50.convertList((List_)src);
        }
        if (src instanceof Location) {
            return Location10_50.convertLocation((Location)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MedicationDispense) {
            return MedicationDispense10_50.convertMedicationDispense((org.hl7.fhir.dstu2.model.MedicationDispense)src);
        }
        if (src instanceof MedicationStatement) {
            return MedicationStatement10_50.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.MessageHeader) {
            return MessageHeader10_50.convertMessageHeader((org.hl7.fhir.dstu2.model.MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.NamingSystem) {
            return NamingSystem10_50.convertNamingSystem((org.hl7.fhir.dstu2.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Observation) {
            return Observation10_50.convertObservation((org.hl7.fhir.dstu2.model.Observation)src);
        }
        if (src instanceof OperationDefinition) {
            return OperationDefinition10_50.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.OperationOutcome) {
            return OperationOutcome10_50.convertOperationOutcome((org.hl7.fhir.dstu2.model.OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Organization) {
            return Organization10_50.convertOrganization((org.hl7.fhir.dstu2.model.Organization)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Patient) {
            return Patient10_50.convertPatient((org.hl7.fhir.dstu2.model.Patient)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Person) {
            return Person10_50.convertPerson((org.hl7.fhir.dstu2.model.Person)src);
        }
        if (src instanceof Practitioner) {
            return Practitioner10_50.convertPractitioner((Practitioner)src);
        }
        if (src instanceof Provenance) {
            return Provenance10_50.convertProvenance((Provenance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Questionnaire) {
            return Questionnaire10_50.convertQuestionnaire((org.hl7.fhir.dstu2.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.QuestionnaireResponse) {
            return QuestionnaireResponse10_50.convertQuestionnaireResponse((org.hl7.fhir.dstu2.model.QuestionnaireResponse)src);
        }
        if (src instanceof RiskAssessment) {
            return RiskAssessment10_50.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Schedule) {
            return Schedule10_50.convertSchedule((org.hl7.fhir.dstu2.model.Schedule)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SearchParameter) {
            return SearchParameter10_50.convertSearchParameter((org.hl7.fhir.dstu2.model.SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.Slot) {
            return Slot10_50.convertSlot((org.hl7.fhir.dstu2.model.Slot)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.StructureDefinition) {
            return StructureDefinition10_50.convertStructureDefinition((org.hl7.fhir.dstu2.model.StructureDefinition)src);
        }
        if (src instanceof Substance) {
            return Substance10_50.convertSubstance((Substance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SupplyDelivery) {
            return SupplyDelivery10_50.convertSupplyDelivery((org.hl7.fhir.dstu2.model.SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.dstu2.model.SupplyRequest) {
            return SupplyRequest10_50.convertSupplyRequest((org.hl7.fhir.dstu2.model.SupplyRequest)src);
        }
        if (src instanceof TestScript) {
            return TestScript10_50.convertTestScript((TestScript)src);
        }
        if (src instanceof ValueSet) {
            return ValueSet10_50.convertValueSet((ValueSet)src, advisor);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2.model.Resource convertResource(Resource src, VersionConvertorAdvisor50 advisor) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return Parameters10_50.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Appointment) {
            return Appointment10_50.convertAppointment((org.hl7.fhir.r5.model.Appointment)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.AppointmentResponse) {
            return AppointmentResponse10_50.convertAppointmentResponse((org.hl7.fhir.r5.model.AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return AuditEvent10_50.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Basic) {
            return Basic10_50.convertBasic((org.hl7.fhir.r5.model.Basic)src);
        }
        if (src instanceof Binary) {
            return Binary10_50.convertBinary((Binary)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Bundle) {
            return Bundle10_50.convertBundle((org.hl7.fhir.r5.model.Bundle)src, advisor);
        }
        if (src instanceof org.hl7.fhir.r5.model.CarePlan) {
            return CarePlan10_50.convertCarePlan((org.hl7.fhir.r5.model.CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Communication) {
            return Communication10_50.convertCommunication((org.hl7.fhir.r5.model.Communication)src);
        }
        if (src instanceof CommunicationRequest) {
            return CommunicationRequest10_50.convertCommunicationRequest((CommunicationRequest)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Composition) {
            return Composition10_50.convertComposition((org.hl7.fhir.r5.model.Composition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ConceptMap) {
            return ConceptMap10_50.convertConceptMap((org.hl7.fhir.r5.model.ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Condition) {
            return Condition10_50.convertCondition((org.hl7.fhir.r5.model.Condition)src);
        }
        if (src instanceof CapabilityStatement) {
            return Conformance10_50.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DetectedIssue) {
            return DetectedIssue10_50.convertDetectedIssue((org.hl7.fhir.r5.model.DetectedIssue)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DeviceMetric) {
            return DeviceMetric10_50.convertDeviceMetric((org.hl7.fhir.r5.model.DeviceMetric)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.DeviceUseStatement) {
            return DeviceUseStatement10_50.convertDeviceUseStatement((org.hl7.fhir.r5.model.DeviceUseStatement)src);
        }
        if (src instanceof DiagnosticReport) {
            return DiagnosticReport10_50.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof DocumentReference) {
            return DocumentReference10_50.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Encounter) {
            return Encounter10_50.convertEncounter((org.hl7.fhir.r5.model.Encounter)src);
        }
        if (src instanceof EnrollmentRequest) {
            return EnrollmentRequest10_50.convertEnrollmentRequest((EnrollmentRequest)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EnrollmentResponse) {
            return EnrollmentResponse10_50.convertEnrollmentResponse((org.hl7.fhir.r5.model.EnrollmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.EpisodeOfCare) {
            return EpisodeOfCare10_50.convertEpisodeOfCare((org.hl7.fhir.r5.model.EpisodeOfCare)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return FamilyMemberHistory10_50.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Flag) {
            return Flag10_50.convertFlag((org.hl7.fhir.r5.model.Flag)src);
        }
        if (src instanceof Group) {
            return Group10_50.convertGroup((Group)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.HealthcareService) {
            return HealthcareService10_50.convertHealthcareService((org.hl7.fhir.r5.model.HealthcareService)src);
        }
        if (src instanceof ImplementationGuide) {
            return ImplementationGuide10_50.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof ListResource) {
            return List10_50.convertList((ListResource)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Location) {
            return Location10_50.convertLocation((org.hl7.fhir.r5.model.Location)src);
        }
        if (src instanceof MedicationDispense) {
            return MedicationDispense10_50.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof MedicationUsage) {
            return MedicationStatement10_50.convertMedicationStatement((MedicationUsage)src);
        }
        if (src instanceof MessageHeader) {
            return MessageHeader10_50.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof NamingSystem) {
            return NamingSystem10_50.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof Observation) {
            return Observation10_50.convertObservation((Observation)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.OperationDefinition) {
            return OperationDefinition10_50.convertOperationDefinition((org.hl7.fhir.r5.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return OperationOutcome10_50.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return Organization10_50.convertOrganization((Organization)src);
        }
        if (src instanceof Patient) {
            return Patient10_50.convertPatient((Patient)src);
        }
        if (src instanceof Person) {
            return Person10_50.convertPerson((Person)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Practitioner) {
            return Practitioner10_50.convertPractitioner((org.hl7.fhir.r5.model.Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Provenance) {
            return Provenance10_50.convertProvenance((org.hl7.fhir.r5.model.Provenance)src);
        }
        if (src instanceof Questionnaire) {
            return Questionnaire10_50.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return QuestionnaireResponse10_50.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.RiskAssessment) {
            return RiskAssessment10_50.convertRiskAssessment((org.hl7.fhir.r5.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return Schedule10_50.convertSchedule((Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return SearchParameter10_50.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof Slot) {
            return Slot10_50.convertSlot((Slot)src);
        }
        if (src instanceof StructureDefinition) {
            return StructureDefinition10_50.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.Substance) {
            return Substance10_50.convertSubstance((org.hl7.fhir.r5.model.Substance)src);
        }
        if (src instanceof SupplyDelivery) {
            return SupplyDelivery10_50.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof SupplyRequest) {
            return SupplyRequest10_50.convertSupplyRequest((SupplyRequest)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.TestScript) {
            return TestScript10_50.convertTestScript((org.hl7.fhir.r5.model.TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r5.model.ValueSet) {
            return ValueSet10_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)src, advisor);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public static TerminologyCapabilities convertTerminologyCapabilities(org.hl7.fhir.dstu2.model.Parameters src) {
        TerminologyCapabilities res = new TerminologyCapabilities();
        for (Parameters.ParametersParameterComponent p : src.getParameter()) {
            if (!p.getName().equals("system")) continue;
            res.addCodeSystem().setUri(p.getValue().primitiveValue());
        }
        return res;
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList(rt, "Parameters", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "Bundle", "CarePlan", "Communication", "CommunicationRequest", "Composition", "ConceptMap", "Condition", "CapabilityStatement", "DetectedIssue", "DeviceMetric", "DeviceUseStatement", "DiagnosticReport", "DocumentReference", "Encounter", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "FamilyMemberHistory", "Flag", "Group", "HealthcareService", "ImplementationGuide", "ListResource", "Location", "MedicationDispense", "MedicationStatement", "MessageHeader", "NamingSystem", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Patient", "Person", "Practitioner", "Questionnaire", "QuestionnaireResponse", "RiskAssessment", "Schedule", "SearchParameter", "Slot", "StructureDefinition", "Subscription", "Substance", "SupplyDelivery", "SupplyRequest", "TestScript", "ValueSet");
    }

    public static Resource convertResource(org.hl7.fhir.dstu2.model.Resource src) throws FHIRException {
        return VersionConvertor_10_50.convertResource(src, null);
    }

    public static org.hl7.fhir.dstu2.model.Resource convertResource(Resource src) throws FHIRException {
        return VersionConvertor_10_50.convertResource(src, null);
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }

    public static class SourceElementComponentWrapper {
        public String source;
        public String target;
        public ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.SourceElementComponent comp, String source, String target) {
            this.source = source;
            this.target = target;
            this.comp = comp;
        }
    }
}

