/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.net.URISyntaxException;
import java.util.Map;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.r5.utils.client.ToolingClientLogger;

public class TerminologyClientR2
implements TerminologyClient {
    private FHIRToolingClient client;

    public TerminologyClientR2(String address) throws URISyntaxException {
        this.client = new FHIRToolingClient(address);
    }

    @Override
    public TerminologyCapabilities getTerminologyCapabilities() throws FHIRException {
        return VersionConvertor_10_50.convertTerminologyCapabilities(this.client.getTerminologyCapabilities());
    }

    @Override
    public String getAddress() {
        return this.client.getAddress();
    }

    @Override
    public ValueSet expandValueset(ValueSet vs, Parameters p, Map<String, String> params) throws FHIRException {
        org.hl7.fhir.dstu2.model.ValueSet vs2 = (org.hl7.fhir.dstu2.model.ValueSet)VersionConvertor_10_50.convertResource(vs);
        org.hl7.fhir.dstu2.model.Parameters p2 = (org.hl7.fhir.dstu2.model.Parameters)VersionConvertor_10_50.convertResource(p);
        vs2 = this.client.expandValueset(vs2, p2, params);
        return (ValueSet)VersionConvertor_10_50.convertResource(vs2);
    }

    @Override
    public Parameters validateCS(Parameters pin) throws FHIRException {
        org.hl7.fhir.dstu2.model.Parameters p2 = (org.hl7.fhir.dstu2.model.Parameters)VersionConvertor_10_50.convertResource(pin);
        p2 = this.client.operateType(org.hl7.fhir.dstu2.model.ValueSet.class, "validate-code", p2);
        return (Parameters)VersionConvertor_10_50.convertResource(p2);
    }

    @Override
    public Parameters validateVS(Parameters pin) throws FHIRException {
        org.hl7.fhir.dstu2.model.Parameters p2 = (org.hl7.fhir.dstu2.model.Parameters)VersionConvertor_10_50.convertResource(pin);
        p2 = this.client.operateType(org.hl7.fhir.dstu2.model.ValueSet.class, "validate-code", p2);
        return (Parameters)VersionConvertor_10_50.convertResource(p2);
    }

    @Override
    public void setTimeout(int i) {
    }

    @Override
    public void setLogger(ToolingClientLogger txLog) {
    }

    @Override
    public CapabilityStatement getCapabilitiesStatementQuick() throws FHIRException {
        return (CapabilityStatement)VersionConvertor_10_50.convertResource(this.client.getConformanceStatementQuick());
    }

    @Override
    public Parameters lookupCode(Map<String, String> params) throws FHIRException {
        return (Parameters)VersionConvertor_10_50.convertResource(this.client.lookupCode(params));
    }
}

