/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.convertors.conv40_50.StructureDefinition40_50;
import org.hl7.fhir.convertors.conv40_50.ValueSet40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ZipGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpecDifferenceEvaluator {
    private SpecPackage original = new SpecPackage();
    private SpecPackage revision = new SpecPackage();
    private Map<String, String> renames = new HashMap<String, String>();
    private List<String> moves = new ArrayList<String>();
    private XhtmlNode tbl;
    private TypeLinkProvider linker;

    public void loadFromIni(IniFile ini) {
        String[] names = ini.getPropertyNames("r5-renames");
        if (names != null) {
            for (String n : names) {
                this.renames.put(ini.getStringProperty("r5-renames", n), n);
            }
        }
    }

    public SpecPackage getOriginal() {
        return this.original;
    }

    public SpecPackage getRevision() {
        return this.revision;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("gen diff");
        SpecDifferenceEvaluator self = new SpecDifferenceEvaluator();
        self.loadFromIni(new IniFile("C:\\work\\org.hl7.fhir\\build\\source\\fhir.ini"));
        SpecDifferenceEvaluator.loadSD4(self.original.types, "C:\\work\\org.hl7.fhir\\build\\source\\release4\\profiles-types.xml");
        SpecDifferenceEvaluator.loadSD(self.revision.types, "C:\\work\\org.hl7.fhir\\build\\publish\\profiles-types.xml");
        SpecDifferenceEvaluator.loadSD4(self.original.resources, "C:\\work\\org.hl7.fhir\\build\\source\\release4\\profiles-resources.xml");
        SpecDifferenceEvaluator.loadSD(self.revision.resources, "C:\\work\\org.hl7.fhir\\build\\publish\\profiles-resources.xml");
        SpecDifferenceEvaluator.loadVS4(self.original.expansions, "C:\\work\\org.hl7.fhir\\build\\source\\release4\\expansions.xml");
        SpecDifferenceEvaluator.loadVS(self.revision.expansions, "C:\\work\\org.hl7.fhir\\build\\publish\\expansions.xml");
        SpecDifferenceEvaluator.loadVS4(self.original.valuesets, "C:\\work\\org.hl7.fhir\\build\\source\\release4\\valuesets.xml");
        SpecDifferenceEvaluator.loadVS(self.revision.valuesets, "C:\\work\\org.hl7.fhir\\build\\publish\\valuesets.xml");
        StringBuilder b = new StringBuilder();
        b.append("<html>\r\n");
        b.append("<head>\r\n");
        b.append("<link href=\"fhir.css\" rel=\"stylesheet\"/>\r\n");
        b.append("</head>\r\n");
        b.append("<body>\r\n");
        b.append(self.getDiffAsHtml(null));
        b.append("</body>\r\n");
        b.append("</html>\r\n");
        TextFile.stringToFile(b.toString(), "c:\\temp\\diff.html");
        System.out.println("done");
    }

    private static void loadSD4(Map<String, org.hl7.fhir.r5.model.StructureDefinition> map, String fn) throws FHIRException, FileNotFoundException, IOException {
        org.hl7.fhir.r4.model.Bundle bundle = (org.hl7.fhir.r4.model.Bundle)new XmlParser().parse(new FileInputStream(fn));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            if (!(be.getResource() instanceof StructureDefinition)) continue;
            StructureDefinition sd = (StructureDefinition)be.getResource();
            map.put(sd.getName(), StructureDefinition40_50.convertStructureDefinition(sd));
        }
    }

    private static void loadSD(Map<String, org.hl7.fhir.r5.model.StructureDefinition> map, String fn) throws FHIRFormatError, FileNotFoundException, IOException {
        Bundle bundle = (Bundle)new org.hl7.fhir.r5.formats.XmlParser().parse(new FileInputStream(fn));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            if (!(be.getResource() instanceof org.hl7.fhir.r5.model.StructureDefinition)) continue;
            org.hl7.fhir.r5.model.StructureDefinition sd = (org.hl7.fhir.r5.model.StructureDefinition)be.getResource();
            map.put(sd.getName(), sd);
        }
    }

    private static void loadVS4(Map<String, ValueSet> map, String fn) throws FHIRException, FileNotFoundException, IOException {
        org.hl7.fhir.r4.model.Bundle bundle = (org.hl7.fhir.r4.model.Bundle)new XmlParser().parse(new FileInputStream(fn));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            if (!(be.getResource() instanceof org.hl7.fhir.r4.model.ValueSet)) continue;
            org.hl7.fhir.r4.model.ValueSet sd = (org.hl7.fhir.r4.model.ValueSet)be.getResource();
            map.put(sd.getName(), ValueSet40_50.convertValueSet(sd));
        }
    }

    private static void loadVS(Map<String, ValueSet> map, String fn) throws FHIRFormatError, FileNotFoundException, IOException {
        Bundle bundle = (Bundle)new org.hl7.fhir.r5.formats.XmlParser().parse(new FileInputStream(fn));
        for (Bundle.BundleEntryComponent be : bundle.getEntry()) {
            if (!(be.getResource() instanceof ValueSet)) continue;
            ValueSet sd = (ValueSet)be.getResource();
            map.put(sd.getName(), sd);
        }
    }

    public void getDiffAsJson(JsonObject json, org.hl7.fhir.r5.model.StructureDefinition rev) throws IOException {
        this.linker = null;
        org.hl7.fhir.r5.model.StructureDefinition orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(rev.getName()));
        if (orig == null) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(this.checkRename(rev.getName()));
        }
        JsonArray types = new JsonArray();
        json.add("types", types);
        types.add(new JsonPrimitive(rev.getName()));
        JsonObject type = new JsonObject();
        json.add(rev.getName(), type);
        if (orig == null) {
            type.addProperty("status", "new");
        } else {
            this.start();
            this.compareJson(type, orig, rev);
        }
    }

    public void getDiffAsXml(Document doc, Element xml, org.hl7.fhir.r5.model.StructureDefinition rev) throws IOException {
        this.linker = null;
        org.hl7.fhir.r5.model.StructureDefinition orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(rev.getName()));
        if (orig == null) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(this.checkRename(rev.getName()));
        }
        Element type = doc.createElement("type");
        type.setAttribute("name", rev.getName());
        xml.appendChild(type);
        if (orig == null) {
            type.setAttribute("status", "new");
        } else {
            this.start();
            this.compareXml(doc, type, orig, rev);
        }
    }

    public void getDiffAsJson(JsonObject json) throws IOException {
        JsonObject type;
        org.hl7.fhir.r5.model.StructureDefinition rev;
        org.hl7.fhir.r5.model.StructureDefinition orig;
        this.linker = null;
        JsonArray types = new JsonArray();
        json.add("types", types);
        for (String s2 : this.sorted(this.revision.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            types.add(new JsonPrimitive(rev.getName()));
            type = new JsonObject();
            json.add(rev.getName(), type);
            if (orig == null) {
                type.addProperty("status", "new");
                continue;
            }
            if (rev.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                type.addProperty("status", "no-change");
                continue;
            }
            if (rev.hasDerivation() && orig.hasDerivation() && rev.getDerivation() != orig.getDerivation()) {
                type.addProperty("status", "status-change");
                type.addProperty("past-status", orig.getDerivation().toCode());
                type.addProperty("current-status", rev.getDerivation().toCode());
                continue;
            }
            this.compareJson(type, orig, rev);
        }
        for (String s2 : this.sorted(this.original.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            if (rev != null) continue;
            types.add(new JsonPrimitive(orig.getName()));
            type = new JsonObject();
            json.add(orig.getName(), type);
            type.addProperty("status", "deleted");
        }
        for (String s2 : this.sorted(this.revision.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(s2));
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            types.add(new JsonPrimitive(rev.getName()));
            type = new JsonObject();
            json.add(rev.getName(), type);
            if (orig == null) {
                type.addProperty("status", "new");
                continue;
            }
            this.compareJson(type, orig, rev);
        }
        for (String s2 : this.sorted(this.original.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            if (rev != null) continue;
            types.add(new JsonPrimitive(orig.getName()));
            type = new JsonObject();
            json.add(orig.getName(), type);
            type.addProperty("status", "deleted");
        }
    }

    public void getDiffAsXml(Document doc, Element xml) throws IOException {
        Element type;
        org.hl7.fhir.r5.model.StructureDefinition rev;
        org.hl7.fhir.r5.model.StructureDefinition orig;
        this.linker = null;
        for (String s2 : this.sorted(this.revision.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            type = doc.createElement("type");
            type.setAttribute("name", rev.getName());
            xml.appendChild(type);
            if (orig == null) {
                type.setAttribute("status", "new");
                continue;
            }
            if (rev.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                type.setAttribute("status", "no-change");
                continue;
            }
            if (rev.hasDerivation() && orig.hasDerivation() && rev.getDerivation() != orig.getDerivation()) {
                type.setAttribute("status", "status-change");
                type.setAttribute("past-status", orig.getDerivation().toCode());
                type.setAttribute("current-status", rev.getDerivation().toCode());
                continue;
            }
            this.compareXml(doc, type, orig, rev);
        }
        for (String s2 : this.sorted(this.original.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            if (rev != null) continue;
            type = doc.createElement("type");
            type.setAttribute("name", orig.getName());
            xml.appendChild(type);
            type.setAttribute("status", "deleted");
        }
        for (String s2 : this.sorted(this.revision.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(s2));
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            type = doc.createElement("type");
            type.setAttribute("name", rev.getName());
            xml.appendChild(type);
            if (orig == null) {
                type.setAttribute("status", "new");
                continue;
            }
            this.compareXml(doc, type, orig, rev);
        }
        for (String s2 : this.sorted(this.original.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            if (rev != null) continue;
            type = doc.createElement("type");
            type.setAttribute("name", orig.getName());
            xml.appendChild(type);
            type.setAttribute("status", "deleted");
        }
    }

    public String getDiffAsHtml(TypeLinkProvider linker, org.hl7.fhir.r5.model.StructureDefinition rev) throws IOException {
        this.linker = linker;
        org.hl7.fhir.r5.model.StructureDefinition orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(rev.getName()));
        if (orig == null) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(this.checkRename(rev.getName()));
        }
        if (orig == null) {
            return "<p>This " + rev.getKind().toCode() + " did not exist in Release 2</p>";
        }
        this.start();
        this.compare(orig, rev);
        return new XhtmlComposer(false, true).compose(this.tbl) + "\r\n<p>See the <a href=\"diff.html\">Full Difference</a> for further information</p>\r\n";
    }

    public String getDiffAsHtml(TypeLinkProvider linker) throws IOException {
        org.hl7.fhir.r5.model.StructureDefinition rev;
        org.hl7.fhir.r5.model.StructureDefinition orig;
        this.linker = linker;
        this.start();
        this.header("Types");
        for (String s2 : this.sorted(this.revision.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            if (orig == null) {
                this.markNew(rev.getName(), true, false, false);
                continue;
            }
            if (rev.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
                this.markNoChanges(rev.getName(), true);
                continue;
            }
            if (rev.hasDerivation() && orig.hasDerivation() && rev.getDerivation() != orig.getDerivation()) {
                this.markChanged(rev.getName(), "Changed from a " + orig.getDerivation().toCode() + " to a " + rev.getDerivation().toCode(), true);
                continue;
            }
            this.compare(orig, rev);
        }
        for (String s2 : this.sorted(this.original.types.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.types.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.types.get(s2);
            if (rev != null) continue;
            this.markDeleted(orig.getName(), true);
        }
        this.header("Resources");
        for (String s2 : this.sorted(this.revision.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(this.checkRename(s2));
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            if (orig == null) {
                this.markNew(rev.getName(), true, true, false);
                continue;
            }
            this.compare(orig, rev);
        }
        for (String s2 : this.sorted(this.original.resources.keySet())) {
            orig = (org.hl7.fhir.r5.model.StructureDefinition)this.original.resources.get(s2);
            rev = (org.hl7.fhir.r5.model.StructureDefinition)this.revision.resources.get(s2);
            if (rev != null) continue;
            this.markDeleted(orig.getName(), true);
        }
        return new XhtmlComposer(false, true).compose(this.tbl);
    }

    private Object checkRename(String s2) {
        if (this.renames.containsKey(s2)) {
            return this.renames.get(s2);
        }
        return s2;
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(keys);
        Collections.sort(list);
        return list;
    }

    private void header(String title) {
        this.tbl.addTag("tr").setAttribute("class", "diff-title").addTag("td").setAttribute("colspan", "2").addText(title);
    }

    private void start() {
        this.tbl = new XhtmlNode(NodeType.Element, "table");
        this.tbl.setAttribute("class", "grid");
    }

    private void markNoChanges(String name, boolean item) {
        String link;
        XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", item ? "diff-item" : "diff-entry");
        XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
        XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
        String string = link = this.linker == null ? null : this.linker.getLink(name);
        if (link != null) {
            left.addTag("a").setAttribute("href", link).addText(name);
        } else {
            left.addText(name);
        }
        right.span("opacity: 0.5", null).addText("(No Changes)");
    }

    private void markChanged(String name, String change, boolean item) {
        String link;
        XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", item ? "diff-item" : "diff-entry");
        XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
        XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
        String string = link = this.linker == null ? null : this.linker.getLink(name);
        if (link != null) {
            left.addTag("a").setAttribute("href", link).addText(name);
        } else {
            left.addText(name);
        }
        right.ul().li().addText(change);
    }

    private void markDeleted(String name, boolean item) {
        XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", item ? "diff-del-item" : "diff-del");
        XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
        XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
        left.addText(name);
        right.ul().li().addText("deleted");
    }

    private void markNew(String name, boolean item, boolean res, boolean mand) {
        String link;
        XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", item ? "diff-new-item" : "diff-new");
        XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
        XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
        String string = link = this.linker == null ? null : this.linker.getLink(name);
        if (link != null) {
            left.addTag("a").setAttribute("href", link).addText(name);
        } else {
            left.addText(name);
        }
        if (!res && mand) {
            right.ul().li().b().addText("Added Mandatory Element");
        } else {
            right.ul().li().addText(res ? "Added Resource" : (!name.contains(".") ? "Added Type" : (mand ? "Added Mandatory Element " : "Added Element")));
        }
    }

    private void compare(org.hl7.fhir.r5.model.StructureDefinition orig, org.hl7.fhir.r5.model.StructureDefinition rev) {
        ElementDefinition oed;
        String link;
        this.moves.clear();
        XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", "diff-item");
        XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
        String string = link = this.linker == null ? null : this.linker.getLink(rev.getName());
        if (link != null) {
            left.addTag("a").setAttribute("href", link).addText(rev.getName());
        } else {
            left.addText(rev.getName());
        }
        XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
        boolean changed = false;
        if (!orig.getName().equals(rev.getName())) {
            changed = true;
            right.ul().li().addText("Name Changed from " + orig.getName() + " to " + rev.getName());
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = this.getMatchingElement(rev.getName(), orig.getDifferential().getElement(), ed);
            if (oed == null) continue;
            ed.setUserData("match", oed);
            oed.setUserData("match", ed);
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = (ElementDefinition)ed.getUserData("match");
            if (oed == null) {
                changed = true;
                this.markNew(ed.getPath(), false, false, ed.getMin() > 0);
                continue;
            }
            changed = this.compareElement(ed, oed) || changed;
        }
        ArrayList<String> dels = new ArrayList<String>();
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            if (ed.getUserData("match") != null) continue;
            changed = true;
            boolean marked = false;
            for (String s2 : dels) {
                if (!ed.getPath().startsWith(s2 + ".")) continue;
                marked = true;
            }
            if (marked) continue;
            dels.add(ed.getPath());
            this.markDeleted(ed.getPath(), false);
        }
        if (!changed) {
            right.ul().li().addText("No Changes");
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
    }

    private ElementDefinition getMatchingElement(String tn, List<ElementDefinition> list, ElementDefinition target) {
        String tp = this.mapPath(tn, target.getPath());
        if (tp.endsWith("[x]")) {
            tp = tp.substring(0, tp.length() - 4);
        }
        for (ElementDefinition ed : list) {
            String p = ed.getPath();
            if (p.endsWith("[x]")) {
                p = p.substring(0, p.length() - 4);
            }
            if (!p.equals(tp)) continue;
            return ed;
        }
        return null;
    }

    private String mapPath(String tn, String path) {
        if (this.renames.containsKey(path)) {
            return this.renames.get(path);
        }
        for (String r : this.renames.keySet()) {
            if (!path.startsWith(r + ".")) continue;
            return this.renames.get(r) + "." + path.substring(r.length() + 1);
        }
        return path;
    }

    private boolean compareElement(ElementDefinition rev, ElementDefinition orig) {
        String s2;
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("\r\n");
        String rn = this.tail(rev.getPath());
        String on = this.tail(orig.getPath());
        String rp = this.head(rev.getPath());
        String op = this.head(orig.getPath());
        boolean renamed = false;
        if (!rn.equals(on) && rev.getPath().contains(".")) {
            if (rp.equals(op)) {
                b.append("Renamed from " + on + " to " + rn);
            } else {
                b.append("Moved from " + orig.getPath() + " to " + rn);
            }
            renamed = true;
        } else if (!rev.getPath().equals(orig.getPath()) && !this.moveAlreadyNoted(rev.getPath(), orig.getPath())) {
            this.noteMove(rev.getPath(), orig.getPath());
            b.append("Moved from " + this.head(orig.getPath()) + " to " + this.head(rev.getPath()));
            renamed = true;
        }
        if (rev.getMin() != orig.getMin()) {
            b.append("Min Cardinality changed from " + Integer.toString(orig.getMin()) + " to " + Integer.toString(rev.getMin()));
        }
        if (!rev.getMax().equals(orig.getMax())) {
            b.append("Max Cardinality changed from " + orig.getMax() + " to " + rev.getMax());
        }
        this.analyseTypes(b, rev, orig);
        if ((this.hasBindingToNote(rev) || this.hasBindingToNote(orig)) && !Utilities.noString(s2 = this.compareBindings(rev, orig))) {
            b.append(s2);
        }
        if (rev.hasDefaultValue() || orig.hasDefaultValue()) {
            if (!rev.hasDefaultValue()) {
                b.append("Default Value " + this.describeValue(orig.getDefaultValue()) + " removed");
            } else if (!orig.hasDefaultValue()) {
                b.append("Default Value " + this.describeValue(rev.getDefaultValue()) + " added");
            } else {
                String s22;
                String s1 = this.describeValue(orig.getDefaultValue());
                if (!s1.equals(s22 = this.describeValue(rev.getDefaultValue()))) {
                    b.append("Default Value changed from " + s1 + " to " + s22);
                }
            }
        }
        if (rev.getIsModifier() != orig.getIsModifier()) {
            if (rev.getIsModifier()) {
                b.append("Now marked as Modifier");
            } else {
                b.append("No longer marked as Modifier");
            }
        }
        if (b.length() > 0) {
            XhtmlNode tr = this.tbl.addTag("tr").setAttribute("class", renamed ? "diff-changed-item" : "diff-entry");
            XhtmlNode left = tr.addTag("td").setAttribute("class", "diff-left");
            left.addText(rev.getPath());
            XhtmlNode right = tr.addTag("td").setAttribute("class", "diff-right");
            XhtmlNode ul = null;
            for (String s3 : b.toString().split("\\r?\\n")) {
                if (Utilities.noString(s3)) continue;
                if (ul == null) {
                    ul = right.addTag("ul");
                }
                XhtmlNode li = ul.addTag("li").notPretty();
                if (s3.contains("`")) {
                    String[] p = s3.split("\\`");
                    boolean code = true;
                    li.addText(p[0]);
                    for (int i = 1; i < p.length; ++i) {
                        if (code) {
                            li.addTag("code").addText(p[i]);
                        } else {
                            li.addText(p[i]);
                        }
                        code = !code;
                    }
                    continue;
                }
                li.addText(s3);
            }
        }
        return b.length() > 0;
    }

    private void noteMove(String revpath, String origpath) {
        this.moves.add(revpath + "=" + origpath);
    }

    private boolean moveAlreadyNoted(String revpath, String origpath) {
        if (this.moves.contains(revpath + "=" + origpath)) {
            return true;
        }
        if (!revpath.contains(".") || !origpath.contains(".")) {
            return false;
        }
        return this.moveAlreadyNoted(this.head(revpath), this.head(origpath));
    }

    private String describeValue(DataType v) {
        if (v instanceof PrimitiveType) {
            return "\"" + ((PrimitiveType)v).asStringValue() + "\"";
        }
        return "{complex}";
    }

    private String compareBindings(ElementDefinition rev, ElementDefinition orig) {
        if (!this.hasBindingToNote(rev)) {
            return "Remove Binding " + this.describeBinding(orig);
        }
        if (!this.hasBindingToNote(orig)) {
            return "Add Binding " + this.describeBinding(rev);
        }
        return this.compareBindings(rev.getBinding(), orig.getBinding());
    }

    private String compareBindings(ElementDefinition.ElementDefinitionBindingComponent rev, ElementDefinition.ElementDefinitionBindingComponent orig) {
        ValueSet vorig;
        ValueSet vrev;
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("\r\n");
        if (rev.getStrength() != orig.getStrength()) {
            b.append("Change binding strength from " + orig.getStrength().toCode() + " to " + rev.getStrength().toCode());
        }
        if (!Base.compareDeep(rev.getValueSet(), orig.getValueSet(), false)) {
            b.append("Change value set from " + this.describeReference(orig.getValueSet()) + " to " + this.describeReference(rev.getValueSet()));
        }
        if (!this.maxValueSetsMatch(rev, orig)) {
            b.append("Change max value set from " + this.describeMax(orig) + " to " + this.describeMax(rev));
        }
        if (rev.getStrength() == Enumerations.BindingStrength.REQUIRED && orig.getStrength() == Enumerations.BindingStrength.REQUIRED) {
            vrev = this.getValueSet(rev.getValueSet(), this.revision.expansions);
            vorig = this.getValueSet(rev.getValueSet(), this.original.expansions);
            CommaSeparatedStringBuilder br = new CommaSeparatedStringBuilder();
            int ir = 0;
            CommaSeparatedStringBuilder bo = new CommaSeparatedStringBuilder();
            int io = 0;
            if (vrev != null && vorig != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : vorig.getExpansion().getContains()) {
                    if (this.hasCode(vrev, cc)) continue;
                    ++io;
                    bo.append("`" + Utilities.escapeXml(cc.getCode()) + "`");
                }
                for (ValueSet.ValueSetExpansionContainsComponent cc : vrev.getExpansion().getContains()) {
                    if (this.hasCode(vorig, cc)) continue;
                    ++ir;
                    br.append("`" + Utilities.escapeXml(cc.getCode()) + "`");
                }
            }
            if (io > 0) {
                b.append("Remove " + Utilities.pluralize("Code", io) + " " + bo);
            }
            if (ir > 0) {
                b.append("Add " + Utilities.pluralize("Code", ir) + "  " + br);
            }
        }
        if (rev.getStrength() == Enumerations.BindingStrength.EXTENSIBLE && orig.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
            vrev = this.getValueSet(rev.getValueSet(), this.revision.valuesets);
            vorig = this.getValueSet(orig.getValueSet(), this.original.valuesets);
            if (vrev != null && vrev.hasCompose() && vrev.getCompose().getInclude().size() == 1 && vrev.getCompose().getIncludeFirstRep().hasSystem() && vorig != null && vorig.hasCompose() && vorig.getCompose().getInclude().size() == 1 && vorig.getCompose().getIncludeFirstRep().hasSystem() && !vorig.getCompose().getIncludeFirstRep().getSystem().equals(vrev.getCompose().getIncludeFirstRep().getSystem())) {
                b.append("Change code system for extensibly bound codes from \"" + vorig.getCompose().getIncludeFirstRep().getSystem() + "\" to \"" + vrev.getCompose().getIncludeFirstRep().getSystem() + "\"");
            }
        }
        return b.toString();
    }

    private String describeMax(ElementDefinition.ElementDefinitionBindingComponent orig) {
        if (!orig.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            return "n/a";
        }
        return "`" + ToolingExtensions.readStringExtension(orig, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet") + "`";
    }

    private boolean maxValueSetsMatch(ElementDefinition.ElementDefinitionBindingComponent rev, ElementDefinition.ElementDefinitionBindingComponent orig) {
        if (!rev.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet") && !orig.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            return true;
        }
        if (rev.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet") != orig.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            return false;
        }
        return ToolingExtensions.readStringExtension(rev, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet").equals(ToolingExtensions.readStringExtension(orig, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"));
    }

    private String describeBinding(ElementDefinition orig) {
        if (orig.getBinding().hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            return "`" + orig.getBinding().getValueSet() + "` (" + orig.getBinding().getStrength().toCode() + "), max =`" + ToolingExtensions.readStringExtension(orig.getBinding(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet") + "`";
        }
        return "`" + orig.getBinding().getValueSet() + "` (" + orig.getBinding().getStrength().toCode() + ")";
    }

    private void describeBinding(JsonObject element, String name, ElementDefinition orig) {
        JsonObject binding = new JsonObject();
        element.add(name, binding);
        binding.addProperty("reference", this.describeReference(orig.getBinding().getValueSet()));
        binding.addProperty("strength", orig.getBinding().getStrength().toCode());
        if (orig.getBinding().hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            binding.addProperty("max", ToolingExtensions.readStringExtension(orig.getBinding(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"));
        }
    }

    private void describeBinding(Document doc, Element element, String name, ElementDefinition orig) {
        Element binding = doc.createElement(name);
        element.appendChild(binding);
        binding.setAttribute("reference", this.describeReference(orig.getBinding().getValueSet()));
        binding.setAttribute("strength", orig.getBinding().getStrength().toCode());
        if (orig.getBinding().hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
            binding.setAttribute("max", ToolingExtensions.readStringExtension(orig.getBinding(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"));
        }
    }

    private String describeReference(String ref) {
        return ref;
    }

    private ValueSet getValueSet(String ref, Map<String, ValueSet> expansions) {
        block2: {
            block3: {
                if (ref == null) break block2;
                if (!Utilities.isAbsoluteUrl(ref)) break block3;
                for (ValueSet ve : expansions.values()) {
                    if (!ref.equals(ve.getUrl())) continue;
                    return ve;
                }
                break block2;
            }
            if (!ref.startsWith("ValueSet/")) break block2;
            ref = ref.substring(9);
            for (ValueSet ve : expansions.values()) {
                if (!ve.getId().equals(ref)) continue;
                return ve;
            }
        }
        return null;
    }

    private String listCodes(ValueSet vs) {
        if (vs.getExpansion().getContains().size() > 15) {
            return ">15 codes";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" | ");
        for (ValueSet.ValueSetExpansionContainsComponent ce : vs.getExpansion().getContains()) {
            if (!ce.hasCode()) continue;
            b.append(ce.getCode());
        }
        return b.toString();
    }

    private boolean hasBindingToNote(ElementDefinition ed) {
        return ed.hasBinding() && (ed.getBinding().getStrength() == Enumerations.BindingStrength.EXTENSIBLE || ed.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED || ed.getBinding().hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) && ed.getBinding().hasValueSet();
    }

    private String tail(String path) {
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : path;
    }

    private String head(String path) {
        return path.contains(".") ? path.substring(0, path.lastIndexOf(".")) : path;
    }

    private void analyseTypes(CommaSeparatedStringBuilder bp, ElementDefinition rev, ElementDefinition orig) {
        if (rev.getType().size() == 1 && orig.getType().size() == 1) {
            String r = this.describeType(rev.getType().get(0));
            if (Utilities.noString(r) && Utilities.existsInList(rev.getId(), "Element.id")) {
                r = "string";
            }
            if (Utilities.noString(r) && Utilities.existsInList(rev.getId(), "Extension.url")) {
                r = "uri";
            }
            String o = this.describeType(orig.getType().get(0));
            if (r == null && o == null) {
                System.out.println("null @ " + rev.getPath());
            }
            if (r.contains("(") && o.contains("(") && r.startsWith(o.substring(0, o.indexOf("(") + 1))) {
                this.compareParameters(bp, rev.getType().get(0), orig.getType().get(0));
            } else if (!r.equals(o)) {
                bp.append("Type changed from " + o + " to " + r);
            }
        } else {
            CommaSeparatedStringBuilder removed = new CommaSeparatedStringBuilder();
            CommaSeparatedStringBuilder added = new CommaSeparatedStringBuilder();
            CommaSeparatedStringBuilder retargetted = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent tr : orig.getType()) {
                if (this.hasType(rev.getType(), tr)) continue;
                removed.append(this.describeType(tr));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                if (this.hasType(orig.getType(), tr) || this.isAbstractType(tr.getWorkingCode())) continue;
                added.append(this.describeType(tr));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                ElementDefinition.TypeRefComponent tm = this.getType(rev.getType(), tr);
                if (tm == null) continue;
                this.compareParameters(bp, tr, tm);
            }
            if (added.length() > 0) {
                bp.append("Add " + Utilities.pluralize("Type", added.count()) + " " + added.toString());
            }
            if (removed.length() > 0) {
                bp.append("Remove " + Utilities.pluralize("Type", removed.count()) + " " + removed.toString());
            }
            if (retargetted.length() > 0) {
                bp.append(retargetted.toString());
            }
        }
    }

    private void compareParameters(CommaSeparatedStringBuilder bp, ElementDefinition.TypeRefComponent tr, ElementDefinition.TypeRefComponent tm) {
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        for (CanonicalType p : tr.getTargetProfile()) {
            if (this.hasParam(tm, p.asStringValue())) continue;
            added.add(this.trimNS(p.asStringValue()));
        }
        for (CanonicalType p : tm.getTargetProfile()) {
            if (this.hasParam(tr, p.asStringValue())) continue;
            removed.add(this.trimNS(p.asStringValue()));
        }
        if (!added.isEmpty()) {
            bp.append("Type " + tr.getWorkingCode() + ": Added Target " + Utilities.pluralize("Type", added.size()) + " " + this.csv(added));
        }
        if (!removed.isEmpty()) {
            bp.append("Type " + tr.getWorkingCode() + ": Removed Target " + Utilities.pluralize("Type", removed.size()) + " " + this.csv(removed));
        }
    }

    private String trimNS(String v) {
        if (v.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            return v.substring(40);
        }
        return v;
    }

    private String csv(List<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (String s2 : list) {
            b.append(s2);
        }
        return b.toString();
    }

    private boolean hasParam(ElementDefinition.TypeRefComponent tm, String s2) {
        for (CanonicalType t : tm.getTargetProfile()) {
            if (!s2.equals(t.asStringValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isAbstractType(String code) {
        return Utilities.existsInList(code, "Element", "BackboneElement");
    }

    private boolean hasType(List<ElementDefinition.TypeRefComponent> types, ElementDefinition.TypeRefComponent tr) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (!t.getWorkingCode().equals(tr.getWorkingCode()) || (t.hasProfile() || tr.hasProfile()) && !t.getProfile().equals(tr.getProfile())) continue;
            return true;
        }
        return false;
    }

    private ElementDefinition.TypeRefComponent getType(List<ElementDefinition.TypeRefComponent> types, ElementDefinition.TypeRefComponent tr) {
        for (ElementDefinition.TypeRefComponent t : types) {
            if (!t.getWorkingCode().equals(tr.getWorkingCode())) continue;
            return t;
        }
        return null;
    }

    private String describeType(ElementDefinition.TypeRefComponent tr) {
        if (!tr.hasProfile() && !tr.hasTargetProfile()) {
            return tr.getWorkingCode();
        }
        if (Utilities.existsInList(tr.getWorkingCode(), "Reference", "canonical")) {
            StringBuilder b = new StringBuilder(tr.getWorkingCode());
            b.append("(");
            boolean first = true;
            for (UriType uriType : tr.getTargetProfile()) {
                if (first) {
                    first = false;
                } else {
                    b.append(" | ");
                }
                if (((String)uriType.getValue()).startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    b.append(((String)uriType.getValue()).substring(40));
                    continue;
                }
                b.append((String)uriType.getValue());
            }
            b.append(")");
            return b.toString();
        }
        StringBuilder b = new StringBuilder(tr.getWorkingCode());
        if (tr.getProfile().size() > 0) {
            b.append("(");
            boolean first = true;
            for (UriType uriType : tr.getTargetProfile()) {
                if (first) {
                    first = false;
                } else {
                    b.append(" | ");
                }
                b.append((String)uriType.getValue());
            }
            b.append(")");
        }
        return b.toString();
    }

    public void saveR4AsR5(ZipGenerator zip, Manager.FhirFormat fmt) throws IOException {
        for (CanonicalResource t : this.original.types.values()) {
            this.saveResource(zip, t, fmt);
        }
        for (CanonicalResource t : this.original.resources.values()) {
            this.saveResource(zip, t, fmt);
        }
        for (CanonicalResource t : this.original.profiles.values()) {
            this.saveResource(zip, t, fmt);
        }
        for (CanonicalResource t : this.original.extensions.values()) {
            this.saveResource(zip, t, fmt);
        }
        for (CanonicalResource t : this.original.valuesets.values()) {
            this.saveResource(zip, t, fmt);
        }
        for (CanonicalResource t : this.original.expansions.values()) {
            this.saveResource(zip, t, fmt);
        }
    }

    private void saveResource(ZipGenerator zip, Resource t, Manager.FhirFormat fmt) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (fmt == Manager.FhirFormat.JSON) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(bs, t);
        } else {
            new org.hl7.fhir.r5.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(bs, t);
        }
        zip.addBytes(t.fhirType() + "-" + t.getId() + "." + fmt.getExtension(), bs.toByteArray(), true);
    }

    private void compareJson(JsonObject type, org.hl7.fhir.r5.model.StructureDefinition orig, org.hl7.fhir.r5.model.StructureDefinition rev) {
        ElementDefinition oed;
        JsonObject elements = new JsonObject();
        boolean changed = false;
        if (!orig.getName().equals(rev.getName())) {
            changed = true;
            type.addProperty("old-name", orig.getName());
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = this.getMatchingElement(rev.getName(), orig.getDifferential().getElement(), ed);
            if (oed == null) continue;
            ed.setUserData("match", oed);
            oed.setUserData("match", ed);
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = (ElementDefinition)ed.getUserData("match");
            if (oed == null) {
                changed = true;
                JsonObject element = new JsonObject();
                elements.add(ed.getPath(), element);
                element.addProperty("status", "new");
                continue;
            }
            changed = this.compareElementJson(elements, ed, oed) || changed;
        }
        ArrayList<String> dels = new ArrayList<String>();
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            if (ed.getUserData("match") != null) continue;
            changed = true;
            boolean marked = false;
            for (String s2 : dels) {
                if (!ed.getPath().startsWith(s2 + ".")) continue;
                marked = true;
            }
            if (marked) continue;
            dels.add(ed.getPath());
            JsonObject element = new JsonObject();
            elements.add(ed.getPath(), element);
            element.addProperty("status", "deleted");
        }
        if (elements.entrySet().size() > 0) {
            type.add("elements", elements);
        }
        if (changed) {
            type.addProperty("status", "changed");
        } else {
            type.addProperty("status", "no-change");
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
    }

    private void compareXml(Document doc, Element type, org.hl7.fhir.r5.model.StructureDefinition orig, org.hl7.fhir.r5.model.StructureDefinition rev) {
        ElementDefinition oed;
        boolean changed = false;
        if (!orig.getName().equals(rev.getName())) {
            changed = true;
            type.setAttribute("old-name", orig.getName());
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = this.getMatchingElement(rev.getName(), orig.getDifferential().getElement(), ed);
            if (oed == null) continue;
            ed.setUserData("match", oed);
            oed.setUserData("match", ed);
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            oed = (ElementDefinition)ed.getUserData("match");
            if (oed == null) {
                changed = true;
                Element element = doc.createElement("element");
                element.setAttribute("path", ed.getPath());
                type.appendChild(element);
                element.setAttribute("status", "new");
                continue;
            }
            changed = this.compareElementXml(doc, type, ed, oed) || changed;
        }
        ArrayList<String> dels = new ArrayList<String>();
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            if (ed.getUserData("match") != null) continue;
            changed = true;
            boolean marked = false;
            for (String s2 : dels) {
                if (!ed.getPath().startsWith(s2 + ".")) continue;
                marked = true;
            }
            if (marked) continue;
            dels.add(ed.getPath());
            Element element = doc.createElement("element");
            element.setAttribute("path", ed.getPath());
            type.appendChild(element);
            element.setAttribute("status", "deleted");
        }
        if (changed) {
            type.setAttribute("status", "changed");
        } else {
            type.setAttribute("status", "no-change");
        }
        for (ElementDefinition ed : rev.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
        for (ElementDefinition ed : orig.getDifferential().getElement()) {
            ed.clearUserData("match");
        }
    }

    private boolean compareElementJson(JsonObject elements, ElementDefinition rev, ElementDefinition orig) {
        String on;
        JsonObject element = new JsonObject();
        String rn = this.tail(rev.getPath());
        if (!rn.equals(on = this.tail(orig.getPath())) && rev.getPath().contains(".")) {
            element.addProperty("old-name", on);
        }
        if (rev.getMin() != orig.getMin()) {
            element.addProperty("old-min", orig.getMin());
            element.addProperty("new-min", rev.getMin());
        }
        if (!rev.getMax().equals(orig.getMax())) {
            element.addProperty("old-max", orig.getMax());
            element.addProperty("new-max", rev.getMax());
        }
        this.analyseTypes(element, rev, orig);
        if (this.hasBindingToNote(rev) || this.hasBindingToNote(orig)) {
            this.compareBindings(element, rev, orig);
        }
        if (rev.hasDefaultValue() || orig.hasDefaultValue()) {
            boolean changed = true;
            if (!rev.hasDefaultValue()) {
                element.addProperty("default", "removed");
            } else if (!orig.hasDefaultValue()) {
                element.addProperty("default", "added");
            } else {
                String s2;
                String s1 = this.describeValue(orig.getDefaultValue());
                if (!s1.equals(s2 = this.describeValue(rev.getDefaultValue()))) {
                    element.addProperty("default", "changed");
                } else {
                    changed = false;
                }
            }
            if (changed) {
                if (orig.hasDefaultValue()) {
                    element.addProperty("old-default", this.describeValue(orig.getDefaultValue()));
                }
                if (rev.hasDefaultValue()) {
                    element.addProperty("new-default", this.describeValue(rev.getDefaultValue()));
                }
            }
        }
        if (rev.getIsModifier() != orig.getIsModifier()) {
            if (rev.getIsModifier()) {
                element.addProperty("modifier", "added");
            } else {
                element.addProperty("modifier", "removed");
            }
        }
        if (element.entrySet().isEmpty()) {
            return false;
        }
        elements.add(rev.getPath(), element);
        return true;
    }

    private boolean compareElementXml(Document doc, Element type, ElementDefinition rev, ElementDefinition orig) {
        String on;
        Element element = doc.createElement("element");
        String rn = this.tail(rev.getPath());
        if (!rn.equals(on = this.tail(orig.getPath())) && rev.getPath().contains(".")) {
            element.setAttribute("old-name", on);
        }
        if (rev.getMin() != orig.getMin()) {
            element.setAttribute("old-min", Integer.toString(orig.getMin()));
            element.setAttribute("new-min", Integer.toString(rev.getMin()));
        }
        if (!rev.getMax().equals(orig.getMax())) {
            element.setAttribute("old-max", orig.getMax());
            element.setAttribute("new-max", rev.getMax());
        }
        this.analyseTypes(doc, element, rev, orig);
        if (this.hasBindingToNote(rev) || this.hasBindingToNote(orig)) {
            this.compareBindings(doc, element, rev, orig);
        }
        if (rev.hasDefaultValue() || orig.hasDefaultValue()) {
            boolean changed = true;
            if (!rev.hasDefaultValue()) {
                element.setAttribute("default", "removed");
            } else if (!orig.hasDefaultValue()) {
                element.setAttribute("default", "added");
            } else {
                String s2;
                String s1 = this.describeValue(orig.getDefaultValue());
                if (!s1.equals(s2 = this.describeValue(rev.getDefaultValue()))) {
                    element.setAttribute("default", "changed");
                } else {
                    changed = false;
                }
            }
            if (changed) {
                if (orig.hasDefaultValue()) {
                    element.setAttribute("old-default", this.describeValue(orig.getDefaultValue()));
                }
                if (rev.hasDefaultValue()) {
                    element.setAttribute("new-default", this.describeValue(rev.getDefaultValue()));
                }
            }
        }
        if (rev.getIsModifier() != orig.getIsModifier()) {
            if (rev.getIsModifier()) {
                element.setAttribute("modifier", "added");
            } else {
                element.setAttribute("modifier", "removed");
            }
        }
        if (element.getAttributes().getLength() == 0 && element.getChildNodes().getLength() == 0) {
            return false;
        }
        element.setAttribute("path", rev.getPath());
        type.appendChild(element);
        return true;
    }

    private void analyseTypes(JsonObject element, ElementDefinition rev, ElementDefinition orig) {
        JsonArray oa = new JsonArray();
        JsonArray ra = new JsonArray();
        if (rev.getType().size() == 1 && orig.getType().size() == 1) {
            String o;
            String r = this.describeType(rev.getType().get(0));
            if (Utilities.noString(r) && Utilities.existsInList(rev.getId(), "Element.id", "Extension.url")) {
                r = "string";
            }
            if (Utilities.noString(o = this.describeType(orig.getType().get(0))) && Utilities.existsInList(orig.getId(), "Element.id", "Extension.url")) {
                o = "string";
            }
            if (!o.equals(r)) {
                oa.add(new JsonPrimitive(o));
                ra.add(new JsonPrimitive(r));
            }
        } else {
            for (ElementDefinition.TypeRefComponent tr : orig.getType()) {
                if (this.hasType(rev.getType(), tr)) continue;
                oa.add(new JsonPrimitive(this.describeType(tr)));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                if (this.hasType(orig.getType(), tr) || this.isAbstractType(tr.getWorkingCode())) continue;
                ra.add(new JsonPrimitive(this.describeType(tr)));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                ElementDefinition.TypeRefComponent tm = this.getType(rev.getType(), tr);
                if (tm == null) continue;
                this.compareParameters(element, tr, tm);
            }
        }
        if (oa.size() > 0) {
            element.add("removed-types", oa);
        }
        if (ra.size() > 0) {
            element.add("added-types", ra);
        }
    }

    private void compareParameters(JsonObject element, ElementDefinition.TypeRefComponent tr, ElementDefinition.TypeRefComponent tm) {
        JsonArray added = new JsonArray();
        JsonArray removed = new JsonArray();
        for (CanonicalType p : tr.getTargetProfile()) {
            if (this.hasParam(tm, p.asStringValue())) continue;
            added.add(new JsonPrimitive(p.asStringValue()));
        }
        for (CanonicalType p : tm.getTargetProfile()) {
            if (this.hasParam(tr, p.asStringValue())) continue;
            removed.add(new JsonPrimitive(p.asStringValue()));
        }
        if (added.size() > 0) {
            element.add(tr.getWorkingCode() + "-target-added", added);
        }
        if (removed.size() > 0) {
            element.add(tr.getWorkingCode() + "-target-removed", removed);
        }
    }

    private void analyseTypes(Document doc, Element element, ElementDefinition rev, ElementDefinition orig) {
        if (rev.getType().size() == 1 && orig.getType().size() == 1) {
            String o;
            String r = this.describeType(rev.getType().get(0));
            if (Utilities.noString(r) && Utilities.existsInList(rev.getId(), "Element.id", "Extension.url")) {
                r = "string";
            }
            if (Utilities.noString(o = this.describeType(orig.getType().get(0))) && Utilities.existsInList(orig.getId(), "Element.id", "Extension.url")) {
                o = "string";
            }
            if (!o.equals(r)) {
                element.appendChild(this.makeElementWithAttribute(doc, "removed-type", "name", o));
                element.appendChild(this.makeElementWithAttribute(doc, "added-type", "name", r));
            }
        } else {
            for (ElementDefinition.TypeRefComponent tr : orig.getType()) {
                if (this.hasType(rev.getType(), tr)) continue;
                element.appendChild(this.makeElementWithAttribute(doc, "removed-type", "name", this.describeType(tr)));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                if (this.hasType(orig.getType(), tr) || this.isAbstractType(tr.getWorkingCode())) continue;
                element.appendChild(this.makeElementWithAttribute(doc, "added-type", "name", this.describeType(tr)));
            }
            for (ElementDefinition.TypeRefComponent tr : rev.getType()) {
                ElementDefinition.TypeRefComponent tm = this.getType(rev.getType(), tr);
                if (tm == null) continue;
                this.compareParameters(doc, element, tr, tm);
            }
        }
    }

    private void compareParameters(Document doc, Element element, ElementDefinition.TypeRefComponent tr, ElementDefinition.TypeRefComponent tm) {
        for (CanonicalType p : tr.getTargetProfile()) {
            if (this.hasParam(tm, p.asStringValue())) continue;
            element.appendChild(this.makeElementWithAttribute(doc, tr.getWorkingCode() + "-target-added", "name", p.asStringValue()));
        }
        for (CanonicalType p : tm.getTargetProfile()) {
            if (this.hasParam(tr, p.asStringValue())) continue;
            element.appendChild(this.makeElementWithAttribute(doc, tr.getWorkingCode() + "-target-removed", "name", p.asStringValue()));
        }
    }

    private Node makeElementWithAttribute(Document doc, String name, String aname, String content) {
        Element e = doc.createElement(name);
        e.setAttribute(aname, content);
        return e;
    }

    private void compareBindings(JsonObject element, ElementDefinition rev, ElementDefinition orig) {
        if (!this.hasBindingToNote(rev)) {
            element.addProperty("binding-status", "removed");
            this.describeBinding(element, "old-binding", orig);
        } else if (!this.hasBindingToNote(orig)) {
            element.addProperty("binding-status", "added");
            this.describeBinding(element, "new-binding", rev);
        } else if (this.compareBindings(element, rev.getBinding(), orig.getBinding())) {
            element.addProperty("binding-status", "changed");
            this.describeBinding(element, "old-binding", orig);
            this.describeBinding(element, "new-binding", rev);
        }
    }

    private boolean compareBindings(JsonObject element, ElementDefinition.ElementDefinitionBindingComponent rev, ElementDefinition.ElementDefinitionBindingComponent orig) {
        boolean res = false;
        if (rev.getStrength() != orig.getStrength()) {
            element.addProperty("binding-strength-changed", true);
            res = true;
        }
        if (!Base.compareDeep(rev.getValueSet(), orig.getValueSet(), false)) {
            element.addProperty("binding-valueset-changed", true);
            res = true;
        }
        if (!this.maxValueSetsMatch(rev, orig)) {
            element.addProperty("max-valueset-changed", true);
            res = true;
        }
        if (rev.getStrength() == Enumerations.BindingStrength.REQUIRED && orig.getStrength() == Enumerations.BindingStrength.REQUIRED) {
            JsonArray oa = new JsonArray();
            JsonArray ra = new JsonArray();
            ValueSet vrev = this.getValueSet(rev.getValueSet(), this.revision.expansions);
            ValueSet vorig = this.getValueSet(rev.getValueSet(), this.original.expansions);
            if (vrev != null && vorig != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : vorig.getExpansion().getContains()) {
                    if (this.hasCode(vrev, cc)) continue;
                    oa.add(new JsonPrimitive(cc.getCode()));
                }
                for (ValueSet.ValueSetExpansionContainsComponent cc : vrev.getExpansion().getContains()) {
                    if (this.hasCode(vorig, cc)) continue;
                    ra.add(new JsonPrimitive(cc.getCode()));
                }
            }
            if (oa.size() > 0 || ra.size() > 0) {
                element.addProperty("binding-codes-changed", true);
                res = true;
            }
            if (oa.size() > 0) {
                element.add("removed-codes", oa);
            }
            if (ra.size() > 0) {
                element.add("added-codes", ra);
            }
        }
        return res;
    }

    private boolean hasCode(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent cc) {
        for (ValueSet.ValueSetExpansionContainsComponent ct : vs.getExpansion().getContains()) {
            if (!ct.getSystem().equals(cc.getSystem()) || !ct.getCode().equals(cc.getCode())) continue;
            return true;
        }
        return false;
    }

    private void compareBindings(Document doc, Element element, ElementDefinition rev, ElementDefinition orig) {
        if (!this.hasBindingToNote(rev)) {
            element.setAttribute("binding-status", "removed");
            this.describeBinding(doc, element, "old-binding", orig);
        } else if (!this.hasBindingToNote(orig)) {
            element.setAttribute("binding-status", "added");
            this.describeBinding(doc, element, "new-binding", rev);
        } else if (this.compareBindings(doc, element, rev.getBinding(), orig.getBinding())) {
            element.setAttribute("binding-status", "changed");
            this.describeBinding(doc, element, "old-binding", orig);
            this.describeBinding(doc, element, "new-binding", rev);
        }
    }

    private boolean compareBindings(Document doc, Element element, ElementDefinition.ElementDefinitionBindingComponent rev, ElementDefinition.ElementDefinitionBindingComponent orig) {
        boolean res = false;
        if (rev.getStrength() != orig.getStrength()) {
            element.setAttribute("binding-strength-changed", "true");
            res = true;
        }
        if (!Base.compareDeep(rev.getValueSet(), orig.getValueSet(), false)) {
            element.setAttribute("binding-valueset-changed", "true");
            res = true;
        }
        if (!this.maxValueSetsMatch(rev, orig)) {
            element.setAttribute("max-valueset-changed", "true");
            res = true;
        }
        if (rev.getStrength() == Enumerations.BindingStrength.REQUIRED && orig.getStrength() == Enumerations.BindingStrength.REQUIRED) {
            ValueSet vrev = this.getValueSet(rev.getValueSet(), this.revision.expansions);
            ValueSet vorig = this.getValueSet(rev.getValueSet(), this.original.expansions);
            boolean changed = false;
            if (vrev != null && vorig != null) {
                for (ValueSet.ValueSetExpansionContainsComponent cc : vorig.getExpansion().getContains()) {
                    if (this.hasCode(vrev, cc)) continue;
                    element.appendChild(this.makeElementWithAttribute(doc, "removed-code", "code", cc.getCode()));
                    changed = true;
                }
                for (ValueSet.ValueSetExpansionContainsComponent cc : vrev.getExpansion().getContains()) {
                    if (this.hasCode(vorig, cc)) continue;
                    element.appendChild(this.makeElementWithAttribute(doc, "added-code", "code", cc.getCode()));
                    changed = true;
                }
            }
            if (changed) {
                element.setAttribute("binding-codes-changed", "true");
                res = true;
            }
        }
        return res;
    }

    public class SpecPackage {
        private Map<String, ValueSet> valuesets = new HashMap<String, ValueSet>();
        private Map<String, ValueSet> expansions = new HashMap<String, ValueSet>();
        private Map<String, org.hl7.fhir.r5.model.StructureDefinition> types = new HashMap<String, org.hl7.fhir.r5.model.StructureDefinition>();
        private Map<String, org.hl7.fhir.r5.model.StructureDefinition> resources = new HashMap<String, org.hl7.fhir.r5.model.StructureDefinition>();
        private Map<String, org.hl7.fhir.r5.model.StructureDefinition> extensions = new HashMap<String, org.hl7.fhir.r5.model.StructureDefinition>();
        private Map<String, org.hl7.fhir.r5.model.StructureDefinition> profiles = new HashMap<String, org.hl7.fhir.r5.model.StructureDefinition>();

        public Map<String, org.hl7.fhir.r5.model.StructureDefinition> getTypes() {
            return this.types;
        }

        public Map<String, org.hl7.fhir.r5.model.StructureDefinition> getResources() {
            return this.resources;
        }

        public Map<String, ValueSet> getExpansions() {
            return this.expansions;
        }

        public Map<String, ValueSet> getValuesets() {
            return this.valuesets;
        }

        public Map<String, org.hl7.fhir.r5.model.StructureDefinition> getExtensions() {
            return this.extensions;
        }

        public Map<String, org.hl7.fhir.r5.model.StructureDefinition> getProfiles() {
            return this.profiles;
        }
    }

    public static interface TypeLinkProvider {
        public String getLink(String var1);
    }
}

