/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.convertors.BaseLoader;
import org.hl7.fhir.convertors.VersionConvertorAdvisor50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;

public class R4ToR5Loader
extends BaseLoader
implements IWorkerContext.IContextResourceLoader,
VersionConvertorAdvisor50 {
    private List<CodeSystem> cslist = new ArrayList<CodeSystem>();
    private boolean patchUrls;
    private boolean killPrimitives;

    public R4ToR5Loader(String[] types) {
        super(types);
    }

    @Override
    public Bundle loadBundle(InputStream stream, boolean isJson) throws FHIRException, IOException {
        Bundle b;
        org.hl7.fhir.r4.model.Resource r4 = null;
        r4 = isJson ? new JsonParser().parse(stream) : new XmlParser().parse(stream);
        org.hl7.fhir.r5.model.Resource r5 = VersionConvertor_40_50.convertResource(r4);
        if (r5 instanceof Bundle) {
            b = (Bundle)r5;
        } else {
            b = new Bundle();
            b.setId(UUID.randomUUID().toString().toLowerCase());
            b.setType(Bundle.BundleType.COLLECTION);
            b.addEntry().setResource(r5).setFullUrl(r5 instanceof CanonicalResource ? ((CanonicalResource)r5).getUrl() : null);
        }
        for (CodeSystem codeSystem : this.cslist) {
            Bundle.BundleEntryComponent be = b.addEntry();
            be.setFullUrl(codeSystem.getUrl());
            be.setResource(codeSystem);
        }
        if (this.killPrimitives) {
            ArrayList<Bundle.BundleEntryComponent> remove = new ArrayList<Bundle.BundleEntryComponent>();
            for (Bundle.BundleEntryComponent be : b.getEntry()) {
                StructureDefinition sd;
                if (!be.hasResource() || !(be.getResource() instanceof StructureDefinition) || (sd = (StructureDefinition)be.getResource()).getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
                remove.add(be);
            }
            b.getEntry().removeAll(remove);
        }
        if (this.patchUrls) {
            for (Bundle.BundleEntryComponent bundleEntryComponent : b.getEntry()) {
                if (!bundleEntryComponent.hasResource() || !(bundleEntryComponent.getResource() instanceof StructureDefinition)) continue;
                StructureDefinition sd = (StructureDefinition)bundleEntryComponent.getResource();
                sd.setUrl(sd.getUrl().replace("http://hl7.org/fhir/", "http://hl7.org/fhir/4.0/"));
                sd.addExtension().setUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType("http://hl7.org/fhir"));
                for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                    this.patchUrl(ed);
                }
                for (ElementDefinition ed : sd.getDifferential().getElement()) {
                    this.patchUrl(ed);
                }
            }
        }
        return b;
    }

    private void patchUrl(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            for (CanonicalType s2 : tr.getTargetProfile()) {
                s2.setValue(((String)s2.getValue()).replace("http://hl7.org/fhir/", "http://hl7.org/fhir/4.0/"));
            }
            for (CanonicalType s2 : tr.getProfile()) {
                s2.setValue(((String)s2.getValue()).replace("http://hl7.org/fhir/", "http://hl7.org/fhir/4.0/"));
            }
        }
    }

    @Override
    public boolean ignoreEntry(Bundle.BundleEntryComponent src) {
        return false;
    }

    @Override
    public org.hl7.fhir.dstu2.model.Resource convertR2(org.hl7.fhir.r5.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public org.hl7.fhir.dstu2016may.model.Resource convertR2016May(org.hl7.fhir.r5.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public org.hl7.fhir.r4.model.Resource convertR4(org.hl7.fhir.r5.model.Resource resource) throws FHIRException {
        return null;
    }

    @Override
    public void handleCodeSystem(CodeSystem cs, ValueSet vs) {
        cs.setId(vs.getId());
        cs.setValueSet(vs.getUrl());
        this.cslist.add(cs);
    }

    @Override
    public CodeSystem getCodeSystem(ValueSet src) {
        return null;
    }

    public boolean isPatchUrls() {
        return this.patchUrls;
    }

    public R4ToR5Loader setPatchUrls(boolean patchUrls) {
        this.patchUrls = patchUrls;
        return this;
    }

    public boolean isKillPrimitives() {
        return this.killPrimitives;
    }

    public R4ToR5Loader setKillPrimitives(boolean killPrimitives) {
        this.killPrimitives = killPrimitives;
        return this;
    }

    @Override
    public Resource convertR3(org.hl7.fhir.r5.model.Resource resource) throws FHIRException {
        return null;
    }
}

