/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.hl7.fhir.VisionPrescriptionDispense;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VisionPrescription", propOrder={"identifier", "dateWritten", "patient", "prescriber", "encounter", "reasonCodeableConcept", "reasonReference", "dispense"})
public class VisionPrescription
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected DateTime dateWritten;
    protected Reference patient;
    protected Reference prescriber;
    protected Reference encounter;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected List<VisionPrescriptionDispense> dispense;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DateTime getDateWritten() {
        return this.dateWritten;
    }

    public void setDateWritten(DateTime value) {
        this.dateWritten = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Reference getPrescriber() {
        return this.prescriber;
    }

    public void setPrescriber(Reference value) {
        this.prescriber = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public List<VisionPrescriptionDispense> getDispense() {
        if (this.dispense == null) {
            this.dispense = new ArrayList<VisionPrescriptionDispense>();
        }
        return this.dispense;
    }

    public VisionPrescription withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public VisionPrescription withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public VisionPrescription withDateWritten(DateTime value) {
        this.setDateWritten(value);
        return this;
    }

    public VisionPrescription withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public VisionPrescription withPrescriber(Reference value) {
        this.setPrescriber(value);
        return this;
    }

    public VisionPrescription withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public VisionPrescription withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public VisionPrescription withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public VisionPrescription withDispense(VisionPrescriptionDispense ... values) {
        if (values != null) {
            for (VisionPrescriptionDispense value : values) {
                this.getDispense().add(value);
            }
        }
        return this;
    }

    public VisionPrescription withDispense(Collection<VisionPrescriptionDispense> values) {
        if (values != null) {
            this.getDispense().addAll(values);
        }
        return this;
    }

    @Override
    public VisionPrescription withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public VisionPrescription withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public VisionPrescription withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public VisionPrescription withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public VisionPrescription withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public VisionPrescription withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public VisionPrescription withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public VisionPrescription withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public VisionPrescription withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public VisionPrescription withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public VisionPrescription withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        VisionPrescription that = (VisionPrescription)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        DateTime lhsDateWritten = this.getDateWritten();
        DateTime rhsDateWritten = that.getDateWritten();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dateWritten", lhsDateWritten), (ObjectLocator)LocatorUtils.property(thatLocator, "dateWritten", rhsDateWritten), lhsDateWritten, rhsDateWritten, this.dateWritten != null, that.dateWritten != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Reference lhsPrescriber = this.getPrescriber();
        Reference rhsPrescriber = that.getPrescriber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "prescriber", lhsPrescriber), (ObjectLocator)LocatorUtils.property(thatLocator, "prescriber", rhsPrescriber), lhsPrescriber, rhsPrescriber, this.prescriber != null, that.prescriber != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonCodeableConcept", lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonCodeableConcept", rhsReasonCodeableConcept), lhsReasonCodeableConcept, rhsReasonCodeableConcept, this.reasonCodeableConcept != null, that.reasonCodeableConcept != null)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference, this.reasonReference != null, that.reasonReference != null)) {
            return false;
        }
        List<VisionPrescriptionDispense> lhsDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        List<VisionPrescriptionDispense> rhsDispense = that.dispense != null && !that.dispense.isEmpty() ? that.getDispense() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dispense", lhsDispense), (ObjectLocator)LocatorUtils.property(thatLocator, "dispense", rhsDispense), lhsDispense, rhsDispense, this.dispense != null && !this.dispense.isEmpty(), that.dispense != null && !that.dispense.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        DateTime theDateWritten = this.getDateWritten();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dateWritten", theDateWritten), currentHashCode, theDateWritten, this.dateWritten != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        Reference thePrescriber = this.getPrescriber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "prescriber", thePrescriber), currentHashCode, thePrescriber, this.prescriber != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonCodeableConcept", theReasonCodeableConcept), currentHashCode, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonReference", theReasonReference), currentHashCode, theReasonReference, this.reasonReference != null);
        List<VisionPrescriptionDispense> theDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dispense", theDispense), currentHashCode, theDispense, this.dispense != null && !this.dispense.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        DateTime theDateWritten = this.getDateWritten();
        strategy.appendField(locator, (Object)this, "dateWritten", buffer, theDateWritten, this.dateWritten != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        Reference thePrescriber = this.getPrescriber();
        strategy.appendField(locator, (Object)this, "prescriber", buffer, thePrescriber, this.prescriber != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference, this.reasonReference != null);
        List<VisionPrescriptionDispense> theDispense = this.dispense != null && !this.dispense.isEmpty() ? this.getDispense() : null;
        strategy.appendField(locator, (Object)this, "dispense", buffer, theDispense, this.dispense != null && !this.dispense.isEmpty());
        return buffer;
    }
}

