/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ContentType;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Integer;
import org.hl7.fhir.String;
import org.hl7.fhir.TestScriptRequestHeader;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TestScript.Operation", propOrder={"type", "resource", "label", "description", "accept", "contentType", "destination", "encodeRequestUrl", "origin", "params", "requestHeader", "responseId", "sourceId", "targetId", "url"})
public class TestScriptOperation
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Coding type;
    protected Code resource;
    protected String label;
    protected String description;
    protected ContentType accept;
    protected ContentType contentType;
    protected Integer destination;
    protected Boolean encodeRequestUrl;
    protected Integer origin;
    protected String params;
    protected List<TestScriptRequestHeader> requestHeader;
    protected Id responseId;
    protected Id sourceId;
    protected Id targetId;
    protected String url;

    public Coding getType() {
        return this.type;
    }

    public void setType(Coding value) {
        this.type = value;
    }

    public Code getResource() {
        return this.resource;
    }

    public void setResource(Code value) {
        this.resource = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public ContentType getAccept() {
        return this.accept;
    }

    public void setAccept(ContentType value) {
        this.accept = value;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType value) {
        this.contentType = value;
    }

    public Integer getDestination() {
        return this.destination;
    }

    public void setDestination(Integer value) {
        this.destination = value;
    }

    public Boolean getEncodeRequestUrl() {
        return this.encodeRequestUrl;
    }

    public void setEncodeRequestUrl(Boolean value) {
        this.encodeRequestUrl = value;
    }

    public Integer getOrigin() {
        return this.origin;
    }

    public void setOrigin(Integer value) {
        this.origin = value;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String value) {
        this.params = value;
    }

    public List<TestScriptRequestHeader> getRequestHeader() {
        if (this.requestHeader == null) {
            this.requestHeader = new ArrayList<TestScriptRequestHeader>();
        }
        return this.requestHeader;
    }

    public Id getResponseId() {
        return this.responseId;
    }

    public void setResponseId(Id value) {
        this.responseId = value;
    }

    public Id getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Id value) {
        this.sourceId = value;
    }

    public Id getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Id value) {
        this.targetId = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public TestScriptOperation withType(Coding value) {
        this.setType(value);
        return this;
    }

    public TestScriptOperation withResource(Code value) {
        this.setResource(value);
        return this;
    }

    public TestScriptOperation withLabel(String value) {
        this.setLabel(value);
        return this;
    }

    public TestScriptOperation withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public TestScriptOperation withAccept(ContentType value) {
        this.setAccept(value);
        return this;
    }

    public TestScriptOperation withContentType(ContentType value) {
        this.setContentType(value);
        return this;
    }

    public TestScriptOperation withDestination(Integer value) {
        this.setDestination(value);
        return this;
    }

    public TestScriptOperation withEncodeRequestUrl(Boolean value) {
        this.setEncodeRequestUrl(value);
        return this;
    }

    public TestScriptOperation withOrigin(Integer value) {
        this.setOrigin(value);
        return this;
    }

    public TestScriptOperation withParams(String value) {
        this.setParams(value);
        return this;
    }

    public TestScriptOperation withRequestHeader(TestScriptRequestHeader ... values) {
        if (values != null) {
            for (TestScriptRequestHeader value : values) {
                this.getRequestHeader().add(value);
            }
        }
        return this;
    }

    public TestScriptOperation withRequestHeader(Collection<TestScriptRequestHeader> values) {
        if (values != null) {
            this.getRequestHeader().addAll(values);
        }
        return this;
    }

    public TestScriptOperation withResponseId(Id value) {
        this.setResponseId(value);
        return this;
    }

    public TestScriptOperation withSourceId(Id value) {
        this.setSourceId(value);
        return this;
    }

    public TestScriptOperation withTargetId(Id value) {
        this.setTargetId(value);
        return this;
    }

    public TestScriptOperation withUrl(String value) {
        this.setUrl(value);
        return this;
    }

    @Override
    public TestScriptOperation withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public TestScriptOperation withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public TestScriptOperation withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public TestScriptOperation withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public TestScriptOperation withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        TestScriptOperation that = (TestScriptOperation)object;
        Coding lhsType = this.getType();
        Coding rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Code lhsResource = this.getResource();
        Code rhsResource = that.getResource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "resource", lhsResource), (ObjectLocator)LocatorUtils.property(thatLocator, "resource", rhsResource), lhsResource, rhsResource, this.resource != null, that.resource != null)) {
            return false;
        }
        String lhsLabel = this.getLabel();
        String rhsLabel = that.getLabel();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "label", lhsLabel), (ObjectLocator)LocatorUtils.property(thatLocator, "label", rhsLabel), lhsLabel, rhsLabel, this.label != null, that.label != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        ContentType lhsAccept = this.getAccept();
        ContentType rhsAccept = that.getAccept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "accept", lhsAccept), (ObjectLocator)LocatorUtils.property(thatLocator, "accept", rhsAccept), lhsAccept, rhsAccept, this.accept != null, that.accept != null)) {
            return false;
        }
        ContentType lhsContentType = this.getContentType();
        ContentType rhsContentType = that.getContentType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contentType", lhsContentType), (ObjectLocator)LocatorUtils.property(thatLocator, "contentType", rhsContentType), lhsContentType, rhsContentType, this.contentType != null, that.contentType != null)) {
            return false;
        }
        Integer lhsDestination = this.getDestination();
        Integer rhsDestination = that.getDestination();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "destination", lhsDestination), (ObjectLocator)LocatorUtils.property(thatLocator, "destination", rhsDestination), lhsDestination, rhsDestination, this.destination != null, that.destination != null)) {
            return false;
        }
        Boolean lhsEncodeRequestUrl = this.getEncodeRequestUrl();
        Boolean rhsEncodeRequestUrl = that.getEncodeRequestUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encodeRequestUrl", lhsEncodeRequestUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "encodeRequestUrl", rhsEncodeRequestUrl), lhsEncodeRequestUrl, rhsEncodeRequestUrl, this.encodeRequestUrl != null, that.encodeRequestUrl != null)) {
            return false;
        }
        Integer lhsOrigin = this.getOrigin();
        Integer rhsOrigin = that.getOrigin();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "origin", lhsOrigin), (ObjectLocator)LocatorUtils.property(thatLocator, "origin", rhsOrigin), lhsOrigin, rhsOrigin, this.origin != null, that.origin != null)) {
            return false;
        }
        String lhsParams = this.getParams();
        String rhsParams = that.getParams();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "params", lhsParams), (ObjectLocator)LocatorUtils.property(thatLocator, "params", rhsParams), lhsParams, rhsParams, this.params != null, that.params != null)) {
            return false;
        }
        List<TestScriptRequestHeader> lhsRequestHeader = this.requestHeader != null && !this.requestHeader.isEmpty() ? this.getRequestHeader() : null;
        List<TestScriptRequestHeader> rhsRequestHeader = that.requestHeader != null && !that.requestHeader.isEmpty() ? that.getRequestHeader() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestHeader", lhsRequestHeader), (ObjectLocator)LocatorUtils.property(thatLocator, "requestHeader", rhsRequestHeader), lhsRequestHeader, rhsRequestHeader, this.requestHeader != null && !this.requestHeader.isEmpty(), that.requestHeader != null && !that.requestHeader.isEmpty())) {
            return false;
        }
        Id lhsResponseId = this.getResponseId();
        Id rhsResponseId = that.getResponseId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "responseId", lhsResponseId), (ObjectLocator)LocatorUtils.property(thatLocator, "responseId", rhsResponseId), lhsResponseId, rhsResponseId, this.responseId != null, that.responseId != null)) {
            return false;
        }
        Id lhsSourceId = this.getSourceId();
        Id rhsSourceId = that.getSourceId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "sourceId", lhsSourceId), (ObjectLocator)LocatorUtils.property(thatLocator, "sourceId", rhsSourceId), lhsSourceId, rhsSourceId, this.sourceId != null, that.sourceId != null)) {
            return false;
        }
        Id lhsTargetId = this.getTargetId();
        Id rhsTargetId = that.getTargetId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetId", lhsTargetId), (ObjectLocator)LocatorUtils.property(thatLocator, "targetId", rhsTargetId), lhsTargetId, rhsTargetId, this.targetId != null, that.targetId != null)) {
            return false;
        }
        String lhsUrl = this.getUrl();
        String rhsUrl = that.getUrl();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Coding theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        Code theResource = this.getResource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "resource", theResource), currentHashCode, theResource, this.resource != null);
        String theLabel = this.getLabel();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "label", theLabel), currentHashCode, theLabel, this.label != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        ContentType theAccept = this.getAccept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "accept", theAccept), currentHashCode, theAccept, this.accept != null);
        ContentType theContentType = this.getContentType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contentType", theContentType), currentHashCode, theContentType, this.contentType != null);
        Integer theDestination = this.getDestination();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "destination", theDestination), currentHashCode, theDestination, this.destination != null);
        Boolean theEncodeRequestUrl = this.getEncodeRequestUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encodeRequestUrl", theEncodeRequestUrl), currentHashCode, theEncodeRequestUrl, this.encodeRequestUrl != null);
        Integer theOrigin = this.getOrigin();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "origin", theOrigin), currentHashCode, theOrigin, this.origin != null);
        String theParams = this.getParams();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "params", theParams), currentHashCode, theParams, this.params != null);
        List<TestScriptRequestHeader> theRequestHeader = this.requestHeader != null && !this.requestHeader.isEmpty() ? this.getRequestHeader() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestHeader", theRequestHeader), currentHashCode, theRequestHeader, this.requestHeader != null && !this.requestHeader.isEmpty());
        Id theResponseId = this.getResponseId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "responseId", theResponseId), currentHashCode, theResponseId, this.responseId != null);
        Id theSourceId = this.getSourceId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "sourceId", theSourceId), currentHashCode, theSourceId, this.sourceId != null);
        Id theTargetId = this.getTargetId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetId", theTargetId), currentHashCode, theTargetId, this.targetId != null);
        String theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Coding theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        Code theResource = this.getResource();
        strategy.appendField(locator, (Object)this, "resource", buffer, theResource, this.resource != null);
        String theLabel = this.getLabel();
        strategy.appendField(locator, (Object)this, "label", buffer, theLabel, this.label != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        ContentType theAccept = this.getAccept();
        strategy.appendField(locator, (Object)this, "accept", buffer, theAccept, this.accept != null);
        ContentType theContentType = this.getContentType();
        strategy.appendField(locator, (Object)this, "contentType", buffer, theContentType, this.contentType != null);
        Integer theDestination = this.getDestination();
        strategy.appendField(locator, (Object)this, "destination", buffer, theDestination, this.destination != null);
        Boolean theEncodeRequestUrl = this.getEncodeRequestUrl();
        strategy.appendField(locator, (Object)this, "encodeRequestUrl", buffer, theEncodeRequestUrl, this.encodeRequestUrl != null);
        Integer theOrigin = this.getOrigin();
        strategy.appendField(locator, (Object)this, "origin", buffer, theOrigin, this.origin != null);
        String theParams = this.getParams();
        strategy.appendField(locator, (Object)this, "params", buffer, theParams, this.params != null);
        List<TestScriptRequestHeader> theRequestHeader = this.requestHeader != null && !this.requestHeader.isEmpty() ? this.getRequestHeader() : null;
        strategy.appendField(locator, (Object)this, "requestHeader", buffer, theRequestHeader, this.requestHeader != null && !this.requestHeader.isEmpty());
        Id theResponseId = this.getResponseId();
        strategy.appendField(locator, (Object)this, "responseId", buffer, theResponseId, this.responseId != null);
        Id theSourceId = this.getSourceId();
        strategy.appendField(locator, (Object)this, "sourceId", buffer, theSourceId, this.sourceId != null);
        Id theTargetId = this.getTargetId();
        strategy.appendField(locator, (Object)this, "targetId", buffer, theTargetId, this.targetId != null);
        String theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        return buffer;
    }
}

