/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.TaskInput;
import org.hl7.fhir.TaskOutput;
import org.hl7.fhir.TaskPriority;
import org.hl7.fhir.TaskStatus;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Task", propOrder={"identifier", "type", "description", "performerType", "priority", "status", "failureReason", "subject", "_for", "definition", "created", "lastModified", "creator", "owner", "parent", "input", "output"})
public class Task
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier identifier;
    protected CodeableConcept type;
    protected String description;
    protected List<Coding> performerType;
    protected TaskPriority priority;
    @XmlElement(required=true)
    protected TaskStatus status;
    protected CodeableConcept failureReason;
    protected Reference subject;
    @XmlElement(name="for")
    protected Reference _for;
    protected Uri definition;
    @XmlElement(required=true)
    protected DateTime created;
    @XmlElement(required=true)
    protected DateTime lastModified;
    @XmlElement(required=true)
    protected Reference creator;
    protected Reference owner;
    protected Reference parent;
    protected List<TaskInput> input;
    protected List<TaskOutput> output;

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<Coding> getPerformerType() {
        if (this.performerType == null) {
            this.performerType = new ArrayList<Coding>();
        }
        return this.performerType;
    }

    public TaskPriority getPriority() {
        return this.priority;
    }

    public void setPriority(TaskPriority value) {
        this.priority = value;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus value) {
        this.status = value;
    }

    public CodeableConcept getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(CodeableConcept value) {
        this.failureReason = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getFor() {
        return this._for;
    }

    public void setFor(Reference value) {
        this._for = value;
    }

    public Uri getDefinition() {
        return this.definition;
    }

    public void setDefinition(Uri value) {
        this.definition = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(DateTime value) {
        this.lastModified = value;
    }

    public Reference getCreator() {
        return this.creator;
    }

    public void setCreator(Reference value) {
        this.creator = value;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public void setOwner(Reference value) {
        this.owner = value;
    }

    public Reference getParent() {
        return this.parent;
    }

    public void setParent(Reference value) {
        this.parent = value;
    }

    public List<TaskInput> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<TaskInput>();
        }
        return this.input;
    }

    public List<TaskOutput> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<TaskOutput>();
        }
        return this.output;
    }

    public Task withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public Task withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Task withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Task withPerformerType(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getPerformerType().add(value);
            }
        }
        return this;
    }

    public Task withPerformerType(Collection<Coding> values) {
        if (values != null) {
            this.getPerformerType().addAll(values);
        }
        return this;
    }

    public Task withPriority(TaskPriority value) {
        this.setPriority(value);
        return this;
    }

    public Task withStatus(TaskStatus value) {
        this.setStatus(value);
        return this;
    }

    public Task withFailureReason(CodeableConcept value) {
        this.setFailureReason(value);
        return this;
    }

    public Task withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Task withFor(Reference value) {
        this.setFor(value);
        return this;
    }

    public Task withDefinition(Uri value) {
        this.setDefinition(value);
        return this;
    }

    public Task withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public Task withLastModified(DateTime value) {
        this.setLastModified(value);
        return this;
    }

    public Task withCreator(Reference value) {
        this.setCreator(value);
        return this;
    }

    public Task withOwner(Reference value) {
        this.setOwner(value);
        return this;
    }

    public Task withParent(Reference value) {
        this.setParent(value);
        return this;
    }

    public Task withInput(TaskInput ... values) {
        if (values != null) {
            for (TaskInput value : values) {
                this.getInput().add(value);
            }
        }
        return this;
    }

    public Task withInput(Collection<TaskInput> values) {
        if (values != null) {
            this.getInput().addAll(values);
        }
        return this;
    }

    public Task withOutput(TaskOutput ... values) {
        if (values != null) {
            for (TaskOutput value : values) {
                this.getOutput().add(value);
            }
        }
        return this;
    }

    public Task withOutput(Collection<TaskOutput> values) {
        if (values != null) {
            this.getOutput().addAll(values);
        }
        return this;
    }

    @Override
    public Task withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Task withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Task withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Task withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Task withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Task withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Task withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Task withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Task withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Task withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Task withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Task that = (Task)object;
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<Coding> lhsPerformerType = this.performerType != null && !this.performerType.isEmpty() ? this.getPerformerType() : null;
        List<Coding> rhsPerformerType = that.performerType != null && !that.performerType.isEmpty() ? that.getPerformerType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performerType", lhsPerformerType), (ObjectLocator)LocatorUtils.property(thatLocator, "performerType", rhsPerformerType), lhsPerformerType, rhsPerformerType, this.performerType != null && !this.performerType.isEmpty(), that.performerType != null && !that.performerType.isEmpty())) {
            return false;
        }
        TaskPriority lhsPriority = this.getPriority();
        TaskPriority rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null)) {
            return false;
        }
        TaskStatus lhsStatus = this.getStatus();
        TaskStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsFailureReason = this.getFailureReason();
        CodeableConcept rhsFailureReason = that.getFailureReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "failureReason", lhsFailureReason), (ObjectLocator)LocatorUtils.property(thatLocator, "failureReason", rhsFailureReason), lhsFailureReason, rhsFailureReason, this.failureReason != null, that.failureReason != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsFor = this.getFor();
        Reference rhsFor = that.getFor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "_for", lhsFor), (ObjectLocator)LocatorUtils.property(thatLocator, "_for", rhsFor), lhsFor, rhsFor, this._for != null, that._for != null)) {
            return false;
        }
        Uri lhsDefinition = this.getDefinition();
        Uri rhsDefinition = that.getDefinition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "definition", lhsDefinition), (ObjectLocator)LocatorUtils.property(thatLocator, "definition", rhsDefinition), lhsDefinition, rhsDefinition, this.definition != null, that.definition != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        DateTime lhsLastModified = this.getLastModified();
        DateTime rhsLastModified = that.getLastModified();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "lastModified", lhsLastModified), (ObjectLocator)LocatorUtils.property(thatLocator, "lastModified", rhsLastModified), lhsLastModified, rhsLastModified, this.lastModified != null, that.lastModified != null)) {
            return false;
        }
        Reference lhsCreator = this.getCreator();
        Reference rhsCreator = that.getCreator();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "creator", lhsCreator), (ObjectLocator)LocatorUtils.property(thatLocator, "creator", rhsCreator), lhsCreator, rhsCreator, this.creator != null, that.creator != null)) {
            return false;
        }
        Reference lhsOwner = this.getOwner();
        Reference rhsOwner = that.getOwner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "owner", lhsOwner), (ObjectLocator)LocatorUtils.property(thatLocator, "owner", rhsOwner), lhsOwner, rhsOwner, this.owner != null, that.owner != null)) {
            return false;
        }
        Reference lhsParent = this.getParent();
        Reference rhsParent = that.getParent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "parent", lhsParent), (ObjectLocator)LocatorUtils.property(thatLocator, "parent", rhsParent), lhsParent, rhsParent, this.parent != null, that.parent != null)) {
            return false;
        }
        List<TaskInput> lhsInput = this.input != null && !this.input.isEmpty() ? this.getInput() : null;
        List<TaskInput> rhsInput = that.input != null && !that.input.isEmpty() ? that.getInput() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "input", lhsInput), (ObjectLocator)LocatorUtils.property(thatLocator, "input", rhsInput), lhsInput, rhsInput, this.input != null && !this.input.isEmpty(), that.input != null && !that.input.isEmpty())) {
            return false;
        }
        List<TaskOutput> lhsOutput = this.output != null && !this.output.isEmpty() ? this.getOutput() : null;
        List<TaskOutput> rhsOutput = that.output != null && !that.output.isEmpty() ? that.getOutput() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "output", lhsOutput), (ObjectLocator)LocatorUtils.property(thatLocator, "output", rhsOutput), lhsOutput, rhsOutput, this.output != null && !this.output.isEmpty(), that.output != null && !that.output.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<Coding> thePerformerType = this.performerType != null && !this.performerType.isEmpty() ? this.getPerformerType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performerType", thePerformerType), currentHashCode, thePerformerType, this.performerType != null && !this.performerType.isEmpty());
        TaskPriority thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        TaskStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theFailureReason = this.getFailureReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "failureReason", theFailureReason), currentHashCode, theFailureReason, this.failureReason != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        Reference theFor = this.getFor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "_for", theFor), currentHashCode, theFor, this._for != null);
        Uri theDefinition = this.getDefinition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "definition", theDefinition), currentHashCode, theDefinition, this.definition != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        DateTime theLastModified = this.getLastModified();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "lastModified", theLastModified), currentHashCode, theLastModified, this.lastModified != null);
        Reference theCreator = this.getCreator();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "creator", theCreator), currentHashCode, theCreator, this.creator != null);
        Reference theOwner = this.getOwner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "owner", theOwner), currentHashCode, theOwner, this.owner != null);
        Reference theParent = this.getParent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "parent", theParent), currentHashCode, theParent, this.parent != null);
        List<TaskInput> theInput = this.input != null && !this.input.isEmpty() ? this.getInput() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "input", theInput), currentHashCode, theInput, this.input != null && !this.input.isEmpty());
        List<TaskOutput> theOutput = this.output != null && !this.output.isEmpty() ? this.getOutput() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "output", theOutput), currentHashCode, theOutput, this.output != null && !this.output.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<Coding> thePerformerType = this.performerType != null && !this.performerType.isEmpty() ? this.getPerformerType() : null;
        strategy.appendField(locator, (Object)this, "performerType", buffer, thePerformerType, this.performerType != null && !this.performerType.isEmpty());
        TaskPriority thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        TaskStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theFailureReason = this.getFailureReason();
        strategy.appendField(locator, (Object)this, "failureReason", buffer, theFailureReason, this.failureReason != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        Reference theFor = this.getFor();
        strategy.appendField(locator, (Object)this, "_for", buffer, theFor, this._for != null);
        Uri theDefinition = this.getDefinition();
        strategy.appendField(locator, (Object)this, "definition", buffer, theDefinition, this.definition != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        DateTime theLastModified = this.getLastModified();
        strategy.appendField(locator, (Object)this, "lastModified", buffer, theLastModified, this.lastModified != null);
        Reference theCreator = this.getCreator();
        strategy.appendField(locator, (Object)this, "creator", buffer, theCreator, this.creator != null);
        Reference theOwner = this.getOwner();
        strategy.appendField(locator, (Object)this, "owner", buffer, theOwner, this.owner != null);
        Reference theParent = this.getParent();
        strategy.appendField(locator, (Object)this, "parent", buffer, theParent, this.parent != null);
        List<TaskInput> theInput = this.input != null && !this.input.isEmpty() ? this.getInput() : null;
        strategy.appendField(locator, (Object)this, "input", buffer, theInput, this.input != null && !this.input.isEmpty());
        List<TaskOutput> theOutput = this.output != null && !this.output.isEmpty() ? this.getOutput() : null;
        strategy.appendField(locator, (Object)this, "output", buffer, theOutput, this.output != null && !this.output.isEmpty());
        return buffer;
    }
}

