/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.SubscriptionChannel;
import org.hl7.fhir.SubscriptionStatus;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Subscription", propOrder={"criteria", "contact", "reason", "status", "error", "channel", "end", "tag"})
public class Subscription
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected String criteria;
    protected List<ContactPoint> contact;
    @XmlElement(required=true)
    protected String reason;
    @XmlElement(required=true)
    protected SubscriptionStatus status;
    protected String error;
    @XmlElement(required=true)
    protected SubscriptionChannel channel;
    protected Instant end;
    protected List<Coding> tag;

    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String value) {
        this.criteria = value;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String value) {
        this.reason = value;
    }

    public SubscriptionStatus getStatus() {
        return this.status;
    }

    public void setStatus(SubscriptionStatus value) {
        this.status = value;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String value) {
        this.error = value;
    }

    public SubscriptionChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SubscriptionChannel value) {
        this.channel = value;
    }

    public Instant getEnd() {
        return this.end;
    }

    public void setEnd(Instant value) {
        this.end = value;
    }

    public List<Coding> getTag() {
        if (this.tag == null) {
            this.tag = new ArrayList<Coding>();
        }
        return this.tag;
    }

    public Subscription withCriteria(String value) {
        this.setCriteria(value);
        return this;
    }

    public Subscription withContact(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public Subscription withContact(Collection<ContactPoint> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public Subscription withReason(String value) {
        this.setReason(value);
        return this;
    }

    public Subscription withStatus(SubscriptionStatus value) {
        this.setStatus(value);
        return this;
    }

    public Subscription withError(String value) {
        this.setError(value);
        return this;
    }

    public Subscription withChannel(SubscriptionChannel value) {
        this.setChannel(value);
        return this;
    }

    public Subscription withEnd(Instant value) {
        this.setEnd(value);
        return this;
    }

    public Subscription withTag(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getTag().add(value);
            }
        }
        return this;
    }

    public Subscription withTag(Collection<Coding> values) {
        if (values != null) {
            this.getTag().addAll(values);
        }
        return this;
    }

    @Override
    public Subscription withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Subscription withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Subscription withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Subscription withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Subscription withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Subscription withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Subscription withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Subscription withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Subscription withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Subscription withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Subscription withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Subscription that = (Subscription)object;
        String lhsCriteria = this.getCriteria();
        String rhsCriteria = that.getCriteria();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "criteria", lhsCriteria), (ObjectLocator)LocatorUtils.property(thatLocator, "criteria", rhsCriteria), lhsCriteria, rhsCriteria, this.criteria != null, that.criteria != null)) {
            return false;
        }
        List<ContactPoint> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ContactPoint> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        String lhsReason = this.getReason();
        String rhsReason = that.getReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reason", lhsReason), (ObjectLocator)LocatorUtils.property(thatLocator, "reason", rhsReason), lhsReason, rhsReason, this.reason != null, that.reason != null)) {
            return false;
        }
        SubscriptionStatus lhsStatus = this.getStatus();
        SubscriptionStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        String lhsError = this.getError();
        String rhsError = that.getError();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "error", lhsError), (ObjectLocator)LocatorUtils.property(thatLocator, "error", rhsError), lhsError, rhsError, this.error != null, that.error != null)) {
            return false;
        }
        SubscriptionChannel lhsChannel = this.getChannel();
        SubscriptionChannel rhsChannel = that.getChannel();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "channel", lhsChannel), (ObjectLocator)LocatorUtils.property(thatLocator, "channel", rhsChannel), lhsChannel, rhsChannel, this.channel != null, that.channel != null)) {
            return false;
        }
        Instant lhsEnd = this.getEnd();
        Instant rhsEnd = that.getEnd();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "end", lhsEnd), (ObjectLocator)LocatorUtils.property(thatLocator, "end", rhsEnd), lhsEnd, rhsEnd, this.end != null, that.end != null)) {
            return false;
        }
        List<Coding> lhsTag = this.tag != null && !this.tag.isEmpty() ? this.getTag() : null;
        List<Coding> rhsTag = that.tag != null && !that.tag.isEmpty() ? that.getTag() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "tag", lhsTag), (ObjectLocator)LocatorUtils.property(thatLocator, "tag", rhsTag), lhsTag, rhsTag, this.tag != null && !this.tag.isEmpty(), that.tag != null && !that.tag.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theCriteria = this.getCriteria();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "criteria", theCriteria), currentHashCode, theCriteria, this.criteria != null);
        List<ContactPoint> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        String theReason = this.getReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reason", theReason), currentHashCode, theReason, this.reason != null);
        SubscriptionStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        String theError = this.getError();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "error", theError), currentHashCode, theError, this.error != null);
        SubscriptionChannel theChannel = this.getChannel();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "channel", theChannel), currentHashCode, theChannel, this.channel != null);
        Instant theEnd = this.getEnd();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "end", theEnd), currentHashCode, theEnd, this.end != null);
        List<Coding> theTag = this.tag != null && !this.tag.isEmpty() ? this.getTag() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "tag", theTag), currentHashCode, theTag, this.tag != null && !this.tag.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theCriteria = this.getCriteria();
        strategy.appendField(locator, (Object)this, "criteria", buffer, theCriteria, this.criteria != null);
        List<ContactPoint> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        String theReason = this.getReason();
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason, this.reason != null);
        SubscriptionStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        String theError = this.getError();
        strategy.appendField(locator, (Object)this, "error", buffer, theError, this.error != null);
        SubscriptionChannel theChannel = this.getChannel();
        strategy.appendField(locator, (Object)this, "channel", buffer, theChannel, this.channel != null);
        Instant theEnd = this.getEnd();
        strategy.appendField(locator, (Object)this, "end", buffer, theEnd, this.end != null);
        List<Coding> theTag = this.tag != null && !this.tag.isEmpty() ? this.getTag() : null;
        strategy.appendField(locator, (Object)this, "tag", buffer, theTag, this.tag != null && !this.tag.isEmpty());
        return buffer;
    }
}

