/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.RiskAssessmentPrediction;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RiskAssessment", propOrder={"subject", "date", "condition", "encounter", "performer", "identifier", "method", "basis", "prediction", "mitigation"})
public class RiskAssessment
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Reference subject;
    protected DateTime date;
    protected Reference condition;
    protected Reference encounter;
    protected Reference performer;
    protected Identifier identifier;
    protected CodeableConcept method;
    protected List<Reference> basis;
    protected List<RiskAssessmentPrediction> prediction;
    protected String mitigation;

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public Reference getCondition() {
        return this.condition;
    }

    public void setCondition(Reference value) {
        this.condition = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public void setMethod(CodeableConcept value) {
        this.method = value;
    }

    public List<Reference> getBasis() {
        if (this.basis == null) {
            this.basis = new ArrayList<Reference>();
        }
        return this.basis;
    }

    public List<RiskAssessmentPrediction> getPrediction() {
        if (this.prediction == null) {
            this.prediction = new ArrayList<RiskAssessmentPrediction>();
        }
        return this.prediction;
    }

    public String getMitigation() {
        return this.mitigation;
    }

    public void setMitigation(String value) {
        this.mitigation = value;
    }

    public RiskAssessment withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public RiskAssessment withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public RiskAssessment withCondition(Reference value) {
        this.setCondition(value);
        return this;
    }

    public RiskAssessment withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public RiskAssessment withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public RiskAssessment withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public RiskAssessment withMethod(CodeableConcept value) {
        this.setMethod(value);
        return this;
    }

    public RiskAssessment withBasis(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getBasis().add(value);
            }
        }
        return this;
    }

    public RiskAssessment withBasis(Collection<Reference> values) {
        if (values != null) {
            this.getBasis().addAll(values);
        }
        return this;
    }

    public RiskAssessment withPrediction(RiskAssessmentPrediction ... values) {
        if (values != null) {
            for (RiskAssessmentPrediction value : values) {
                this.getPrediction().add(value);
            }
        }
        return this;
    }

    public RiskAssessment withPrediction(Collection<RiskAssessmentPrediction> values) {
        if (values != null) {
            this.getPrediction().addAll(values);
        }
        return this;
    }

    public RiskAssessment withMitigation(String value) {
        this.setMitigation(value);
        return this;
    }

    @Override
    public RiskAssessment withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public RiskAssessment withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public RiskAssessment withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public RiskAssessment withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public RiskAssessment withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public RiskAssessment withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public RiskAssessment withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        RiskAssessment that = (RiskAssessment)object;
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        Reference lhsCondition = this.getCondition();
        Reference rhsCondition = that.getCondition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "condition", lhsCondition), (ObjectLocator)LocatorUtils.property(thatLocator, "condition", rhsCondition), lhsCondition, rhsCondition, this.condition != null, that.condition != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null, that.performer != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        CodeableConcept lhsMethod = this.getMethod();
        CodeableConcept rhsMethod = that.getMethod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "method", lhsMethod), (ObjectLocator)LocatorUtils.property(thatLocator, "method", rhsMethod), lhsMethod, rhsMethod, this.method != null, that.method != null)) {
            return false;
        }
        List<Reference> lhsBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        List<Reference> rhsBasis = that.basis != null && !that.basis.isEmpty() ? that.getBasis() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "basis", lhsBasis), (ObjectLocator)LocatorUtils.property(thatLocator, "basis", rhsBasis), lhsBasis, rhsBasis, this.basis != null && !this.basis.isEmpty(), that.basis != null && !that.basis.isEmpty())) {
            return false;
        }
        List<RiskAssessmentPrediction> lhsPrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        List<RiskAssessmentPrediction> rhsPrediction = that.prediction != null && !that.prediction.isEmpty() ? that.getPrediction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "prediction", lhsPrediction), (ObjectLocator)LocatorUtils.property(thatLocator, "prediction", rhsPrediction), lhsPrediction, rhsPrediction, this.prediction != null && !this.prediction.isEmpty(), that.prediction != null && !that.prediction.isEmpty())) {
            return false;
        }
        String lhsMitigation = this.getMitigation();
        String rhsMitigation = that.getMitigation();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "mitigation", lhsMitigation), (ObjectLocator)LocatorUtils.property(thatLocator, "mitigation", rhsMitigation), lhsMitigation, rhsMitigation, this.mitigation != null, that.mitigation != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        Reference theCondition = this.getCondition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "condition", theCondition), currentHashCode, theCondition, this.condition != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        CodeableConcept theMethod = this.getMethod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "method", theMethod), currentHashCode, theMethod, this.method != null);
        List<Reference> theBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "basis", theBasis), currentHashCode, theBasis, this.basis != null && !this.basis.isEmpty());
        List<RiskAssessmentPrediction> thePrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "prediction", thePrediction), currentHashCode, thePrediction, this.prediction != null && !this.prediction.isEmpty());
        String theMitigation = this.getMitigation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "mitigation", theMitigation), currentHashCode, theMitigation, this.mitigation != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        Reference theCondition = this.getCondition();
        strategy.appendField(locator, (Object)this, "condition", buffer, theCondition, this.condition != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        CodeableConcept theMethod = this.getMethod();
        strategy.appendField(locator, (Object)this, "method", buffer, theMethod, this.method != null);
        List<Reference> theBasis = this.basis != null && !this.basis.isEmpty() ? this.getBasis() : null;
        strategy.appendField(locator, (Object)this, "basis", buffer, theBasis, this.basis != null && !this.basis.isEmpty());
        List<RiskAssessmentPrediction> thePrediction = this.prediction != null && !this.prediction.isEmpty() ? this.getPrediction() : null;
        strategy.appendField(locator, (Object)this, "prediction", buffer, thePrediction, this.prediction != null && !this.prediction.isEmpty());
        String theMitigation = this.getMitigation();
        strategy.appendField(locator, (Object)this, "mitigation", buffer, theMitigation, this.mitigation != null);
        return buffer;
    }
}

