/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.QuestionnaireResponseAnswer;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QuestionnaireResponse.Item", propOrder={"linkId", "text", "subject", "answer", "item"})
public class QuestionnaireResponseItem
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected String linkId;
    protected String text;
    protected Reference subject;
    protected List<QuestionnaireResponseAnswer> answer;
    protected List<QuestionnaireResponseItem> item;

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String value) {
        this.linkId = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public List<QuestionnaireResponseAnswer> getAnswer() {
        if (this.answer == null) {
            this.answer = new ArrayList<QuestionnaireResponseAnswer>();
        }
        return this.answer;
    }

    public List<QuestionnaireResponseItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<QuestionnaireResponseItem>();
        }
        return this.item;
    }

    public QuestionnaireResponseItem withLinkId(String value) {
        this.setLinkId(value);
        return this;
    }

    public QuestionnaireResponseItem withText(String value) {
        this.setText(value);
        return this;
    }

    public QuestionnaireResponseItem withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public QuestionnaireResponseItem withAnswer(QuestionnaireResponseAnswer ... values) {
        if (values != null) {
            for (QuestionnaireResponseAnswer value : values) {
                this.getAnswer().add(value);
            }
        }
        return this;
    }

    public QuestionnaireResponseItem withAnswer(Collection<QuestionnaireResponseAnswer> values) {
        if (values != null) {
            this.getAnswer().addAll(values);
        }
        return this;
    }

    public QuestionnaireResponseItem withItem(QuestionnaireResponseItem ... values) {
        if (values != null) {
            for (QuestionnaireResponseItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public QuestionnaireResponseItem withItem(Collection<QuestionnaireResponseItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponseItem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireResponseItem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponseItem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public QuestionnaireResponseItem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public QuestionnaireResponseItem withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        QuestionnaireResponseItem that = (QuestionnaireResponseItem)object;
        String lhsLinkId = this.getLinkId();
        String rhsLinkId = that.getLinkId();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "linkId", lhsLinkId), (ObjectLocator)LocatorUtils.property(thatLocator, "linkId", rhsLinkId), lhsLinkId, rhsLinkId, this.linkId != null, that.linkId != null)) {
            return false;
        }
        String lhsText = this.getText();
        String rhsText = that.getText();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "text", lhsText), (ObjectLocator)LocatorUtils.property(thatLocator, "text", rhsText), lhsText, rhsText, this.text != null, that.text != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        List<QuestionnaireResponseAnswer> lhsAnswer = this.answer != null && !this.answer.isEmpty() ? this.getAnswer() : null;
        List<QuestionnaireResponseAnswer> rhsAnswer = that.answer != null && !that.answer.isEmpty() ? that.getAnswer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "answer", lhsAnswer), (ObjectLocator)LocatorUtils.property(thatLocator, "answer", rhsAnswer), lhsAnswer, rhsAnswer, this.answer != null && !this.answer.isEmpty(), that.answer != null && !that.answer.isEmpty())) {
            return false;
        }
        List<QuestionnaireResponseItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<QuestionnaireResponseItem> rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "item", lhsItem), (ObjectLocator)LocatorUtils.property(thatLocator, "item", rhsItem), lhsItem, rhsItem, this.item != null && !this.item.isEmpty(), that.item != null && !that.item.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theLinkId = this.getLinkId();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "linkId", theLinkId), currentHashCode, theLinkId, this.linkId != null);
        String theText = this.getText();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "text", theText), currentHashCode, theText, this.text != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        List<QuestionnaireResponseAnswer> theAnswer = this.answer != null && !this.answer.isEmpty() ? this.getAnswer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "answer", theAnswer), currentHashCode, theAnswer, this.answer != null && !this.answer.isEmpty());
        List<QuestionnaireResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "item", theItem), currentHashCode, theItem, this.item != null && !this.item.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theLinkId = this.getLinkId();
        strategy.appendField(locator, (Object)this, "linkId", buffer, theLinkId, this.linkId != null);
        String theText = this.getText();
        strategy.appendField(locator, (Object)this, "text", buffer, theText, this.text != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        List<QuestionnaireResponseAnswer> theAnswer = this.answer != null && !this.answer.isEmpty() ? this.getAnswer() : null;
        strategy.appendField(locator, (Object)this, "answer", buffer, theAnswer, this.answer != null && !this.answer.isEmpty());
        List<QuestionnaireResponseItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem, this.item != null && !this.item.isEmpty());
        return buffer;
    }
}

