/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProvenanceAgent;
import org.hl7.fhir.ProvenanceEntity;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Signature;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Provenance", propOrder={"target", "period", "recorded", "reason", "activity", "location", "policy", "agent", "entity", "signature"})
public class Provenance
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected List<Reference> target;
    protected Period period;
    @XmlElement(required=true)
    protected Instant recorded;
    protected List<Coding> reason;
    protected Coding activity;
    protected Reference location;
    protected List<Uri> policy;
    @XmlElement(required=true)
    protected List<ProvenanceAgent> agent;
    protected List<ProvenanceEntity> entity;
    protected List<Signature> signature;

    public List<Reference> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<Reference>();
        }
        return this.target;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public Instant getRecorded() {
        return this.recorded;
    }

    public void setRecorded(Instant value) {
        this.recorded = value;
    }

    public List<Coding> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<Coding>();
        }
        return this.reason;
    }

    public Coding getActivity() {
        return this.activity;
    }

    public void setActivity(Coding value) {
        this.activity = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public List<Uri> getPolicy() {
        if (this.policy == null) {
            this.policy = new ArrayList<Uri>();
        }
        return this.policy;
    }

    public List<ProvenanceAgent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<ProvenanceAgent>();
        }
        return this.agent;
    }

    public List<ProvenanceEntity> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<ProvenanceEntity>();
        }
        return this.entity;
    }

    public List<Signature> getSignature() {
        if (this.signature == null) {
            this.signature = new ArrayList<Signature>();
        }
        return this.signature;
    }

    public Provenance withTarget(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getTarget().add(value);
            }
        }
        return this;
    }

    public Provenance withTarget(Collection<Reference> values) {
        if (values != null) {
            this.getTarget().addAll(values);
        }
        return this;
    }

    public Provenance withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public Provenance withRecorded(Instant value) {
        this.setRecorded(value);
        return this;
    }

    public Provenance withReason(Coding ... values) {
        if (values != null) {
            for (Coding value : values) {
                this.getReason().add(value);
            }
        }
        return this;
    }

    public Provenance withReason(Collection<Coding> values) {
        if (values != null) {
            this.getReason().addAll(values);
        }
        return this;
    }

    public Provenance withActivity(Coding value) {
        this.setActivity(value);
        return this;
    }

    public Provenance withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Provenance withPolicy(Uri ... values) {
        if (values != null) {
            for (Uri value : values) {
                this.getPolicy().add(value);
            }
        }
        return this;
    }

    public Provenance withPolicy(Collection<Uri> values) {
        if (values != null) {
            this.getPolicy().addAll(values);
        }
        return this;
    }

    public Provenance withAgent(ProvenanceAgent ... values) {
        if (values != null) {
            for (ProvenanceAgent value : values) {
                this.getAgent().add(value);
            }
        }
        return this;
    }

    public Provenance withAgent(Collection<ProvenanceAgent> values) {
        if (values != null) {
            this.getAgent().addAll(values);
        }
        return this;
    }

    public Provenance withEntity(ProvenanceEntity ... values) {
        if (values != null) {
            for (ProvenanceEntity value : values) {
                this.getEntity().add(value);
            }
        }
        return this;
    }

    public Provenance withEntity(Collection<ProvenanceEntity> values) {
        if (values != null) {
            this.getEntity().addAll(values);
        }
        return this;
    }

    public Provenance withSignature(Signature ... values) {
        if (values != null) {
            for (Signature value : values) {
                this.getSignature().add(value);
            }
        }
        return this;
    }

    public Provenance withSignature(Collection<Signature> values) {
        if (values != null) {
            this.getSignature().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Provenance withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Provenance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Provenance withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Provenance withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Provenance withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Provenance withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Provenance that = (Provenance)object;
        List<Reference> lhsTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        List<Reference> rhsTarget = that.target != null && !that.target.isEmpty() ? that.getTarget() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "target", lhsTarget), (ObjectLocator)LocatorUtils.property(thatLocator, "target", rhsTarget), lhsTarget, rhsTarget, this.target != null && !this.target.isEmpty(), that.target != null && !that.target.isEmpty())) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "period", lhsPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "period", rhsPeriod), lhsPeriod, rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        Instant lhsRecorded = this.getRecorded();
        Instant rhsRecorded = that.getRecorded();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "recorded", lhsRecorded), (ObjectLocator)LocatorUtils.property(thatLocator, "recorded", rhsRecorded), lhsRecorded, rhsRecorded, this.recorded != null, that.recorded != null)) {
            return false;
        }
        List<Coding> lhsReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        List<Coding> rhsReason = that.reason != null && !that.reason.isEmpty() ? that.getReason() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reason", lhsReason), (ObjectLocator)LocatorUtils.property(thatLocator, "reason", rhsReason), lhsReason, rhsReason, this.reason != null && !this.reason.isEmpty(), that.reason != null && !that.reason.isEmpty())) {
            return false;
        }
        Coding lhsActivity = this.getActivity();
        Coding rhsActivity = that.getActivity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "activity", lhsActivity), (ObjectLocator)LocatorUtils.property(thatLocator, "activity", rhsActivity), lhsActivity, rhsActivity, this.activity != null, that.activity != null)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "location", lhsLocation), (ObjectLocator)LocatorUtils.property(thatLocator, "location", rhsLocation), lhsLocation, rhsLocation, this.location != null, that.location != null)) {
            return false;
        }
        List<Uri> lhsPolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        List<Uri> rhsPolicy = that.policy != null && !that.policy.isEmpty() ? that.getPolicy() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "policy", lhsPolicy), (ObjectLocator)LocatorUtils.property(thatLocator, "policy", rhsPolicy), lhsPolicy, rhsPolicy, this.policy != null && !this.policy.isEmpty(), that.policy != null && !that.policy.isEmpty())) {
            return false;
        }
        List<ProvenanceAgent> lhsAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        List<ProvenanceAgent> rhsAgent = that.agent != null && !that.agent.isEmpty() ? that.getAgent() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "agent", lhsAgent), (ObjectLocator)LocatorUtils.property(thatLocator, "agent", rhsAgent), lhsAgent, rhsAgent, this.agent != null && !this.agent.isEmpty(), that.agent != null && !that.agent.isEmpty())) {
            return false;
        }
        List<ProvenanceEntity> lhsEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        List<ProvenanceEntity> rhsEntity = that.entity != null && !that.entity.isEmpty() ? that.getEntity() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "entity", lhsEntity), (ObjectLocator)LocatorUtils.property(thatLocator, "entity", rhsEntity), lhsEntity, rhsEntity, this.entity != null && !this.entity.isEmpty(), that.entity != null && !that.entity.isEmpty())) {
            return false;
        }
        List<Signature> lhsSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        List<Signature> rhsSignature = that.signature != null && !that.signature.isEmpty() ? that.getSignature() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "signature", lhsSignature), (ObjectLocator)LocatorUtils.property(thatLocator, "signature", rhsSignature), lhsSignature, rhsSignature, this.signature != null && !this.signature.isEmpty(), that.signature != null && !that.signature.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Reference> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "target", theTarget), currentHashCode, theTarget, this.target != null && !this.target.isEmpty());
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "period", thePeriod), currentHashCode, thePeriod, this.period != null);
        Instant theRecorded = this.getRecorded();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "recorded", theRecorded), currentHashCode, theRecorded, this.recorded != null);
        List<Coding> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reason", theReason), currentHashCode, theReason, this.reason != null && !this.reason.isEmpty());
        Coding theActivity = this.getActivity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "activity", theActivity), currentHashCode, theActivity, this.activity != null);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "location", theLocation), currentHashCode, theLocation, this.location != null);
        List<Uri> thePolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "policy", thePolicy), currentHashCode, thePolicy, this.policy != null && !this.policy.isEmpty());
        List<ProvenanceAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "agent", theAgent), currentHashCode, theAgent, this.agent != null && !this.agent.isEmpty());
        List<ProvenanceEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "entity", theEntity), currentHashCode, theEntity, this.entity != null && !this.entity.isEmpty());
        List<Signature> theSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "signature", theSignature), currentHashCode, theSignature, this.signature != null && !this.signature.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Reference> theTarget = this.target != null && !this.target.isEmpty() ? this.getTarget() : null;
        strategy.appendField(locator, (Object)this, "target", buffer, theTarget, this.target != null && !this.target.isEmpty());
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, thePeriod, this.period != null);
        Instant theRecorded = this.getRecorded();
        strategy.appendField(locator, (Object)this, "recorded", buffer, theRecorded, this.recorded != null);
        List<Coding> theReason = this.reason != null && !this.reason.isEmpty() ? this.getReason() : null;
        strategy.appendField(locator, (Object)this, "reason", buffer, theReason, this.reason != null && !this.reason.isEmpty());
        Coding theActivity = this.getActivity();
        strategy.appendField(locator, (Object)this, "activity", buffer, theActivity, this.activity != null);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null);
        List<Uri> thePolicy = this.policy != null && !this.policy.isEmpty() ? this.getPolicy() : null;
        strategy.appendField(locator, (Object)this, "policy", buffer, thePolicy, this.policy != null && !this.policy.isEmpty());
        List<ProvenanceAgent> theAgent = this.agent != null && !this.agent.isEmpty() ? this.getAgent() : null;
        strategy.appendField(locator, (Object)this, "agent", buffer, theAgent, this.agent != null && !this.agent.isEmpty());
        List<ProvenanceEntity> theEntity = this.entity != null && !this.entity.isEmpty() ? this.getEntity() : null;
        strategy.appendField(locator, (Object)this, "entity", buffer, theEntity, this.entity != null && !this.entity.isEmpty());
        List<Signature> theSignature = this.signature != null && !this.signature.isEmpty() ? this.getSignature() : null;
        strategy.appendField(locator, (Object)this, "signature", buffer, theSignature, this.signature != null && !this.signature.isEmpty());
        return buffer;
    }
}

