/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.ActionList;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcessRequestItem;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessRequest", propOrder={"action", "identifier", "ruleset", "originalRuleset", "created", "targetIdentifier", "targetReference", "providerIdentifier", "providerReference", "organizationIdentifier", "organizationReference", "requestIdentifier", "requestReference", "responseIdentifier", "responseReference", "nullify", "reference", "item", "include", "exclude", "period"})
public class ProcessRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected ActionList action;
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Identifier targetIdentifier;
    protected Reference targetReference;
    protected Identifier providerIdentifier;
    protected Reference providerReference;
    protected Identifier organizationIdentifier;
    protected Reference organizationReference;
    protected Identifier requestIdentifier;
    protected Reference requestReference;
    protected Identifier responseIdentifier;
    protected Reference responseReference;
    protected Boolean nullify;
    protected String reference;
    protected List<ProcessRequestItem> item;
    protected List<String> include;
    protected List<String> exclude;
    protected Period period;

    public ActionList getAction() {
        return this.action;
    }

    public void setAction(ActionList value) {
        this.action = value;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Identifier getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public void setTargetIdentifier(Identifier value) {
        this.targetIdentifier = value;
    }

    public Reference getTargetReference() {
        return this.targetReference;
    }

    public void setTargetReference(Reference value) {
        this.targetReference = value;
    }

    public Identifier getProviderIdentifier() {
        return this.providerIdentifier;
    }

    public void setProviderIdentifier(Identifier value) {
        this.providerIdentifier = value;
    }

    public Reference getProviderReference() {
        return this.providerReference;
    }

    public void setProviderReference(Reference value) {
        this.providerReference = value;
    }

    public Identifier getOrganizationIdentifier() {
        return this.organizationIdentifier;
    }

    public void setOrganizationIdentifier(Identifier value) {
        this.organizationIdentifier = value;
    }

    public Reference getOrganizationReference() {
        return this.organizationReference;
    }

    public void setOrganizationReference(Reference value) {
        this.organizationReference = value;
    }

    public Identifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public void setRequestIdentifier(Identifier value) {
        this.requestIdentifier = value;
    }

    public Reference getRequestReference() {
        return this.requestReference;
    }

    public void setRequestReference(Reference value) {
        this.requestReference = value;
    }

    public Identifier getResponseIdentifier() {
        return this.responseIdentifier;
    }

    public void setResponseIdentifier(Identifier value) {
        this.responseIdentifier = value;
    }

    public Reference getResponseReference() {
        return this.responseReference;
    }

    public void setResponseReference(Reference value) {
        this.responseReference = value;
    }

    public Boolean getNullify() {
        return this.nullify;
    }

    public void setNullify(Boolean value) {
        this.nullify = value;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String value) {
        this.reference = value;
    }

    public List<ProcessRequestItem> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ProcessRequestItem>();
        }
        return this.item;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        return this.include;
    }

    public List<String> getExclude() {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        return this.exclude;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public ProcessRequest withAction(ActionList value) {
        this.setAction(value);
        return this;
    }

    public ProcessRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public ProcessRequest withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public ProcessRequest withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public ProcessRequest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public ProcessRequest withTargetIdentifier(Identifier value) {
        this.setTargetIdentifier(value);
        return this;
    }

    public ProcessRequest withTargetReference(Reference value) {
        this.setTargetReference(value);
        return this;
    }

    public ProcessRequest withProviderIdentifier(Identifier value) {
        this.setProviderIdentifier(value);
        return this;
    }

    public ProcessRequest withProviderReference(Reference value) {
        this.setProviderReference(value);
        return this;
    }

    public ProcessRequest withOrganizationIdentifier(Identifier value) {
        this.setOrganizationIdentifier(value);
        return this;
    }

    public ProcessRequest withOrganizationReference(Reference value) {
        this.setOrganizationReference(value);
        return this;
    }

    public ProcessRequest withRequestIdentifier(Identifier value) {
        this.setRequestIdentifier(value);
        return this;
    }

    public ProcessRequest withRequestReference(Reference value) {
        this.setRequestReference(value);
        return this;
    }

    public ProcessRequest withResponseIdentifier(Identifier value) {
        this.setResponseIdentifier(value);
        return this;
    }

    public ProcessRequest withResponseReference(Reference value) {
        this.setResponseReference(value);
        return this;
    }

    public ProcessRequest withNullify(Boolean value) {
        this.setNullify(value);
        return this;
    }

    public ProcessRequest withReference(String value) {
        this.setReference(value);
        return this;
    }

    public ProcessRequest withItem(ProcessRequestItem ... values) {
        if (values != null) {
            for (ProcessRequestItem value : values) {
                this.getItem().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withItem(Collection<ProcessRequestItem> values) {
        if (values != null) {
            this.getItem().addAll(values);
        }
        return this;
    }

    public ProcessRequest withInclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getInclude().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withInclude(Collection<String> values) {
        if (values != null) {
            this.getInclude().addAll(values);
        }
        return this;
    }

    public ProcessRequest withExclude(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getExclude().add(value);
            }
        }
        return this;
    }

    public ProcessRequest withExclude(Collection<String> values) {
        if (values != null) {
            this.getExclude().addAll(values);
        }
        return this;
    }

    public ProcessRequest withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    @Override
    public ProcessRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ProcessRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ProcessRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ProcessRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ProcessRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ProcessRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ProcessRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ProcessRequest that = (ProcessRequest)object;
        ActionList lhsAction = this.getAction();
        ActionList rhsAction = that.getAction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "action", lhsAction), (ObjectLocator)LocatorUtils.property(thatLocator, "action", rhsAction), lhsAction, rhsAction, this.action != null, that.action != null)) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ruleset", lhsRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "ruleset", rhsRuleset), lhsRuleset, rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "originalRuleset", lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "originalRuleset", rhsOriginalRuleset), lhsOriginalRuleset, rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Identifier lhsTargetIdentifier = this.getTargetIdentifier();
        Identifier rhsTargetIdentifier = that.getTargetIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetIdentifier", lhsTargetIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "targetIdentifier", rhsTargetIdentifier), lhsTargetIdentifier, rhsTargetIdentifier, this.targetIdentifier != null, that.targetIdentifier != null)) {
            return false;
        }
        Reference lhsTargetReference = this.getTargetReference();
        Reference rhsTargetReference = that.getTargetReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetReference", lhsTargetReference), (ObjectLocator)LocatorUtils.property(thatLocator, "targetReference", rhsTargetReference), lhsTargetReference, rhsTargetReference, this.targetReference != null, that.targetReference != null)) {
            return false;
        }
        Identifier lhsProviderIdentifier = this.getProviderIdentifier();
        Identifier rhsProviderIdentifier = that.getProviderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "providerIdentifier", lhsProviderIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "providerIdentifier", rhsProviderIdentifier), lhsProviderIdentifier, rhsProviderIdentifier, this.providerIdentifier != null, that.providerIdentifier != null)) {
            return false;
        }
        Reference lhsProviderReference = this.getProviderReference();
        Reference rhsProviderReference = that.getProviderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "providerReference", lhsProviderReference), (ObjectLocator)LocatorUtils.property(thatLocator, "providerReference", rhsProviderReference), lhsProviderReference, rhsProviderReference, this.providerReference != null, that.providerReference != null)) {
            return false;
        }
        Identifier lhsOrganizationIdentifier = this.getOrganizationIdentifier();
        Identifier rhsOrganizationIdentifier = that.getOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationIdentifier", lhsOrganizationIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationIdentifier", rhsOrganizationIdentifier), lhsOrganizationIdentifier, rhsOrganizationIdentifier, this.organizationIdentifier != null, that.organizationIdentifier != null)) {
            return false;
        }
        Reference lhsOrganizationReference = this.getOrganizationReference();
        Reference rhsOrganizationReference = that.getOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationReference", lhsOrganizationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationReference", rhsOrganizationReference), lhsOrganizationReference, rhsOrganizationReference, this.organizationReference != null, that.organizationReference != null)) {
            return false;
        }
        Identifier lhsRequestIdentifier = this.getRequestIdentifier();
        Identifier rhsRequestIdentifier = that.getRequestIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestIdentifier", lhsRequestIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "requestIdentifier", rhsRequestIdentifier), lhsRequestIdentifier, rhsRequestIdentifier, this.requestIdentifier != null, that.requestIdentifier != null)) {
            return false;
        }
        Reference lhsRequestReference = this.getRequestReference();
        Reference rhsRequestReference = that.getRequestReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requestReference", lhsRequestReference), (ObjectLocator)LocatorUtils.property(thatLocator, "requestReference", rhsRequestReference), lhsRequestReference, rhsRequestReference, this.requestReference != null, that.requestReference != null)) {
            return false;
        }
        Identifier lhsResponseIdentifier = this.getResponseIdentifier();
        Identifier rhsResponseIdentifier = that.getResponseIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "responseIdentifier", lhsResponseIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "responseIdentifier", rhsResponseIdentifier), lhsResponseIdentifier, rhsResponseIdentifier, this.responseIdentifier != null, that.responseIdentifier != null)) {
            return false;
        }
        Reference lhsResponseReference = this.getResponseReference();
        Reference rhsResponseReference = that.getResponseReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "responseReference", lhsResponseReference), (ObjectLocator)LocatorUtils.property(thatLocator, "responseReference", rhsResponseReference), lhsResponseReference, rhsResponseReference, this.responseReference != null, that.responseReference != null)) {
            return false;
        }
        Boolean lhsNullify = this.getNullify();
        Boolean rhsNullify = that.getNullify();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "nullify", lhsNullify), (ObjectLocator)LocatorUtils.property(thatLocator, "nullify", rhsNullify), lhsNullify, rhsNullify, this.nullify != null, that.nullify != null)) {
            return false;
        }
        String lhsReference = this.getReference();
        String rhsReference = that.getReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reference", lhsReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reference", rhsReference), lhsReference, rhsReference, this.reference != null, that.reference != null)) {
            return false;
        }
        List<ProcessRequestItem> lhsItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        List<ProcessRequestItem> rhsItem = that.item != null && !that.item.isEmpty() ? that.getItem() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "item", lhsItem), (ObjectLocator)LocatorUtils.property(thatLocator, "item", rhsItem), lhsItem, rhsItem, this.item != null && !this.item.isEmpty(), that.item != null && !that.item.isEmpty())) {
            return false;
        }
        List<String> lhsInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        List<String> rhsInclude = that.include != null && !that.include.isEmpty() ? that.getInclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "include", lhsInclude), (ObjectLocator)LocatorUtils.property(thatLocator, "include", rhsInclude), lhsInclude, rhsInclude, this.include != null && !this.include.isEmpty(), that.include != null && !that.include.isEmpty())) {
            return false;
        }
        List<String> lhsExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        List<String> rhsExclude = that.exclude != null && !that.exclude.isEmpty() ? that.getExclude() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "exclude", lhsExclude), (ObjectLocator)LocatorUtils.property(thatLocator, "exclude", rhsExclude), lhsExclude, rhsExclude, this.exclude != null && !this.exclude.isEmpty(), that.exclude != null && !that.exclude.isEmpty())) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "period", lhsPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "period", rhsPeriod), lhsPeriod, rhsPeriod, this.period != null, that.period != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        ActionList theAction = this.getAction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "action", theAction), currentHashCode, theAction, this.action != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ruleset", theRuleset), currentHashCode, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "originalRuleset", theOriginalRuleset), currentHashCode, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        Identifier theTargetIdentifier = this.getTargetIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetIdentifier", theTargetIdentifier), currentHashCode, theTargetIdentifier, this.targetIdentifier != null);
        Reference theTargetReference = this.getTargetReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetReference", theTargetReference), currentHashCode, theTargetReference, this.targetReference != null);
        Identifier theProviderIdentifier = this.getProviderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "providerIdentifier", theProviderIdentifier), currentHashCode, theProviderIdentifier, this.providerIdentifier != null);
        Reference theProviderReference = this.getProviderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "providerReference", theProviderReference), currentHashCode, theProviderReference, this.providerReference != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationIdentifier", theOrganizationIdentifier), currentHashCode, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationReference", theOrganizationReference), currentHashCode, theOrganizationReference, this.organizationReference != null);
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestIdentifier", theRequestIdentifier), currentHashCode, theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requestReference", theRequestReference), currentHashCode, theRequestReference, this.requestReference != null);
        Identifier theResponseIdentifier = this.getResponseIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "responseIdentifier", theResponseIdentifier), currentHashCode, theResponseIdentifier, this.responseIdentifier != null);
        Reference theResponseReference = this.getResponseReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "responseReference", theResponseReference), currentHashCode, theResponseReference, this.responseReference != null);
        Boolean theNullify = this.getNullify();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "nullify", theNullify), currentHashCode, theNullify, this.nullify != null);
        String theReference = this.getReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reference", theReference), currentHashCode, theReference, this.reference != null);
        List<ProcessRequestItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "item", theItem), currentHashCode, theItem, this.item != null && !this.item.isEmpty());
        List<String> theInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "include", theInclude), currentHashCode, theInclude, this.include != null && !this.include.isEmpty());
        List<String> theExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "exclude", theExclude), currentHashCode, theExclude, this.exclude != null && !this.exclude.isEmpty());
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "period", thePeriod), currentHashCode, thePeriod, this.period != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        ActionList theAction = this.getAction();
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        Identifier theTargetIdentifier = this.getTargetIdentifier();
        strategy.appendField(locator, (Object)this, "targetIdentifier", buffer, theTargetIdentifier, this.targetIdentifier != null);
        Reference theTargetReference = this.getTargetReference();
        strategy.appendField(locator, (Object)this, "targetReference", buffer, theTargetReference, this.targetReference != null);
        Identifier theProviderIdentifier = this.getProviderIdentifier();
        strategy.appendField(locator, (Object)this, "providerIdentifier", buffer, theProviderIdentifier, this.providerIdentifier != null);
        Reference theProviderReference = this.getProviderReference();
        strategy.appendField(locator, (Object)this, "providerReference", buffer, theProviderReference, this.providerReference != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "organizationIdentifier", buffer, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        strategy.appendField(locator, (Object)this, "organizationReference", buffer, theOrganizationReference, this.organizationReference != null);
        Identifier theRequestIdentifier = this.getRequestIdentifier();
        strategy.appendField(locator, (Object)this, "requestIdentifier", buffer, theRequestIdentifier, this.requestIdentifier != null);
        Reference theRequestReference = this.getRequestReference();
        strategy.appendField(locator, (Object)this, "requestReference", buffer, theRequestReference, this.requestReference != null);
        Identifier theResponseIdentifier = this.getResponseIdentifier();
        strategy.appendField(locator, (Object)this, "responseIdentifier", buffer, theResponseIdentifier, this.responseIdentifier != null);
        Reference theResponseReference = this.getResponseReference();
        strategy.appendField(locator, (Object)this, "responseReference", buffer, theResponseReference, this.responseReference != null);
        Boolean theNullify = this.getNullify();
        strategy.appendField(locator, (Object)this, "nullify", buffer, theNullify, this.nullify != null);
        String theReference = this.getReference();
        strategy.appendField(locator, (Object)this, "reference", buffer, theReference, this.reference != null);
        List<ProcessRequestItem> theItem = this.item != null && !this.item.isEmpty() ? this.getItem() : null;
        strategy.appendField(locator, (Object)this, "item", buffer, theItem, this.item != null && !this.item.isEmpty());
        List<String> theInclude = this.include != null && !this.include.isEmpty() ? this.getInclude() : null;
        strategy.appendField(locator, (Object)this, "include", buffer, theInclude, this.include != null && !this.include.isEmpty());
        List<String> theExclude = this.exclude != null && !this.exclude.isEmpty() ? this.getExclude() : null;
        strategy.appendField(locator, (Object)this, "exclude", buffer, theExclude, this.exclude != null && !this.exclude.isEmpty());
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, thePeriod, this.period != null);
        return buffer;
    }
}

