/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.ProcedureFocalDevice;
import org.hl7.fhir.ProcedurePerformer;
import org.hl7.fhir.ProcedureStatus;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Procedure", propOrder={"identifier", "subject", "status", "category", "code", "notPerformed", "reasonNotPerformed", "bodySite", "reasonCodeableConcept", "reasonReference", "performer", "performedDateTime", "performedPeriod", "encounter", "location", "outcome", "report", "complication", "followUp", "request", "notes", "focalDevice", "used"})
public class Procedure
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected ProcedureStatus status;
    protected CodeableConcept category;
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected Boolean notPerformed;
    protected List<CodeableConcept> reasonNotPerformed;
    protected List<CodeableConcept> bodySite;
    protected CodeableConcept reasonCodeableConcept;
    protected Reference reasonReference;
    protected List<ProcedurePerformer> performer;
    protected DateTime performedDateTime;
    protected Period performedPeriod;
    protected Reference encounter;
    protected Reference location;
    protected CodeableConcept outcome;
    protected List<Reference> report;
    protected List<CodeableConcept> complication;
    protected List<CodeableConcept> followUp;
    protected Reference request;
    protected List<Annotation> notes;
    protected List<ProcedureFocalDevice> focalDevice;
    protected List<Reference> used;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public ProcedureStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcedureStatus value) {
        this.status = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Boolean getNotPerformed() {
        return this.notPerformed;
    }

    public void setNotPerformed(Boolean value) {
        this.notPerformed = value;
    }

    public List<CodeableConcept> getReasonNotPerformed() {
        if (this.reasonNotPerformed == null) {
            this.reasonNotPerformed = new ArrayList<CodeableConcept>();
        }
        return this.reasonNotPerformed;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public CodeableConcept getReasonCodeableConcept() {
        return this.reasonCodeableConcept;
    }

    public void setReasonCodeableConcept(CodeableConcept value) {
        this.reasonCodeableConcept = value;
    }

    public Reference getReasonReference() {
        return this.reasonReference;
    }

    public void setReasonReference(Reference value) {
        this.reasonReference = value;
    }

    public List<ProcedurePerformer> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<ProcedurePerformer>();
        }
        return this.performer;
    }

    public DateTime getPerformedDateTime() {
        return this.performedDateTime;
    }

    public void setPerformedDateTime(DateTime value) {
        this.performedDateTime = value;
    }

    public Period getPerformedPeriod() {
        return this.performedPeriod;
    }

    public void setPerformedPeriod(Period value) {
        this.performedPeriod = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public CodeableConcept getOutcome() {
        return this.outcome;
    }

    public void setOutcome(CodeableConcept value) {
        this.outcome = value;
    }

    public List<Reference> getReport() {
        if (this.report == null) {
            this.report = new ArrayList<Reference>();
        }
        return this.report;
    }

    public List<CodeableConcept> getComplication() {
        if (this.complication == null) {
            this.complication = new ArrayList<CodeableConcept>();
        }
        return this.complication;
    }

    public List<CodeableConcept> getFollowUp() {
        if (this.followUp == null) {
            this.followUp = new ArrayList<CodeableConcept>();
        }
        return this.followUp;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public List<Annotation> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<Annotation>();
        }
        return this.notes;
    }

    public List<ProcedureFocalDevice> getFocalDevice() {
        if (this.focalDevice == null) {
            this.focalDevice = new ArrayList<ProcedureFocalDevice>();
        }
        return this.focalDevice;
    }

    public List<Reference> getUsed() {
        if (this.used == null) {
            this.used = new ArrayList<Reference>();
        }
        return this.used;
    }

    public Procedure withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Procedure withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Procedure withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Procedure withStatus(ProcedureStatus value) {
        this.setStatus(value);
        return this;
    }

    public Procedure withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public Procedure withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Procedure withNotPerformed(Boolean value) {
        this.setNotPerformed(value);
        return this;
    }

    public Procedure withReasonNotPerformed(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getReasonNotPerformed().add(value);
            }
        }
        return this;
    }

    public Procedure withReasonNotPerformed(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getReasonNotPerformed().addAll(values);
        }
        return this;
    }

    public Procedure withBodySite(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getBodySite().add(value);
            }
        }
        return this;
    }

    public Procedure withBodySite(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getBodySite().addAll(values);
        }
        return this;
    }

    public Procedure withReasonCodeableConcept(CodeableConcept value) {
        this.setReasonCodeableConcept(value);
        return this;
    }

    public Procedure withReasonReference(Reference value) {
        this.setReasonReference(value);
        return this;
    }

    public Procedure withPerformer(ProcedurePerformer ... values) {
        if (values != null) {
            for (ProcedurePerformer value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public Procedure withPerformer(Collection<ProcedurePerformer> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public Procedure withPerformedDateTime(DateTime value) {
        this.setPerformedDateTime(value);
        return this;
    }

    public Procedure withPerformedPeriod(Period value) {
        this.setPerformedPeriod(value);
        return this;
    }

    public Procedure withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Procedure withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Procedure withOutcome(CodeableConcept value) {
        this.setOutcome(value);
        return this;
    }

    public Procedure withReport(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getReport().add(value);
            }
        }
        return this;
    }

    public Procedure withReport(Collection<Reference> values) {
        if (values != null) {
            this.getReport().addAll(values);
        }
        return this;
    }

    public Procedure withComplication(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getComplication().add(value);
            }
        }
        return this;
    }

    public Procedure withComplication(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getComplication().addAll(values);
        }
        return this;
    }

    public Procedure withFollowUp(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getFollowUp().add(value);
            }
        }
        return this;
    }

    public Procedure withFollowUp(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getFollowUp().addAll(values);
        }
        return this;
    }

    public Procedure withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public Procedure withNotes(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNotes().add(value);
            }
        }
        return this;
    }

    public Procedure withNotes(Collection<Annotation> values) {
        if (values != null) {
            this.getNotes().addAll(values);
        }
        return this;
    }

    public Procedure withFocalDevice(ProcedureFocalDevice ... values) {
        if (values != null) {
            for (ProcedureFocalDevice value : values) {
                this.getFocalDevice().add(value);
            }
        }
        return this;
    }

    public Procedure withFocalDevice(Collection<ProcedureFocalDevice> values) {
        if (values != null) {
            this.getFocalDevice().addAll(values);
        }
        return this;
    }

    public Procedure withUsed(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getUsed().add(value);
            }
        }
        return this;
    }

    public Procedure withUsed(Collection<Reference> values) {
        if (values != null) {
            this.getUsed().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Procedure withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Procedure withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Procedure withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Procedure withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Procedure withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Procedure withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Procedure that = (Procedure)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        ProcedureStatus lhsStatus = this.getStatus();
        ProcedureStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Boolean lhsNotPerformed = this.getNotPerformed();
        Boolean rhsNotPerformed = that.getNotPerformed();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "notPerformed", lhsNotPerformed), (ObjectLocator)LocatorUtils.property(thatLocator, "notPerformed", rhsNotPerformed), lhsNotPerformed, rhsNotPerformed, this.notPerformed != null, that.notPerformed != null)) {
            return false;
        }
        List<CodeableConcept> lhsReasonNotPerformed = this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty() ? this.getReasonNotPerformed() : null;
        List<CodeableConcept> rhsReasonNotPerformed = that.reasonNotPerformed != null && !that.reasonNotPerformed.isEmpty() ? that.getReasonNotPerformed() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonNotPerformed", lhsReasonNotPerformed), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonNotPerformed", rhsReasonNotPerformed), lhsReasonNotPerformed, rhsReasonNotPerformed, this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty(), that.reasonNotPerformed != null && !that.reasonNotPerformed.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        List<CodeableConcept> rhsBodySite = that.bodySite != null && !that.bodySite.isEmpty() ? that.getBodySite() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property(thatLocator, "bodySite", rhsBodySite), lhsBodySite, rhsBodySite, this.bodySite != null && !this.bodySite.isEmpty(), that.bodySite != null && !that.bodySite.isEmpty())) {
            return false;
        }
        CodeableConcept lhsReasonCodeableConcept = this.getReasonCodeableConcept();
        CodeableConcept rhsReasonCodeableConcept = that.getReasonCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonCodeableConcept", lhsReasonCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonCodeableConcept", rhsReasonCodeableConcept), lhsReasonCodeableConcept, rhsReasonCodeableConcept, this.reasonCodeableConcept != null, that.reasonCodeableConcept != null)) {
            return false;
        }
        Reference lhsReasonReference = this.getReasonReference();
        Reference rhsReasonReference = that.getReasonReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reasonReference", lhsReasonReference), (ObjectLocator)LocatorUtils.property(thatLocator, "reasonReference", rhsReasonReference), lhsReasonReference, rhsReasonReference, this.reasonReference != null, that.reasonReference != null)) {
            return false;
        }
        List<ProcedurePerformer> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<ProcedurePerformer> rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null && !this.performer.isEmpty(), that.performer != null && !that.performer.isEmpty())) {
            return false;
        }
        DateTime lhsPerformedDateTime = this.getPerformedDateTime();
        DateTime rhsPerformedDateTime = that.getPerformedDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performedDateTime", lhsPerformedDateTime), (ObjectLocator)LocatorUtils.property(thatLocator, "performedDateTime", rhsPerformedDateTime), lhsPerformedDateTime, rhsPerformedDateTime, this.performedDateTime != null, that.performedDateTime != null)) {
            return false;
        }
        Period lhsPerformedPeriod = this.getPerformedPeriod();
        Period rhsPerformedPeriod = that.getPerformedPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performedPeriod", lhsPerformedPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "performedPeriod", rhsPerformedPeriod), lhsPerformedPeriod, rhsPerformedPeriod, this.performedPeriod != null, that.performedPeriod != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "location", lhsLocation), (ObjectLocator)LocatorUtils.property(thatLocator, "location", rhsLocation), lhsLocation, rhsLocation, this.location != null, that.location != null)) {
            return false;
        }
        CodeableConcept lhsOutcome = this.getOutcome();
        CodeableConcept rhsOutcome = that.getOutcome();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "outcome", lhsOutcome), (ObjectLocator)LocatorUtils.property(thatLocator, "outcome", rhsOutcome), lhsOutcome, rhsOutcome, this.outcome != null, that.outcome != null)) {
            return false;
        }
        List<Reference> lhsReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        List<Reference> rhsReport = that.report != null && !that.report.isEmpty() ? that.getReport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "report", lhsReport), (ObjectLocator)LocatorUtils.property(thatLocator, "report", rhsReport), lhsReport, rhsReport, this.report != null && !this.report.isEmpty(), that.report != null && !that.report.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        List<CodeableConcept> rhsComplication = that.complication != null && !that.complication.isEmpty() ? that.getComplication() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "complication", lhsComplication), (ObjectLocator)LocatorUtils.property(thatLocator, "complication", rhsComplication), lhsComplication, rhsComplication, this.complication != null && !this.complication.isEmpty(), that.complication != null && !that.complication.isEmpty())) {
            return false;
        }
        List<CodeableConcept> lhsFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        List<CodeableConcept> rhsFollowUp = that.followUp != null && !that.followUp.isEmpty() ? that.getFollowUp() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "followUp", lhsFollowUp), (ObjectLocator)LocatorUtils.property(thatLocator, "followUp", rhsFollowUp), lhsFollowUp, rhsFollowUp, this.followUp != null && !this.followUp.isEmpty(), that.followUp != null && !that.followUp.isEmpty())) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "request", lhsRequest), (ObjectLocator)LocatorUtils.property(thatLocator, "request", rhsRequest), lhsRequest, rhsRequest, this.request != null, that.request != null)) {
            return false;
        }
        List<Annotation> lhsNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        List<Annotation> rhsNotes = that.notes != null && !that.notes.isEmpty() ? that.getNotes() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "notes", lhsNotes), (ObjectLocator)LocatorUtils.property(thatLocator, "notes", rhsNotes), lhsNotes, rhsNotes, this.notes != null && !this.notes.isEmpty(), that.notes != null && !that.notes.isEmpty())) {
            return false;
        }
        List<ProcedureFocalDevice> lhsFocalDevice = this.focalDevice != null && !this.focalDevice.isEmpty() ? this.getFocalDevice() : null;
        List<ProcedureFocalDevice> rhsFocalDevice = that.focalDevice != null && !that.focalDevice.isEmpty() ? that.getFocalDevice() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "focalDevice", lhsFocalDevice), (ObjectLocator)LocatorUtils.property(thatLocator, "focalDevice", rhsFocalDevice), lhsFocalDevice, rhsFocalDevice, this.focalDevice != null && !this.focalDevice.isEmpty(), that.focalDevice != null && !that.focalDevice.isEmpty())) {
            return false;
        }
        List<Reference> lhsUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        List<Reference> rhsUsed = that.used != null && !that.used.isEmpty() ? that.getUsed() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "used", lhsUsed), (ObjectLocator)LocatorUtils.property(thatLocator, "used", rhsUsed), lhsUsed, rhsUsed, this.used != null && !this.used.isEmpty(), that.used != null && !that.used.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        ProcedureStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        Boolean theNotPerformed = this.getNotPerformed();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "notPerformed", theNotPerformed), currentHashCode, theNotPerformed, this.notPerformed != null);
        List<CodeableConcept> theReasonNotPerformed = this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty() ? this.getReasonNotPerformed() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonNotPerformed", theReasonNotPerformed), currentHashCode, theReasonNotPerformed, this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty());
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "bodySite", theBodySite), currentHashCode, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonCodeableConcept", theReasonCodeableConcept), currentHashCode, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reasonReference", theReasonReference), currentHashCode, theReasonReference, this.reasonReference != null);
        List<ProcedurePerformer> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null && !this.performer.isEmpty());
        DateTime thePerformedDateTime = this.getPerformedDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performedDateTime", thePerformedDateTime), currentHashCode, thePerformedDateTime, this.performedDateTime != null);
        Period thePerformedPeriod = this.getPerformedPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performedPeriod", thePerformedPeriod), currentHashCode, thePerformedPeriod, this.performedPeriod != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "location", theLocation), currentHashCode, theLocation, this.location != null);
        CodeableConcept theOutcome = this.getOutcome();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "outcome", theOutcome), currentHashCode, theOutcome, this.outcome != null);
        List<Reference> theReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "report", theReport), currentHashCode, theReport, this.report != null && !this.report.isEmpty());
        List<CodeableConcept> theComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "complication", theComplication), currentHashCode, theComplication, this.complication != null && !this.complication.isEmpty());
        List<CodeableConcept> theFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "followUp", theFollowUp), currentHashCode, theFollowUp, this.followUp != null && !this.followUp.isEmpty());
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "request", theRequest), currentHashCode, theRequest, this.request != null);
        List<Annotation> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "notes", theNotes), currentHashCode, theNotes, this.notes != null && !this.notes.isEmpty());
        List<ProcedureFocalDevice> theFocalDevice = this.focalDevice != null && !this.focalDevice.isEmpty() ? this.getFocalDevice() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "focalDevice", theFocalDevice), currentHashCode, theFocalDevice, this.focalDevice != null && !this.focalDevice.isEmpty());
        List<Reference> theUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "used", theUsed), currentHashCode, theUsed, this.used != null && !this.used.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        ProcedureStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        Boolean theNotPerformed = this.getNotPerformed();
        strategy.appendField(locator, (Object)this, "notPerformed", buffer, theNotPerformed, this.notPerformed != null);
        List<CodeableConcept> theReasonNotPerformed = this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty() ? this.getReasonNotPerformed() : null;
        strategy.appendField(locator, (Object)this, "reasonNotPerformed", buffer, theReasonNotPerformed, this.reasonNotPerformed != null && !this.reasonNotPerformed.isEmpty());
        List<CodeableConcept> theBodySite = this.bodySite != null && !this.bodySite.isEmpty() ? this.getBodySite() : null;
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite, this.bodySite != null && !this.bodySite.isEmpty());
        CodeableConcept theReasonCodeableConcept = this.getReasonCodeableConcept();
        strategy.appendField(locator, (Object)this, "reasonCodeableConcept", buffer, theReasonCodeableConcept, this.reasonCodeableConcept != null);
        Reference theReasonReference = this.getReasonReference();
        strategy.appendField(locator, (Object)this, "reasonReference", buffer, theReasonReference, this.reasonReference != null);
        List<ProcedurePerformer> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null && !this.performer.isEmpty());
        DateTime thePerformedDateTime = this.getPerformedDateTime();
        strategy.appendField(locator, (Object)this, "performedDateTime", buffer, thePerformedDateTime, this.performedDateTime != null);
        Period thePerformedPeriod = this.getPerformedPeriod();
        strategy.appendField(locator, (Object)this, "performedPeriod", buffer, thePerformedPeriod, this.performedPeriod != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null);
        CodeableConcept theOutcome = this.getOutcome();
        strategy.appendField(locator, (Object)this, "outcome", buffer, theOutcome, this.outcome != null);
        List<Reference> theReport = this.report != null && !this.report.isEmpty() ? this.getReport() : null;
        strategy.appendField(locator, (Object)this, "report", buffer, theReport, this.report != null && !this.report.isEmpty());
        List<CodeableConcept> theComplication = this.complication != null && !this.complication.isEmpty() ? this.getComplication() : null;
        strategy.appendField(locator, (Object)this, "complication", buffer, theComplication, this.complication != null && !this.complication.isEmpty());
        List<CodeableConcept> theFollowUp = this.followUp != null && !this.followUp.isEmpty() ? this.getFollowUp() : null;
        strategy.appendField(locator, (Object)this, "followUp", buffer, theFollowUp, this.followUp != null && !this.followUp.isEmpty());
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, theRequest, this.request != null);
        List<Annotation> theNotes = this.notes != null && !this.notes.isEmpty() ? this.getNotes() : null;
        strategy.appendField(locator, (Object)this, "notes", buffer, theNotes, this.notes != null && !this.notes.isEmpty());
        List<ProcedureFocalDevice> theFocalDevice = this.focalDevice != null && !this.focalDevice.isEmpty() ? this.getFocalDevice() : null;
        strategy.appendField(locator, (Object)this, "focalDevice", buffer, theFocalDevice, this.focalDevice != null && !this.focalDevice.isEmpty());
        List<Reference> theUsed = this.used != null && !this.used.isEmpty() ? this.getUsed() : null;
        strategy.appendField(locator, (Object)this, "used", buffer, theUsed, this.used != null && !this.used.isEmpty());
        return buffer;
    }
}

