/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Instant;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ObservationComponent;
import org.hl7.fhir.ObservationReferenceRange;
import org.hl7.fhir.ObservationRelated;
import org.hl7.fhir.ObservationStatus;
import org.hl7.fhir.Period;
import org.hl7.fhir.Quantity;
import org.hl7.fhir.Range;
import org.hl7.fhir.Ratio;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SampledData;
import org.hl7.fhir.String;
import org.hl7.fhir.Time;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Observation", propOrder={"identifier", "status", "category", "code", "subject", "encounter", "effectiveDateTime", "effectivePeriod", "issued", "performer", "valueQuantity", "valueCodeableConcept", "valueString", "valueRange", "valueRatio", "valueSampledData", "valueAttachment", "valueTime", "valueDateTime", "valuePeriod", "dataAbsentReason", "interpretation", "comment", "bodySite", "method", "specimen", "device", "referenceRange", "related", "component"})
public class Observation
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected ObservationStatus status;
    protected CodeableConcept category;
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected Reference subject;
    protected Reference encounter;
    protected DateTime effectiveDateTime;
    protected Period effectivePeriod;
    protected Instant issued;
    protected List<Reference> performer;
    protected Quantity valueQuantity;
    protected CodeableConcept valueCodeableConcept;
    protected String valueString;
    protected Range valueRange;
    protected Ratio valueRatio;
    protected SampledData valueSampledData;
    protected Attachment valueAttachment;
    protected Time valueTime;
    protected DateTime valueDateTime;
    protected Period valuePeriod;
    protected CodeableConcept dataAbsentReason;
    protected CodeableConcept interpretation;
    protected String comment;
    protected CodeableConcept bodySite;
    protected CodeableConcept method;
    protected Reference specimen;
    protected Reference device;
    protected List<ObservationReferenceRange> referenceRange;
    protected List<ObservationRelated> related;
    protected List<ObservationComponent> component;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ObservationStatus getStatus() {
        return this.status;
    }

    public void setStatus(ObservationStatus value) {
        this.status = value;
    }

    public CodeableConcept getCategory() {
        return this.category;
    }

    public void setCategory(CodeableConcept value) {
        this.category = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public DateTime getEffectiveDateTime() {
        return this.effectiveDateTime;
    }

    public void setEffectiveDateTime(DateTime value) {
        this.effectiveDateTime = value;
    }

    public Period getEffectivePeriod() {
        return this.effectivePeriod;
    }

    public void setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public void setIssued(Instant value) {
        this.issued = value;
    }

    public List<Reference> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<Reference>();
        }
        return this.performer;
    }

    public Quantity getValueQuantity() {
        return this.valueQuantity;
    }

    public void setValueQuantity(Quantity value) {
        this.valueQuantity = value;
    }

    public CodeableConcept getValueCodeableConcept() {
        return this.valueCodeableConcept;
    }

    public void setValueCodeableConcept(CodeableConcept value) {
        this.valueCodeableConcept = value;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String value) {
        this.valueString = value;
    }

    public Range getValueRange() {
        return this.valueRange;
    }

    public void setValueRange(Range value) {
        this.valueRange = value;
    }

    public Ratio getValueRatio() {
        return this.valueRatio;
    }

    public void setValueRatio(Ratio value) {
        this.valueRatio = value;
    }

    public SampledData getValueSampledData() {
        return this.valueSampledData;
    }

    public void setValueSampledData(SampledData value) {
        this.valueSampledData = value;
    }

    public Attachment getValueAttachment() {
        return this.valueAttachment;
    }

    public void setValueAttachment(Attachment value) {
        this.valueAttachment = value;
    }

    public Time getValueTime() {
        return this.valueTime;
    }

    public void setValueTime(Time value) {
        this.valueTime = value;
    }

    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime value) {
        this.valueDateTime = value;
    }

    public Period getValuePeriod() {
        return this.valuePeriod;
    }

    public void setValuePeriod(Period value) {
        this.valuePeriod = value;
    }

    public CodeableConcept getDataAbsentReason() {
        return this.dataAbsentReason;
    }

    public void setDataAbsentReason(CodeableConcept value) {
        this.dataAbsentReason = value;
    }

    public CodeableConcept getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(CodeableConcept value) {
        this.interpretation = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public void setBodySite(CodeableConcept value) {
        this.bodySite = value;
    }

    public CodeableConcept getMethod() {
        return this.method;
    }

    public void setMethod(CodeableConcept value) {
        this.method = value;
    }

    public Reference getSpecimen() {
        return this.specimen;
    }

    public void setSpecimen(Reference value) {
        this.specimen = value;
    }

    public Reference getDevice() {
        return this.device;
    }

    public void setDevice(Reference value) {
        this.device = value;
    }

    public List<ObservationReferenceRange> getReferenceRange() {
        if (this.referenceRange == null) {
            this.referenceRange = new ArrayList<ObservationReferenceRange>();
        }
        return this.referenceRange;
    }

    public List<ObservationRelated> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<ObservationRelated>();
        }
        return this.related;
    }

    public List<ObservationComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<ObservationComponent>();
        }
        return this.component;
    }

    public Observation withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Observation withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Observation withStatus(ObservationStatus value) {
        this.setStatus(value);
        return this;
    }

    public Observation withCategory(CodeableConcept value) {
        this.setCategory(value);
        return this;
    }

    public Observation withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public Observation withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Observation withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Observation withEffectiveDateTime(DateTime value) {
        this.setEffectiveDateTime(value);
        return this;
    }

    public Observation withEffectivePeriod(Period value) {
        this.setEffectivePeriod(value);
        return this;
    }

    public Observation withIssued(Instant value) {
        this.setIssued(value);
        return this;
    }

    public Observation withPerformer(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getPerformer().add(value);
            }
        }
        return this;
    }

    public Observation withPerformer(Collection<Reference> values) {
        if (values != null) {
            this.getPerformer().addAll(values);
        }
        return this;
    }

    public Observation withValueQuantity(Quantity value) {
        this.setValueQuantity(value);
        return this;
    }

    public Observation withValueCodeableConcept(CodeableConcept value) {
        this.setValueCodeableConcept(value);
        return this;
    }

    public Observation withValueString(String value) {
        this.setValueString(value);
        return this;
    }

    public Observation withValueRange(Range value) {
        this.setValueRange(value);
        return this;
    }

    public Observation withValueRatio(Ratio value) {
        this.setValueRatio(value);
        return this;
    }

    public Observation withValueSampledData(SampledData value) {
        this.setValueSampledData(value);
        return this;
    }

    public Observation withValueAttachment(Attachment value) {
        this.setValueAttachment(value);
        return this;
    }

    public Observation withValueTime(Time value) {
        this.setValueTime(value);
        return this;
    }

    public Observation withValueDateTime(DateTime value) {
        this.setValueDateTime(value);
        return this;
    }

    public Observation withValuePeriod(Period value) {
        this.setValuePeriod(value);
        return this;
    }

    public Observation withDataAbsentReason(CodeableConcept value) {
        this.setDataAbsentReason(value);
        return this;
    }

    public Observation withInterpretation(CodeableConcept value) {
        this.setInterpretation(value);
        return this;
    }

    public Observation withComment(String value) {
        this.setComment(value);
        return this;
    }

    public Observation withBodySite(CodeableConcept value) {
        this.setBodySite(value);
        return this;
    }

    public Observation withMethod(CodeableConcept value) {
        this.setMethod(value);
        return this;
    }

    public Observation withSpecimen(Reference value) {
        this.setSpecimen(value);
        return this;
    }

    public Observation withDevice(Reference value) {
        this.setDevice(value);
        return this;
    }

    public Observation withReferenceRange(ObservationReferenceRange ... values) {
        if (values != null) {
            for (ObservationReferenceRange value : values) {
                this.getReferenceRange().add(value);
            }
        }
        return this;
    }

    public Observation withReferenceRange(Collection<ObservationReferenceRange> values) {
        if (values != null) {
            this.getReferenceRange().addAll(values);
        }
        return this;
    }

    public Observation withRelated(ObservationRelated ... values) {
        if (values != null) {
            for (ObservationRelated value : values) {
                this.getRelated().add(value);
            }
        }
        return this;
    }

    public Observation withRelated(Collection<ObservationRelated> values) {
        if (values != null) {
            this.getRelated().addAll(values);
        }
        return this;
    }

    public Observation withComponent(ObservationComponent ... values) {
        if (values != null) {
            for (ObservationComponent value : values) {
                this.getComponent().add(value);
            }
        }
        return this;
    }

    public Observation withComponent(Collection<ObservationComponent> values) {
        if (values != null) {
            this.getComponent().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Observation withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Observation withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Observation withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Observation withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Observation withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Observation withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Observation that = (Observation)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        ObservationStatus lhsStatus = this.getStatus();
        ObservationStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        CodeableConcept lhsCategory = this.getCategory();
        CodeableConcept rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        DateTime lhsEffectiveDateTime = this.getEffectiveDateTime();
        DateTime rhsEffectiveDateTime = that.getEffectiveDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "effectiveDateTime", lhsEffectiveDateTime), (ObjectLocator)LocatorUtils.property(thatLocator, "effectiveDateTime", rhsEffectiveDateTime), lhsEffectiveDateTime, rhsEffectiveDateTime, this.effectiveDateTime != null, that.effectiveDateTime != null)) {
            return false;
        }
        Period lhsEffectivePeriod = this.getEffectivePeriod();
        Period rhsEffectivePeriod = that.getEffectivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "effectivePeriod", lhsEffectivePeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "effectivePeriod", rhsEffectivePeriod), lhsEffectivePeriod, rhsEffectivePeriod, this.effectivePeriod != null, that.effectivePeriod != null)) {
            return false;
        }
        Instant lhsIssued = this.getIssued();
        Instant rhsIssued = that.getIssued();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "issued", lhsIssued), (ObjectLocator)LocatorUtils.property(thatLocator, "issued", rhsIssued), lhsIssued, rhsIssued, this.issued != null, that.issued != null)) {
            return false;
        }
        List<Reference> lhsPerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        List<Reference> rhsPerformer = that.performer != null && !that.performer.isEmpty() ? that.getPerformer() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null && !this.performer.isEmpty(), that.performer != null && !that.performer.isEmpty())) {
            return false;
        }
        Quantity lhsValueQuantity = this.getValueQuantity();
        Quantity rhsValueQuantity = that.getValueQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueQuantity", lhsValueQuantity), (ObjectLocator)LocatorUtils.property(thatLocator, "valueQuantity", rhsValueQuantity), lhsValueQuantity, rhsValueQuantity, this.valueQuantity != null, that.valueQuantity != null)) {
            return false;
        }
        CodeableConcept lhsValueCodeableConcept = this.getValueCodeableConcept();
        CodeableConcept rhsValueCodeableConcept = that.getValueCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueCodeableConcept", lhsValueCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "valueCodeableConcept", rhsValueCodeableConcept), lhsValueCodeableConcept, rhsValueCodeableConcept, this.valueCodeableConcept != null, that.valueCodeableConcept != null)) {
            return false;
        }
        String lhsValueString = this.getValueString();
        String rhsValueString = that.getValueString();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueString", lhsValueString), (ObjectLocator)LocatorUtils.property(thatLocator, "valueString", rhsValueString), lhsValueString, rhsValueString, this.valueString != null, that.valueString != null)) {
            return false;
        }
        Range lhsValueRange = this.getValueRange();
        Range rhsValueRange = that.getValueRange();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueRange", lhsValueRange), (ObjectLocator)LocatorUtils.property(thatLocator, "valueRange", rhsValueRange), lhsValueRange, rhsValueRange, this.valueRange != null, that.valueRange != null)) {
            return false;
        }
        Ratio lhsValueRatio = this.getValueRatio();
        Ratio rhsValueRatio = that.getValueRatio();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueRatio", lhsValueRatio), (ObjectLocator)LocatorUtils.property(thatLocator, "valueRatio", rhsValueRatio), lhsValueRatio, rhsValueRatio, this.valueRatio != null, that.valueRatio != null)) {
            return false;
        }
        SampledData lhsValueSampledData = this.getValueSampledData();
        SampledData rhsValueSampledData = that.getValueSampledData();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueSampledData", lhsValueSampledData), (ObjectLocator)LocatorUtils.property(thatLocator, "valueSampledData", rhsValueSampledData), lhsValueSampledData, rhsValueSampledData, this.valueSampledData != null, that.valueSampledData != null)) {
            return false;
        }
        Attachment lhsValueAttachment = this.getValueAttachment();
        Attachment rhsValueAttachment = that.getValueAttachment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueAttachment", lhsValueAttachment), (ObjectLocator)LocatorUtils.property(thatLocator, "valueAttachment", rhsValueAttachment), lhsValueAttachment, rhsValueAttachment, this.valueAttachment != null, that.valueAttachment != null)) {
            return false;
        }
        Time lhsValueTime = this.getValueTime();
        Time rhsValueTime = that.getValueTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueTime", lhsValueTime), (ObjectLocator)LocatorUtils.property(thatLocator, "valueTime", rhsValueTime), lhsValueTime, rhsValueTime, this.valueTime != null, that.valueTime != null)) {
            return false;
        }
        DateTime lhsValueDateTime = this.getValueDateTime();
        DateTime rhsValueDateTime = that.getValueDateTime();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valueDateTime", lhsValueDateTime), (ObjectLocator)LocatorUtils.property(thatLocator, "valueDateTime", rhsValueDateTime), lhsValueDateTime, rhsValueDateTime, this.valueDateTime != null, that.valueDateTime != null)) {
            return false;
        }
        Period lhsValuePeriod = this.getValuePeriod();
        Period rhsValuePeriod = that.getValuePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "valuePeriod", lhsValuePeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "valuePeriod", rhsValuePeriod), lhsValuePeriod, rhsValuePeriod, this.valuePeriod != null, that.valuePeriod != null)) {
            return false;
        }
        CodeableConcept lhsDataAbsentReason = this.getDataAbsentReason();
        CodeableConcept rhsDataAbsentReason = that.getDataAbsentReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dataAbsentReason", lhsDataAbsentReason), (ObjectLocator)LocatorUtils.property(thatLocator, "dataAbsentReason", rhsDataAbsentReason), lhsDataAbsentReason, rhsDataAbsentReason, this.dataAbsentReason != null, that.dataAbsentReason != null)) {
            return false;
        }
        CodeableConcept lhsInterpretation = this.getInterpretation();
        CodeableConcept rhsInterpretation = that.getInterpretation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "interpretation", lhsInterpretation), (ObjectLocator)LocatorUtils.property(thatLocator, "interpretation", rhsInterpretation), lhsInterpretation, rhsInterpretation, this.interpretation != null, that.interpretation != null)) {
            return false;
        }
        String lhsComment = this.getComment();
        String rhsComment = that.getComment();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "comment", lhsComment), (ObjectLocator)LocatorUtils.property(thatLocator, "comment", rhsComment), lhsComment, rhsComment, this.comment != null, that.comment != null)) {
            return false;
        }
        CodeableConcept lhsBodySite = this.getBodySite();
        CodeableConcept rhsBodySite = that.getBodySite();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property(thatLocator, "bodySite", rhsBodySite), lhsBodySite, rhsBodySite, this.bodySite != null, that.bodySite != null)) {
            return false;
        }
        CodeableConcept lhsMethod = this.getMethod();
        CodeableConcept rhsMethod = that.getMethod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "method", lhsMethod), (ObjectLocator)LocatorUtils.property(thatLocator, "method", rhsMethod), lhsMethod, rhsMethod, this.method != null, that.method != null)) {
            return false;
        }
        Reference lhsSpecimen = this.getSpecimen();
        Reference rhsSpecimen = that.getSpecimen();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specimen", lhsSpecimen), (ObjectLocator)LocatorUtils.property(thatLocator, "specimen", rhsSpecimen), lhsSpecimen, rhsSpecimen, this.specimen != null, that.specimen != null)) {
            return false;
        }
        Reference lhsDevice = this.getDevice();
        Reference rhsDevice = that.getDevice();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "device", lhsDevice), (ObjectLocator)LocatorUtils.property(thatLocator, "device", rhsDevice), lhsDevice, rhsDevice, this.device != null, that.device != null)) {
            return false;
        }
        List<ObservationReferenceRange> lhsReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        List<ObservationReferenceRange> rhsReferenceRange = that.referenceRange != null && !that.referenceRange.isEmpty() ? that.getReferenceRange() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "referenceRange", lhsReferenceRange), (ObjectLocator)LocatorUtils.property(thatLocator, "referenceRange", rhsReferenceRange), lhsReferenceRange, rhsReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty(), that.referenceRange != null && !that.referenceRange.isEmpty())) {
            return false;
        }
        List<ObservationRelated> lhsRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        List<ObservationRelated> rhsRelated = that.related != null && !that.related.isEmpty() ? that.getRelated() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "related", lhsRelated), (ObjectLocator)LocatorUtils.property(thatLocator, "related", rhsRelated), lhsRelated, rhsRelated, this.related != null && !this.related.isEmpty(), that.related != null && !that.related.isEmpty())) {
            return false;
        }
        List<ObservationComponent> lhsComponent = this.component != null && !this.component.isEmpty() ? this.getComponent() : null;
        List<ObservationComponent> rhsComponent = that.component != null && !that.component.isEmpty() ? that.getComponent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "component", lhsComponent), (ObjectLocator)LocatorUtils.property(thatLocator, "component", rhsComponent), lhsComponent, rhsComponent, this.component != null && !this.component.isEmpty(), that.component != null && !that.component.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        ObservationStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        CodeableConcept theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "effectiveDateTime", theEffectiveDateTime), currentHashCode, theEffectiveDateTime, this.effectiveDateTime != null);
        Period theEffectivePeriod = this.getEffectivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "effectivePeriod", theEffectivePeriod), currentHashCode, theEffectivePeriod, this.effectivePeriod != null);
        Instant theIssued = this.getIssued();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "issued", theIssued), currentHashCode, theIssued, this.issued != null);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null && !this.performer.isEmpty());
        Quantity theValueQuantity = this.getValueQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueQuantity", theValueQuantity), currentHashCode, theValueQuantity, this.valueQuantity != null);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueCodeableConcept", theValueCodeableConcept), currentHashCode, theValueCodeableConcept, this.valueCodeableConcept != null);
        String theValueString = this.getValueString();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueString", theValueString), currentHashCode, theValueString, this.valueString != null);
        Range theValueRange = this.getValueRange();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueRange", theValueRange), currentHashCode, theValueRange, this.valueRange != null);
        Ratio theValueRatio = this.getValueRatio();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueRatio", theValueRatio), currentHashCode, theValueRatio, this.valueRatio != null);
        SampledData theValueSampledData = this.getValueSampledData();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueSampledData", theValueSampledData), currentHashCode, theValueSampledData, this.valueSampledData != null);
        Attachment theValueAttachment = this.getValueAttachment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueAttachment", theValueAttachment), currentHashCode, theValueAttachment, this.valueAttachment != null);
        Time theValueTime = this.getValueTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueTime", theValueTime), currentHashCode, theValueTime, this.valueTime != null);
        DateTime theValueDateTime = this.getValueDateTime();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valueDateTime", theValueDateTime), currentHashCode, theValueDateTime, this.valueDateTime != null);
        Period theValuePeriod = this.getValuePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "valuePeriod", theValuePeriod), currentHashCode, theValuePeriod, this.valuePeriod != null);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dataAbsentReason", theDataAbsentReason), currentHashCode, theDataAbsentReason, this.dataAbsentReason != null);
        CodeableConcept theInterpretation = this.getInterpretation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "interpretation", theInterpretation), currentHashCode, theInterpretation, this.interpretation != null);
        String theComment = this.getComment();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "comment", theComment), currentHashCode, theComment, this.comment != null);
        CodeableConcept theBodySite = this.getBodySite();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "bodySite", theBodySite), currentHashCode, theBodySite, this.bodySite != null);
        CodeableConcept theMethod = this.getMethod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "method", theMethod), currentHashCode, theMethod, this.method != null);
        Reference theSpecimen = this.getSpecimen();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specimen", theSpecimen), currentHashCode, theSpecimen, this.specimen != null);
        Reference theDevice = this.getDevice();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "device", theDevice), currentHashCode, theDevice, this.device != null);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "referenceRange", theReferenceRange), currentHashCode, theReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty());
        List<ObservationRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "related", theRelated), currentHashCode, theRelated, this.related != null && !this.related.isEmpty());
        List<ObservationComponent> theComponent = this.component != null && !this.component.isEmpty() ? this.getComponent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "component", theComponent), currentHashCode, theComponent, this.component != null && !this.component.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        ObservationStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        CodeableConcept theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        DateTime theEffectiveDateTime = this.getEffectiveDateTime();
        strategy.appendField(locator, (Object)this, "effectiveDateTime", buffer, theEffectiveDateTime, this.effectiveDateTime != null);
        Period theEffectivePeriod = this.getEffectivePeriod();
        strategy.appendField(locator, (Object)this, "effectivePeriod", buffer, theEffectivePeriod, this.effectivePeriod != null);
        Instant theIssued = this.getIssued();
        strategy.appendField(locator, (Object)this, "issued", buffer, theIssued, this.issued != null);
        List<Reference> thePerformer = this.performer != null && !this.performer.isEmpty() ? this.getPerformer() : null;
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null && !this.performer.isEmpty());
        Quantity theValueQuantity = this.getValueQuantity();
        strategy.appendField(locator, (Object)this, "valueQuantity", buffer, theValueQuantity, this.valueQuantity != null);
        CodeableConcept theValueCodeableConcept = this.getValueCodeableConcept();
        strategy.appendField(locator, (Object)this, "valueCodeableConcept", buffer, theValueCodeableConcept, this.valueCodeableConcept != null);
        String theValueString = this.getValueString();
        strategy.appendField(locator, (Object)this, "valueString", buffer, theValueString, this.valueString != null);
        Range theValueRange = this.getValueRange();
        strategy.appendField(locator, (Object)this, "valueRange", buffer, theValueRange, this.valueRange != null);
        Ratio theValueRatio = this.getValueRatio();
        strategy.appendField(locator, (Object)this, "valueRatio", buffer, theValueRatio, this.valueRatio != null);
        SampledData theValueSampledData = this.getValueSampledData();
        strategy.appendField(locator, (Object)this, "valueSampledData", buffer, theValueSampledData, this.valueSampledData != null);
        Attachment theValueAttachment = this.getValueAttachment();
        strategy.appendField(locator, (Object)this, "valueAttachment", buffer, theValueAttachment, this.valueAttachment != null);
        Time theValueTime = this.getValueTime();
        strategy.appendField(locator, (Object)this, "valueTime", buffer, theValueTime, this.valueTime != null);
        DateTime theValueDateTime = this.getValueDateTime();
        strategy.appendField(locator, (Object)this, "valueDateTime", buffer, theValueDateTime, this.valueDateTime != null);
        Period theValuePeriod = this.getValuePeriod();
        strategy.appendField(locator, (Object)this, "valuePeriod", buffer, theValuePeriod, this.valuePeriod != null);
        CodeableConcept theDataAbsentReason = this.getDataAbsentReason();
        strategy.appendField(locator, (Object)this, "dataAbsentReason", buffer, theDataAbsentReason, this.dataAbsentReason != null);
        CodeableConcept theInterpretation = this.getInterpretation();
        strategy.appendField(locator, (Object)this, "interpretation", buffer, theInterpretation, this.interpretation != null);
        String theComment = this.getComment();
        strategy.appendField(locator, (Object)this, "comment", buffer, theComment, this.comment != null);
        CodeableConcept theBodySite = this.getBodySite();
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite, this.bodySite != null);
        CodeableConcept theMethod = this.getMethod();
        strategy.appendField(locator, (Object)this, "method", buffer, theMethod, this.method != null);
        Reference theSpecimen = this.getSpecimen();
        strategy.appendField(locator, (Object)this, "specimen", buffer, theSpecimen, this.specimen != null);
        Reference theDevice = this.getDevice();
        strategy.appendField(locator, (Object)this, "device", buffer, theDevice, this.device != null);
        List<ObservationReferenceRange> theReferenceRange = this.referenceRange != null && !this.referenceRange.isEmpty() ? this.getReferenceRange() : null;
        strategy.appendField(locator, (Object)this, "referenceRange", buffer, theReferenceRange, this.referenceRange != null && !this.referenceRange.isEmpty());
        List<ObservationRelated> theRelated = this.related != null && !this.related.isEmpty() ? this.getRelated() : null;
        strategy.appendField(locator, (Object)this, "related", buffer, theRelated, this.related != null && !this.related.isEmpty());
        List<ObservationComponent> theComponent = this.component != null && !this.component.isEmpty() ? this.getComponent() : null;
        strategy.appendField(locator, (Object)this, "component", buffer, theComponent, this.component != null && !this.component.isEmpty());
        return buffer;
    }
}

