/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ModuleDefinitionCodeFilter;
import org.hl7.fhir.ModuleDefinitionDateFilter;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ModuleDefinition.Data", propOrder={"type", "profile", "mustSupport", "codeFilter", "dateFilter"})
public class ModuleDefinitionData
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Code type;
    protected Reference profile;
    protected List<String> mustSupport;
    protected List<ModuleDefinitionCodeFilter> codeFilter;
    protected List<ModuleDefinitionDateFilter> dateFilter;

    public Code getType() {
        return this.type;
    }

    public void setType(Code value) {
        this.type = value;
    }

    public Reference getProfile() {
        return this.profile;
    }

    public void setProfile(Reference value) {
        this.profile = value;
    }

    public List<String> getMustSupport() {
        if (this.mustSupport == null) {
            this.mustSupport = new ArrayList<String>();
        }
        return this.mustSupport;
    }

    public List<ModuleDefinitionCodeFilter> getCodeFilter() {
        if (this.codeFilter == null) {
            this.codeFilter = new ArrayList<ModuleDefinitionCodeFilter>();
        }
        return this.codeFilter;
    }

    public List<ModuleDefinitionDateFilter> getDateFilter() {
        if (this.dateFilter == null) {
            this.dateFilter = new ArrayList<ModuleDefinitionDateFilter>();
        }
        return this.dateFilter;
    }

    public ModuleDefinitionData withType(Code value) {
        this.setType(value);
        return this;
    }

    public ModuleDefinitionData withProfile(Reference value) {
        this.setProfile(value);
        return this;
    }

    public ModuleDefinitionData withMustSupport(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getMustSupport().add(value);
            }
        }
        return this;
    }

    public ModuleDefinitionData withMustSupport(Collection<String> values) {
        if (values != null) {
            this.getMustSupport().addAll(values);
        }
        return this;
    }

    public ModuleDefinitionData withCodeFilter(ModuleDefinitionCodeFilter ... values) {
        if (values != null) {
            for (ModuleDefinitionCodeFilter value : values) {
                this.getCodeFilter().add(value);
            }
        }
        return this;
    }

    public ModuleDefinitionData withCodeFilter(Collection<ModuleDefinitionCodeFilter> values) {
        if (values != null) {
            this.getCodeFilter().addAll(values);
        }
        return this;
    }

    public ModuleDefinitionData withDateFilter(ModuleDefinitionDateFilter ... values) {
        if (values != null) {
            for (ModuleDefinitionDateFilter value : values) {
                this.getDateFilter().add(value);
            }
        }
        return this;
    }

    public ModuleDefinitionData withDateFilter(Collection<ModuleDefinitionDateFilter> values) {
        if (values != null) {
            this.getDateFilter().addAll(values);
        }
        return this;
    }

    @Override
    public ModuleDefinitionData withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ModuleDefinitionData withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ModuleDefinitionData withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ModuleDefinitionData withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ModuleDefinitionData withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ModuleDefinitionData that = (ModuleDefinitionData)object;
        Code lhsType = this.getType();
        Code rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        Reference lhsProfile = this.getProfile();
        Reference rhsProfile = that.getProfile();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "profile", lhsProfile), (ObjectLocator)LocatorUtils.property(thatLocator, "profile", rhsProfile), lhsProfile, rhsProfile, this.profile != null, that.profile != null)) {
            return false;
        }
        List<String> lhsMustSupport = this.mustSupport != null && !this.mustSupport.isEmpty() ? this.getMustSupport() : null;
        List<String> rhsMustSupport = that.mustSupport != null && !that.mustSupport.isEmpty() ? that.getMustSupport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "mustSupport", lhsMustSupport), (ObjectLocator)LocatorUtils.property(thatLocator, "mustSupport", rhsMustSupport), lhsMustSupport, rhsMustSupport, this.mustSupport != null && !this.mustSupport.isEmpty(), that.mustSupport != null && !that.mustSupport.isEmpty())) {
            return false;
        }
        List<ModuleDefinitionCodeFilter> lhsCodeFilter = this.codeFilter != null && !this.codeFilter.isEmpty() ? this.getCodeFilter() : null;
        List<ModuleDefinitionCodeFilter> rhsCodeFilter = that.codeFilter != null && !that.codeFilter.isEmpty() ? that.getCodeFilter() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "codeFilter", lhsCodeFilter), (ObjectLocator)LocatorUtils.property(thatLocator, "codeFilter", rhsCodeFilter), lhsCodeFilter, rhsCodeFilter, this.codeFilter != null && !this.codeFilter.isEmpty(), that.codeFilter != null && !that.codeFilter.isEmpty())) {
            return false;
        }
        List<ModuleDefinitionDateFilter> lhsDateFilter = this.dateFilter != null && !this.dateFilter.isEmpty() ? this.getDateFilter() : null;
        List<ModuleDefinitionDateFilter> rhsDateFilter = that.dateFilter != null && !that.dateFilter.isEmpty() ? that.getDateFilter() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "dateFilter", lhsDateFilter), (ObjectLocator)LocatorUtils.property(thatLocator, "dateFilter", rhsDateFilter), lhsDateFilter, rhsDateFilter, this.dateFilter != null && !this.dateFilter.isEmpty(), that.dateFilter != null && !that.dateFilter.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Code theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        Reference theProfile = this.getProfile();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "profile", theProfile), currentHashCode, theProfile, this.profile != null);
        List<String> theMustSupport = this.mustSupport != null && !this.mustSupport.isEmpty() ? this.getMustSupport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "mustSupport", theMustSupport), currentHashCode, theMustSupport, this.mustSupport != null && !this.mustSupport.isEmpty());
        List<ModuleDefinitionCodeFilter> theCodeFilter = this.codeFilter != null && !this.codeFilter.isEmpty() ? this.getCodeFilter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "codeFilter", theCodeFilter), currentHashCode, theCodeFilter, this.codeFilter != null && !this.codeFilter.isEmpty());
        List<ModuleDefinitionDateFilter> theDateFilter = this.dateFilter != null && !this.dateFilter.isEmpty() ? this.getDateFilter() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "dateFilter", theDateFilter), currentHashCode, theDateFilter, this.dateFilter != null && !this.dateFilter.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Code theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        Reference theProfile = this.getProfile();
        strategy.appendField(locator, (Object)this, "profile", buffer, theProfile, this.profile != null);
        List<String> theMustSupport = this.mustSupport != null && !this.mustSupport.isEmpty() ? this.getMustSupport() : null;
        strategy.appendField(locator, (Object)this, "mustSupport", buffer, theMustSupport, this.mustSupport != null && !this.mustSupport.isEmpty());
        List<ModuleDefinitionCodeFilter> theCodeFilter = this.codeFilter != null && !this.codeFilter.isEmpty() ? this.getCodeFilter() : null;
        strategy.appendField(locator, (Object)this, "codeFilter", buffer, theCodeFilter, this.codeFilter != null && !this.codeFilter.isEmpty());
        List<ModuleDefinitionDateFilter> theDateFilter = this.dateFilter != null && !this.dateFilter.isEmpty() ? this.getDateFilter() : null;
        strategy.appendField(locator, (Object)this, "dateFilter", buffer, theDateFilter, this.dateFilter != null && !this.dateFilter.isEmpty());
        return buffer;
    }
}

