/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.PositiveInt;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Immunization.VaccinationProtocol", propOrder={"doseSequence", "description", "authority", "series", "seriesDoses", "targetDisease", "doseStatus", "doseStatusReason"})
public class ImmunizationVaccinationProtocol
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected PositiveInt doseSequence;
    protected String description;
    protected Reference authority;
    protected String series;
    protected PositiveInt seriesDoses;
    @XmlElement(required=true)
    protected List<CodeableConcept> targetDisease;
    @XmlElement(required=true)
    protected CodeableConcept doseStatus;
    protected CodeableConcept doseStatusReason;

    public PositiveInt getDoseSequence() {
        return this.doseSequence;
    }

    public void setDoseSequence(PositiveInt value) {
        this.doseSequence = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Reference getAuthority() {
        return this.authority;
    }

    public void setAuthority(Reference value) {
        this.authority = value;
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String value) {
        this.series = value;
    }

    public PositiveInt getSeriesDoses() {
        return this.seriesDoses;
    }

    public void setSeriesDoses(PositiveInt value) {
        this.seriesDoses = value;
    }

    public List<CodeableConcept> getTargetDisease() {
        if (this.targetDisease == null) {
            this.targetDisease = new ArrayList<CodeableConcept>();
        }
        return this.targetDisease;
    }

    public CodeableConcept getDoseStatus() {
        return this.doseStatus;
    }

    public void setDoseStatus(CodeableConcept value) {
        this.doseStatus = value;
    }

    public CodeableConcept getDoseStatusReason() {
        return this.doseStatusReason;
    }

    public void setDoseStatusReason(CodeableConcept value) {
        this.doseStatusReason = value;
    }

    public ImmunizationVaccinationProtocol withDoseSequence(PositiveInt value) {
        this.setDoseSequence(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withAuthority(Reference value) {
        this.setAuthority(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withSeries(String value) {
        this.setSeries(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withSeriesDoses(PositiveInt value) {
        this.setSeriesDoses(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withTargetDisease(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getTargetDisease().add(value);
            }
        }
        return this;
    }

    public ImmunizationVaccinationProtocol withTargetDisease(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getTargetDisease().addAll(values);
        }
        return this;
    }

    public ImmunizationVaccinationProtocol withDoseStatus(CodeableConcept value) {
        this.setDoseStatus(value);
        return this;
    }

    public ImmunizationVaccinationProtocol withDoseStatusReason(CodeableConcept value) {
        this.setDoseStatusReason(value);
        return this;
    }

    @Override
    public ImmunizationVaccinationProtocol withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImmunizationVaccinationProtocol withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImmunizationVaccinationProtocol withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImmunizationVaccinationProtocol withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImmunizationVaccinationProtocol withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImmunizationVaccinationProtocol that = (ImmunizationVaccinationProtocol)object;
        PositiveInt lhsDoseSequence = this.getDoseSequence();
        PositiveInt rhsDoseSequence = that.getDoseSequence();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "doseSequence", lhsDoseSequence), (ObjectLocator)LocatorUtils.property(thatLocator, "doseSequence", rhsDoseSequence), lhsDoseSequence, rhsDoseSequence, this.doseSequence != null, that.doseSequence != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        Reference lhsAuthority = this.getAuthority();
        Reference rhsAuthority = that.getAuthority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "authority", lhsAuthority), (ObjectLocator)LocatorUtils.property(thatLocator, "authority", rhsAuthority), lhsAuthority, rhsAuthority, this.authority != null, that.authority != null)) {
            return false;
        }
        String lhsSeries = this.getSeries();
        String rhsSeries = that.getSeries();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "series", lhsSeries), (ObjectLocator)LocatorUtils.property(thatLocator, "series", rhsSeries), lhsSeries, rhsSeries, this.series != null, that.series != null)) {
            return false;
        }
        PositiveInt lhsSeriesDoses = this.getSeriesDoses();
        PositiveInt rhsSeriesDoses = that.getSeriesDoses();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "seriesDoses", lhsSeriesDoses), (ObjectLocator)LocatorUtils.property(thatLocator, "seriesDoses", rhsSeriesDoses), lhsSeriesDoses, rhsSeriesDoses, this.seriesDoses != null, that.seriesDoses != null)) {
            return false;
        }
        List<CodeableConcept> lhsTargetDisease = this.targetDisease != null && !this.targetDisease.isEmpty() ? this.getTargetDisease() : null;
        List<CodeableConcept> rhsTargetDisease = that.targetDisease != null && !that.targetDisease.isEmpty() ? that.getTargetDisease() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetDisease", lhsTargetDisease), (ObjectLocator)LocatorUtils.property(thatLocator, "targetDisease", rhsTargetDisease), lhsTargetDisease, rhsTargetDisease, this.targetDisease != null && !this.targetDisease.isEmpty(), that.targetDisease != null && !that.targetDisease.isEmpty())) {
            return false;
        }
        CodeableConcept lhsDoseStatus = this.getDoseStatus();
        CodeableConcept rhsDoseStatus = that.getDoseStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "doseStatus", lhsDoseStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "doseStatus", rhsDoseStatus), lhsDoseStatus, rhsDoseStatus, this.doseStatus != null, that.doseStatus != null)) {
            return false;
        }
        CodeableConcept lhsDoseStatusReason = this.getDoseStatusReason();
        CodeableConcept rhsDoseStatusReason = that.getDoseStatusReason();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "doseStatusReason", lhsDoseStatusReason), (ObjectLocator)LocatorUtils.property(thatLocator, "doseStatusReason", rhsDoseStatusReason), lhsDoseStatusReason, rhsDoseStatusReason, this.doseStatusReason != null, that.doseStatusReason != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        PositiveInt theDoseSequence = this.getDoseSequence();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "doseSequence", theDoseSequence), currentHashCode, theDoseSequence, this.doseSequence != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        Reference theAuthority = this.getAuthority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "authority", theAuthority), currentHashCode, theAuthority, this.authority != null);
        String theSeries = this.getSeries();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "series", theSeries), currentHashCode, theSeries, this.series != null);
        PositiveInt theSeriesDoses = this.getSeriesDoses();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "seriesDoses", theSeriesDoses), currentHashCode, theSeriesDoses, this.seriesDoses != null);
        List<CodeableConcept> theTargetDisease = this.targetDisease != null && !this.targetDisease.isEmpty() ? this.getTargetDisease() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetDisease", theTargetDisease), currentHashCode, theTargetDisease, this.targetDisease != null && !this.targetDisease.isEmpty());
        CodeableConcept theDoseStatus = this.getDoseStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "doseStatus", theDoseStatus), currentHashCode, theDoseStatus, this.doseStatus != null);
        CodeableConcept theDoseStatusReason = this.getDoseStatusReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "doseStatusReason", theDoseStatusReason), currentHashCode, theDoseStatusReason, this.doseStatusReason != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        PositiveInt theDoseSequence = this.getDoseSequence();
        strategy.appendField(locator, (Object)this, "doseSequence", buffer, theDoseSequence, this.doseSequence != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        Reference theAuthority = this.getAuthority();
        strategy.appendField(locator, (Object)this, "authority", buffer, theAuthority, this.authority != null);
        String theSeries = this.getSeries();
        strategy.appendField(locator, (Object)this, "series", buffer, theSeries, this.series != null);
        PositiveInt theSeriesDoses = this.getSeriesDoses();
        strategy.appendField(locator, (Object)this, "seriesDoses", buffer, theSeriesDoses, this.seriesDoses != null);
        List<CodeableConcept> theTargetDisease = this.targetDisease != null && !this.targetDisease.isEmpty() ? this.getTargetDisease() : null;
        strategy.appendField(locator, (Object)this, "targetDisease", buffer, theTargetDisease, this.targetDisease != null && !this.targetDisease.isEmpty());
        CodeableConcept theDoseStatus = this.getDoseStatus();
        strategy.appendField(locator, (Object)this, "doseStatus", buffer, theDoseStatus, this.doseStatus != null);
        CodeableConcept theDoseStatusReason = this.getDoseStatusReason();
        strategy.appendField(locator, (Object)this, "doseStatusReason", buffer, theDoseStatusReason, this.doseStatusReason != null);
        return buffer;
    }
}

