/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.ImmunizationExplanation;
import org.hl7.fhir.ImmunizationReaction;
import org.hl7.fhir.ImmunizationVaccinationProtocol;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.SimpleQuantity;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Immunization", propOrder={"identifier", "status", "date", "vaccineCode", "patient", "wasNotGiven", "reported", "performer", "requester", "encounter", "manufacturer", "location", "lotNumber", "expirationDate", "site", "route", "doseQuantity", "note", "explanation", "reaction", "vaccinationProtocol"})
public class Immunization
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    @XmlElement(required=true)
    protected Code status;
    protected DateTime date;
    @XmlElement(required=true)
    protected CodeableConcept vaccineCode;
    @XmlElement(required=true)
    protected Reference patient;
    @XmlElement(required=true)
    protected Boolean wasNotGiven;
    @XmlElement(required=true)
    protected Boolean reported;
    protected Reference performer;
    protected Reference requester;
    protected Reference encounter;
    protected Reference manufacturer;
    protected Reference location;
    protected String lotNumber;
    protected Date expirationDate;
    protected CodeableConcept site;
    protected CodeableConcept route;
    protected SimpleQuantity doseQuantity;
    protected List<Annotation> note;
    protected ImmunizationExplanation explanation;
    protected List<ImmunizationReaction> reaction;
    protected List<ImmunizationVaccinationProtocol> vaccinationProtocol;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Code getStatus() {
        return this.status;
    }

    public void setStatus(Code value) {
        this.status = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public CodeableConcept getVaccineCode() {
        return this.vaccineCode;
    }

    public void setVaccineCode(CodeableConcept value) {
        this.vaccineCode = value;
    }

    public Reference getPatient() {
        return this.patient;
    }

    public void setPatient(Reference value) {
        this.patient = value;
    }

    public Boolean getWasNotGiven() {
        return this.wasNotGiven;
    }

    public void setWasNotGiven(Boolean value) {
        this.wasNotGiven = value;
    }

    public Boolean getReported() {
        return this.reported;
    }

    public void setReported(Boolean value) {
        this.reported = value;
    }

    public Reference getPerformer() {
        return this.performer;
    }

    public void setPerformer(Reference value) {
        this.performer = value;
    }

    public Reference getRequester() {
        return this.requester;
    }

    public void setRequester(Reference value) {
        this.requester = value;
    }

    public Reference getEncounter() {
        return this.encounter;
    }

    public void setEncounter(Reference value) {
        this.encounter = value;
    }

    public Reference getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(Reference value) {
        this.manufacturer = value;
    }

    public Reference getLocation() {
        return this.location;
    }

    public void setLocation(Reference value) {
        this.location = value;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String value) {
        this.lotNumber = value;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date value) {
        this.expirationDate = value;
    }

    public CodeableConcept getSite() {
        return this.site;
    }

    public void setSite(CodeableConcept value) {
        this.site = value;
    }

    public CodeableConcept getRoute() {
        return this.route;
    }

    public void setRoute(CodeableConcept value) {
        this.route = value;
    }

    public SimpleQuantity getDoseQuantity() {
        return this.doseQuantity;
    }

    public void setDoseQuantity(SimpleQuantity value) {
        this.doseQuantity = value;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ImmunizationExplanation getExplanation() {
        return this.explanation;
    }

    public void setExplanation(ImmunizationExplanation value) {
        this.explanation = value;
    }

    public List<ImmunizationReaction> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<ImmunizationReaction>();
        }
        return this.reaction;
    }

    public List<ImmunizationVaccinationProtocol> getVaccinationProtocol() {
        if (this.vaccinationProtocol == null) {
            this.vaccinationProtocol = new ArrayList<ImmunizationVaccinationProtocol>();
        }
        return this.vaccinationProtocol;
    }

    public Immunization withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Immunization withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Immunization withStatus(Code value) {
        this.setStatus(value);
        return this;
    }

    public Immunization withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public Immunization withVaccineCode(CodeableConcept value) {
        this.setVaccineCode(value);
        return this;
    }

    public Immunization withPatient(Reference value) {
        this.setPatient(value);
        return this;
    }

    public Immunization withWasNotGiven(Boolean value) {
        this.setWasNotGiven(value);
        return this;
    }

    public Immunization withReported(Boolean value) {
        this.setReported(value);
        return this;
    }

    public Immunization withPerformer(Reference value) {
        this.setPerformer(value);
        return this;
    }

    public Immunization withRequester(Reference value) {
        this.setRequester(value);
        return this;
    }

    public Immunization withEncounter(Reference value) {
        this.setEncounter(value);
        return this;
    }

    public Immunization withManufacturer(Reference value) {
        this.setManufacturer(value);
        return this;
    }

    public Immunization withLocation(Reference value) {
        this.setLocation(value);
        return this;
    }

    public Immunization withLotNumber(String value) {
        this.setLotNumber(value);
        return this;
    }

    public Immunization withExpirationDate(Date value) {
        this.setExpirationDate(value);
        return this;
    }

    public Immunization withSite(CodeableConcept value) {
        this.setSite(value);
        return this;
    }

    public Immunization withRoute(CodeableConcept value) {
        this.setRoute(value);
        return this;
    }

    public Immunization withDoseQuantity(SimpleQuantity value) {
        this.setDoseQuantity(value);
        return this;
    }

    public Immunization withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public Immunization withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public Immunization withExplanation(ImmunizationExplanation value) {
        this.setExplanation(value);
        return this;
    }

    public Immunization withReaction(ImmunizationReaction ... values) {
        if (values != null) {
            for (ImmunizationReaction value : values) {
                this.getReaction().add(value);
            }
        }
        return this;
    }

    public Immunization withReaction(Collection<ImmunizationReaction> values) {
        if (values != null) {
            this.getReaction().addAll(values);
        }
        return this;
    }

    public Immunization withVaccinationProtocol(ImmunizationVaccinationProtocol ... values) {
        if (values != null) {
            for (ImmunizationVaccinationProtocol value : values) {
                this.getVaccinationProtocol().add(value);
            }
        }
        return this;
    }

    public Immunization withVaccinationProtocol(Collection<ImmunizationVaccinationProtocol> values) {
        if (values != null) {
            this.getVaccinationProtocol().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Immunization withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Immunization withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Immunization withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Immunization withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Immunization withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Immunization withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Immunization that = (Immunization)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Code lhsStatus = this.getStatus();
        Code rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        CodeableConcept lhsVaccineCode = this.getVaccineCode();
        CodeableConcept rhsVaccineCode = that.getVaccineCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "vaccineCode", lhsVaccineCode), (ObjectLocator)LocatorUtils.property(thatLocator, "vaccineCode", rhsVaccineCode), lhsVaccineCode, rhsVaccineCode, this.vaccineCode != null, that.vaccineCode != null)) {
            return false;
        }
        Reference lhsPatient = this.getPatient();
        Reference rhsPatient = that.getPatient();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patient", lhsPatient), (ObjectLocator)LocatorUtils.property(thatLocator, "patient", rhsPatient), lhsPatient, rhsPatient, this.patient != null, that.patient != null)) {
            return false;
        }
        Boolean lhsWasNotGiven = this.getWasNotGiven();
        Boolean rhsWasNotGiven = that.getWasNotGiven();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "wasNotGiven", lhsWasNotGiven), (ObjectLocator)LocatorUtils.property(thatLocator, "wasNotGiven", rhsWasNotGiven), lhsWasNotGiven, rhsWasNotGiven, this.wasNotGiven != null, that.wasNotGiven != null)) {
            return false;
        }
        Boolean lhsReported = this.getReported();
        Boolean rhsReported = that.getReported();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reported", lhsReported), (ObjectLocator)LocatorUtils.property(thatLocator, "reported", rhsReported), lhsReported, rhsReported, this.reported != null, that.reported != null)) {
            return false;
        }
        Reference lhsPerformer = this.getPerformer();
        Reference rhsPerformer = that.getPerformer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "performer", lhsPerformer), (ObjectLocator)LocatorUtils.property(thatLocator, "performer", rhsPerformer), lhsPerformer, rhsPerformer, this.performer != null, that.performer != null)) {
            return false;
        }
        Reference lhsRequester = this.getRequester();
        Reference rhsRequester = that.getRequester();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "requester", lhsRequester), (ObjectLocator)LocatorUtils.property(thatLocator, "requester", rhsRequester), lhsRequester, rhsRequester, this.requester != null, that.requester != null)) {
            return false;
        }
        Reference lhsEncounter = this.getEncounter();
        Reference rhsEncounter = that.getEncounter();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "encounter", lhsEncounter), (ObjectLocator)LocatorUtils.property(thatLocator, "encounter", rhsEncounter), lhsEncounter, rhsEncounter, this.encounter != null, that.encounter != null)) {
            return false;
        }
        Reference lhsManufacturer = this.getManufacturer();
        Reference rhsManufacturer = that.getManufacturer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "manufacturer", lhsManufacturer), (ObjectLocator)LocatorUtils.property(thatLocator, "manufacturer", rhsManufacturer), lhsManufacturer, rhsManufacturer, this.manufacturer != null, that.manufacturer != null)) {
            return false;
        }
        Reference lhsLocation = this.getLocation();
        Reference rhsLocation = that.getLocation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "location", lhsLocation), (ObjectLocator)LocatorUtils.property(thatLocator, "location", rhsLocation), lhsLocation, rhsLocation, this.location != null, that.location != null)) {
            return false;
        }
        String lhsLotNumber = this.getLotNumber();
        String rhsLotNumber = that.getLotNumber();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "lotNumber", lhsLotNumber), (ObjectLocator)LocatorUtils.property(thatLocator, "lotNumber", rhsLotNumber), lhsLotNumber, rhsLotNumber, this.lotNumber != null, that.lotNumber != null)) {
            return false;
        }
        Date lhsExpirationDate = this.getExpirationDate();
        Date rhsExpirationDate = that.getExpirationDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "expirationDate", lhsExpirationDate), (ObjectLocator)LocatorUtils.property(thatLocator, "expirationDate", rhsExpirationDate), lhsExpirationDate, rhsExpirationDate, this.expirationDate != null, that.expirationDate != null)) {
            return false;
        }
        CodeableConcept lhsSite = this.getSite();
        CodeableConcept rhsSite = that.getSite();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "site", lhsSite), (ObjectLocator)LocatorUtils.property(thatLocator, "site", rhsSite), lhsSite, rhsSite, this.site != null, that.site != null)) {
            return false;
        }
        CodeableConcept lhsRoute = this.getRoute();
        CodeableConcept rhsRoute = that.getRoute();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "route", lhsRoute), (ObjectLocator)LocatorUtils.property(thatLocator, "route", rhsRoute), lhsRoute, rhsRoute, this.route != null, that.route != null)) {
            return false;
        }
        SimpleQuantity lhsDoseQuantity = this.getDoseQuantity();
        SimpleQuantity rhsDoseQuantity = that.getDoseQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "doseQuantity", lhsDoseQuantity), (ObjectLocator)LocatorUtils.property(thatLocator, "doseQuantity", rhsDoseQuantity), lhsDoseQuantity, rhsDoseQuantity, this.doseQuantity != null, that.doseQuantity != null)) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        ImmunizationExplanation lhsExplanation = this.getExplanation();
        ImmunizationExplanation rhsExplanation = that.getExplanation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "explanation", lhsExplanation), (ObjectLocator)LocatorUtils.property(thatLocator, "explanation", rhsExplanation), lhsExplanation, rhsExplanation, this.explanation != null, that.explanation != null)) {
            return false;
        }
        List<ImmunizationReaction> lhsReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        List<ImmunizationReaction> rhsReaction = that.reaction != null && !that.reaction.isEmpty() ? that.getReaction() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reaction", lhsReaction), (ObjectLocator)LocatorUtils.property(thatLocator, "reaction", rhsReaction), lhsReaction, rhsReaction, this.reaction != null && !this.reaction.isEmpty(), that.reaction != null && !that.reaction.isEmpty())) {
            return false;
        }
        List<ImmunizationVaccinationProtocol> lhsVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        List<ImmunizationVaccinationProtocol> rhsVaccinationProtocol = that.vaccinationProtocol != null && !that.vaccinationProtocol.isEmpty() ? that.getVaccinationProtocol() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "vaccinationProtocol", lhsVaccinationProtocol), (ObjectLocator)LocatorUtils.property(thatLocator, "vaccinationProtocol", rhsVaccinationProtocol), lhsVaccinationProtocol, rhsVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty(), that.vaccinationProtocol != null && !that.vaccinationProtocol.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Code theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "vaccineCode", theVaccineCode), currentHashCode, theVaccineCode, this.vaccineCode != null);
        Reference thePatient = this.getPatient();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patient", thePatient), currentHashCode, thePatient, this.patient != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "wasNotGiven", theWasNotGiven), currentHashCode, theWasNotGiven, this.wasNotGiven != null);
        Boolean theReported = this.getReported();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reported", theReported), currentHashCode, theReported, this.reported != null);
        Reference thePerformer = this.getPerformer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "performer", thePerformer), currentHashCode, thePerformer, this.performer != null);
        Reference theRequester = this.getRequester();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "requester", theRequester), currentHashCode, theRequester, this.requester != null);
        Reference theEncounter = this.getEncounter();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "encounter", theEncounter), currentHashCode, theEncounter, this.encounter != null);
        Reference theManufacturer = this.getManufacturer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "manufacturer", theManufacturer), currentHashCode, theManufacturer, this.manufacturer != null);
        Reference theLocation = this.getLocation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "location", theLocation), currentHashCode, theLocation, this.location != null);
        String theLotNumber = this.getLotNumber();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "lotNumber", theLotNumber), currentHashCode, theLotNumber, this.lotNumber != null);
        Date theExpirationDate = this.getExpirationDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "expirationDate", theExpirationDate), currentHashCode, theExpirationDate, this.expirationDate != null);
        CodeableConcept theSite = this.getSite();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "site", theSite), currentHashCode, theSite, this.site != null);
        CodeableConcept theRoute = this.getRoute();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "route", theRoute), currentHashCode, theRoute, this.route != null);
        SimpleQuantity theDoseQuantity = this.getDoseQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "doseQuantity", theDoseQuantity), currentHashCode, theDoseQuantity, this.doseQuantity != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        ImmunizationExplanation theExplanation = this.getExplanation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "explanation", theExplanation), currentHashCode, theExplanation, this.explanation != null);
        List<ImmunizationReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reaction", theReaction), currentHashCode, theReaction, this.reaction != null && !this.reaction.isEmpty());
        List<ImmunizationVaccinationProtocol> theVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "vaccinationProtocol", theVaccinationProtocol), currentHashCode, theVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Code theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        CodeableConcept theVaccineCode = this.getVaccineCode();
        strategy.appendField(locator, (Object)this, "vaccineCode", buffer, theVaccineCode, this.vaccineCode != null);
        Reference thePatient = this.getPatient();
        strategy.appendField(locator, (Object)this, "patient", buffer, thePatient, this.patient != null);
        Boolean theWasNotGiven = this.getWasNotGiven();
        strategy.appendField(locator, (Object)this, "wasNotGiven", buffer, theWasNotGiven, this.wasNotGiven != null);
        Boolean theReported = this.getReported();
        strategy.appendField(locator, (Object)this, "reported", buffer, theReported, this.reported != null);
        Reference thePerformer = this.getPerformer();
        strategy.appendField(locator, (Object)this, "performer", buffer, thePerformer, this.performer != null);
        Reference theRequester = this.getRequester();
        strategy.appendField(locator, (Object)this, "requester", buffer, theRequester, this.requester != null);
        Reference theEncounter = this.getEncounter();
        strategy.appendField(locator, (Object)this, "encounter", buffer, theEncounter, this.encounter != null);
        Reference theManufacturer = this.getManufacturer();
        strategy.appendField(locator, (Object)this, "manufacturer", buffer, theManufacturer, this.manufacturer != null);
        Reference theLocation = this.getLocation();
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null);
        String theLotNumber = this.getLotNumber();
        strategy.appendField(locator, (Object)this, "lotNumber", buffer, theLotNumber, this.lotNumber != null);
        Date theExpirationDate = this.getExpirationDate();
        strategy.appendField(locator, (Object)this, "expirationDate", buffer, theExpirationDate, this.expirationDate != null);
        CodeableConcept theSite = this.getSite();
        strategy.appendField(locator, (Object)this, "site", buffer, theSite, this.site != null);
        CodeableConcept theRoute = this.getRoute();
        strategy.appendField(locator, (Object)this, "route", buffer, theRoute, this.route != null);
        SimpleQuantity theDoseQuantity = this.getDoseQuantity();
        strategy.appendField(locator, (Object)this, "doseQuantity", buffer, theDoseQuantity, this.doseQuantity != null);
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        ImmunizationExplanation theExplanation = this.getExplanation();
        strategy.appendField(locator, (Object)this, "explanation", buffer, theExplanation, this.explanation != null);
        List<ImmunizationReaction> theReaction = this.reaction != null && !this.reaction.isEmpty() ? this.getReaction() : null;
        strategy.appendField(locator, (Object)this, "reaction", buffer, theReaction, this.reaction != null && !this.reaction.isEmpty());
        List<ImmunizationVaccinationProtocol> theVaccinationProtocol = this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty() ? this.getVaccinationProtocol() : null;
        strategy.appendField(locator, (Object)this, "vaccinationProtocol", buffer, theVaccinationProtocol, this.vaccinationProtocol != null && !this.vaccinationProtocol.isEmpty());
        return buffer;
    }
}

