/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Extension;
import org.hl7.fhir.ImagingObjectSelectionFrame;
import org.hl7.fhir.Oid;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ImagingObjectSelection.Instance", propOrder={"sopClass", "uid", "url", "frame"})
public class ImagingObjectSelectionInstance
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Oid sopClass;
    @XmlElement(required=true)
    protected Oid uid;
    @XmlElement(required=true)
    protected Uri url;
    protected List<ImagingObjectSelectionFrame> frame;

    public Oid getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(Oid value) {
        this.sopClass = value;
    }

    public Oid getUid() {
        return this.uid;
    }

    public void setUid(Oid value) {
        this.uid = value;
    }

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public List<ImagingObjectSelectionFrame> getFrame() {
        if (this.frame == null) {
            this.frame = new ArrayList<ImagingObjectSelectionFrame>();
        }
        return this.frame;
    }

    public ImagingObjectSelectionInstance withSopClass(Oid value) {
        this.setSopClass(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUid(Oid value) {
        this.setUid(value);
        return this;
    }

    public ImagingObjectSelectionInstance withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ImagingObjectSelectionInstance withFrame(ImagingObjectSelectionFrame ... values) {
        if (values != null) {
            for (ImagingObjectSelectionFrame value : values) {
                this.getFrame().add(value);
            }
        }
        return this;
    }

    public ImagingObjectSelectionInstance withFrame(Collection<ImagingObjectSelectionFrame> values) {
        if (values != null) {
            this.getFrame().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ImagingObjectSelectionInstance withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ImagingObjectSelectionInstance that = (ImagingObjectSelectionInstance)object;
        Oid lhsSopClass = this.getSopClass();
        Oid rhsSopClass = that.getSopClass();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "sopClass", lhsSopClass), (ObjectLocator)LocatorUtils.property(thatLocator, "sopClass", rhsSopClass), lhsSopClass, rhsSopClass, this.sopClass != null, that.sopClass != null)) {
            return false;
        }
        Oid lhsUid = this.getUid();
        Oid rhsUid = that.getUid();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "uid", lhsUid), (ObjectLocator)LocatorUtils.property(thatLocator, "uid", rhsUid), lhsUid, rhsUid, this.uid != null, that.uid != null)) {
            return false;
        }
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        List<ImagingObjectSelectionFrame> lhsFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        List<ImagingObjectSelectionFrame> rhsFrame = that.frame != null && !that.frame.isEmpty() ? that.getFrame() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "frame", lhsFrame), (ObjectLocator)LocatorUtils.property(thatLocator, "frame", rhsFrame), lhsFrame, rhsFrame, this.frame != null && !this.frame.isEmpty(), that.frame != null && !that.frame.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Oid theSopClass = this.getSopClass();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "sopClass", theSopClass), currentHashCode, theSopClass, this.sopClass != null);
        Oid theUid = this.getUid();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "uid", theUid), currentHashCode, theUid, this.uid != null);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        List<ImagingObjectSelectionFrame> theFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "frame", theFrame), currentHashCode, theFrame, this.frame != null && !this.frame.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Oid theSopClass = this.getSopClass();
        strategy.appendField(locator, (Object)this, "sopClass", buffer, theSopClass, this.sopClass != null);
        Oid theUid = this.getUid();
        strategy.appendField(locator, (Object)this, "uid", buffer, theUid, this.uid != null);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        List<ImagingObjectSelectionFrame> theFrame = this.frame != null && !this.frame.isEmpty() ? this.getFrame() : null;
        strategy.appendField(locator, (Object)this, "frame", buffer, theFrame, this.frame != null && !this.frame.isEmpty());
        return buffer;
    }
}

