/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Date;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Duration;
import org.hl7.fhir.Extension;
import org.hl7.fhir.GoalOutcome;
import org.hl7.fhir.GoalStatus;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Goal", propOrder={"identifier", "subject", "startDate", "startCodeableConcept", "targetDate", "targetQuantity", "category", "description", "status", "statusDate", "statusReason", "author", "priority", "addresses", "note", "outcome"})
public class Goal
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Reference subject;
    protected Date startDate;
    protected CodeableConcept startCodeableConcept;
    protected Date targetDate;
    protected Duration targetQuantity;
    protected List<CodeableConcept> category;
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true)
    protected GoalStatus status;
    protected Date statusDate;
    protected CodeableConcept statusReason;
    protected Reference author;
    protected CodeableConcept priority;
    protected List<Reference> addresses;
    protected List<Annotation> note;
    protected List<GoalOutcome> outcome;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public CodeableConcept getStartCodeableConcept() {
        return this.startCodeableConcept;
    }

    public void setStartCodeableConcept(CodeableConcept value) {
        this.startCodeableConcept = value;
    }

    public Date getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(Date value) {
        this.targetDate = value;
    }

    public Duration getTargetQuantity() {
        return this.targetQuantity;
    }

    public void setTargetQuantity(Duration value) {
        this.targetQuantity = value;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public GoalStatus getStatus() {
        return this.status;
    }

    public void setStatus(GoalStatus value) {
        this.status = value;
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date value) {
        this.statusDate = value;
    }

    public CodeableConcept getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(CodeableConcept value) {
        this.statusReason = value;
    }

    public Reference getAuthor() {
        return this.author;
    }

    public void setAuthor(Reference value) {
        this.author = value;
    }

    public CodeableConcept getPriority() {
        return this.priority;
    }

    public void setPriority(CodeableConcept value) {
        this.priority = value;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public List<GoalOutcome> getOutcome() {
        if (this.outcome == null) {
            this.outcome = new ArrayList<GoalOutcome>();
        }
        return this.outcome;
    }

    public Goal withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Goal withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Goal withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Goal withStartDate(Date value) {
        this.setStartDate(value);
        return this;
    }

    public Goal withStartCodeableConcept(CodeableConcept value) {
        this.setStartCodeableConcept(value);
        return this;
    }

    public Goal withTargetDate(Date value) {
        this.setTargetDate(value);
        return this;
    }

    public Goal withTargetQuantity(Duration value) {
        this.setTargetQuantity(value);
        return this;
    }

    public Goal withCategory(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getCategory().add(value);
            }
        }
        return this;
    }

    public Goal withCategory(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getCategory().addAll(values);
        }
        return this;
    }

    public Goal withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public Goal withStatus(GoalStatus value) {
        this.setStatus(value);
        return this;
    }

    public Goal withStatusDate(Date value) {
        this.setStatusDate(value);
        return this;
    }

    public Goal withStatusReason(CodeableConcept value) {
        this.setStatusReason(value);
        return this;
    }

    public Goal withAuthor(Reference value) {
        this.setAuthor(value);
        return this;
    }

    public Goal withPriority(CodeableConcept value) {
        this.setPriority(value);
        return this;
    }

    public Goal withAddresses(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAddresses().add(value);
            }
        }
        return this;
    }

    public Goal withAddresses(Collection<Reference> values) {
        if (values != null) {
            this.getAddresses().addAll(values);
        }
        return this;
    }

    public Goal withNote(Annotation ... values) {
        if (values != null) {
            for (Annotation value : values) {
                this.getNote().add(value);
            }
        }
        return this;
    }

    public Goal withNote(Collection<Annotation> values) {
        if (values != null) {
            this.getNote().addAll(values);
        }
        return this;
    }

    public Goal withOutcome(GoalOutcome ... values) {
        if (values != null) {
            for (GoalOutcome value : values) {
                this.getOutcome().add(value);
            }
        }
        return this;
    }

    public Goal withOutcome(Collection<GoalOutcome> values) {
        if (values != null) {
            this.getOutcome().addAll(values);
        }
        return this;
    }

    @Override
    public Goal withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Goal withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Goal withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Goal withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Goal withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Goal withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Goal withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Goal withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Goal withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Goal withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Goal withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Goal that = (Goal)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Date lhsStartDate = this.getStartDate();
        Date rhsStartDate = that.getStartDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "startDate", lhsStartDate), (ObjectLocator)LocatorUtils.property(thatLocator, "startDate", rhsStartDate), lhsStartDate, rhsStartDate, this.startDate != null, that.startDate != null)) {
            return false;
        }
        CodeableConcept lhsStartCodeableConcept = this.getStartCodeableConcept();
        CodeableConcept rhsStartCodeableConcept = that.getStartCodeableConcept();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "startCodeableConcept", lhsStartCodeableConcept), (ObjectLocator)LocatorUtils.property(thatLocator, "startCodeableConcept", rhsStartCodeableConcept), lhsStartCodeableConcept, rhsStartCodeableConcept, this.startCodeableConcept != null, that.startCodeableConcept != null)) {
            return false;
        }
        Date lhsTargetDate = this.getTargetDate();
        Date rhsTargetDate = that.getTargetDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetDate", lhsTargetDate), (ObjectLocator)LocatorUtils.property(thatLocator, "targetDate", rhsTargetDate), lhsTargetDate, rhsTargetDate, this.targetDate != null, that.targetDate != null)) {
            return false;
        }
        Duration lhsTargetQuantity = this.getTargetQuantity();
        Duration rhsTargetQuantity = that.getTargetQuantity();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetQuantity", lhsTargetQuantity), (ObjectLocator)LocatorUtils.property(thatLocator, "targetQuantity", rhsTargetQuantity), lhsTargetQuantity, rhsTargetQuantity, this.targetQuantity != null, that.targetQuantity != null)) {
            return false;
        }
        List<CodeableConcept> lhsCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        List<CodeableConcept> rhsCategory = that.category != null && !that.category.isEmpty() ? that.getCategory() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null && !this.category.isEmpty(), that.category != null && !that.category.isEmpty())) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        GoalStatus lhsStatus = this.getStatus();
        GoalStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Date lhsStatusDate = this.getStatusDate();
        Date rhsStatusDate = that.getStatusDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "statusDate", lhsStatusDate), (ObjectLocator)LocatorUtils.property(thatLocator, "statusDate", rhsStatusDate), lhsStatusDate, rhsStatusDate, this.statusDate != null, that.statusDate != null)) {
            return false;
        }
        CodeableConcept lhsStatusReason = this.getStatusReason();
        CodeableConcept rhsStatusReason = that.getStatusReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "statusReason", lhsStatusReason), (ObjectLocator)LocatorUtils.property(thatLocator, "statusReason", rhsStatusReason), lhsStatusReason, rhsStatusReason, this.statusReason != null, that.statusReason != null)) {
            return false;
        }
        Reference lhsAuthor = this.getAuthor();
        Reference rhsAuthor = that.getAuthor();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "author", lhsAuthor), (ObjectLocator)LocatorUtils.property(thatLocator, "author", rhsAuthor), lhsAuthor, rhsAuthor, this.author != null, that.author != null)) {
            return false;
        }
        CodeableConcept lhsPriority = this.getPriority();
        CodeableConcept rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null)) {
            return false;
        }
        List<Reference> lhsAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        List<Reference> rhsAddresses = that.addresses != null && !that.addresses.isEmpty() ? that.getAddresses() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "addresses", lhsAddresses), (ObjectLocator)LocatorUtils.property(thatLocator, "addresses", rhsAddresses), lhsAddresses, rhsAddresses, this.addresses != null && !this.addresses.isEmpty(), that.addresses != null && !that.addresses.isEmpty())) {
            return false;
        }
        List<Annotation> lhsNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        List<Annotation> rhsNote = that.note != null && !that.note.isEmpty() ? that.getNote() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null && !this.note.isEmpty(), that.note != null && !that.note.isEmpty())) {
            return false;
        }
        List<GoalOutcome> lhsOutcome = this.outcome != null && !this.outcome.isEmpty() ? this.getOutcome() : null;
        List<GoalOutcome> rhsOutcome = that.outcome != null && !that.outcome.isEmpty() ? that.getOutcome() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "outcome", lhsOutcome), (ObjectLocator)LocatorUtils.property(thatLocator, "outcome", rhsOutcome), lhsOutcome, rhsOutcome, this.outcome != null && !this.outcome.isEmpty(), that.outcome != null && !that.outcome.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        Date theStartDate = this.getStartDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "startDate", theStartDate), currentHashCode, theStartDate, this.startDate != null);
        CodeableConcept theStartCodeableConcept = this.getStartCodeableConcept();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "startCodeableConcept", theStartCodeableConcept), currentHashCode, theStartCodeableConcept, this.startCodeableConcept != null);
        Date theTargetDate = this.getTargetDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetDate", theTargetDate), currentHashCode, theTargetDate, this.targetDate != null);
        Duration theTargetQuantity = this.getTargetQuantity();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetQuantity", theTargetQuantity), currentHashCode, theTargetQuantity, this.targetQuantity != null);
        List<CodeableConcept> theCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null && !this.category.isEmpty());
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        GoalStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Date theStatusDate = this.getStatusDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "statusDate", theStatusDate), currentHashCode, theStatusDate, this.statusDate != null);
        CodeableConcept theStatusReason = this.getStatusReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "statusReason", theStatusReason), currentHashCode, theStatusReason, this.statusReason != null);
        Reference theAuthor = this.getAuthor();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "author", theAuthor), currentHashCode, theAuthor, this.author != null);
        CodeableConcept thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        List<Reference> theAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "addresses", theAddresses), currentHashCode, theAddresses, this.addresses != null && !this.addresses.isEmpty());
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null && !this.note.isEmpty());
        List<GoalOutcome> theOutcome = this.outcome != null && !this.outcome.isEmpty() ? this.getOutcome() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "outcome", theOutcome), currentHashCode, theOutcome, this.outcome != null && !this.outcome.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        Date theStartDate = this.getStartDate();
        strategy.appendField(locator, (Object)this, "startDate", buffer, theStartDate, this.startDate != null);
        CodeableConcept theStartCodeableConcept = this.getStartCodeableConcept();
        strategy.appendField(locator, (Object)this, "startCodeableConcept", buffer, theStartCodeableConcept, this.startCodeableConcept != null);
        Date theTargetDate = this.getTargetDate();
        strategy.appendField(locator, (Object)this, "targetDate", buffer, theTargetDate, this.targetDate != null);
        Duration theTargetQuantity = this.getTargetQuantity();
        strategy.appendField(locator, (Object)this, "targetQuantity", buffer, theTargetQuantity, this.targetQuantity != null);
        List<CodeableConcept> theCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null && !this.category.isEmpty());
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        GoalStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Date theStatusDate = this.getStatusDate();
        strategy.appendField(locator, (Object)this, "statusDate", buffer, theStatusDate, this.statusDate != null);
        CodeableConcept theStatusReason = this.getStatusReason();
        strategy.appendField(locator, (Object)this, "statusReason", buffer, theStatusReason, this.statusReason != null);
        Reference theAuthor = this.getAuthor();
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor, this.author != null);
        CodeableConcept thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        List<Reference> theAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        strategy.appendField(locator, (Object)this, "addresses", buffer, theAddresses, this.addresses != null && !this.addresses.isEmpty());
        List<Annotation> theNote = this.note != null && !this.note.isEmpty() ? this.getNote() : null;
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null && !this.note.isEmpty());
        List<GoalOutcome> theOutcome = this.outcome != null && !this.outcome.isEmpty() ? this.getOutcome() : null;
        strategy.appendField(locator, (Object)this, "outcome", buffer, theOutcome, this.outcome != null && !this.outcome.isEmpty());
        return buffer;
    }
}

