/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Boolean;
import org.hl7.fhir.Code;
import org.hl7.fhir.ConformanceResourceStatus;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.ExpansionProfileCodeSystem;
import org.hl7.fhir.ExpansionProfileContact;
import org.hl7.fhir.ExpansionProfileDesignation;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ExpansionProfile", propOrder={"url", "identifier", "version", "name", "status", "experimental", "publisher", "contact", "date", "description", "codeSystem", "includeDesignations", "designation", "includeDefinition", "includeInactive", "excludeNested", "excludeNotForUI", "excludePostCoordinated", "displayLanguage", "limitedExpansion"})
public class ExpansionProfile
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected Uri url;
    protected Identifier identifier;
    protected String version;
    protected String name;
    @XmlElement(required=true)
    protected ConformanceResourceStatus status;
    protected Boolean experimental;
    protected String publisher;
    protected List<ExpansionProfileContact> contact;
    protected DateTime date;
    protected String description;
    protected ExpansionProfileCodeSystem codeSystem;
    protected Boolean includeDesignations;
    protected ExpansionProfileDesignation designation;
    protected Boolean includeDefinition;
    protected Boolean includeInactive;
    protected Boolean excludeNested;
    protected Boolean excludeNotForUI;
    protected Boolean excludePostCoordinated;
    protected Code displayLanguage;
    protected Boolean limitedExpansion;

    public Uri getUrl() {
        return this.url;
    }

    public void setUrl(Uri value) {
        this.url = value;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public ConformanceResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConformanceResourceStatus value) {
        this.status = value;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public void setExperimental(Boolean value) {
        this.experimental = value;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String value) {
        this.publisher = value;
    }

    public List<ExpansionProfileContact> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ExpansionProfileContact>();
        }
        return this.contact;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public ExpansionProfileCodeSystem getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(ExpansionProfileCodeSystem value) {
        this.codeSystem = value;
    }

    public Boolean getIncludeDesignations() {
        return this.includeDesignations;
    }

    public void setIncludeDesignations(Boolean value) {
        this.includeDesignations = value;
    }

    public ExpansionProfileDesignation getDesignation() {
        return this.designation;
    }

    public void setDesignation(ExpansionProfileDesignation value) {
        this.designation = value;
    }

    public Boolean getIncludeDefinition() {
        return this.includeDefinition;
    }

    public void setIncludeDefinition(Boolean value) {
        this.includeDefinition = value;
    }

    public Boolean getIncludeInactive() {
        return this.includeInactive;
    }

    public void setIncludeInactive(Boolean value) {
        this.includeInactive = value;
    }

    public Boolean getExcludeNested() {
        return this.excludeNested;
    }

    public void setExcludeNested(Boolean value) {
        this.excludeNested = value;
    }

    public Boolean getExcludeNotForUI() {
        return this.excludeNotForUI;
    }

    public void setExcludeNotForUI(Boolean value) {
        this.excludeNotForUI = value;
    }

    public Boolean getExcludePostCoordinated() {
        return this.excludePostCoordinated;
    }

    public void setExcludePostCoordinated(Boolean value) {
        this.excludePostCoordinated = value;
    }

    public Code getDisplayLanguage() {
        return this.displayLanguage;
    }

    public void setDisplayLanguage(Code value) {
        this.displayLanguage = value;
    }

    public Boolean getLimitedExpansion() {
        return this.limitedExpansion;
    }

    public void setLimitedExpansion(Boolean value) {
        this.limitedExpansion = value;
    }

    public ExpansionProfile withUrl(Uri value) {
        this.setUrl(value);
        return this;
    }

    public ExpansionProfile withIdentifier(Identifier value) {
        this.setIdentifier(value);
        return this;
    }

    public ExpansionProfile withVersion(String value) {
        this.setVersion(value);
        return this;
    }

    public ExpansionProfile withName(String value) {
        this.setName(value);
        return this;
    }

    public ExpansionProfile withStatus(ConformanceResourceStatus value) {
        this.setStatus(value);
        return this;
    }

    public ExpansionProfile withExperimental(Boolean value) {
        this.setExperimental(value);
        return this;
    }

    public ExpansionProfile withPublisher(String value) {
        this.setPublisher(value);
        return this;
    }

    public ExpansionProfile withContact(ExpansionProfileContact ... values) {
        if (values != null) {
            for (ExpansionProfileContact value : values) {
                this.getContact().add(value);
            }
        }
        return this;
    }

    public ExpansionProfile withContact(Collection<ExpansionProfileContact> values) {
        if (values != null) {
            this.getContact().addAll(values);
        }
        return this;
    }

    public ExpansionProfile withDate(DateTime value) {
        this.setDate(value);
        return this;
    }

    public ExpansionProfile withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ExpansionProfile withCodeSystem(ExpansionProfileCodeSystem value) {
        this.setCodeSystem(value);
        return this;
    }

    public ExpansionProfile withIncludeDesignations(Boolean value) {
        this.setIncludeDesignations(value);
        return this;
    }

    public ExpansionProfile withDesignation(ExpansionProfileDesignation value) {
        this.setDesignation(value);
        return this;
    }

    public ExpansionProfile withIncludeDefinition(Boolean value) {
        this.setIncludeDefinition(value);
        return this;
    }

    public ExpansionProfile withIncludeInactive(Boolean value) {
        this.setIncludeInactive(value);
        return this;
    }

    public ExpansionProfile withExcludeNested(Boolean value) {
        this.setExcludeNested(value);
        return this;
    }

    public ExpansionProfile withExcludeNotForUI(Boolean value) {
        this.setExcludeNotForUI(value);
        return this;
    }

    public ExpansionProfile withExcludePostCoordinated(Boolean value) {
        this.setExcludePostCoordinated(value);
        return this;
    }

    public ExpansionProfile withDisplayLanguage(Code value) {
        this.setDisplayLanguage(value);
        return this;
    }

    public ExpansionProfile withLimitedExpansion(Boolean value) {
        this.setLimitedExpansion(value);
        return this;
    }

    @Override
    public ExpansionProfile withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public ExpansionProfile withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public ExpansionProfile withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public ExpansionProfile withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ExpansionProfile withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ExpansionProfile withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ExpansionProfile withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ExpansionProfile withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public ExpansionProfile withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public ExpansionProfile withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public ExpansionProfile withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ExpansionProfile that = (ExpansionProfile)object;
        Uri lhsUrl = this.getUrl();
        Uri rhsUrl = that.getUrl();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "url", lhsUrl), (ObjectLocator)LocatorUtils.property(thatLocator, "url", rhsUrl), lhsUrl, rhsUrl, this.url != null, that.url != null)) {
            return false;
        }
        Identifier lhsIdentifier = this.getIdentifier();
        Identifier rhsIdentifier = that.getIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null, that.identifier != null)) {
            return false;
        }
        String lhsVersion = this.getVersion();
        String rhsVersion = that.getVersion();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "version", lhsVersion), (ObjectLocator)LocatorUtils.property(thatLocator, "version", rhsVersion), lhsVersion, rhsVersion, this.version != null, that.version != null)) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        ConformanceResourceStatus lhsStatus = this.getStatus();
        ConformanceResourceStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Boolean lhsExperimental = this.getExperimental();
        Boolean rhsExperimental = that.getExperimental();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "experimental", lhsExperimental), (ObjectLocator)LocatorUtils.property(thatLocator, "experimental", rhsExperimental), lhsExperimental, rhsExperimental, this.experimental != null, that.experimental != null)) {
            return false;
        }
        String lhsPublisher = this.getPublisher();
        String rhsPublisher = that.getPublisher();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "publisher", lhsPublisher), (ObjectLocator)LocatorUtils.property(thatLocator, "publisher", rhsPublisher), lhsPublisher, rhsPublisher, this.publisher != null, that.publisher != null)) {
            return false;
        }
        List<ExpansionProfileContact> lhsContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        List<ExpansionProfileContact> rhsContact = that.contact != null && !that.contact.isEmpty() ? that.getContact() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "contact", lhsContact), (ObjectLocator)LocatorUtils.property(thatLocator, "contact", rhsContact), lhsContact, rhsContact, this.contact != null && !this.contact.isEmpty(), that.contact != null && !that.contact.isEmpty())) {
            return false;
        }
        DateTime lhsDate = this.getDate();
        DateTime rhsDate = that.getDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "date", lhsDate), (ObjectLocator)LocatorUtils.property(thatLocator, "date", rhsDate), lhsDate, rhsDate, this.date != null, that.date != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        ExpansionProfileCodeSystem lhsCodeSystem = this.getCodeSystem();
        ExpansionProfileCodeSystem rhsCodeSystem = that.getCodeSystem();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "codeSystem", lhsCodeSystem), (ObjectLocator)LocatorUtils.property(thatLocator, "codeSystem", rhsCodeSystem), lhsCodeSystem, rhsCodeSystem, this.codeSystem != null, that.codeSystem != null)) {
            return false;
        }
        Boolean lhsIncludeDesignations = this.getIncludeDesignations();
        Boolean rhsIncludeDesignations = that.getIncludeDesignations();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "includeDesignations", lhsIncludeDesignations), (ObjectLocator)LocatorUtils.property(thatLocator, "includeDesignations", rhsIncludeDesignations), lhsIncludeDesignations, rhsIncludeDesignations, this.includeDesignations != null, that.includeDesignations != null)) {
            return false;
        }
        ExpansionProfileDesignation lhsDesignation = this.getDesignation();
        ExpansionProfileDesignation rhsDesignation = that.getDesignation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "designation", lhsDesignation), (ObjectLocator)LocatorUtils.property(thatLocator, "designation", rhsDesignation), lhsDesignation, rhsDesignation, this.designation != null, that.designation != null)) {
            return false;
        }
        Boolean lhsIncludeDefinition = this.getIncludeDefinition();
        Boolean rhsIncludeDefinition = that.getIncludeDefinition();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "includeDefinition", lhsIncludeDefinition), (ObjectLocator)LocatorUtils.property(thatLocator, "includeDefinition", rhsIncludeDefinition), lhsIncludeDefinition, rhsIncludeDefinition, this.includeDefinition != null, that.includeDefinition != null)) {
            return false;
        }
        Boolean lhsIncludeInactive = this.getIncludeInactive();
        Boolean rhsIncludeInactive = that.getIncludeInactive();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "includeInactive", lhsIncludeInactive), (ObjectLocator)LocatorUtils.property(thatLocator, "includeInactive", rhsIncludeInactive), lhsIncludeInactive, rhsIncludeInactive, this.includeInactive != null, that.includeInactive != null)) {
            return false;
        }
        Boolean lhsExcludeNested = this.getExcludeNested();
        Boolean rhsExcludeNested = that.getExcludeNested();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "excludeNested", lhsExcludeNested), (ObjectLocator)LocatorUtils.property(thatLocator, "excludeNested", rhsExcludeNested), lhsExcludeNested, rhsExcludeNested, this.excludeNested != null, that.excludeNested != null)) {
            return false;
        }
        Boolean lhsExcludeNotForUI = this.getExcludeNotForUI();
        Boolean rhsExcludeNotForUI = that.getExcludeNotForUI();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "excludeNotForUI", lhsExcludeNotForUI), (ObjectLocator)LocatorUtils.property(thatLocator, "excludeNotForUI", rhsExcludeNotForUI), lhsExcludeNotForUI, rhsExcludeNotForUI, this.excludeNotForUI != null, that.excludeNotForUI != null)) {
            return false;
        }
        Boolean lhsExcludePostCoordinated = this.getExcludePostCoordinated();
        Boolean rhsExcludePostCoordinated = that.getExcludePostCoordinated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "excludePostCoordinated", lhsExcludePostCoordinated), (ObjectLocator)LocatorUtils.property(thatLocator, "excludePostCoordinated", rhsExcludePostCoordinated), lhsExcludePostCoordinated, rhsExcludePostCoordinated, this.excludePostCoordinated != null, that.excludePostCoordinated != null)) {
            return false;
        }
        Code lhsDisplayLanguage = this.getDisplayLanguage();
        Code rhsDisplayLanguage = that.getDisplayLanguage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "displayLanguage", lhsDisplayLanguage), (ObjectLocator)LocatorUtils.property(thatLocator, "displayLanguage", rhsDisplayLanguage), lhsDisplayLanguage, rhsDisplayLanguage, this.displayLanguage != null, that.displayLanguage != null)) {
            return false;
        }
        Boolean lhsLimitedExpansion = this.getLimitedExpansion();
        Boolean rhsLimitedExpansion = that.getLimitedExpansion();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "limitedExpansion", lhsLimitedExpansion), (ObjectLocator)LocatorUtils.property(thatLocator, "limitedExpansion", rhsLimitedExpansion), lhsLimitedExpansion, rhsLimitedExpansion, this.limitedExpansion != null, that.limitedExpansion != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Uri theUrl = this.getUrl();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "url", theUrl), currentHashCode, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "version", theVersion), currentHashCode, theVersion, this.version != null);
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "experimental", theExperimental), currentHashCode, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "publisher", thePublisher), currentHashCode, thePublisher, this.publisher != null);
        List<ExpansionProfileContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "contact", theContact), currentHashCode, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "date", theDate), currentHashCode, theDate, this.date != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        ExpansionProfileCodeSystem theCodeSystem = this.getCodeSystem();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "codeSystem", theCodeSystem), currentHashCode, theCodeSystem, this.codeSystem != null);
        Boolean theIncludeDesignations = this.getIncludeDesignations();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "includeDesignations", theIncludeDesignations), currentHashCode, theIncludeDesignations, this.includeDesignations != null);
        ExpansionProfileDesignation theDesignation = this.getDesignation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "designation", theDesignation), currentHashCode, theDesignation, this.designation != null);
        Boolean theIncludeDefinition = this.getIncludeDefinition();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "includeDefinition", theIncludeDefinition), currentHashCode, theIncludeDefinition, this.includeDefinition != null);
        Boolean theIncludeInactive = this.getIncludeInactive();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "includeInactive", theIncludeInactive), currentHashCode, theIncludeInactive, this.includeInactive != null);
        Boolean theExcludeNested = this.getExcludeNested();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "excludeNested", theExcludeNested), currentHashCode, theExcludeNested, this.excludeNested != null);
        Boolean theExcludeNotForUI = this.getExcludeNotForUI();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "excludeNotForUI", theExcludeNotForUI), currentHashCode, theExcludeNotForUI, this.excludeNotForUI != null);
        Boolean theExcludePostCoordinated = this.getExcludePostCoordinated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "excludePostCoordinated", theExcludePostCoordinated), currentHashCode, theExcludePostCoordinated, this.excludePostCoordinated != null);
        Code theDisplayLanguage = this.getDisplayLanguage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "displayLanguage", theDisplayLanguage), currentHashCode, theDisplayLanguage, this.displayLanguage != null);
        Boolean theLimitedExpansion = this.getLimitedExpansion();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "limitedExpansion", theLimitedExpansion), currentHashCode, theLimitedExpansion, this.limitedExpansion != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Uri theUrl = this.getUrl();
        strategy.appendField(locator, (Object)this, "url", buffer, theUrl, this.url != null);
        Identifier theIdentifier = this.getIdentifier();
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null);
        String theVersion = this.getVersion();
        strategy.appendField(locator, (Object)this, "version", buffer, theVersion, this.version != null);
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        ConformanceResourceStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Boolean theExperimental = this.getExperimental();
        strategy.appendField(locator, (Object)this, "experimental", buffer, theExperimental, this.experimental != null);
        String thePublisher = this.getPublisher();
        strategy.appendField(locator, (Object)this, "publisher", buffer, thePublisher, this.publisher != null);
        List<ExpansionProfileContact> theContact = this.contact != null && !this.contact.isEmpty() ? this.getContact() : null;
        strategy.appendField(locator, (Object)this, "contact", buffer, theContact, this.contact != null && !this.contact.isEmpty());
        DateTime theDate = this.getDate();
        strategy.appendField(locator, (Object)this, "date", buffer, theDate, this.date != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        ExpansionProfileCodeSystem theCodeSystem = this.getCodeSystem();
        strategy.appendField(locator, (Object)this, "codeSystem", buffer, theCodeSystem, this.codeSystem != null);
        Boolean theIncludeDesignations = this.getIncludeDesignations();
        strategy.appendField(locator, (Object)this, "includeDesignations", buffer, theIncludeDesignations, this.includeDesignations != null);
        ExpansionProfileDesignation theDesignation = this.getDesignation();
        strategy.appendField(locator, (Object)this, "designation", buffer, theDesignation, this.designation != null);
        Boolean theIncludeDefinition = this.getIncludeDefinition();
        strategy.appendField(locator, (Object)this, "includeDefinition", buffer, theIncludeDefinition, this.includeDefinition != null);
        Boolean theIncludeInactive = this.getIncludeInactive();
        strategy.appendField(locator, (Object)this, "includeInactive", buffer, theIncludeInactive, this.includeInactive != null);
        Boolean theExcludeNested = this.getExcludeNested();
        strategy.appendField(locator, (Object)this, "excludeNested", buffer, theExcludeNested, this.excludeNested != null);
        Boolean theExcludeNotForUI = this.getExcludeNotForUI();
        strategy.appendField(locator, (Object)this, "excludeNotForUI", buffer, theExcludeNotForUI, this.excludeNotForUI != null);
        Boolean theExcludePostCoordinated = this.getExcludePostCoordinated();
        strategy.appendField(locator, (Object)this, "excludePostCoordinated", buffer, theExcludePostCoordinated, this.excludePostCoordinated != null);
        Code theDisplayLanguage = this.getDisplayLanguage();
        strategy.appendField(locator, (Object)this, "displayLanguage", buffer, theDisplayLanguage, this.displayLanguage != null);
        Boolean theLimitedExpansion = this.getLimitedExpansion();
        strategy.appendField(locator, (Object)this, "limitedExpansion", buffer, theLimitedExpansion, this.limitedExpansion != null);
        return buffer;
    }
}

