/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnrollmentRequest", propOrder={"identifier", "ruleset", "originalRuleset", "created", "target", "provider", "organization", "subject", "coverage", "relationship"})
public class EnrollmentRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Reference target;
    protected Reference provider;
    protected Reference organization;
    @XmlElement(required=true)
    protected Reference subject;
    @XmlElement(required=true)
    protected Reference coverage;
    @XmlElement(required=true)
    protected Coding relationship;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Reference getTarget() {
        return this.target;
    }

    public void setTarget(Reference value) {
        this.target = value;
    }

    public Reference getProvider() {
        return this.provider;
    }

    public void setProvider(Reference value) {
        this.provider = value;
    }

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Reference value) {
        this.coverage = value;
    }

    public Coding getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Coding value) {
        this.relationship = value;
    }

    public EnrollmentRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public EnrollmentRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public EnrollmentRequest withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public EnrollmentRequest withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public EnrollmentRequest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public EnrollmentRequest withTarget(Reference value) {
        this.setTarget(value);
        return this;
    }

    public EnrollmentRequest withProvider(Reference value) {
        this.setProvider(value);
        return this;
    }

    public EnrollmentRequest withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public EnrollmentRequest withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public EnrollmentRequest withCoverage(Reference value) {
        this.setCoverage(value);
        return this;
    }

    public EnrollmentRequest withRelationship(Coding value) {
        this.setRelationship(value);
        return this;
    }

    @Override
    public EnrollmentRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public EnrollmentRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EnrollmentRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EnrollmentRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public EnrollmentRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public EnrollmentRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public EnrollmentRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EnrollmentRequest that = (EnrollmentRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ruleset", lhsRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "ruleset", rhsRuleset), lhsRuleset, rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "originalRuleset", lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "originalRuleset", rhsOriginalRuleset), lhsOriginalRuleset, rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Reference lhsTarget = this.getTarget();
        Reference rhsTarget = that.getTarget();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "target", lhsTarget), (ObjectLocator)LocatorUtils.property(thatLocator, "target", rhsTarget), lhsTarget, rhsTarget, this.target != null, that.target != null)) {
            return false;
        }
        Reference lhsProvider = this.getProvider();
        Reference rhsProvider = that.getProvider();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "provider", lhsProvider), (ObjectLocator)LocatorUtils.property(thatLocator, "provider", rhsProvider), lhsProvider, rhsProvider, this.provider != null, that.provider != null)) {
            return false;
        }
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organization", lhsOrganization), (ObjectLocator)LocatorUtils.property(thatLocator, "organization", rhsOrganization), lhsOrganization, rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsCoverage = this.getCoverage();
        Reference rhsCoverage = that.getCoverage();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverage", lhsCoverage), (ObjectLocator)LocatorUtils.property(thatLocator, "coverage", rhsCoverage), lhsCoverage, rhsCoverage, this.coverage != null, that.coverage != null)) {
            return false;
        }
        Coding lhsRelationship = this.getRelationship();
        Coding rhsRelationship = that.getRelationship();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "relationship", lhsRelationship), (ObjectLocator)LocatorUtils.property(thatLocator, "relationship", rhsRelationship), lhsRelationship, rhsRelationship, this.relationship != null, that.relationship != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ruleset", theRuleset), currentHashCode, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "originalRuleset", theOriginalRuleset), currentHashCode, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        Reference theTarget = this.getTarget();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "target", theTarget), currentHashCode, theTarget, this.target != null);
        Reference theProvider = this.getProvider();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "provider", theProvider), currentHashCode, theProvider, this.provider != null);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organization", theOrganization), currentHashCode, theOrganization, this.organization != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        Reference theCoverage = this.getCoverage();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverage", theCoverage), currentHashCode, theCoverage, this.coverage != null);
        Coding theRelationship = this.getRelationship();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "relationship", theRelationship), currentHashCode, theRelationship, this.relationship != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        Reference theTarget = this.getTarget();
        strategy.appendField(locator, (Object)this, "target", buffer, theTarget, this.target != null);
        Reference theProvider = this.getProvider();
        strategy.appendField(locator, (Object)this, "provider", buffer, theProvider, this.provider != null);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, theOrganization, this.organization != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        Reference theCoverage = this.getCoverage();
        strategy.appendField(locator, (Object)this, "coverage", buffer, theCoverage, this.coverage != null);
        Coding theRelationship = this.getRelationship();
        strategy.appendField(locator, (Object)this, "relationship", buffer, theRelationship, this.relationship != null);
        return buffer;
    }
}

