/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.Date;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EligibilityRequest", propOrder={"identifier", "ruleset", "originalRuleset", "created", "targetIdentifier", "targetReference", "providerIdentifier", "providerReference", "organizationIdentifier", "organizationReference", "priority", "entererIdentifier", "entererReference", "facilityIdentifier", "facilityReference", "patientIdentifier", "patientReference", "coverageIdentifier", "coverageReference", "businessArrangement", "servicedDate", "servicedPeriod", "benefitCategory", "benefitSubCategory"})
public class EligibilityRequest
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Coding ruleset;
    protected Coding originalRuleset;
    protected DateTime created;
    protected Identifier targetIdentifier;
    protected Reference targetReference;
    protected Identifier providerIdentifier;
    protected Reference providerReference;
    protected Identifier organizationIdentifier;
    protected Reference organizationReference;
    protected Coding priority;
    protected Identifier entererIdentifier;
    protected Reference entererReference;
    protected Identifier facilityIdentifier;
    protected Reference facilityReference;
    protected Identifier patientIdentifier;
    protected Reference patientReference;
    protected Identifier coverageIdentifier;
    protected Reference coverageReference;
    protected String businessArrangement;
    protected Date servicedDate;
    protected Period servicedPeriod;
    protected Coding benefitCategory;
    protected Coding benefitSubCategory;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Coding getRuleset() {
        return this.ruleset;
    }

    public void setRuleset(Coding value) {
        this.ruleset = value;
    }

    public Coding getOriginalRuleset() {
        return this.originalRuleset;
    }

    public void setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime value) {
        this.created = value;
    }

    public Identifier getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public void setTargetIdentifier(Identifier value) {
        this.targetIdentifier = value;
    }

    public Reference getTargetReference() {
        return this.targetReference;
    }

    public void setTargetReference(Reference value) {
        this.targetReference = value;
    }

    public Identifier getProviderIdentifier() {
        return this.providerIdentifier;
    }

    public void setProviderIdentifier(Identifier value) {
        this.providerIdentifier = value;
    }

    public Reference getProviderReference() {
        return this.providerReference;
    }

    public void setProviderReference(Reference value) {
        this.providerReference = value;
    }

    public Identifier getOrganizationIdentifier() {
        return this.organizationIdentifier;
    }

    public void setOrganizationIdentifier(Identifier value) {
        this.organizationIdentifier = value;
    }

    public Reference getOrganizationReference() {
        return this.organizationReference;
    }

    public void setOrganizationReference(Reference value) {
        this.organizationReference = value;
    }

    public Coding getPriority() {
        return this.priority;
    }

    public void setPriority(Coding value) {
        this.priority = value;
    }

    public Identifier getEntererIdentifier() {
        return this.entererIdentifier;
    }

    public void setEntererIdentifier(Identifier value) {
        this.entererIdentifier = value;
    }

    public Reference getEntererReference() {
        return this.entererReference;
    }

    public void setEntererReference(Reference value) {
        this.entererReference = value;
    }

    public Identifier getFacilityIdentifier() {
        return this.facilityIdentifier;
    }

    public void setFacilityIdentifier(Identifier value) {
        this.facilityIdentifier = value;
    }

    public Reference getFacilityReference() {
        return this.facilityReference;
    }

    public void setFacilityReference(Reference value) {
        this.facilityReference = value;
    }

    public Identifier getPatientIdentifier() {
        return this.patientIdentifier;
    }

    public void setPatientIdentifier(Identifier value) {
        this.patientIdentifier = value;
    }

    public Reference getPatientReference() {
        return this.patientReference;
    }

    public void setPatientReference(Reference value) {
        this.patientReference = value;
    }

    public Identifier getCoverageIdentifier() {
        return this.coverageIdentifier;
    }

    public void setCoverageIdentifier(Identifier value) {
        this.coverageIdentifier = value;
    }

    public Reference getCoverageReference() {
        return this.coverageReference;
    }

    public void setCoverageReference(Reference value) {
        this.coverageReference = value;
    }

    public String getBusinessArrangement() {
        return this.businessArrangement;
    }

    public void setBusinessArrangement(String value) {
        this.businessArrangement = value;
    }

    public Date getServicedDate() {
        return this.servicedDate;
    }

    public void setServicedDate(Date value) {
        this.servicedDate = value;
    }

    public Period getServicedPeriod() {
        return this.servicedPeriod;
    }

    public void setServicedPeriod(Period value) {
        this.servicedPeriod = value;
    }

    public Coding getBenefitCategory() {
        return this.benefitCategory;
    }

    public void setBenefitCategory(Coding value) {
        this.benefitCategory = value;
    }

    public Coding getBenefitSubCategory() {
        return this.benefitSubCategory;
    }

    public void setBenefitSubCategory(Coding value) {
        this.benefitSubCategory = value;
    }

    public EligibilityRequest withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public EligibilityRequest withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public EligibilityRequest withRuleset(Coding value) {
        this.setRuleset(value);
        return this;
    }

    public EligibilityRequest withOriginalRuleset(Coding value) {
        this.setOriginalRuleset(value);
        return this;
    }

    public EligibilityRequest withCreated(DateTime value) {
        this.setCreated(value);
        return this;
    }

    public EligibilityRequest withTargetIdentifier(Identifier value) {
        this.setTargetIdentifier(value);
        return this;
    }

    public EligibilityRequest withTargetReference(Reference value) {
        this.setTargetReference(value);
        return this;
    }

    public EligibilityRequest withProviderIdentifier(Identifier value) {
        this.setProviderIdentifier(value);
        return this;
    }

    public EligibilityRequest withProviderReference(Reference value) {
        this.setProviderReference(value);
        return this;
    }

    public EligibilityRequest withOrganizationIdentifier(Identifier value) {
        this.setOrganizationIdentifier(value);
        return this;
    }

    public EligibilityRequest withOrganizationReference(Reference value) {
        this.setOrganizationReference(value);
        return this;
    }

    public EligibilityRequest withPriority(Coding value) {
        this.setPriority(value);
        return this;
    }

    public EligibilityRequest withEntererIdentifier(Identifier value) {
        this.setEntererIdentifier(value);
        return this;
    }

    public EligibilityRequest withEntererReference(Reference value) {
        this.setEntererReference(value);
        return this;
    }

    public EligibilityRequest withFacilityIdentifier(Identifier value) {
        this.setFacilityIdentifier(value);
        return this;
    }

    public EligibilityRequest withFacilityReference(Reference value) {
        this.setFacilityReference(value);
        return this;
    }

    public EligibilityRequest withPatientIdentifier(Identifier value) {
        this.setPatientIdentifier(value);
        return this;
    }

    public EligibilityRequest withPatientReference(Reference value) {
        this.setPatientReference(value);
        return this;
    }

    public EligibilityRequest withCoverageIdentifier(Identifier value) {
        this.setCoverageIdentifier(value);
        return this;
    }

    public EligibilityRequest withCoverageReference(Reference value) {
        this.setCoverageReference(value);
        return this;
    }

    public EligibilityRequest withBusinessArrangement(String value) {
        this.setBusinessArrangement(value);
        return this;
    }

    public EligibilityRequest withServicedDate(Date value) {
        this.setServicedDate(value);
        return this;
    }

    public EligibilityRequest withServicedPeriod(Period value) {
        this.setServicedPeriod(value);
        return this;
    }

    public EligibilityRequest withBenefitCategory(Coding value) {
        this.setBenefitCategory(value);
        return this;
    }

    public EligibilityRequest withBenefitSubCategory(Coding value) {
        this.setBenefitSubCategory(value);
        return this;
    }

    @Override
    public EligibilityRequest withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public EligibilityRequest withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityRequest withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityRequest withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityRequest withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityRequest withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public EligibilityRequest withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public EligibilityRequest withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public EligibilityRequest withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public EligibilityRequest withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public EligibilityRequest withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        EligibilityRequest that = (EligibilityRequest)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Coding lhsRuleset = this.getRuleset();
        Coding rhsRuleset = that.getRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "ruleset", lhsRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "ruleset", rhsRuleset), lhsRuleset, rhsRuleset, this.ruleset != null, that.ruleset != null)) {
            return false;
        }
        Coding lhsOriginalRuleset = this.getOriginalRuleset();
        Coding rhsOriginalRuleset = that.getOriginalRuleset();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "originalRuleset", lhsOriginalRuleset), (ObjectLocator)LocatorUtils.property(thatLocator, "originalRuleset", rhsOriginalRuleset), lhsOriginalRuleset, rhsOriginalRuleset, this.originalRuleset != null, that.originalRuleset != null)) {
            return false;
        }
        DateTime lhsCreated = this.getCreated();
        DateTime rhsCreated = that.getCreated();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "created", lhsCreated), (ObjectLocator)LocatorUtils.property(thatLocator, "created", rhsCreated), lhsCreated, rhsCreated, this.created != null, that.created != null)) {
            return false;
        }
        Identifier lhsTargetIdentifier = this.getTargetIdentifier();
        Identifier rhsTargetIdentifier = that.getTargetIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetIdentifier", lhsTargetIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "targetIdentifier", rhsTargetIdentifier), lhsTargetIdentifier, rhsTargetIdentifier, this.targetIdentifier != null, that.targetIdentifier != null)) {
            return false;
        }
        Reference lhsTargetReference = this.getTargetReference();
        Reference rhsTargetReference = that.getTargetReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "targetReference", lhsTargetReference), (ObjectLocator)LocatorUtils.property(thatLocator, "targetReference", rhsTargetReference), lhsTargetReference, rhsTargetReference, this.targetReference != null, that.targetReference != null)) {
            return false;
        }
        Identifier lhsProviderIdentifier = this.getProviderIdentifier();
        Identifier rhsProviderIdentifier = that.getProviderIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "providerIdentifier", lhsProviderIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "providerIdentifier", rhsProviderIdentifier), lhsProviderIdentifier, rhsProviderIdentifier, this.providerIdentifier != null, that.providerIdentifier != null)) {
            return false;
        }
        Reference lhsProviderReference = this.getProviderReference();
        Reference rhsProviderReference = that.getProviderReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "providerReference", lhsProviderReference), (ObjectLocator)LocatorUtils.property(thatLocator, "providerReference", rhsProviderReference), lhsProviderReference, rhsProviderReference, this.providerReference != null, that.providerReference != null)) {
            return false;
        }
        Identifier lhsOrganizationIdentifier = this.getOrganizationIdentifier();
        Identifier rhsOrganizationIdentifier = that.getOrganizationIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationIdentifier", lhsOrganizationIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationIdentifier", rhsOrganizationIdentifier), lhsOrganizationIdentifier, rhsOrganizationIdentifier, this.organizationIdentifier != null, that.organizationIdentifier != null)) {
            return false;
        }
        Reference lhsOrganizationReference = this.getOrganizationReference();
        Reference rhsOrganizationReference = that.getOrganizationReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "organizationReference", lhsOrganizationReference), (ObjectLocator)LocatorUtils.property(thatLocator, "organizationReference", rhsOrganizationReference), lhsOrganizationReference, rhsOrganizationReference, this.organizationReference != null, that.organizationReference != null)) {
            return false;
        }
        Coding lhsPriority = this.getPriority();
        Coding rhsPriority = that.getPriority();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "priority", lhsPriority), (ObjectLocator)LocatorUtils.property(thatLocator, "priority", rhsPriority), lhsPriority, rhsPriority, this.priority != null, that.priority != null)) {
            return false;
        }
        Identifier lhsEntererIdentifier = this.getEntererIdentifier();
        Identifier rhsEntererIdentifier = that.getEntererIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "entererIdentifier", lhsEntererIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "entererIdentifier", rhsEntererIdentifier), lhsEntererIdentifier, rhsEntererIdentifier, this.entererIdentifier != null, that.entererIdentifier != null)) {
            return false;
        }
        Reference lhsEntererReference = this.getEntererReference();
        Reference rhsEntererReference = that.getEntererReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "entererReference", lhsEntererReference), (ObjectLocator)LocatorUtils.property(thatLocator, "entererReference", rhsEntererReference), lhsEntererReference, rhsEntererReference, this.entererReference != null, that.entererReference != null)) {
            return false;
        }
        Identifier lhsFacilityIdentifier = this.getFacilityIdentifier();
        Identifier rhsFacilityIdentifier = that.getFacilityIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "facilityIdentifier", lhsFacilityIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "facilityIdentifier", rhsFacilityIdentifier), lhsFacilityIdentifier, rhsFacilityIdentifier, this.facilityIdentifier != null, that.facilityIdentifier != null)) {
            return false;
        }
        Reference lhsFacilityReference = this.getFacilityReference();
        Reference rhsFacilityReference = that.getFacilityReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "facilityReference", lhsFacilityReference), (ObjectLocator)LocatorUtils.property(thatLocator, "facilityReference", rhsFacilityReference), lhsFacilityReference, rhsFacilityReference, this.facilityReference != null, that.facilityReference != null)) {
            return false;
        }
        Identifier lhsPatientIdentifier = this.getPatientIdentifier();
        Identifier rhsPatientIdentifier = that.getPatientIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patientIdentifier", lhsPatientIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "patientIdentifier", rhsPatientIdentifier), lhsPatientIdentifier, rhsPatientIdentifier, this.patientIdentifier != null, that.patientIdentifier != null)) {
            return false;
        }
        Reference lhsPatientReference = this.getPatientReference();
        Reference rhsPatientReference = that.getPatientReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "patientReference", lhsPatientReference), (ObjectLocator)LocatorUtils.property(thatLocator, "patientReference", rhsPatientReference), lhsPatientReference, rhsPatientReference, this.patientReference != null, that.patientReference != null)) {
            return false;
        }
        Identifier lhsCoverageIdentifier = this.getCoverageIdentifier();
        Identifier rhsCoverageIdentifier = that.getCoverageIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverageIdentifier", lhsCoverageIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "coverageIdentifier", rhsCoverageIdentifier), lhsCoverageIdentifier, rhsCoverageIdentifier, this.coverageIdentifier != null, that.coverageIdentifier != null)) {
            return false;
        }
        Reference lhsCoverageReference = this.getCoverageReference();
        Reference rhsCoverageReference = that.getCoverageReference();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coverageReference", lhsCoverageReference), (ObjectLocator)LocatorUtils.property(thatLocator, "coverageReference", rhsCoverageReference), lhsCoverageReference, rhsCoverageReference, this.coverageReference != null, that.coverageReference != null)) {
            return false;
        }
        String lhsBusinessArrangement = this.getBusinessArrangement();
        String rhsBusinessArrangement = that.getBusinessArrangement();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "businessArrangement", lhsBusinessArrangement), (ObjectLocator)LocatorUtils.property(thatLocator, "businessArrangement", rhsBusinessArrangement), lhsBusinessArrangement, rhsBusinessArrangement, this.businessArrangement != null, that.businessArrangement != null)) {
            return false;
        }
        Date lhsServicedDate = this.getServicedDate();
        Date rhsServicedDate = that.getServicedDate();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "servicedDate", lhsServicedDate), (ObjectLocator)LocatorUtils.property(thatLocator, "servicedDate", rhsServicedDate), lhsServicedDate, rhsServicedDate, this.servicedDate != null, that.servicedDate != null)) {
            return false;
        }
        Period lhsServicedPeriod = this.getServicedPeriod();
        Period rhsServicedPeriod = that.getServicedPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "servicedPeriod", lhsServicedPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "servicedPeriod", rhsServicedPeriod), lhsServicedPeriod, rhsServicedPeriod, this.servicedPeriod != null, that.servicedPeriod != null)) {
            return false;
        }
        Coding lhsBenefitCategory = this.getBenefitCategory();
        Coding rhsBenefitCategory = that.getBenefitCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "benefitCategory", lhsBenefitCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "benefitCategory", rhsBenefitCategory), lhsBenefitCategory, rhsBenefitCategory, this.benefitCategory != null, that.benefitCategory != null)) {
            return false;
        }
        Coding lhsBenefitSubCategory = this.getBenefitSubCategory();
        Coding rhsBenefitSubCategory = that.getBenefitSubCategory();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "benefitSubCategory", lhsBenefitSubCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "benefitSubCategory", rhsBenefitSubCategory), lhsBenefitSubCategory, rhsBenefitSubCategory, this.benefitSubCategory != null, that.benefitSubCategory != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "ruleset", theRuleset), currentHashCode, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "originalRuleset", theOriginalRuleset), currentHashCode, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "created", theCreated), currentHashCode, theCreated, this.created != null);
        Identifier theTargetIdentifier = this.getTargetIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetIdentifier", theTargetIdentifier), currentHashCode, theTargetIdentifier, this.targetIdentifier != null);
        Reference theTargetReference = this.getTargetReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "targetReference", theTargetReference), currentHashCode, theTargetReference, this.targetReference != null);
        Identifier theProviderIdentifier = this.getProviderIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "providerIdentifier", theProviderIdentifier), currentHashCode, theProviderIdentifier, this.providerIdentifier != null);
        Reference theProviderReference = this.getProviderReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "providerReference", theProviderReference), currentHashCode, theProviderReference, this.providerReference != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationIdentifier", theOrganizationIdentifier), currentHashCode, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "organizationReference", theOrganizationReference), currentHashCode, theOrganizationReference, this.organizationReference != null);
        Coding thePriority = this.getPriority();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "priority", thePriority), currentHashCode, thePriority, this.priority != null);
        Identifier theEntererIdentifier = this.getEntererIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "entererIdentifier", theEntererIdentifier), currentHashCode, theEntererIdentifier, this.entererIdentifier != null);
        Reference theEntererReference = this.getEntererReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "entererReference", theEntererReference), currentHashCode, theEntererReference, this.entererReference != null);
        Identifier theFacilityIdentifier = this.getFacilityIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "facilityIdentifier", theFacilityIdentifier), currentHashCode, theFacilityIdentifier, this.facilityIdentifier != null);
        Reference theFacilityReference = this.getFacilityReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "facilityReference", theFacilityReference), currentHashCode, theFacilityReference, this.facilityReference != null);
        Identifier thePatientIdentifier = this.getPatientIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patientIdentifier", thePatientIdentifier), currentHashCode, thePatientIdentifier, this.patientIdentifier != null);
        Reference thePatientReference = this.getPatientReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "patientReference", thePatientReference), currentHashCode, thePatientReference, this.patientReference != null);
        Identifier theCoverageIdentifier = this.getCoverageIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverageIdentifier", theCoverageIdentifier), currentHashCode, theCoverageIdentifier, this.coverageIdentifier != null);
        Reference theCoverageReference = this.getCoverageReference();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coverageReference", theCoverageReference), currentHashCode, theCoverageReference, this.coverageReference != null);
        String theBusinessArrangement = this.getBusinessArrangement();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "businessArrangement", theBusinessArrangement), currentHashCode, theBusinessArrangement, this.businessArrangement != null);
        Date theServicedDate = this.getServicedDate();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "servicedDate", theServicedDate), currentHashCode, theServicedDate, this.servicedDate != null);
        Period theServicedPeriod = this.getServicedPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "servicedPeriod", theServicedPeriod), currentHashCode, theServicedPeriod, this.servicedPeriod != null);
        Coding theBenefitCategory = this.getBenefitCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "benefitCategory", theBenefitCategory), currentHashCode, theBenefitCategory, this.benefitCategory != null);
        Coding theBenefitSubCategory = this.getBenefitSubCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "benefitSubCategory", theBenefitSubCategory), currentHashCode, theBenefitSubCategory, this.benefitSubCategory != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Coding theRuleset = this.getRuleset();
        strategy.appendField(locator, (Object)this, "ruleset", buffer, theRuleset, this.ruleset != null);
        Coding theOriginalRuleset = this.getOriginalRuleset();
        strategy.appendField(locator, (Object)this, "originalRuleset", buffer, theOriginalRuleset, this.originalRuleset != null);
        DateTime theCreated = this.getCreated();
        strategy.appendField(locator, (Object)this, "created", buffer, theCreated, this.created != null);
        Identifier theTargetIdentifier = this.getTargetIdentifier();
        strategy.appendField(locator, (Object)this, "targetIdentifier", buffer, theTargetIdentifier, this.targetIdentifier != null);
        Reference theTargetReference = this.getTargetReference();
        strategy.appendField(locator, (Object)this, "targetReference", buffer, theTargetReference, this.targetReference != null);
        Identifier theProviderIdentifier = this.getProviderIdentifier();
        strategy.appendField(locator, (Object)this, "providerIdentifier", buffer, theProviderIdentifier, this.providerIdentifier != null);
        Reference theProviderReference = this.getProviderReference();
        strategy.appendField(locator, (Object)this, "providerReference", buffer, theProviderReference, this.providerReference != null);
        Identifier theOrganizationIdentifier = this.getOrganizationIdentifier();
        strategy.appendField(locator, (Object)this, "organizationIdentifier", buffer, theOrganizationIdentifier, this.organizationIdentifier != null);
        Reference theOrganizationReference = this.getOrganizationReference();
        strategy.appendField(locator, (Object)this, "organizationReference", buffer, theOrganizationReference, this.organizationReference != null);
        Coding thePriority = this.getPriority();
        strategy.appendField(locator, (Object)this, "priority", buffer, thePriority, this.priority != null);
        Identifier theEntererIdentifier = this.getEntererIdentifier();
        strategy.appendField(locator, (Object)this, "entererIdentifier", buffer, theEntererIdentifier, this.entererIdentifier != null);
        Reference theEntererReference = this.getEntererReference();
        strategy.appendField(locator, (Object)this, "entererReference", buffer, theEntererReference, this.entererReference != null);
        Identifier theFacilityIdentifier = this.getFacilityIdentifier();
        strategy.appendField(locator, (Object)this, "facilityIdentifier", buffer, theFacilityIdentifier, this.facilityIdentifier != null);
        Reference theFacilityReference = this.getFacilityReference();
        strategy.appendField(locator, (Object)this, "facilityReference", buffer, theFacilityReference, this.facilityReference != null);
        Identifier thePatientIdentifier = this.getPatientIdentifier();
        strategy.appendField(locator, (Object)this, "patientIdentifier", buffer, thePatientIdentifier, this.patientIdentifier != null);
        Reference thePatientReference = this.getPatientReference();
        strategy.appendField(locator, (Object)this, "patientReference", buffer, thePatientReference, this.patientReference != null);
        Identifier theCoverageIdentifier = this.getCoverageIdentifier();
        strategy.appendField(locator, (Object)this, "coverageIdentifier", buffer, theCoverageIdentifier, this.coverageIdentifier != null);
        Reference theCoverageReference = this.getCoverageReference();
        strategy.appendField(locator, (Object)this, "coverageReference", buffer, theCoverageReference, this.coverageReference != null);
        String theBusinessArrangement = this.getBusinessArrangement();
        strategy.appendField(locator, (Object)this, "businessArrangement", buffer, theBusinessArrangement, this.businessArrangement != null);
        Date theServicedDate = this.getServicedDate();
        strategy.appendField(locator, (Object)this, "servicedDate", buffer, theServicedDate, this.servicedDate != null);
        Period theServicedPeriod = this.getServicedPeriod();
        strategy.appendField(locator, (Object)this, "servicedPeriod", buffer, theServicedPeriod, this.servicedPeriod != null);
        Coding theBenefitCategory = this.getBenefitCategory();
        strategy.appendField(locator, (Object)this, "benefitCategory", buffer, theBenefitCategory, this.benefitCategory != null);
        Coding theBenefitSubCategory = this.getBenefitSubCategory();
        strategy.appendField(locator, (Object)this, "benefitSubCategory", buffer, theBenefitSubCategory, this.benefitSubCategory != null);
        return buffer;
    }
}

