/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DiagnosticOrderEvent;
import org.hl7.fhir.DiagnosticOrderStatus;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DiagnosticOrder.Item", propOrder={"code", "specimen", "bodySite", "status", "event"})
public class DiagnosticOrderItem
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected CodeableConcept code;
    protected List<Reference> specimen;
    protected CodeableConcept bodySite;
    protected DiagnosticOrderStatus status;
    protected List<DiagnosticOrderEvent> event;

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public CodeableConcept getBodySite() {
        return this.bodySite;
    }

    public void setBodySite(CodeableConcept value) {
        this.bodySite = value;
    }

    public DiagnosticOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(DiagnosticOrderStatus value) {
        this.status = value;
    }

    public List<DiagnosticOrderEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<DiagnosticOrderEvent>();
        }
        return this.event;
    }

    public DiagnosticOrderItem withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public DiagnosticOrderItem withSpecimen(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSpecimen().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrderItem withSpecimen(Collection<Reference> values) {
        if (values != null) {
            this.getSpecimen().addAll(values);
        }
        return this;
    }

    public DiagnosticOrderItem withBodySite(CodeableConcept value) {
        this.setBodySite(value);
        return this;
    }

    public DiagnosticOrderItem withStatus(DiagnosticOrderStatus value) {
        this.setStatus(value);
        return this;
    }

    public DiagnosticOrderItem withEvent(DiagnosticOrderEvent ... values) {
        if (values != null) {
            for (DiagnosticOrderEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public DiagnosticOrderItem withEvent(Collection<DiagnosticOrderEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrderItem withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticOrderItem withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrderItem withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public DiagnosticOrderItem withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public DiagnosticOrderItem withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        DiagnosticOrderItem that = (DiagnosticOrderItem)object;
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        List<Reference> lhsSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        List<Reference> rhsSpecimen = that.specimen != null && !that.specimen.isEmpty() ? that.getSpecimen() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "specimen", lhsSpecimen), (ObjectLocator)LocatorUtils.property(thatLocator, "specimen", rhsSpecimen), lhsSpecimen, rhsSpecimen, this.specimen != null && !this.specimen.isEmpty(), that.specimen != null && !that.specimen.isEmpty())) {
            return false;
        }
        CodeableConcept lhsBodySite = this.getBodySite();
        CodeableConcept rhsBodySite = that.getBodySite();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "bodySite", lhsBodySite), (ObjectLocator)LocatorUtils.property(thatLocator, "bodySite", rhsBodySite), lhsBodySite, rhsBodySite, this.bodySite != null, that.bodySite != null)) {
            return false;
        }
        DiagnosticOrderStatus lhsStatus = this.getStatus();
        DiagnosticOrderStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        List<DiagnosticOrderEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<DiagnosticOrderEvent> rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "event", lhsEvent), (ObjectLocator)LocatorUtils.property(thatLocator, "event", rhsEvent), lhsEvent, rhsEvent, this.event != null && !this.event.isEmpty(), that.event != null && !that.event.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "specimen", theSpecimen), currentHashCode, theSpecimen, this.specimen != null && !this.specimen.isEmpty());
        CodeableConcept theBodySite = this.getBodySite();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "bodySite", theBodySite), currentHashCode, theBodySite, this.bodySite != null);
        DiagnosticOrderStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        List<DiagnosticOrderEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "event", theEvent), currentHashCode, theEvent, this.event != null && !this.event.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        List<Reference> theSpecimen = this.specimen != null && !this.specimen.isEmpty() ? this.getSpecimen() : null;
        strategy.appendField(locator, (Object)this, "specimen", buffer, theSpecimen, this.specimen != null && !this.specimen.isEmpty());
        CodeableConcept theBodySite = this.getBodySite();
        strategy.appendField(locator, (Object)this, "bodySite", buffer, theBodySite, this.bodySite != null);
        DiagnosticOrderStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        List<DiagnosticOrderEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent, this.event != null && !this.event.isEmpty());
        return buffer;
    }
}

