/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.ConformanceEndpoint;
import org.hl7.fhir.ConformanceEvent;
import org.hl7.fhir.Extension;
import org.hl7.fhir.String;
import org.hl7.fhir.UnsignedInt;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Messaging", propOrder={"endpoint", "reliableCache", "documentation", "event"})
public class ConformanceMessaging
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected List<ConformanceEndpoint> endpoint;
    protected UnsignedInt reliableCache;
    protected String documentation;
    @XmlElement(required=true)
    protected List<ConformanceEvent> event;

    public List<ConformanceEndpoint> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<ConformanceEndpoint>();
        }
        return this.endpoint;
    }

    public UnsignedInt getReliableCache() {
        return this.reliableCache;
    }

    public void setReliableCache(UnsignedInt value) {
        this.reliableCache = value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String value) {
        this.documentation = value;
    }

    public List<ConformanceEvent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<ConformanceEvent>();
        }
        return this.event;
    }

    public ConformanceMessaging withEndpoint(ConformanceEndpoint ... values) {
        if (values != null) {
            for (ConformanceEndpoint value : values) {
                this.getEndpoint().add(value);
            }
        }
        return this;
    }

    public ConformanceMessaging withEndpoint(Collection<ConformanceEndpoint> values) {
        if (values != null) {
            this.getEndpoint().addAll(values);
        }
        return this;
    }

    public ConformanceMessaging withReliableCache(UnsignedInt value) {
        this.setReliableCache(value);
        return this;
    }

    public ConformanceMessaging withDocumentation(String value) {
        this.setDocumentation(value);
        return this;
    }

    public ConformanceMessaging withEvent(ConformanceEvent ... values) {
        if (values != null) {
            for (ConformanceEvent value : values) {
                this.getEvent().add(value);
            }
        }
        return this;
    }

    public ConformanceMessaging withEvent(Collection<ConformanceEvent> values) {
        if (values != null) {
            this.getEvent().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceMessaging withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceMessaging withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceMessaging withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceMessaging that = (ConformanceMessaging)object;
        List<ConformanceEndpoint> lhsEndpoint = this.endpoint != null && !this.endpoint.isEmpty() ? this.getEndpoint() : null;
        List<ConformanceEndpoint> rhsEndpoint = that.endpoint != null && !that.endpoint.isEmpty() ? that.getEndpoint() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "endpoint", lhsEndpoint), (ObjectLocator)LocatorUtils.property(thatLocator, "endpoint", rhsEndpoint), lhsEndpoint, rhsEndpoint, this.endpoint != null && !this.endpoint.isEmpty(), that.endpoint != null && !that.endpoint.isEmpty())) {
            return false;
        }
        UnsignedInt lhsReliableCache = this.getReliableCache();
        UnsignedInt rhsReliableCache = that.getReliableCache();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "reliableCache", lhsReliableCache), (ObjectLocator)LocatorUtils.property(thatLocator, "reliableCache", rhsReliableCache), lhsReliableCache, rhsReliableCache, this.reliableCache != null, that.reliableCache != null)) {
            return false;
        }
        String lhsDocumentation = this.getDocumentation();
        String rhsDocumentation = that.getDocumentation();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "documentation", lhsDocumentation), (ObjectLocator)LocatorUtils.property(thatLocator, "documentation", rhsDocumentation), lhsDocumentation, rhsDocumentation, this.documentation != null, that.documentation != null)) {
            return false;
        }
        List<ConformanceEvent> lhsEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        List<ConformanceEvent> rhsEvent = that.event != null && !that.event.isEmpty() ? that.getEvent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "event", lhsEvent), (ObjectLocator)LocatorUtils.property(thatLocator, "event", rhsEvent), lhsEvent, rhsEvent, this.event != null && !this.event.isEmpty(), that.event != null && !that.event.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<ConformanceEndpoint> theEndpoint = this.endpoint != null && !this.endpoint.isEmpty() ? this.getEndpoint() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "endpoint", theEndpoint), currentHashCode, theEndpoint, this.endpoint != null && !this.endpoint.isEmpty());
        UnsignedInt theReliableCache = this.getReliableCache();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "reliableCache", theReliableCache), currentHashCode, theReliableCache, this.reliableCache != null);
        String theDocumentation = this.getDocumentation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "documentation", theDocumentation), currentHashCode, theDocumentation, this.documentation != null);
        List<ConformanceEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "event", theEvent), currentHashCode, theEvent, this.event != null && !this.event.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<ConformanceEndpoint> theEndpoint = this.endpoint != null && !this.endpoint.isEmpty() ? this.getEndpoint() : null;
        strategy.appendField(locator, (Object)this, "endpoint", buffer, theEndpoint, this.endpoint != null && !this.endpoint.isEmpty());
        UnsignedInt theReliableCache = this.getReliableCache();
        strategy.appendField(locator, (Object)this, "reliableCache", buffer, theReliableCache, this.reliableCache != null);
        String theDocumentation = this.getDocumentation();
        strategy.appendField(locator, (Object)this, "documentation", buffer, theDocumentation, this.documentation != null);
        List<ConformanceEvent> theEvent = this.event != null && !this.event.isEmpty() ? this.getEvent() : null;
        strategy.appendField(locator, (Object)this, "event", buffer, theEvent, this.event != null && !this.event.isEmpty());
        return buffer;
    }
}

