/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.Coding;
import org.hl7.fhir.ConformanceEventMode;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MessageSignificanceCategory;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Conformance.Event", propOrder={"code", "category", "mode", "focus", "request", "response", "documentation"})
public class ConformanceEvent
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    @XmlElement(required=true)
    protected Coding code;
    protected MessageSignificanceCategory category;
    @XmlElement(required=true)
    protected ConformanceEventMode mode;
    @XmlElement(required=true)
    protected Code focus;
    @XmlElement(required=true)
    protected Reference request;
    @XmlElement(required=true)
    protected Reference response;
    protected String documentation;

    public Coding getCode() {
        return this.code;
    }

    public void setCode(Coding value) {
        this.code = value;
    }

    public MessageSignificanceCategory getCategory() {
        return this.category;
    }

    public void setCategory(MessageSignificanceCategory value) {
        this.category = value;
    }

    public ConformanceEventMode getMode() {
        return this.mode;
    }

    public void setMode(ConformanceEventMode value) {
        this.mode = value;
    }

    public Code getFocus() {
        return this.focus;
    }

    public void setFocus(Code value) {
        this.focus = value;
    }

    public Reference getRequest() {
        return this.request;
    }

    public void setRequest(Reference value) {
        this.request = value;
    }

    public Reference getResponse() {
        return this.response;
    }

    public void setResponse(Reference value) {
        this.response = value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String value) {
        this.documentation = value;
    }

    public ConformanceEvent withCode(Coding value) {
        this.setCode(value);
        return this;
    }

    public ConformanceEvent withCategory(MessageSignificanceCategory value) {
        this.setCategory(value);
        return this;
    }

    public ConformanceEvent withMode(ConformanceEventMode value) {
        this.setMode(value);
        return this;
    }

    public ConformanceEvent withFocus(Code value) {
        this.setFocus(value);
        return this;
    }

    public ConformanceEvent withRequest(Reference value) {
        this.setRequest(value);
        return this;
    }

    public ConformanceEvent withResponse(Reference value) {
        this.setResponse(value);
        return this;
    }

    public ConformanceEvent withDocumentation(String value) {
        this.setDocumentation(value);
        return this;
    }

    @Override
    public ConformanceEvent withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceEvent withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceEvent withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConformanceEvent withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConformanceEvent withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConformanceEvent that = (ConformanceEvent)object;
        Coding lhsCode = this.getCode();
        Coding rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        MessageSignificanceCategory lhsCategory = this.getCategory();
        MessageSignificanceCategory rhsCategory = that.getCategory();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null, that.category != null)) {
            return false;
        }
        ConformanceEventMode lhsMode = this.getMode();
        ConformanceEventMode rhsMode = that.getMode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "mode", lhsMode), (ObjectLocator)LocatorUtils.property(thatLocator, "mode", rhsMode), lhsMode, rhsMode, this.mode != null, that.mode != null)) {
            return false;
        }
        Code lhsFocus = this.getFocus();
        Code rhsFocus = that.getFocus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "focus", lhsFocus), (ObjectLocator)LocatorUtils.property(thatLocator, "focus", rhsFocus), lhsFocus, rhsFocus, this.focus != null, that.focus != null)) {
            return false;
        }
        Reference lhsRequest = this.getRequest();
        Reference rhsRequest = that.getRequest();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "request", lhsRequest), (ObjectLocator)LocatorUtils.property(thatLocator, "request", rhsRequest), lhsRequest, rhsRequest, this.request != null, that.request != null)) {
            return false;
        }
        Reference lhsResponse = this.getResponse();
        Reference rhsResponse = that.getResponse();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "response", lhsResponse), (ObjectLocator)LocatorUtils.property(thatLocator, "response", rhsResponse), lhsResponse, rhsResponse, this.response != null, that.response != null)) {
            return false;
        }
        String lhsDocumentation = this.getDocumentation();
        String rhsDocumentation = that.getDocumentation();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "documentation", lhsDocumentation), (ObjectLocator)LocatorUtils.property(thatLocator, "documentation", rhsDocumentation), lhsDocumentation, rhsDocumentation, this.documentation != null, that.documentation != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Coding theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        MessageSignificanceCategory theCategory = this.getCategory();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null);
        ConformanceEventMode theMode = this.getMode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "mode", theMode), currentHashCode, theMode, this.mode != null);
        Code theFocus = this.getFocus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "focus", theFocus), currentHashCode, theFocus, this.focus != null);
        Reference theRequest = this.getRequest();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "request", theRequest), currentHashCode, theRequest, this.request != null);
        Reference theResponse = this.getResponse();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "response", theResponse), currentHashCode, theResponse, this.response != null);
        String theDocumentation = this.getDocumentation();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "documentation", theDocumentation), currentHashCode, theDocumentation, this.documentation != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Coding theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        MessageSignificanceCategory theCategory = this.getCategory();
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null);
        ConformanceEventMode theMode = this.getMode();
        strategy.appendField(locator, (Object)this, "mode", buffer, theMode, this.mode != null);
        Code theFocus = this.getFocus();
        strategy.appendField(locator, (Object)this, "focus", buffer, theFocus, this.focus != null);
        Reference theRequest = this.getRequest();
        strategy.appendField(locator, (Object)this, "request", buffer, theRequest, this.request != null);
        Reference theResponse = this.getResponse();
        strategy.appendField(locator, (Object)this, "response", buffer, theResponse, this.response != null);
        String theDocumentation = this.getDocumentation();
        strategy.appendField(locator, (Object)this, "documentation", buffer, theDocumentation, this.documentation != null);
        return buffer;
    }
}

