/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Condition.Stage", propOrder={"summary", "assessment"})
public class ConditionStage
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept summary;
    protected List<Reference> assessment;

    public CodeableConcept getSummary() {
        return this.summary;
    }

    public void setSummary(CodeableConcept value) {
        this.summary = value;
    }

    public List<Reference> getAssessment() {
        if (this.assessment == null) {
            this.assessment = new ArrayList<Reference>();
        }
        return this.assessment;
    }

    public ConditionStage withSummary(CodeableConcept value) {
        this.setSummary(value);
        return this;
    }

    public ConditionStage withAssessment(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAssessment().add(value);
            }
        }
        return this;
    }

    public ConditionStage withAssessment(Collection<Reference> values) {
        if (values != null) {
            this.getAssessment().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConditionStage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ConditionStage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ConditionStage withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ConditionStage that = (ConditionStage)object;
        CodeableConcept lhsSummary = this.getSummary();
        CodeableConcept rhsSummary = that.getSummary();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "summary", lhsSummary), (ObjectLocator)LocatorUtils.property(thatLocator, "summary", rhsSummary), lhsSummary, rhsSummary, this.summary != null, that.summary != null)) {
            return false;
        }
        List<Reference> lhsAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        List<Reference> rhsAssessment = that.assessment != null && !that.assessment.isEmpty() ? that.getAssessment() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "assessment", lhsAssessment), (ObjectLocator)LocatorUtils.property(thatLocator, "assessment", rhsAssessment), lhsAssessment, rhsAssessment, this.assessment != null && !this.assessment.isEmpty(), that.assessment != null && !that.assessment.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theSummary = this.getSummary();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "summary", theSummary), currentHashCode, theSummary, this.summary != null);
        List<Reference> theAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "assessment", theAssessment), currentHashCode, theAssessment, this.assessment != null && !this.assessment.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theSummary = this.getSummary();
        strategy.appendField(locator, (Object)this, "summary", buffer, theSummary, this.summary != null);
        List<Reference> theAssessment = this.assessment != null && !this.assessment.isEmpty() ? this.getAssessment() : null;
        strategy.appendField(locator, (Object)this, "assessment", buffer, theAssessment, this.assessment != null && !this.assessment.isEmpty());
        return buffer;
    }
}

