/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Composition.Section", propOrder={"title", "code", "text", "mode", "orderedBy", "entry", "emptyReason", "section"})
public class CompositionSection
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected String title;
    protected CodeableConcept code;
    protected Narrative text;
    protected Code mode;
    protected CodeableConcept orderedBy;
    protected List<Reference> entry;
    protected CodeableConcept emptyReason;
    protected List<CompositionSection> section;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public void setCode(CodeableConcept value) {
        this.code = value;
    }

    public Narrative getText() {
        return this.text;
    }

    public void setText(Narrative value) {
        this.text = value;
    }

    public Code getMode() {
        return this.mode;
    }

    public void setMode(Code value) {
        this.mode = value;
    }

    public CodeableConcept getOrderedBy() {
        return this.orderedBy;
    }

    public void setOrderedBy(CodeableConcept value) {
        this.orderedBy = value;
    }

    public List<Reference> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<Reference>();
        }
        return this.entry;
    }

    public CodeableConcept getEmptyReason() {
        return this.emptyReason;
    }

    public void setEmptyReason(CodeableConcept value) {
        this.emptyReason = value;
    }

    public List<CompositionSection> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<CompositionSection>();
        }
        return this.section;
    }

    public CompositionSection withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public CompositionSection withCode(CodeableConcept value) {
        this.setCode(value);
        return this;
    }

    public CompositionSection withText(Narrative value) {
        this.setText(value);
        return this;
    }

    public CompositionSection withMode(Code value) {
        this.setMode(value);
        return this;
    }

    public CompositionSection withOrderedBy(CodeableConcept value) {
        this.setOrderedBy(value);
        return this;
    }

    public CompositionSection withEntry(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getEntry().add(value);
            }
        }
        return this;
    }

    public CompositionSection withEntry(Collection<Reference> values) {
        if (values != null) {
            this.getEntry().addAll(values);
        }
        return this;
    }

    public CompositionSection withEmptyReason(CodeableConcept value) {
        this.setEmptyReason(value);
        return this;
    }

    public CompositionSection withSection(CompositionSection ... values) {
        if (values != null) {
            for (CompositionSection value : values) {
                this.getSection().add(value);
            }
        }
        return this;
    }

    public CompositionSection withSection(Collection<CompositionSection> values) {
        if (values != null) {
            this.getSection().addAll(values);
        }
        return this;
    }

    @Override
    public CompositionSection withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CompositionSection withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CompositionSection withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CompositionSection withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CompositionSection withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CompositionSection that = (CompositionSection)object;
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "title", lhsTitle), (ObjectLocator)LocatorUtils.property(thatLocator, "title", rhsTitle), lhsTitle, rhsTitle, this.title != null, that.title != null)) {
            return false;
        }
        CodeableConcept lhsCode = this.getCode();
        CodeableConcept rhsCode = that.getCode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "code", lhsCode), (ObjectLocator)LocatorUtils.property(thatLocator, "code", rhsCode), lhsCode, rhsCode, this.code != null, that.code != null)) {
            return false;
        }
        Narrative lhsText = this.getText();
        Narrative rhsText = that.getText();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "text", lhsText), (ObjectLocator)LocatorUtils.property(thatLocator, "text", rhsText), lhsText, rhsText, this.text != null, that.text != null)) {
            return false;
        }
        Code lhsMode = this.getMode();
        Code rhsMode = that.getMode();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "mode", lhsMode), (ObjectLocator)LocatorUtils.property(thatLocator, "mode", rhsMode), lhsMode, rhsMode, this.mode != null, that.mode != null)) {
            return false;
        }
        CodeableConcept lhsOrderedBy = this.getOrderedBy();
        CodeableConcept rhsOrderedBy = that.getOrderedBy();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "orderedBy", lhsOrderedBy), (ObjectLocator)LocatorUtils.property(thatLocator, "orderedBy", rhsOrderedBy), lhsOrderedBy, rhsOrderedBy, this.orderedBy != null, that.orderedBy != null)) {
            return false;
        }
        List<Reference> lhsEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        List<Reference> rhsEntry = that.entry != null && !that.entry.isEmpty() ? that.getEntry() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "entry", lhsEntry), (ObjectLocator)LocatorUtils.property(thatLocator, "entry", rhsEntry), lhsEntry, rhsEntry, this.entry != null && !this.entry.isEmpty(), that.entry != null && !that.entry.isEmpty())) {
            return false;
        }
        CodeableConcept lhsEmptyReason = this.getEmptyReason();
        CodeableConcept rhsEmptyReason = that.getEmptyReason();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "emptyReason", lhsEmptyReason), (ObjectLocator)LocatorUtils.property(thatLocator, "emptyReason", rhsEmptyReason), lhsEmptyReason, rhsEmptyReason, this.emptyReason != null, that.emptyReason != null)) {
            return false;
        }
        List<CompositionSection> lhsSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        List<CompositionSection> rhsSection = that.section != null && !that.section.isEmpty() ? that.getSection() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "section", lhsSection), (ObjectLocator)LocatorUtils.property(thatLocator, "section", rhsSection), lhsSection, rhsSection, this.section != null && !this.section.isEmpty(), that.section != null && !that.section.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "title", theTitle), currentHashCode, theTitle, this.title != null);
        CodeableConcept theCode = this.getCode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "code", theCode), currentHashCode, theCode, this.code != null);
        Narrative theText = this.getText();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "text", theText), currentHashCode, theText, this.text != null);
        Code theMode = this.getMode();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "mode", theMode), currentHashCode, theMode, this.mode != null);
        CodeableConcept theOrderedBy = this.getOrderedBy();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "orderedBy", theOrderedBy), currentHashCode, theOrderedBy, this.orderedBy != null);
        List<Reference> theEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "entry", theEntry), currentHashCode, theEntry, this.entry != null && !this.entry.isEmpty());
        CodeableConcept theEmptyReason = this.getEmptyReason();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "emptyReason", theEmptyReason), currentHashCode, theEmptyReason, this.emptyReason != null);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "section", theSection), currentHashCode, theSection, this.section != null && !this.section.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, theTitle, this.title != null);
        CodeableConcept theCode = this.getCode();
        strategy.appendField(locator, (Object)this, "code", buffer, theCode, this.code != null);
        Narrative theText = this.getText();
        strategy.appendField(locator, (Object)this, "text", buffer, theText, this.text != null);
        Code theMode = this.getMode();
        strategy.appendField(locator, (Object)this, "mode", buffer, theMode, this.mode != null);
        CodeableConcept theOrderedBy = this.getOrderedBy();
        strategy.appendField(locator, (Object)this, "orderedBy", buffer, theOrderedBy, this.orderedBy != null);
        List<Reference> theEntry = this.entry != null && !this.entry.isEmpty() ? this.getEntry() : null;
        strategy.appendField(locator, (Object)this, "entry", buffer, theEntry, this.entry != null && !this.entry.isEmpty());
        CodeableConcept theEmptyReason = this.getEmptyReason();
        strategy.appendField(locator, (Object)this, "emptyReason", buffer, theEmptyReason, this.emptyReason != null);
        List<CompositionSection> theSection = this.section != null && !this.section.isEmpty() ? this.getSection() : null;
        strategy.appendField(locator, (Object)this, "section", buffer, theSection, this.section != null && !this.section.isEmpty());
        return buffer;
    }
}

