/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.Annotation;
import org.hl7.fhir.CarePlanActivity;
import org.hl7.fhir.CarePlanParticipant;
import org.hl7.fhir.CarePlanRelatedPlan;
import org.hl7.fhir.CarePlanStatus;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.DateTime;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CarePlan", propOrder={"identifier", "subject", "status", "context", "period", "author", "modified", "category", "description", "addresses", "support", "relatedPlan", "participant", "goal", "activity", "note"})
public class CarePlan
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected Reference subject;
    @XmlElement(required=true)
    protected CarePlanStatus status;
    protected Reference context;
    protected Period period;
    protected List<Reference> author;
    protected DateTime modified;
    protected List<CodeableConcept> category;
    protected String description;
    protected List<Reference> addresses;
    protected List<Reference> support;
    protected List<CarePlanRelatedPlan> relatedPlan;
    protected List<CarePlanParticipant> participant;
    protected List<Reference> goal;
    protected List<CarePlanActivity> activity;
    protected Annotation note;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public CarePlanStatus getStatus() {
        return this.status;
    }

    public void setStatus(CarePlanStatus value) {
        this.status = value;
    }

    public Reference getContext() {
        return this.context;
    }

    public void setContext(Reference value) {
        this.context = value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime value) {
        this.modified = value;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public List<Reference> getSupport() {
        if (this.support == null) {
            this.support = new ArrayList<Reference>();
        }
        return this.support;
    }

    public List<CarePlanRelatedPlan> getRelatedPlan() {
        if (this.relatedPlan == null) {
            this.relatedPlan = new ArrayList<CarePlanRelatedPlan>();
        }
        return this.relatedPlan;
    }

    public List<CarePlanParticipant> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<CarePlanParticipant>();
        }
        return this.participant;
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public List<CarePlanActivity> getActivity() {
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivity>();
        }
        return this.activity;
    }

    public Annotation getNote() {
        return this.note;
    }

    public void setNote(Annotation value) {
        this.note = value;
    }

    public CarePlan withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public CarePlan withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public CarePlan withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public CarePlan withStatus(CarePlanStatus value) {
        this.setStatus(value);
        return this;
    }

    public CarePlan withContext(Reference value) {
        this.setContext(value);
        return this;
    }

    public CarePlan withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public CarePlan withAuthor(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAuthor().add(value);
            }
        }
        return this;
    }

    public CarePlan withAuthor(Collection<Reference> values) {
        if (values != null) {
            this.getAuthor().addAll(values);
        }
        return this;
    }

    public CarePlan withModified(DateTime value) {
        this.setModified(value);
        return this;
    }

    public CarePlan withCategory(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getCategory().add(value);
            }
        }
        return this;
    }

    public CarePlan withCategory(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getCategory().addAll(values);
        }
        return this;
    }

    public CarePlan withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public CarePlan withAddresses(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getAddresses().add(value);
            }
        }
        return this;
    }

    public CarePlan withAddresses(Collection<Reference> values) {
        if (values != null) {
            this.getAddresses().addAll(values);
        }
        return this;
    }

    public CarePlan withSupport(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getSupport().add(value);
            }
        }
        return this;
    }

    public CarePlan withSupport(Collection<Reference> values) {
        if (values != null) {
            this.getSupport().addAll(values);
        }
        return this;
    }

    public CarePlan withRelatedPlan(CarePlanRelatedPlan ... values) {
        if (values != null) {
            for (CarePlanRelatedPlan value : values) {
                this.getRelatedPlan().add(value);
            }
        }
        return this;
    }

    public CarePlan withRelatedPlan(Collection<CarePlanRelatedPlan> values) {
        if (values != null) {
            this.getRelatedPlan().addAll(values);
        }
        return this;
    }

    public CarePlan withParticipant(CarePlanParticipant ... values) {
        if (values != null) {
            for (CarePlanParticipant value : values) {
                this.getParticipant().add(value);
            }
        }
        return this;
    }

    public CarePlan withParticipant(Collection<CarePlanParticipant> values) {
        if (values != null) {
            this.getParticipant().addAll(values);
        }
        return this;
    }

    public CarePlan withGoal(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getGoal().add(value);
            }
        }
        return this;
    }

    public CarePlan withGoal(Collection<Reference> values) {
        if (values != null) {
            this.getGoal().addAll(values);
        }
        return this;
    }

    public CarePlan withActivity(CarePlanActivity ... values) {
        if (values != null) {
            for (CarePlanActivity value : values) {
                this.getActivity().add(value);
            }
        }
        return this;
    }

    public CarePlan withActivity(Collection<CarePlanActivity> values) {
        if (values != null) {
            this.getActivity().addAll(values);
        }
        return this;
    }

    public CarePlan withNote(Annotation value) {
        this.setNote(value);
        return this;
    }

    @Override
    public CarePlan withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public CarePlan withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlan withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlan withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlan withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlan withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public CarePlan withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public CarePlan withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public CarePlan withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public CarePlan withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public CarePlan withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        CarePlan that = (CarePlan)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        CarePlanStatus lhsStatus = this.getStatus();
        CarePlanStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Reference lhsContext = this.getContext();
        Reference rhsContext = that.getContext();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "context", lhsContext), (ObjectLocator)LocatorUtils.property(thatLocator, "context", rhsContext), lhsContext, rhsContext, this.context != null, that.context != null)) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "period", lhsPeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "period", rhsPeriod), lhsPeriod, rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        List<Reference> lhsAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        List<Reference> rhsAuthor = that.author != null && !that.author.isEmpty() ? that.getAuthor() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "author", lhsAuthor), (ObjectLocator)LocatorUtils.property(thatLocator, "author", rhsAuthor), lhsAuthor, rhsAuthor, this.author != null && !this.author.isEmpty(), that.author != null && !that.author.isEmpty())) {
            return false;
        }
        DateTime lhsModified = this.getModified();
        DateTime rhsModified = that.getModified();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "modified", lhsModified), (ObjectLocator)LocatorUtils.property(thatLocator, "modified", rhsModified), lhsModified, rhsModified, this.modified != null, that.modified != null)) {
            return false;
        }
        List<CodeableConcept> lhsCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        List<CodeableConcept> rhsCategory = that.category != null && !that.category.isEmpty() ? that.getCategory() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "category", lhsCategory), (ObjectLocator)LocatorUtils.property(thatLocator, "category", rhsCategory), lhsCategory, rhsCategory, this.category != null && !this.category.isEmpty(), that.category != null && !that.category.isEmpty())) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        List<Reference> lhsAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        List<Reference> rhsAddresses = that.addresses != null && !that.addresses.isEmpty() ? that.getAddresses() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "addresses", lhsAddresses), (ObjectLocator)LocatorUtils.property(thatLocator, "addresses", rhsAddresses), lhsAddresses, rhsAddresses, this.addresses != null && !this.addresses.isEmpty(), that.addresses != null && !that.addresses.isEmpty())) {
            return false;
        }
        List<Reference> lhsSupport = this.support != null && !this.support.isEmpty() ? this.getSupport() : null;
        List<Reference> rhsSupport = that.support != null && !that.support.isEmpty() ? that.getSupport() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "support", lhsSupport), (ObjectLocator)LocatorUtils.property(thatLocator, "support", rhsSupport), lhsSupport, rhsSupport, this.support != null && !this.support.isEmpty(), that.support != null && !that.support.isEmpty())) {
            return false;
        }
        List<CarePlanRelatedPlan> lhsRelatedPlan = this.relatedPlan != null && !this.relatedPlan.isEmpty() ? this.getRelatedPlan() : null;
        List<CarePlanRelatedPlan> rhsRelatedPlan = that.relatedPlan != null && !that.relatedPlan.isEmpty() ? that.getRelatedPlan() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "relatedPlan", lhsRelatedPlan), (ObjectLocator)LocatorUtils.property(thatLocator, "relatedPlan", rhsRelatedPlan), lhsRelatedPlan, rhsRelatedPlan, this.relatedPlan != null && !this.relatedPlan.isEmpty(), that.relatedPlan != null && !that.relatedPlan.isEmpty())) {
            return false;
        }
        List<CarePlanParticipant> lhsParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        List<CarePlanParticipant> rhsParticipant = that.participant != null && !that.participant.isEmpty() ? that.getParticipant() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "participant", lhsParticipant), (ObjectLocator)LocatorUtils.property(thatLocator, "participant", rhsParticipant), lhsParticipant, rhsParticipant, this.participant != null && !this.participant.isEmpty(), that.participant != null && !that.participant.isEmpty())) {
            return false;
        }
        List<Reference> lhsGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        List<Reference> rhsGoal = that.goal != null && !that.goal.isEmpty() ? that.getGoal() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "goal", lhsGoal), (ObjectLocator)LocatorUtils.property(thatLocator, "goal", rhsGoal), lhsGoal, rhsGoal, this.goal != null && !this.goal.isEmpty(), that.goal != null && !that.goal.isEmpty())) {
            return false;
        }
        List<CarePlanActivity> lhsActivity = this.activity != null && !this.activity.isEmpty() ? this.getActivity() : null;
        List<CarePlanActivity> rhsActivity = that.activity != null && !that.activity.isEmpty() ? that.getActivity() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "activity", lhsActivity), (ObjectLocator)LocatorUtils.property(thatLocator, "activity", rhsActivity), lhsActivity, rhsActivity, this.activity != null && !this.activity.isEmpty(), that.activity != null && !that.activity.isEmpty())) {
            return false;
        }
        Annotation lhsNote = this.getNote();
        Annotation rhsNote = that.getNote();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "note", lhsNote), (ObjectLocator)LocatorUtils.property(thatLocator, "note", rhsNote), lhsNote, rhsNote, this.note != null, that.note != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        CarePlanStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Reference theContext = this.getContext();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "context", theContext), currentHashCode, theContext, this.context != null);
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "period", thePeriod), currentHashCode, thePeriod, this.period != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "author", theAuthor), currentHashCode, theAuthor, this.author != null && !this.author.isEmpty());
        DateTime theModified = this.getModified();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "modified", theModified), currentHashCode, theModified, this.modified != null);
        List<CodeableConcept> theCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "category", theCategory), currentHashCode, theCategory, this.category != null && !this.category.isEmpty());
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        List<Reference> theAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "addresses", theAddresses), currentHashCode, theAddresses, this.addresses != null && !this.addresses.isEmpty());
        List<Reference> theSupport = this.support != null && !this.support.isEmpty() ? this.getSupport() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "support", theSupport), currentHashCode, theSupport, this.support != null && !this.support.isEmpty());
        List<CarePlanRelatedPlan> theRelatedPlan = this.relatedPlan != null && !this.relatedPlan.isEmpty() ? this.getRelatedPlan() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "relatedPlan", theRelatedPlan), currentHashCode, theRelatedPlan, this.relatedPlan != null && !this.relatedPlan.isEmpty());
        List<CarePlanParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "participant", theParticipant), currentHashCode, theParticipant, this.participant != null && !this.participant.isEmpty());
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "goal", theGoal), currentHashCode, theGoal, this.goal != null && !this.goal.isEmpty());
        List<CarePlanActivity> theActivity = this.activity != null && !this.activity.isEmpty() ? this.getActivity() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "activity", theActivity), currentHashCode, theActivity, this.activity != null && !this.activity.isEmpty());
        Annotation theNote = this.getNote();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "note", theNote), currentHashCode, theNote, this.note != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        CarePlanStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Reference theContext = this.getContext();
        strategy.appendField(locator, (Object)this, "context", buffer, theContext, this.context != null);
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, thePeriod, this.period != null);
        List<Reference> theAuthor = this.author != null && !this.author.isEmpty() ? this.getAuthor() : null;
        strategy.appendField(locator, (Object)this, "author", buffer, theAuthor, this.author != null && !this.author.isEmpty());
        DateTime theModified = this.getModified();
        strategy.appendField(locator, (Object)this, "modified", buffer, theModified, this.modified != null);
        List<CodeableConcept> theCategory = this.category != null && !this.category.isEmpty() ? this.getCategory() : null;
        strategy.appendField(locator, (Object)this, "category", buffer, theCategory, this.category != null && !this.category.isEmpty());
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        List<Reference> theAddresses = this.addresses != null && !this.addresses.isEmpty() ? this.getAddresses() : null;
        strategy.appendField(locator, (Object)this, "addresses", buffer, theAddresses, this.addresses != null && !this.addresses.isEmpty());
        List<Reference> theSupport = this.support != null && !this.support.isEmpty() ? this.getSupport() : null;
        strategy.appendField(locator, (Object)this, "support", buffer, theSupport, this.support != null && !this.support.isEmpty());
        List<CarePlanRelatedPlan> theRelatedPlan = this.relatedPlan != null && !this.relatedPlan.isEmpty() ? this.getRelatedPlan() : null;
        strategy.appendField(locator, (Object)this, "relatedPlan", buffer, theRelatedPlan, this.relatedPlan != null && !this.relatedPlan.isEmpty());
        List<CarePlanParticipant> theParticipant = this.participant != null && !this.participant.isEmpty() ? this.getParticipant() : null;
        strategy.appendField(locator, (Object)this, "participant", buffer, theParticipant, this.participant != null && !this.participant.isEmpty());
        List<Reference> theGoal = this.goal != null && !this.goal.isEmpty() ? this.getGoal() : null;
        strategy.appendField(locator, (Object)this, "goal", buffer, theGoal, this.goal != null && !this.goal.isEmpty());
        List<CarePlanActivity> theActivity = this.activity != null && !this.activity.isEmpty() ? this.getActivity() : null;
        strategy.appendField(locator, (Object)this, "activity", buffer, theActivity, this.activity != null && !this.activity.isEmpty());
        Annotation theNote = this.getNote();
        strategy.appendField(locator, (Object)this, "note", buffer, theNote, this.note != null);
        return buffer;
    }
}

