/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.hl7.fhir.AccountStatus;
import org.hl7.fhir.Code;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Coding;
import org.hl7.fhir.DomainResource;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Id;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Meta;
import org.hl7.fhir.Money;
import org.hl7.fhir.Narrative;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.hl7.fhir.ResourceContainer;
import org.hl7.fhir.String;
import org.hl7.fhir.Uri;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Account", propOrder={"identifier", "name", "type", "status", "activePeriod", "currency", "balance", "coveragePeriod", "subject", "owner", "description"})
public class Account
extends DomainResource
implements Equals2,
HashCode2,
ToString2 {
    protected List<Identifier> identifier;
    protected String name;
    protected CodeableConcept type;
    protected AccountStatus status;
    protected Period activePeriod;
    protected Coding currency;
    protected Money balance;
    protected Period coveragePeriod;
    protected Reference subject;
    protected Reference owner;
    protected String description;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public void setType(CodeableConcept value) {
        this.type = value;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus value) {
        this.status = value;
    }

    public Period getActivePeriod() {
        return this.activePeriod;
    }

    public void setActivePeriod(Period value) {
        this.activePeriod = value;
    }

    public Coding getCurrency() {
        return this.currency;
    }

    public void setCurrency(Coding value) {
        this.currency = value;
    }

    public Money getBalance() {
        return this.balance;
    }

    public void setBalance(Money value) {
        this.balance = value;
    }

    public Period getCoveragePeriod() {
        return this.coveragePeriod;
    }

    public void setCoveragePeriod(Period value) {
        this.coveragePeriod = value;
    }

    public Reference getSubject() {
        return this.subject;
    }

    public void setSubject(Reference value) {
        this.subject = value;
    }

    public Reference getOwner() {
        return this.owner;
    }

    public void setOwner(Reference value) {
        this.owner = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Account withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public Account withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public Account withName(String value) {
        this.setName(value);
        return this;
    }

    public Account withType(CodeableConcept value) {
        this.setType(value);
        return this;
    }

    public Account withStatus(AccountStatus value) {
        this.setStatus(value);
        return this;
    }

    public Account withActivePeriod(Period value) {
        this.setActivePeriod(value);
        return this;
    }

    public Account withCurrency(Coding value) {
        this.setCurrency(value);
        return this;
    }

    public Account withBalance(Money value) {
        this.setBalance(value);
        return this;
    }

    public Account withCoveragePeriod(Period value) {
        this.setCoveragePeriod(value);
        return this;
    }

    public Account withSubject(Reference value) {
        this.setSubject(value);
        return this;
    }

    public Account withOwner(Reference value) {
        this.setOwner(value);
        return this;
    }

    public Account withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    @Override
    public Account withText(Narrative value) {
        this.setText(value);
        return this;
    }

    @Override
    public Account withContained(ResourceContainer ... values) {
        if (values != null) {
            for (ResourceContainer value : values) {
                this.getContained().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withContained(Collection<ResourceContainer> values) {
        if (values != null) {
            this.getContained().addAll(values);
        }
        return this;
    }

    @Override
    public Account withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Account withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public Account withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public Account withId(Id value) {
        this.setId(value);
        return this;
    }

    @Override
    public Account withMeta(Meta value) {
        this.setMeta(value);
        return this;
    }

    @Override
    public Account withImplicitRules(Uri value) {
        this.setImplicitRules(value);
        return this;
    }

    @Override
    public Account withLanguage(Code value) {
        this.setLanguage(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        Account that = (Account)object;
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property(thatLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        String lhsName = this.getName();
        String rhsName = that.getName();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "name", lhsName), (ObjectLocator)LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName, this.name != null, that.name != null)) {
            return false;
        }
        CodeableConcept lhsType = this.getType();
        CodeableConcept rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "type", lhsType), (ObjectLocator)LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType, this.type != null, that.type != null)) {
            return false;
        }
        AccountStatus lhsStatus = this.getStatus();
        AccountStatus rhsStatus = that.getStatus();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "status", lhsStatus), (ObjectLocator)LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus, this.status != null, that.status != null)) {
            return false;
        }
        Period lhsActivePeriod = this.getActivePeriod();
        Period rhsActivePeriod = that.getActivePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "activePeriod", lhsActivePeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "activePeriod", rhsActivePeriod), lhsActivePeriod, rhsActivePeriod, this.activePeriod != null, that.activePeriod != null)) {
            return false;
        }
        Coding lhsCurrency = this.getCurrency();
        Coding rhsCurrency = that.getCurrency();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "currency", lhsCurrency), (ObjectLocator)LocatorUtils.property(thatLocator, "currency", rhsCurrency), lhsCurrency, rhsCurrency, this.currency != null, that.currency != null)) {
            return false;
        }
        Money lhsBalance = this.getBalance();
        Money rhsBalance = that.getBalance();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "balance", lhsBalance), (ObjectLocator)LocatorUtils.property(thatLocator, "balance", rhsBalance), lhsBalance, rhsBalance, this.balance != null, that.balance != null)) {
            return false;
        }
        Period lhsCoveragePeriod = this.getCoveragePeriod();
        Period rhsCoveragePeriod = that.getCoveragePeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "coveragePeriod", lhsCoveragePeriod), (ObjectLocator)LocatorUtils.property(thatLocator, "coveragePeriod", rhsCoveragePeriod), lhsCoveragePeriod, rhsCoveragePeriod, this.coveragePeriod != null, that.coveragePeriod != null)) {
            return false;
        }
        Reference lhsSubject = this.getSubject();
        Reference rhsSubject = that.getSubject();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "subject", lhsSubject), (ObjectLocator)LocatorUtils.property(thatLocator, "subject", rhsSubject), lhsSubject, rhsSubject, this.subject != null, that.subject != null)) {
            return false;
        }
        Reference lhsOwner = this.getOwner();
        Reference rhsOwner = that.getOwner();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "owner", lhsOwner), (ObjectLocator)LocatorUtils.property(thatLocator, "owner", rhsOwner), lhsOwner, rhsOwner, this.owner != null, that.owner != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        return strategy.equals((ObjectLocator)LocatorUtils.property(thisLocator, "description", lhsDescription), (ObjectLocator)LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription, this.description != null, that.description != null);
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE2;
        return this.equals(null, null, object, strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theName = this.getName();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "name", theName), currentHashCode, theName, this.name != null);
        CodeableConcept theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "type", theType), currentHashCode, theType, this.type != null);
        AccountStatus theStatus = this.getStatus();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus, this.status != null);
        Period theActivePeriod = this.getActivePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "activePeriod", theActivePeriod), currentHashCode, theActivePeriod, this.activePeriod != null);
        Coding theCurrency = this.getCurrency();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "currency", theCurrency), currentHashCode, theCurrency, this.currency != null);
        Money theBalance = this.getBalance();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "balance", theBalance), currentHashCode, theBalance, this.balance != null);
        Period theCoveragePeriod = this.getCoveragePeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "coveragePeriod", theCoveragePeriod), currentHashCode, theCoveragePeriod, this.coveragePeriod != null);
        Reference theSubject = this.getSubject();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "subject", theSubject), currentHashCode, theSubject, this.subject != null);
        Reference theOwner = this.getOwner();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "owner", theOwner), currentHashCode, theOwner, this.owner != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription, this.description != null);
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.INSTANCE2;
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        String theName = this.getName();
        strategy.appendField(locator, (Object)this, "name", buffer, theName, this.name != null);
        CodeableConcept theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, theType, this.type != null);
        AccountStatus theStatus = this.getStatus();
        strategy.appendField(locator, (Object)this, "status", buffer, theStatus, this.status != null);
        Period theActivePeriod = this.getActivePeriod();
        strategy.appendField(locator, (Object)this, "activePeriod", buffer, theActivePeriod, this.activePeriod != null);
        Coding theCurrency = this.getCurrency();
        strategy.appendField(locator, (Object)this, "currency", buffer, theCurrency, this.currency != null);
        Money theBalance = this.getBalance();
        strategy.appendField(locator, (Object)this, "balance", buffer, theBalance, this.balance != null);
        Period theCoveragePeriod = this.getCoveragePeriod();
        strategy.appendField(locator, (Object)this, "coveragePeriod", buffer, theCoveragePeriod, this.coveragePeriod != null);
        Reference theSubject = this.getSubject();
        strategy.appendField(locator, (Object)this, "subject", buffer, theSubject, this.subject != null);
        Reference theOwner = this.getOwner();
        strategy.appendField(locator, (Object)this, "owner", buffer, theOwner, this.owner != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, theDescription, this.description != null);
        return buffer;
    }
}

