/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.cql.model;

import org.hl7.cql.model.DataType;
import org.hl7.cql.model.InstantiationContext;

public class IntervalType
extends DataType {
    private DataType pointType;

    public IntervalType(DataType pointType) {
        if (pointType == null) {
            throw new IllegalArgumentException("pointType");
        }
        this.pointType = pointType;
    }

    public DataType getPointType() {
        return this.pointType;
    }

    public int hashCode() {
        return 53 * this.pointType.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof IntervalType) {
            IntervalType that = (IntervalType)o;
            return this.pointType.equals(that.pointType);
        }
        return false;
    }

    @Override
    public boolean isSubTypeOf(DataType other) {
        if (other instanceof IntervalType) {
            IntervalType that = (IntervalType)other;
            return this.pointType.isSubTypeOf(that.pointType);
        }
        return super.isSubTypeOf(other);
    }

    @Override
    public boolean isSuperTypeOf(DataType other) {
        if (other instanceof IntervalType) {
            IntervalType that = (IntervalType)other;
            return this.pointType.isSuperTypeOf(that.pointType);
        }
        return super.isSuperTypeOf(other);
    }

    public String toString() {
        return String.format("interval<%s>", this.pointType.toString());
    }

    @Override
    public String toLabel() {
        return String.format("Interval of %s", this.pointType.toLabel());
    }

    @Override
    public boolean isGeneric() {
        return this.pointType.isGeneric();
    }

    @Override
    public boolean isInstantiable(DataType callType, InstantiationContext context) {
        if (callType instanceof IntervalType) {
            IntervalType intervalType = (IntervalType)callType;
            return this.pointType.isInstantiable(intervalType.pointType, context);
        }
        boolean isAlreadyInstantiable = false;
        for (IntervalType targetIntervalType : context.getIntervalConversionTargets(callType)) {
            boolean isInstantiable = this.pointType.isInstantiable(targetIntervalType.pointType, context);
            if (!isInstantiable) continue;
            if (isAlreadyInstantiable) {
                throw new IllegalArgumentException(String.format("Ambiguous generic instantiation involving %s to %s.", callType.toString(), targetIntervalType.toString()));
            }
            isAlreadyInstantiable = true;
        }
        return isAlreadyInstantiable;
    }

    @Override
    public DataType instantiate(InstantiationContext context) {
        return new IntervalType(this.pointType.instantiate(context));
    }
}

