/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REMatcher {
    static final int MAX_PAREN = 16;
    REProgram program;
    UnicodeString search;
    int matchFlags;
    int maxParen = 16;
    int parenCount;
    int[] startn;
    int[] endn;
    int[] startBackref;
    int[] endBackref;
    IntHashMap<IntSet> history;
    Operation[] instructions;
    boolean anchoredMatch;

    public REMatcher(REProgram program) {
        this.setProgram(program);
    }

    public void setProgram(REProgram program) {
        this.program = program;
        if (program != null && program.maxParens != -1) {
            this.instructions = program.instructions;
            this.maxParen = program.maxParens;
        } else {
            this.maxParen = 16;
        }
    }

    public REProgram getProgram() {
        return this.program;
    }

    public int getParenCount() {
        return this.parenCount;
    }

    public UnicodeString getParen(int which) {
        int start;
        if (which < this.parenCount && (start = this.getParenStart(which)) >= 0) {
            return this.search.substring(start, this.getParenEnd(which));
        }
        return null;
    }

    public final int getParenStart(int which) {
        if (which < this.startn.length) {
            return this.startn[which];
        }
        return -1;
    }

    public final int getParenEnd(int which) {
        if (which < this.endn.length) {
            return this.endn[which];
        }
        return -1;
    }

    public final int getParenLength(int which) {
        if (which < this.startn.length) {
            return this.getParenEnd(which) - this.getParenStart(which);
        }
        return -1;
    }

    protected final void setParenStart(int which, int i) {
        while (which > this.startn.length - 1) {
            int[] s2 = new int[this.startn.length * 2];
            System.arraycopy(this.startn, 0, s2, 0, this.startn.length);
            Arrays.fill(s2, this.startn.length, s2.length, -1);
            this.startn = s2;
        }
        this.startn[which] = i;
    }

    protected final void setParenEnd(int which, int i) {
        while (which > this.endn.length - 1) {
            int[] e2 = new int[this.endn.length * 2];
            System.arraycopy(this.endn, 0, e2, 0, this.endn.length);
            Arrays.fill(e2, this.endn.length, e2.length, -1);
            this.endn = e2;
        }
        this.endn[which] = i;
    }

    protected void internalError(String s2) throws Error {
        throw new Error("RE internal error: " + s2);
    }

    int matchNodes(int firstNode, int lastNode, int idx) {
        return this.matchNodes(firstNode, idx);
    }

    int matchNodes(int node, int idx) {
        block6: while (true) {
            Operation op;
            int idxNew;
            if ((idxNew = (op = this.instructions[node]).exec(this, node, idx)) != -1) {
                idx = idxNew;
            }
            switch (op.nextAction(idxNew)) {
                case 2: {
                    return idxNew;
                }
                case 1: {
                    node = op.next;
                    continue block6;
                }
                case 3: {
                    ++node;
                    continue block6;
                }
                case 4: {
                    node = this.instructions[op.next].next;
                    continue block6;
                }
            }
            break;
        }
        this.internalError("Unknown action");
        this.internalError("Corrupt program");
        return -1;
    }

    boolean beenHereBefore(int idx, int node) {
        IntSet previousVisitors;
        if (this.history == null) {
            this.history = new IntHashMap(Math.max(this.search.length(), 128));
        }
        if ((previousVisitors = this.history.get(idx)) != null && previousVisitors.contains(node)) {
            return true;
        }
        if (previousVisitors == null) {
            previousVisitors = new IntHashSet(4);
            this.history.put(idx, previousVisitors);
        }
        previousVisitors.add(node);
        return false;
    }

    protected boolean matchAt(int i, boolean anchored) {
        int idx;
        this.startn = new int[3];
        this.startn[2] = -1;
        this.startn[1] = -1;
        this.startn[0] = -1;
        this.endn = new int[3];
        this.endn[2] = -1;
        this.endn[1] = -1;
        this.endn[0] = -1;
        this.parenCount = 1;
        this.anchoredMatch = anchored;
        this.setParenStart(0, i);
        if ((this.program.optimizationFlags & 1) != 0) {
            this.startBackref = new int[this.maxParen];
            this.endBackref = new int[this.maxParen];
        }
        if ((idx = this.matchNodes(0, i)) != -1) {
            this.setParenEnd(0, idx);
            return true;
        }
        this.parenCount = 0;
        return false;
    }

    public boolean anchoredMatch(UnicodeString search) {
        this.search = search;
        return this.matchAt(0, true);
    }

    public boolean match(UnicodeString search, int i) {
        if (this.program == null) {
            this.internalError("No RE program to run!");
        }
        this.search = search;
        if ((this.program.optimizationFlags & 2) == 2) {
            if (!this.program.flags.isMultiLine()) {
                return i == 0 && this.matchAt(i, false);
            }
            while (!search.isEnd(i)) {
                if (!this.isNewline(i)) {
                    if (this.matchAt(i, false)) {
                        return true;
                    }
                    while (!search.isEnd(i) && !this.isNewline(i)) {
                        ++i;
                    }
                }
                ++i;
            }
            return false;
        }
        if (this.program.prefix == null) {
            if (this.program.initialCharClass != null) {
                IntPredicate pred = this.program.initialCharClass;
                while (!search.isEnd(i)) {
                    if (pred.matches(search.charAt(i)) && this.matchAt(i, false)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            while (!search.isEnd(i - 1)) {
                if (this.matchAt(i, false)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        UnicodeString prefix = this.program.prefix;
        while (!search.isEnd(i + prefix.length() - 1)) {
            int j = i;
            int k = 0;
            if (this.program.flags.isCaseIndependent()) {
                while (this.equalCaseBlind(search.charAt(j++), prefix.charAt(k++)) && k < prefix.length()) {
                }
            } else {
                while (search.charAt(j++) == prefix.charAt(k++) && k < prefix.length()) {
                }
            }
            if (k == prefix.length() && this.matchAt(i, false)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(String search) {
        return this.match(UnicodeString.makeUnicodeString(search), 0);
    }

    public List<UnicodeString> split(UnicodeString s2) {
        ArrayList<UnicodeString> v = new ArrayList<UnicodeString>();
        int pos = 0;
        int len = s2.length();
        while (pos < len && this.match(s2, pos)) {
            int start = this.getParenStart(0);
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                v.add(s2.substring(pos, start + 1));
            } else {
                v.add(s2.substring(pos, start));
            }
            pos = ++newpos;
        }
        UnicodeString remainder = s2.substring(pos, len);
        v.add(remainder);
        return v;
    }

    public CharSequence subst(UnicodeString in, UnicodeString replacement) {
        int i;
        FastStringBuffer sb = new FastStringBuffer(in.length() * 2);
        int pos = 0;
        int len = in.length();
        while (pos < len && this.match(in, pos)) {
            int newpos;
            for (i = pos; i < this.getParenStart(0); ++i) {
                sb.appendWideChar(in.charAt(i));
            }
            if (!this.program.flags.isLiteral()) {
                int maxCapture = this.getParenCount() - 1;
                for (int i2 = 0; i2 < replacement.length(); ++i2) {
                    int ch = replacement.charAt(i2);
                    if (ch == 92) {
                        if ((ch = replacement.charAt(++i2)) == 92 || ch == 36) {
                            sb.append((char)ch);
                            continue;
                        }
                        throw new RESyntaxException("Invalid escape in replacement string");
                    }
                    if (ch == 36) {
                        int j;
                        UnicodeString captured;
                        if ((ch = replacement.charAt(++i2)) < 48 || ch > 57) {
                            throw new RESyntaxException("$ in replacement must be followed by a digit");
                        }
                        int n = ch - 48;
                        if (maxCapture <= 9) {
                            if (maxCapture < n || (captured = this.getParen(n)) == null) continue;
                            for (j = 0; j < captured.length(); ++j) {
                                sb.appendWideChar(captured.charAt(j));
                            }
                            continue;
                        }
                        while (i2 < replacement.length()) {
                            if ((ch = replacement.charAt(++i2)) >= 48 && ch <= 57) {
                                int m3 = n * 10 + (ch - 48);
                                if (m3 > maxCapture) {
                                    --i2;
                                    break;
                                }
                                n = m3;
                                continue;
                            }
                            --i2;
                            break;
                        }
                        captured = this.getParen(n);
                        for (j = 0; j < captured.length(); ++j) {
                            sb.appendWideChar(captured.charAt(j));
                        }
                        continue;
                    }
                    sb.appendWideChar(ch);
                }
            } else {
                for (i = 0; i < replacement.length(); ++i) {
                    sb.appendWideChar(replacement.charAt(i));
                }
            }
            if ((newpos = this.getParenEnd(0)) == pos) {
                // empty if block
            }
            pos = ++newpos;
        }
        for (i = pos; i < len; ++i) {
            sb.appendWideChar(in.charAt(i));
        }
        return sb.condense();
    }

    boolean isNewline(int i) {
        return this.search.charAt(i) == 10;
    }

    boolean equalCaseBlind(int c1, int c2) {
        if (c1 == c2) {
            return true;
        }
        for (int v : CaseVariants.getCaseVariants(c2)) {
            if (c1 != v) continue;
            return true;
        }
        return false;
    }
}

