/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringAfter
extends CollatingFunction
implements Callable {
    protected int getCollationArgument() {
        return 2;
    }

    public StringValue evaluateItem(XPathContext context) throws XPathException {
        StringValue arg1 = (StringValue)this.argument[0].evaluateItem(context);
        StringValue arg2 = (StringValue)this.argument[1].evaluateItem(context);
        StringCollator collator = this.getCollator(context);
        return this.substringAfter(context, arg1, arg2, collator);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg1 = (StringValue)arguments[0].head();
        StringValue arg2 = (StringValue)arguments[1].head();
        StringCollator collator = this.getCollatorFromLastArgument(arguments, 2, context);
        return this.substringAfter(context, arg1, arg2, collator);
    }

    private StringValue substringAfter(XPathContext context, StringValue arg1, StringValue arg2, StringCollator collator) throws XPathException {
        if (arg1 == null) {
            arg1 = StringValue.EMPTY_STRING;
        }
        if (arg2 == null) {
            arg2 = StringValue.EMPTY_STRING;
        }
        if (arg2.isZeroLength()) {
            return arg1;
        }
        if (arg1.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        String s1 = arg1.getStringValue();
        String s2 = arg2.getStringValue();
        String result = null;
        if (collator instanceof CodepointCollator) {
            int i = s1.indexOf(s2);
            result = i < 0 ? "" : s1.substring(i + s2.length());
        } else {
            if (collator instanceof SimpleCollation && ((SimpleCollation)collator).getCollation() instanceof RuleBasedCollator) {
                collator = new RuleBasedSubstringMatcher((RuleBasedCollator)((SimpleCollation)collator).getCollation());
            }
            if (collator instanceof SubstringMatcher) {
                result = ((SubstringMatcher)collator).substringAfter(s1, s2);
            } else {
                this.dynamicError("The collation requested for " + this.getDisplayName() + " does not support substring matching", "FOCH0004", context);
            }
        }
        StringValue s3 = StringValue.makeStringValue(result);
        if (arg1.isKnownToContainNoSurrogates()) {
            s3.setContainsNoSurrogates();
        }
        return s3;
    }
}

