/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;

public class XPathContextMajor
extends XPathContextMinor {
    private ParameterSet localParameters;
    private ParameterSet tunnelParameters;
    private UserFunction tailCallFunction;
    private Mode currentMode;
    private Rule currentTemplate;
    private GroupIterator currentGroupIterator;
    private RegexIterator currentRegexIterator;
    boolean isTemporaryDestination = false;
    Object origin;
    private ThreadManager threadManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildThread(Thread t) {
        if (this.threadManager == null) {
            this.threadManager = new ThreadManager();
        }
        List<Thread> list = this.threadManager.threads;
        synchronized (list) {
            this.threadManager.addThread(t);
        }
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void createThreadManager() {
        this.threadManager = new ThreadManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChildThreads() throws XPathException {
        if (this.threadManager != null) {
            List<Thread> childThreads = this.threadManager.getChildThreads();
            while (!childThreads.isEmpty()) {
                try {
                    if (this.threadManager.errFound != null) {
                        throw this.threadManager.getException();
                    }
                    childThreads.get(0).join();
                    List<Thread> list = this.threadManager.threads;
                    synchronized (list) {
                        childThreads.remove(0);
                    }
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IndexOutOfBoundsException e) {
                }
            }
            if (this.threadManager.errFound != null) {
                XPathException err = this.threadManager.getException();
                this.threadManager.errFound = null;
                throw err;
            }
        }
    }

    public XPathContextMajor(Controller controller) {
        this.controller = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.origin = controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item item, Executable exec) {
        this.controller = new Controller(exec.getConfiguration(), exec);
        if (item != null) {
            UnfailingIterator<Item> iter = SingletonIterator.makeIterator(item);
            iter.next();
            this.currentIterator = iter;
            this.last = new XPathContextMinor.LastValue(1);
        }
        this.origin = this.controller;
    }

    public XPathContextMajor(Item item, Configuration config) {
        Executable exec = new Executable(config);
        exec.setHostLanguage(53, true);
        this.controller = new Controller(config, exec);
        if (item != null) {
            UnfailingIterator<Item> iter = SingletonIterator.makeIterator(item);
            iter.next();
            this.currentIterator = iter;
            this.last = new XPathContextMinor.LastValue(1);
        }
        this.origin = this.controller;
    }

    public XPathContextMajor newContext() {
        XPathContextMajor c = new XPathContextMajor();
        c.controller = this.controller;
        c.currentIterator = this.currentIterator;
        c.stackFrame = this.stackFrame;
        c.localParameters = this.localParameters;
        c.tunnelParameters = this.tunnelParameters;
        c.last = this.last;
        c.currentReceiver = this.currentReceiver;
        c.isTemporaryDestination = this.isTemporaryDestination;
        c.currentMode = this.currentMode;
        c.currentTemplate = this.currentTemplate;
        c.currentRegexIterator = this.currentRegexIterator;
        c.currentGroupIterator = this.currentGroupIterator;
        c.caller = this;
        c.tailCallFunction = null;
        c.threadManager = this.threadManager;
        return c;
    }

    public static XPathContextMajor newContext(XPathContextMinor prev) {
        XPathContextMajor c = new XPathContextMajor();
        XPathContext p = prev;
        while (!(p instanceof XPathContextMajor)) {
            p = p.getCaller();
        }
        c.controller = p.getController();
        c.currentIterator = prev.getCurrentIterator();
        c.stackFrame = prev.getStackFrame();
        c.localParameters = p.getLocalParameters();
        c.tunnelParameters = p.getTunnelParameters();
        c.last = prev.last;
        c.currentReceiver = prev.currentReceiver;
        c.isTemporaryDestination = ((XPathContextMajor)p).isTemporaryDestination;
        c.currentMode = p.getCurrentMode();
        c.currentTemplate = p.getCurrentTemplateRule();
        c.currentRegexIterator = p.getCurrentRegexIterator();
        c.currentGroupIterator = p.getCurrentGroupIterator();
        c.caller = prev;
        c.tailCallFunction = null;
        c.threadManager = ((XPathContextMajor)p).threadManager;
        return c;
    }

    public static XPathContextMajor newThreadContext(XPathContextMinor prev) {
        XPathContextMajor c = XPathContextMajor.newContext(prev);
        c.stackFrame = prev.stackFrame.copy();
        return c;
    }

    public ParameterSet getLocalParameters() {
        if (this.localParameters == null) {
            this.localParameters = new ParameterSet();
        }
        return this.localParameters;
    }

    public void setLocalParameters(ParameterSet localParameters) {
        this.localParameters = localParameters;
    }

    public ParameterSet getTunnelParameters() {
        return this.tunnelParameters;
    }

    public void setTunnelParameters(ParameterSet tunnelParameters) {
        this.tunnelParameters = tunnelParameters;
    }

    public void setOrigin(InstructionInfo expr) {
        this.origin = expr;
    }

    public void setOriginatingConstructType(int loc) {
        this.origin = loc;
    }

    public int getOriginatingConstructType() {
        if (this.origin == null) {
            return -1;
        }
        if (this.origin instanceof Expression) {
            if (this.origin instanceof SlashExpression) {
                return 2025;
            }
            return ((Expression)this.origin).getConstructType();
        }
        if (this.origin instanceof Integer) {
            return (Integer)this.origin;
        }
        if (this.origin instanceof InstructionInfo) {
            return ((InstructionInfo)this.origin).getConstructType();
        }
        return -1;
    }

    public InstructionInfo getOrigin() {
        if (this.origin instanceof InstructionInfo) {
            return (InstructionInfo)this.origin;
        }
        return null;
    }

    public void setStackFrame(SlotManager map, Sequence[] variables) {
        this.stackFrame = new StackFrame(map, variables);
        if (map != null && variables.length != map.getNumberOfVariables()) {
            if (variables.length > map.getNumberOfVariables()) {
                throw new IllegalStateException("Attempting to set more local variables (" + variables.length + ") than the stackframe can accommodate (" + map.getNumberOfVariables() + ")");
            }
            this.stackFrame.slots = new Sequence[map.getNumberOfVariables()];
            System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
        }
    }

    public void resetStackFrameMap(SlotManager map, int numberOfParams) {
        this.stackFrame.map = map;
        if (this.stackFrame.slots.length != map.getNumberOfVariables()) {
            Sequence[] v2 = new Sequence[map.getNumberOfVariables()];
            System.arraycopy(this.stackFrame.slots, 0, v2, 0, numberOfParams);
            this.stackFrame.slots = v2;
        } else {
            Arrays.fill(this.stackFrame.slots, numberOfParams, this.stackFrame.slots.length, null);
        }
    }

    public Sequence[] getAllVariableValues() {
        return this.stackFrame.getStackFrameValues();
    }

    public void resetAllVariableValues(Sequence[] values) {
        this.stackFrame.setStackFrameValues(values);
    }

    public void resetParameterValues(Sequence[] values) {
        System.arraycopy(values, 0, this.stackFrame.slots, 0, values.length);
    }

    public void requestTailCall(UserFunction fn, Sequence[] variables) {
        if (variables.length > this.stackFrame.slots.length) {
            Sequence[] v2 = new Sequence[fn.getStackFrameMap().getNumberOfVariables()];
            System.arraycopy(variables, 0, v2, 0, variables.length);
            this.stackFrame.slots = v2;
        } else {
            System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
        }
        this.tailCallFunction = fn;
    }

    public UserFunction getTailCallFunction() {
        UserFunction fn = this.tailCallFunction;
        this.tailCallFunction = null;
        return fn;
    }

    public void openStackFrame(SlotManager map) {
        int numberOfSlots = map.getNumberOfVariables();
        this.stackFrame = numberOfSlots == 0 ? StackFrame.EMPTY : new StackFrame(map, new Sequence[numberOfSlots]);
    }

    public void openStackFrame(int numberOfVariables) {
        this.stackFrame = new StackFrame(new SlotManager(numberOfVariables), new Sequence[numberOfVariables]);
    }

    public void setCurrentMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getCurrentMode() {
        Mode m3 = this.currentMode;
        if (m3 == null) {
            RuleManager rm = this.getController().getRuleManager();
            if (rm != null) {
                return rm.getUnnamedMode();
            }
            return null;
        }
        return m3;
    }

    public void setCurrentTemplateRule(Rule rule) {
        this.currentTemplate = rule;
    }

    public Rule getCurrentTemplateRule() {
        return this.currentTemplate;
    }

    public void setCurrentGroupIterator(GroupIterator iterator) {
        this.currentGroupIterator = iterator;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.currentGroupIterator;
    }

    public void setCurrentRegexIterator(RegexIterator currentRegexIterator) {
        this.currentRegexIterator = currentRegexIterator;
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.currentRegexIterator;
    }

    public int useLocalParameter(int parameterId, int slotNumber, boolean isTunnel) throws XPathException {
        Sequence val;
        ParameterSet params;
        ParameterSet parameterSet = params = isTunnel ? this.getTunnelParameters() : this.localParameters;
        if (params == null) {
            return 0;
        }
        int index = params.getIndex(parameterId);
        if (index < 0) {
            return 0;
        }
        this.stackFrame.slots[slotNumber] = val = params.getValue(index);
        boolean checked = params.isTypeChecked(index);
        return checked ? 2 : 1;
    }

    public void setTemporaryOutputState(boolean temporary) {
        this.isTemporaryDestination = temporary;
    }

    public boolean isTemporaryOutputState() {
        return this.isTemporaryDestination;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThreadManager {
        List<Thread> threads = new ArrayList<Thread>();
        Exception errFound;

        public void addThread(Thread t) {
            this.threads.add(t);
        }

        public List<Thread> getChildThreads() {
            return this.threads;
        }

        public void setException(Exception err) {
            this.errFound = err;
        }

        public XPathException getException() {
            if (this.errFound instanceof XPathException) {
                return (XPathException)this.errFound;
            }
            throw new AssertionError((Object)this.errFound);
        }
    }
}

