/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxisExpression
extends Expression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    private ItemType contextItemType = null;
    private int computedCardinality = -1;
    private boolean doneWarnings = false;
    private boolean contextMaybeUndefined = true;

    public AxisExpression(byte axis, NodeTest nodeTest) {
        this.axis = axis;
        this.test = nodeTest;
    }

    @Override
    public String getExpressionName() {
        return "axisStep";
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e2 = super.simplify(visitor);
        if (e2 != this) {
            return e2;
        }
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            ParentNodeExpression p = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, p);
            return p;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException("Axis step " + this.toString(visitor.getConfiguration().getNamePool()) + " cannot be used here: the context item is absent");
            err.setIsTypeError(true);
            err.setErrorCode("XPDY0002");
            err.setLocator(this);
            throw err;
        }
        this.contextMaybeUndefined = contextItemType.contextMaybeUndefined;
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        int relation = th.relationship(contextItemType.itemType, AnyNodeTest.getInstance());
        if (relation == 4) {
            XPathException err = new XPathException("Axis step " + this.toString(visitor.getConfiguration().getNamePool()) + " cannot be used here: the context item is not a node");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0020");
            err.setLocator(this);
            throw err;
        }
        if (relation == 3 || relation == 1) {
            ContextItemExpression exp = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, exp);
            RoleLocator role = new RoleLocator(14, AxisInfo.axisName[this.axis], 0);
            role.setErrorCode("XPTY0020");
            ItemChecker checker = new ItemChecker(exp, AnyNodeTest.getInstance(), role);
            ExpressionTool.copyLocationInfo(this, checker);
            SimpleStepExpression step = new SimpleStepExpression(checker, this);
            ExpressionTool.copyLocationInfo(this, step);
            return step;
        }
        StaticContext env = visitor.getStaticContext();
        if (this.contextItemType == contextItemType && this.doneWarnings) {
            return this;
        }
        this.contextItemType = contextItemType.itemType;
        this.doneWarnings = true;
        ItemType contextType = this.contextItemType;
        if (contextType instanceof NodeTest) {
            int origin = contextType.getPrimitiveType();
            if (origin != 0 && AxisInfo.isAlwaysEmpty(this.axis, origin)) {
                env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node will never select anything", this);
                return Literal.makeEmptySequence();
            }
            if (this.test != null) {
                SchemaType contentType;
                IntSet selectedElementNames;
                NodeTest elementTest;
                IntSet outermostElementNames;
                int kind = this.test.getPrimitiveType();
                if (kind != 0 && !AxisInfo.containsNodeKind(this.axis, kind)) {
                    env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes", this);
                    return Literal.makeEmptySequence();
                }
                if (this.axis == 12 && kind != 0 && origin != 0 && kind != origin) {
                    env.issueWarning("The self axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node", this);
                    return Literal.makeEmptySequence();
                }
                if (this.axis == 12) {
                    this.itemType = new CombinedNodeTest(this.test, 23, (NodeTest)contextType);
                }
                if (contextType instanceof DocumentNodeTest && kind == 1 && (outermostElementNames = (elementTest = ((DocumentNodeTest)contextType).getElementTest()).getRequiredNodeNames()) != null && (selectedElementNames = this.test.getRequiredNodeNames()) != null) {
                    if (this.axis == 3) {
                        if (selectedElementNames.intersect(outermostElementNames).isEmpty()) {
                            env.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this);
                            return Literal.makeEmptySequence();
                        }
                        if (env.isSchemaAware() && elementTest instanceof SchemaNodeTest && outermostElementNames.size() == 1) {
                            IntIterator oeni = outermostElementNames.iterator();
                            int outermostElementName = oeni.hasNext() ? oeni.next() : -1;
                            SchemaDeclaration decl = config.getElementDeclaration(outermostElementName);
                            if (decl == null) {
                                env.issueWarning("Element " + config.getNamePool().getDisplayName(outermostElementName) + " is not declared in the schema", this);
                                this.itemType = elementTest;
                            } else {
                                SchemaType contentType2 = decl.getType();
                                this.itemType = new CombinedNodeTest(elementTest, 23, new ContentTypeTest(1, contentType2, config, true));
                            }
                        } else {
                            this.itemType = elementTest;
                        }
                        return this;
                    }
                    if (this.axis == 4) {
                        boolean canMatchOutermost;
                        boolean bl = canMatchOutermost = !selectedElementNames.intersect(outermostElementNames).isEmpty();
                        if (!canMatchOutermost) {
                            Expression path = ExpressionTool.makePathExpression(new AxisExpression(3, elementTest), new AxisExpression(4, this.test), false);
                            ExpressionTool.copyLocationInfo(this, path);
                            return path.typeCheck(visitor, contextItemType);
                        }
                    }
                }
                if ((contentType = ((NodeTest)contextType).getContentType()) == AnyType.getInstance()) {
                    return this;
                }
                int targetfp = this.test.getFingerprint();
                if (contentType.isSimpleType()) {
                    if (!(this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 2 && kind != 9)) {
                        env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 2 ? "an attribute node" : AxisExpression.getStartingNodeDescription(contentType)), this);
                    } else if (this.axis == 3 && kind == 3 && visitor.getParentExpression() instanceof Atomizer) {
                        env.issueWarning("Selecting the text nodes of an element with simple content may give the wrong answer in the presence of comments or processing instructions. It is usually better to omit the '/text()' step", this);
                    } else if (this.axis == 2) {
                        Iterator<? extends SchemaType> extensions = config.getExtensionsOfType(contentType);
                        boolean found = false;
                        if (targetfp == -1) {
                            while (extensions.hasNext()) {
                                ComplexType extension = (ComplexType)extensions.next();
                                if (!extension.allowsAttributes()) continue;
                                found = true;
                                break;
                            }
                        } else {
                            while (extensions.hasNext()) {
                                ComplexType extension = (ComplexType)extensions.next();
                                try {
                                    if (extension.getAttributeUseType(targetfp) == null) continue;
                                    found = true;
                                    break;
                                }
                                catch (SchemaException e) {
                                }
                            }
                        }
                        if (!found) {
                            env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select " + (targetfp == -1 ? "any attribute nodes" : "an attribute node named " + AxisExpression.getDiagnosticName(targetfp, env)) + " when starting at " + AxisExpression.getStartingNodeDescription(contentType), this);
                        }
                    }
                } else {
                    if (!(!((ComplexType)contentType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 9)) {
                        env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + AxisExpression.getStartingNodeDescription(contentType) + ", as this type requires simple content", this);
                        return Literal.makeEmptySequence();
                    }
                    if (((ComplexType)contentType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                        Iterator<? extends SchemaType> iter = config.getExtensionsOfType(contentType);
                        while (iter.hasNext()) {
                            ComplexType extension = (ComplexType)iter.next();
                            if (extension.isEmptyContent()) continue;
                            return this;
                        }
                        env.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any" + " nodes when starting at " + AxisExpression.getStartingNodeDescription(contentType) + ", as this type requires empty content", this);
                        return Literal.makeEmptySequence();
                    }
                    if (this.axis == 2) {
                        if (targetfp == -1) {
                            if (!((ComplexType)contentType).allowsAttributes()) {
                                env.issueWarning("The complex type " + contentType.getDescription() + " allows no attributes other than the standard attributes in the xsi namespace", this);
                            }
                        } else {
                            try {
                                SimpleType schemaType = targetfp == 641 ? BuiltInAtomicType.QNAME : (targetfp == 643 ? BuiltInListType.ANY_URIS : (targetfp == 644 ? BuiltInAtomicType.ANY_URI : (targetfp == 642 ? BuiltInAtomicType.BOOLEAN : ((ComplexType)contentType).getAttributeUseType(targetfp))));
                                if (schemaType == null) {
                                    env.issueWarning("The complex type " + contentType.getDescription() + " does not allow an attribute named " + AxisExpression.getDiagnosticName(targetfp, env), this);
                                    return Literal.makeEmptySequence();
                                }
                                this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType, env.getConfiguration(), false));
                            }
                            catch (SchemaException e) {}
                        }
                    } else if (this.axis == 3 && kind == 1) {
                        try {
                            SchemaType schemaType;
                            int childElement = targetfp;
                            if (targetfp == -1) {
                                if (((ComplexType)contentType).containsElementWildcard()) {
                                    return this;
                                }
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children, false);
                                if (children.isEmpty()) {
                                    env.issueWarning("The complex type " + contentType.getDescription() + " does not allow children", this);
                                    return Literal.makeEmptySequence();
                                }
                                if (children.size() == 1) {
                                    IntIterator iter = children.iterator();
                                    if (iter.hasNext()) {
                                        childElement = iter.next();
                                    }
                                } else {
                                    return this;
                                }
                            }
                            if ((schemaType = ((ComplexType)contentType).getElementParticleType(childElement, true)) == null) {
                                env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a child element named " + AxisExpression.getDiagnosticName(childElement, env), this);
                                return Literal.makeEmptySequence();
                            }
                            this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType, env.getConfiguration(), true));
                            this.computedCardinality = ((ComplexType)contentType).getElementParticleCardinality(childElement, true);
                            visitor.resetStaticProperties();
                            if (this.computedCardinality == 8192) {
                                env.issueWarning("The complex type " + contentType.getDescription() + " appears not to allow a child element named " + AxisExpression.getDiagnosticName(childElement, env), this);
                                return Literal.makeEmptySequence();
                            }
                            if (!Cardinality.allowsMany(this.computedCardinality)) {
                                return FirstItemExpression.makeFirstItemExpression(this);
                            }
                        }
                        catch (SchemaException e) {}
                    } else if (this.axis == 4 && kind == 1 && targetfp != -1) {
                        try {
                            IntHashSet descendants = new IntHashSet();
                            ((ComplexType)contentType).gatherAllPermittedDescendants(descendants);
                            if (descendants.contains(-1)) {
                                return this;
                            }
                            if (descendants.contains(targetfp)) {
                                SchemaType st;
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children, false);
                                IntHashSet usefulChildren = new IntHashSet();
                                boolean considerSelf = false;
                                boolean considerDescendants = false;
                                IntIterator child = children.iterator();
                                while (child.hasNext()) {
                                    SchemaType st2;
                                    int c = child.next();
                                    if (c == targetfp) {
                                        usefulChildren.add(c);
                                        considerSelf = true;
                                    }
                                    if ((st2 = ((ComplexType)contentType).getElementParticleType(c, true)) == null) {
                                        throw new AssertionError((Object)("Can't find type for child element " + c));
                                    }
                                    if (!(st2 instanceof ComplexType)) continue;
                                    IntHashSet subDescendants = new IntHashSet();
                                    ((ComplexType)st2).gatherAllPermittedDescendants(subDescendants);
                                    if (!subDescendants.contains(targetfp)) continue;
                                    usefulChildren.add(c);
                                    considerDescendants = true;
                                }
                                this.itemType = this.test;
                                if (considerDescendants && (st = ((ComplexType)contentType).getDescendantElementType(targetfp)) != AnyType.getInstance()) {
                                    this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, st, config, true));
                                }
                                if (usefulChildren.size() < children.size()) {
                                    NodeTest childTest = this.makeUnionNodeTest(usefulChildren, visitor.getConfiguration().getNamePool());
                                    AxisExpression first = new AxisExpression(3, childTest);
                                    ExpressionTool.copyLocationInfo(this, first);
                                    byte nextAxis = considerSelf ? (considerDescendants ? (byte)5 : 12) : (byte)4;
                                    AxisExpression next = new AxisExpression(nextAxis, (NodeTest)this.itemType);
                                    ExpressionTool.copyLocationInfo(this, next);
                                    Expression path = ExpressionTool.makePathExpression(first, next, false);
                                    ExpressionTool.copyLocationInfo(this, path);
                                    return path.typeCheck(visitor, contextItemType);
                                }
                            } else {
                                env.issueWarning("The complex type " + contentType.getDescription() + " does not allow a descendant element named " + AxisExpression.getDiagnosticName(targetfp, env), this);
                            }
                        }
                        catch (SchemaException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
        }
        return this;
    }

    private static String getDiagnosticName(int fp, StaticContext env) {
        NamePool pool = env.getNamePool();
        String uri = pool.getURI(fp);
        NamespaceResolver resolver = env.getNamespaceResolver();
        Iterator<String> it = resolver.iteratePrefixes();
        while (it.hasNext()) {
            String prefix = it.next();
            if (!uri.equals(resolver.getURIForPrefix(prefix, true))) continue;
            if (prefix.length() == 0) {
                return "{" + uri + "}" + pool.getLocalName(fp);
            }
            return prefix + ":" + pool.getLocalName(fp);
        }
        return "{" + uri + "}" + pool.getLocalName(fp);
    }

    private static String getStartingNodeDescription(SchemaType type) {
        String s2 = type.getDescription();
        if (s2.startsWith("of element")) {
            return "a valid element named" + s2.substring("of element".length());
        }
        if (s2.startsWith("of attribute")) {
            return "a valid attribute named" + s2.substring("of attribute".length());
        }
        return "a node with " + (type.isSimpleType() ? "simple" : "complex") + " type " + s2;
    }

    private NodeTest makeUnionNodeTest(IntHashSet elements, NamePool pool) {
        NodeTest test = null;
        IntIterator iter = elements.iterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            NameTest nextTest = new NameTest(1, fp, pool);
            if (test == null) {
                test = nextTest;
                continue;
            }
            test = new CombinedNodeTest(test, 1, nextTest);
        }
        return test;
    }

    public ItemType getContextItemType() {
        return this.contextItemType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)other).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)other).test == null;
        }
        return this.test.toString().equals(((AxisExpression)other).test.toString());
    }

    public int hashCode() {
        int h2 = 9375162 + this.axis << 20;
        if (this.test != null) {
            h2 ^= this.test.getPrimitiveType() << 16;
            h2 ^= this.test.getFingerprint();
        }
        return h2;
    }

    @Override
    public Expression copy() {
        AxisExpression a2 = new AxisExpression(this.axis, this.test);
        a2.itemType = this.itemType;
        a2.contextItemType = this.contextItemType;
        a2.computedCardinality = this.computedCardinality;
        a2.doneWarnings = this.doneWarnings;
        return a2;
    }

    @Override
    public int computeSpecialProperties() {
        return 0xC10000 | (AxisInfo.isForwards[this.axis] ? 131072 : 262144) | (AxisInfo.isPeerAxis[this.axis] ? 524288 : 0) | (AxisInfo.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        short p = AxisInfo.principalNodeType[this.axis];
        switch (p) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(p);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public final int computeCardinality() {
        NodeTest originNodeType;
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        NodeTest nodeTest = this.test;
        if (this.contextItemType instanceof NodeTest) {
            originNodeType = (NodeTest)this.contextItemType;
        } else if (this.contextItemType instanceof AnyItemType) {
            originNodeType = AnyNodeTest.getInstance();
        } else {
            return 57344;
        }
        if (this.axis == 2 && nodeTest instanceof NameTest) {
            SchemaType contentType = originNodeType.getContentType();
            if (contentType instanceof ComplexType) {
                try {
                    return ((ComplexType)contentType).getAttributeUseCardinality(nodeTest.getFingerprint());
                }
                catch (SchemaException err) {
                    return 24576;
                }
            }
            if (contentType instanceof SimpleType) {
                return 8192;
            }
            return 24576;
        }
        if (this.axis == 4 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
            SchemaType contentType = originNodeType.getContentType();
            if (contentType instanceof ComplexType) {
                try {
                    return ((ComplexType)contentType).getDescendantElementCardinality(nodeTest.getFingerprint());
                }
                catch (SchemaException err) {
                    return 57344;
                }
            }
            return 8192;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public boolean isSubtreeExpression() {
        return AxisInfo.isSubtreeAxis[this.axis];
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        return pathMapNodeSet.createArc(this.axis, this.test == null ? AnyNodeTest.getInstance() : this.test);
    }

    public boolean isContextPossiblyUndefined() {
        return this.contextMaybeUndefined;
    }

    private void addFreeRangingMessage(int axis, List<String> reasons) {
        if (reasons != null) {
            reasons.add("The " + AxisInfo.axisName[axis] + " axis in a general context is free-ranging (used at line " + this.getLineNumber() + ")");
        }
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        NodeTest test = this.getNodeTest();
        if (test == null) {
            test = AnyNodeTest.getInstance();
        }
        if (test instanceof AnyNodeTest && (this.axis == 3 || this.axis == 4)) {
            test = AnyChildNodeTest.getInstance();
        }
        int kind = test.getPrimitiveType();
        if (this.axis == 12) {
            return new ItemTypePattern(test);
        }
        if (this.axis == 2) {
            if (kind == 0) {
                return new ItemTypePattern(NodeKindTest.ATTRIBUTE);
            }
            if (!AxisInfo.containsNodeKind(this.axis, kind)) {
                return new ItemTypePattern(ErrorType.getInstance());
            }
            return new ItemTypePattern(test);
        }
        if (this.axis == 3 || this.axis == 4 || this.axis == 5) {
            if (kind != 0 && !AxisInfo.containsNodeKind(this.axis, kind)) {
                return new ItemTypePattern(ErrorType.getInstance());
            }
            return new ItemTypePattern(test);
        }
        if (this.axis == 8) {
            if (kind == 0) {
                return new ItemTypePattern(NodeKindTest.NAMESPACE);
            }
            if (!AxisInfo.containsNodeKind(this.axis, kind)) {
                return new ItemTypePattern(ErrorType.getInstance());
            }
            return new ItemTypePattern(test);
        }
        throw new XPathException("Only downwards axes are allowed in a pattern", "XTSE0340");
    }

    public AxisIterator<? extends NodeInfo> iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception err) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is absent");
            err.setErrorCode("XPDY0002");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (ClassCastException cce) {
            NamePool pool;
            try {
                pool = context.getConfiguration().getNamePool();
            }
            catch (Exception err) {
                pool = null;
            }
            XPathException err = new XPathException("The context item for axis step " + (pool == null ? this.toString() : this.toString(pool)) + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (UnsupportedOperationException err) {
            if (err.getCause() instanceof XPathException) {
                XPathException ec = (XPathException)err.getCause();
                ec.maybeSetLocation(this);
                ec.maybeSetContext(context);
                throw ec;
            }
            this.dynamicError(err.getMessage(), "XPST0010", context);
            return null;
        }
    }

    public SequenceIterator iterate(Item origin) throws XPathException {
        try {
            if (this.test == null) {
                return ((NodeInfo)origin).iterateAxis(this.axis);
            }
            return ((NodeInfo)origin).iterateAxis(this.axis, this.test);
        }
        catch (ClassCastException cce) {
            XPathException err = new XPathException("The context item for axis step " + this.toString() + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("axis");
        destination.emitAttribute("name", AxisInfo.axisName[this.axis]);
        destination.emitAttribute("nodeTest", this.test == null ? "node()" : this.test.toString());
        destination.endElement();
    }

    @Override
    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        fsb.append(AxisInfo.axisName[this.axis]);
        fsb.append("::");
        fsb.append(this.test == null ? "node()" : this.test.toString());
        return fsb.toString();
    }

    public String toString(NamePool pool) {
        FastStringBuffer fsb = new FastStringBuffer(16);
        fsb.append(AxisInfo.axisName[this.axis]);
        fsb.append("::");
        fsb.append(this.test == null ? "node()" : this.test.toString());
        return fsb.toString();
    }
}

