/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.thymeleaf.util.Validate;

public class SubscriptionUtil {
    private static void populatePrimitiveValue(FhirContext theContext, IBaseResource theSubscription, String theChildName, String theValue) {
        IPrimitiveType instance;
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theSubscription);
        Validate.isTrue(def.getName().equals("Subscription"), "theResource is not a subscription");
        BaseRuntimeChildDefinition statusChild = def.getChildByName(theChildName);
        List<IBase> entries = statusChild.getAccessor().getValues(theSubscription);
        if (entries.size() == 0) {
            BaseRuntimeElementDefinition<?> statusElement = statusChild.getChildByName(theChildName);
            instance = (IPrimitiveType)statusElement.newInstance(statusChild.getInstanceConstructorArguments());
            statusChild.getMutator().addValue(theSubscription, instance);
        } else {
            instance = (IPrimitiveType)entries.get(0);
        }
        instance.setValueAsString(theValue);
    }

    public static void setReason(FhirContext theContext, IBaseResource theSubscription, String theMessage) {
        SubscriptionUtil.populatePrimitiveValue(theContext, theSubscription, "reason", theMessage);
    }

    public static void setStatus(FhirContext theContext, IBaseResource theSubscription, String theStatus) {
        SubscriptionUtil.populatePrimitiveValue(theContext, theSubscription, "status", theStatus);
    }
}

