/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.primitive.StringDt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ParametersUtil {
    public static List<String> getNamedParameterValuesAsString(FhirContext theCtx, IBaseParameters theParameters, String theParameterName) {
        Function<IPrimitiveType, String> mapper = t -> StringUtils.defaultIfBlank(t.getValueAsString(), null);
        return ParametersUtil.extractNamedParameters(theCtx, theParameters, theParameterName, mapper);
    }

    public static List<Integer> getNamedParameterValuesAsInteger(FhirContext theCtx, IBaseParameters theParameters, String theParameterName) {
        Function<IPrimitiveType, Integer> mapper = t -> (Integer)t.getValue();
        return ParametersUtil.extractNamedParameters(theCtx, theParameters, theParameterName, mapper);
    }

    public static Optional<Integer> getNamedParameterValueAsInteger(FhirContext theCtx, IBaseParameters theParameters, String theParameterName) {
        return ParametersUtil.getNamedParameterValuesAsInteger(theCtx, theParameters, theParameterName).stream().findFirst();
    }

    private static <T> List<T> extractNamedParameters(FhirContext theCtx, IBaseParameters theParameters, String theParameterName, Function<IPrimitiveType<?>, T> theMapper) {
        Validate.notNull(theParameters, "theParameters must not be null", new Object[0]);
        RuntimeResourceDefinition resDef = theCtx.getResourceDefinition(theParameters.getClass());
        BaseRuntimeChildDefinition parameterChild = resDef.getChildByName("parameter");
        List<IBase> parameterReps = parameterChild.getAccessor().getValues(theParameters);
        ArrayList retVal = new ArrayList();
        for (IBase nextParameter : parameterReps) {
            BaseRuntimeElementCompositeDefinition nextParameterDef = (BaseRuntimeElementCompositeDefinition)theCtx.getElementDefinition(nextParameter.getClass());
            BaseRuntimeChildDefinition nameChild = nextParameterDef.getChildByName("name");
            List<IBase> nameValues = nameChild.getAccessor().getValues(nextParameter);
            Optional<IPrimitiveType> nameValue = nameValues.stream().filter(t -> t instanceof IPrimitiveType).map(t -> (IPrimitiveType)t).findFirst();
            if (!nameValue.isPresent() || !theParameterName.equals(nameValue.get().getValueAsString())) continue;
            BaseRuntimeChildDefinition valueChild = nextParameterDef.getChildByName("value[x]");
            List<IBase> valueValues = valueChild.getAccessor().getValues(nextParameter);
            valueValues.stream().filter(t -> t instanceof IPrimitiveType).map(t -> (IPrimitiveType)t).map(theMapper).filter(t -> t != null).forEach(retVal::add);
        }
        return retVal;
    }

    private static void addClientParameter(FhirContext theContext, Object theValue, IBaseResource theTargetResource, BaseRuntimeChildDefinition paramChild, BaseRuntimeElementCompositeDefinition<?> paramChildElem, String theName) {
        Validate.notNull(theValue, "theValue must not be null", new Object[0]);
        if (theValue instanceof IBaseResource) {
            IBase parameter = ParametersUtil.createParameterRepetition(theContext, theTargetResource, paramChild, paramChildElem, theName);
            paramChildElem.getChildByName("resource").getMutator().addValue(parameter, (IBaseResource)theValue);
        } else if (theValue instanceof IBaseDatatype) {
            IBase parameter = ParametersUtil.createParameterRepetition(theContext, theTargetResource, paramChild, paramChildElem, theName);
            paramChildElem.getChildByName("value[x]").getMutator().addValue(parameter, (IBaseDatatype)theValue);
        } else if (theValue instanceof Collection) {
            Collection collection = (Collection)theValue;
            for (Object next : collection) {
                ParametersUtil.addClientParameter(theContext, next, theTargetResource, paramChild, paramChildElem, theName);
            }
        } else {
            throw new IllegalArgumentException("Don't know how to handle value of type " + theValue.getClass() + " for parameter " + theName);
        }
    }

    public static void addParameterToParameters(FhirContext theContext, IBaseParameters theParameters, String theName, Object theValue) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theParameters);
        BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
        BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
        ParametersUtil.addClientParameter(theContext, theValue, theParameters, paramChild, paramChildElem, theName);
    }

    public static void addParameterToParameters(FhirContext theContext, IBaseParameters theParameters, String theName, String thePrimitiveDatatype, String theValue) {
        Validate.notBlank(thePrimitiveDatatype, "thePrimitiveDatatype must not be null or empty", new Object[0]);
        BaseRuntimeElementDefinition<?> datatypeDef = theContext.getElementDefinition(thePrimitiveDatatype);
        IPrimitiveType value = (IPrimitiveType)datatypeDef.newInstance();
        value.setValueAsString(theValue);
        ParametersUtil.addParameterToParameters(theContext, theParameters, theName, value);
    }

    private static IBase createParameterRepetition(FhirContext theContext, IBaseResource theTargetResource, BaseRuntimeChildDefinition paramChild, BaseRuntimeElementCompositeDefinition<?> paramChildElem, String theName) {
        Object parameter = paramChildElem.newInstance();
        paramChild.getMutator().addValue(theTargetResource, (IBase)parameter);
        IPrimitiveType<?> value = ParametersUtil.createString(theContext, theName);
        paramChildElem.getChildByName("name").getMutator().addValue((IBase)parameter, value);
        return parameter;
    }

    public static IPrimitiveType<?> createString(FhirContext theContext, String theValue) {
        IPrimitiveType<String> value = theContext.getVersion().getVersion().isRi() ? (IPrimitiveType)theContext.getElementDefinition("string").newInstance(theValue) : new StringDt(theValue);
        return value;
    }

    public static IPrimitiveType<?> createUri(FhirContext theContext, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theContext.getElementDefinition("uri").newInstance(theValue);
        return value;
    }

    public static IPrimitiveType<?> createCode(FhirContext theContext, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theContext.getElementDefinition("code").newInstance(theValue);
        return value;
    }

    public static IBaseParameters newInstance(FhirContext theContext) {
        Validate.notNull(theContext, "theContext must not be null", new Object[0]);
        return (IBaseParameters)theContext.getResourceDefinition("Parameters").newInstance();
    }

    public static void addParameterToParametersBoolean(FhirContext theCtx, IBaseParameters theParameters, String theName, boolean theValue) {
        IPrimitiveType value = (IPrimitiveType)theCtx.getElementDefinition("boolean").newInstance();
        value.setValue(theValue);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, value);
    }

    public static void addParameterToParametersCode(FhirContext theCtx, IBaseParameters theParameters, String theName, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theCtx.getElementDefinition("code").newInstance();
        value.setValue(theValue);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, value);
    }

    public static void addParameterToParametersInteger(FhirContext theCtx, IBaseParameters theParameters, String theName, int theValue) {
        IPrimitiveType count = (IPrimitiveType)theCtx.getElementDefinition("integer").newInstance();
        count.setValue(theValue);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, count);
    }

    public static void addParameterToParametersReference(FhirContext theCtx, IBaseParameters theParameters, String theName, String theReference) {
        IBaseReference target = (IBaseReference)theCtx.getElementDefinition("reference").newInstance();
        target.setReference(theReference);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, target);
    }

    public static void addParameterToParametersString(FhirContext theCtx, IBaseParameters theParameters, String theName, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theCtx.getElementDefinition("string").newInstance();
        value.setValue(theValue);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, value);
    }

    public static void addParameterToParametersUri(FhirContext theCtx, IBaseParameters theParameters, String theName, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theCtx.getElementDefinition("uri").newInstance();
        value.setValue(theValue);
        ParametersUtil.addParameterToParameters(theCtx, theParameters, theName, value);
    }

    public static IBase addParameterToParameters(FhirContext theContext, IBaseParameters theParameters, String theName) {
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theParameters);
        BaseRuntimeChildDefinition paramChild = def.getChildByName("parameter");
        BaseRuntimeElementCompositeDefinition paramChildElem = (BaseRuntimeElementCompositeDefinition)paramChild.getChildByName("parameter");
        return ParametersUtil.createParameterRepetition(theContext, theParameters, paramChild, paramChildElem, theName);
    }

    public static void addPartCode(FhirContext theContext, IBase theParameter, String theName, String theCode) {
        IPrimitiveType value = (IPrimitiveType)theContext.getElementDefinition("code").newInstance();
        value.setValue(theCode);
        ParametersUtil.addPart(theContext, theParameter, theName, value);
    }

    public static void addPartString(FhirContext theContext, IBase theParameter, String theName, String theValue) {
        IPrimitiveType value = (IPrimitiveType)theContext.getElementDefinition("string").newInstance();
        value.setValue(theValue);
        ParametersUtil.addPart(theContext, theParameter, theName, value);
    }

    public static void addPartCoding(FhirContext theContext, IBase theParameter, String theName, String theSystem, String theCode, String theDisplay) {
        Object coding = theContext.getElementDefinition("coding").newInstance();
        BaseRuntimeElementCompositeDefinition codingDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(coding.getClass());
        codingDef.getChildByName("system").getMutator().addValue((IBase)coding, ParametersUtil.createUri(theContext, theSystem));
        codingDef.getChildByName("code").getMutator().addValue((IBase)coding, ParametersUtil.createCode(theContext, theCode));
        codingDef.getChildByName("display").getMutator().addValue((IBase)coding, ParametersUtil.createString(theContext, theDisplay));
        ParametersUtil.addPart(theContext, theParameter, theName, coding);
    }

    public static void addPart(FhirContext theContext, IBase theParameter, String theName, IBase theValue) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(theParameter.getClass());
        BaseRuntimeChildDefinition partChild = def.getChildByName("part");
        BaseRuntimeElementCompositeDefinition partChildElem = (BaseRuntimeElementCompositeDefinition)partChild.getChildByName("part");
        Object part = partChildElem.newInstance();
        partChild.getMutator().addValue(theParameter, (IBase)part);
        IPrimitiveType name = (IPrimitiveType)theContext.getElementDefinition("string").newInstance();
        name.setValue(theName);
        partChildElem.getChildByName("name").getMutator().addValue((IBase)part, name);
        partChildElem.getChildByName("value[x]").getMutator().addValue((IBase)part, theValue);
    }

    public static void addPartResource(FhirContext theContext, IBase theParameter, String theName, IBaseResource theValue) {
        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(theParameter.getClass());
        BaseRuntimeChildDefinition partChild = def.getChildByName("part");
        BaseRuntimeElementCompositeDefinition partChildElem = (BaseRuntimeElementCompositeDefinition)partChild.getChildByName("part");
        Object part = partChildElem.newInstance();
        partChild.getMutator().addValue(theParameter, (IBase)part);
        IPrimitiveType name = (IPrimitiveType)theContext.getElementDefinition("string").newInstance();
        name.setValue(theName);
        partChildElem.getChildByName("name").getMutator().addValue((IBase)part, name);
        partChildElem.getChildByName("resource").getMutator().addValue((IBase)part, theValue);
    }
}

