/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.exceptions.PayloadTooLargeException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;

public abstract class BaseServerResponseException
extends RuntimeException {
    private static final Map<Integer, Class<? extends BaseServerResponseException>> ourStatusCodeToExceptionType = new HashMap<Integer, Class<? extends BaseServerResponseException>>();
    private static final long serialVersionUID = 1L;
    private List<String> myAdditionalMessages = null;
    private IBaseOperationOutcome myBaseOperationOutcome;
    private String myResponseBody;
    private Map<String, List<String>> myResponseHeaders;
    private String myResponseMimeType;
    private int myStatusCode;
    private boolean myErrorMessageTrusted;

    public BaseServerResponseException(int theStatusCode, String theMessage) {
        super(theMessage);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = null;
    }

    public BaseServerResponseException(int theStatusCode, String ... theMessages) {
        super(theMessages != null && theMessages.length > 0 ? theMessages[0] : null);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = null;
        if (theMessages != null && theMessages.length > 1) {
            this.myAdditionalMessages = Arrays.asList((String[])Arrays.copyOfRange(theMessages, 1, theMessages.length, String[].class));
        }
    }

    public BaseServerResponseException(int theStatusCode, String theMessage, IBaseOperationOutcome theBaseOperationOutcome) {
        super(theMessage);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = theBaseOperationOutcome;
    }

    public BaseServerResponseException(int theStatusCode, String theMessage, Throwable theCause) {
        super(theMessage, theCause);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = null;
    }

    public BaseServerResponseException(int theStatusCode, String theMessage, Throwable theCause, IBaseOperationOutcome theBaseOperationOutcome) {
        super(theMessage, theCause);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = theBaseOperationOutcome;
    }

    public BaseServerResponseException(int theStatusCode, Throwable theCause) {
        super(theCause.getMessage(), theCause);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = null;
    }

    public BaseServerResponseException(int theStatusCode, Throwable theCause, IBaseOperationOutcome theBaseOperationOutcome) {
        super(theCause.toString(), theCause);
        this.myStatusCode = theStatusCode;
        this.myBaseOperationOutcome = theBaseOperationOutcome;
    }

    public boolean isErrorMessageTrusted() {
        return this.myErrorMessageTrusted;
    }

    public BaseServerResponseException setErrorMessageTrusted(boolean theErrorMessageTrusted) {
        this.myErrorMessageTrusted = theErrorMessageTrusted;
        return this;
    }

    public BaseServerResponseException addResponseHeader(String theName, String theValue) {
        Validate.notBlank(theName, "theName must not be null or empty", new Object[0]);
        Validate.notBlank(theValue, "theValue must not be null or empty", new Object[0]);
        if (!this.getResponseHeaders().containsKey(theName)) {
            this.getResponseHeaders().put(theName, new ArrayList());
        }
        this.getResponseHeaders().get(theName).add(theValue);
        return this;
    }

    public List<String> getAdditionalMessages() {
        return this.myAdditionalMessages;
    }

    public IBaseOperationOutcome getOperationOutcome() {
        return this.myBaseOperationOutcome;
    }

    public void setOperationOutcome(IBaseOperationOutcome theBaseOperationOutcome) {
        this.myBaseOperationOutcome = theBaseOperationOutcome;
    }

    public String getResponseBody() {
        return this.myResponseBody;
    }

    public void setResponseBody(String theResponseBody) {
        this.myResponseBody = theResponseBody;
    }

    public Map<String, List<String>> getResponseHeaders() {
        if (this.myResponseHeaders == null) {
            this.myResponseHeaders = new HashMap<String, List<String>>();
        }
        return this.myResponseHeaders;
    }

    public String getResponseMimeType() {
        return this.myResponseMimeType;
    }

    public void setResponseMimeType(String theResponseMimeType) {
        this.myResponseMimeType = theResponseMimeType;
    }

    public int getStatusCode() {
        return this.myStatusCode;
    }

    public boolean hasResponseHeaders() {
        return this.myResponseHeaders != null && !this.myResponseHeaders.isEmpty();
    }

    static boolean isExceptionTypeRegistered(Class<?> theType) {
        return ourStatusCodeToExceptionType.values().contains(theType);
    }

    public static BaseServerResponseException newInstance(int theStatusCode, String theMessage) {
        if (ourStatusCodeToExceptionType.containsKey(theStatusCode)) {
            try {
                return ourStatusCodeToExceptionType.get(theStatusCode).getConstructor(String.class).newInstance(theMessage);
            }
            catch (InstantiationException e) {
                throw new InternalErrorException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalErrorException(e);
            }
            catch (IllegalArgumentException e) {
                throw new InternalErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new InternalErrorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InternalErrorException(e);
            }
            catch (SecurityException e) {
                throw new InternalErrorException(e);
            }
        }
        return new UnclassifiedServerFailureException(theStatusCode, theMessage);
    }

    static void registerExceptionType(int theStatusCode, Class<? extends BaseServerResponseException> theType) {
        if (ourStatusCodeToExceptionType.containsKey(theStatusCode)) {
            throw new Error("Can not register " + theType + " to status code " + theStatusCode + " because " + ourStatusCodeToExceptionType.get(theStatusCode) + " already registers that code");
        }
        ourStatusCodeToExceptionType.put(theStatusCode, theType);
    }

    static {
        BaseServerResponseException.registerExceptionType(413, PayloadTooLargeException.class);
        BaseServerResponseException.registerExceptionType(401, AuthenticationException.class);
        BaseServerResponseException.registerExceptionType(500, InternalErrorException.class);
        BaseServerResponseException.registerExceptionType(400, InvalidRequestException.class);
        BaseServerResponseException.registerExceptionType(405, MethodNotAllowedException.class);
        BaseServerResponseException.registerExceptionType(501, NotImplementedOperationException.class);
        BaseServerResponseException.registerExceptionType(304, NotModifiedException.class);
        BaseServerResponseException.registerExceptionType(404, ResourceNotFoundException.class);
        BaseServerResponseException.registerExceptionType(410, ResourceGoneException.class);
        BaseServerResponseException.registerExceptionType(412, PreconditionFailedException.class);
        BaseServerResponseException.registerExceptionType(409, ResourceVersionConflictException.class);
        BaseServerResponseException.registerExceptionType(422, UnprocessableEntityException.class);
        BaseServerResponseException.registerExceptionType(403, ForbiddenOperationException.class);
    }
}

