/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public enum EncodingEnum {
    JSON("application/json+fhir", "application/fhir+json", "json"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newJsonParser();
        }
    }
    ,
    XML("application/xml+fhir", "application/fhir+xml", "xml"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newXmlParser();
        }
    }
    ,
    RDF("application/x-turtle", "application/x-turtle", "text/turtle"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newRDFParser();
        }
    };

    public static final String JSON_PLAIN_STRING = "json";
    public static final String XML_PLAIN_STRING = "xml";
    private static Map<String, EncodingEnum> ourContentTypeToEncoding;
    private static Map<String, EncodingEnum> ourContentTypeToEncodingLegacy;
    private static Map<String, EncodingEnum> ourContentTypeToEncodingStrict;
    private String myFormatContentType;
    private String myResourceContentTypeLegacy;
    private String myResourceContentTypeNonLegacy;

    private EncodingEnum(String theResourceContentTypeLegacy, String theResourceContentType, String theFormatContentType) {
        this.myResourceContentTypeLegacy = theResourceContentTypeLegacy;
        this.myResourceContentTypeNonLegacy = theResourceContentType;
        this.myFormatContentType = theFormatContentType;
    }

    public String getFormatContentType() {
        return this.myFormatContentType;
    }

    public String getResourceContentType() {
        return this.myResourceContentTypeLegacy;
    }

    public String getResourceContentTypeNonLegacy() {
        return this.myResourceContentTypeNonLegacy;
    }

    public abstract IParser newParser(FhirContext var1);

    public static EncodingEnum detectEncoding(String theBody) {
        EncodingEnum retVal = EncodingEnum.detectEncodingNoDefault(theBody);
        retVal = ObjectUtils.defaultIfNull(retVal, XML);
        return retVal;
    }

    public static EncodingEnum detectEncodingNoDefault(String theBody) {
        EncodingEnum retVal = null;
        block4: for (int i = 0; i < theBody.length() && retVal == null; ++i) {
            switch (theBody.charAt(i)) {
                case '<': {
                    retVal = XML;
                    continue block4;
                }
                case '{': {
                    retVal = JSON;
                }
            }
        }
        return retVal;
    }

    public static EncodingEnum forContentType(String theContentType) {
        String contentTypeSplitted = EncodingEnum.getTypeWithoutCharset(theContentType);
        if (contentTypeSplitted == null) {
            return null;
        }
        return ourContentTypeToEncoding.get(contentTypeSplitted);
    }

    public static EncodingEnum forContentTypeStrict(String theContentType) {
        String contentTypeSplitted = EncodingEnum.getTypeWithoutCharset(theContentType);
        if (contentTypeSplitted == null) {
            return null;
        }
        return ourContentTypeToEncodingStrict.get(contentTypeSplitted);
    }

    static String getTypeWithoutCharset(String theContentType) {
        int end;
        int start;
        if (StringUtils.isBlank(theContentType)) {
            return null;
        }
        for (start = 0; start < theContentType.length() && theContentType.charAt(start) == ' '; ++start) {
        }
        for (end = start; end < theContentType.length() && theContentType.charAt(end) != ';'; ++end) {
        }
        while (end > start && theContentType.charAt(end - 1) == ' ') {
            --end;
        }
        String retVal = theContentType.substring(start, end);
        if (retVal.contains(" ")) {
            retVal = retVal.replace(' ', '+');
        }
        return retVal;
    }

    public static boolean isLegacy(String theContentType) {
        String contentTypeSplitted = EncodingEnum.getTypeWithoutCharset(theContentType);
        if (contentTypeSplitted == null) {
            return false;
        }
        return ourContentTypeToEncodingLegacy.containsKey(contentTypeSplitted);
    }

    static {
        ourContentTypeToEncoding = new HashMap<String, EncodingEnum>();
        ourContentTypeToEncodingLegacy = new HashMap<String, EncodingEnum>();
        for (EncodingEnum next : EncodingEnum.values()) {
            ourContentTypeToEncoding.put(next.myResourceContentTypeNonLegacy, next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeLegacy, next);
            ourContentTypeToEncodingLegacy.put(next.myResourceContentTypeLegacy, next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeNonLegacy.replace('+', ' '), next);
            ourContentTypeToEncoding.put(next.myResourceContentTypeLegacy.replace('+', ' '), next);
            ourContentTypeToEncodingLegacy.put(next.myResourceContentTypeLegacy.replace('+', ' '), next);
        }
        ourContentTypeToEncodingStrict = Collections.unmodifiableMap(new HashMap<String, EncodingEnum>(ourContentTypeToEncoding));
        ourContentTypeToEncoding.put("application/json", JSON);
        ourContentTypeToEncoding.put("application/xml", XML);
        ourContentTypeToEncoding.put("text/json", JSON);
        ourContentTypeToEncoding.put("text/xml", XML);
        ourContentTypeToEncoding.put(JSON_PLAIN_STRING, JSON);
        ourContentTypeToEncoding.put(XML_PLAIN_STRING, XML);
        ourContentTypeToEncodingLegacy = Collections.unmodifiableMap(ourContentTypeToEncodingLegacy);
    }
}

