/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class RuntimePrimitiveDatatypeDefinition
extends BaseRuntimeElementDefinition<IPrimitiveType<?>>
implements IRuntimeDatatypeDefinition {
    private Class<?> myNativeType;
    private BaseRuntimeElementDefinition<?> myProfileOf;
    private Class<? extends IBaseDatatype> myProfileOfType;
    private boolean mySpecialization;

    public RuntimePrimitiveDatatypeDefinition(DatatypeDef theDef, Class<? extends IPrimitiveType<?>> theImplementingClass, boolean theStandardType) {
        super(theDef.name(), theImplementingClass, theStandardType);
        String resourceName = theDef.name();
        if (StringUtils.isBlank(resourceName)) {
            throw new ConfigurationException("Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name: " + theImplementingClass.getCanonicalName());
        }
        this.mySpecialization = theDef.isSpecialization();
        this.myProfileOfType = theDef.profileOf();
        if (this.myProfileOfType.equals(IBaseDatatype.class)) {
            this.myProfileOfType = null;
        }
        this.determineNativeType(theImplementingClass);
    }

    private void determineNativeType(Class<? extends IPrimitiveType<?>> theImplementingClass) {
        Class<IPrimitiveType<?>> clazz = theImplementingClass;
        while (!clazz.equals(Object.class)) {
            Type typeVariable;
            Class rawClass;
            ParameterizedType superPt;
            Type rawType;
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType && (rawType = (superPt = (ParameterizedType)type).getRawType()) instanceof Class && ((rawClass = (Class)rawType).getName().endsWith(".BasePrimitive") || rawClass.getName().endsWith(".PrimitiveType")) && (typeVariable = superPt.getActualTypeArguments()[0]) instanceof Class) {
                this.myNativeType = (Class)typeVariable;
                break;
            }
            clazz = clazz.getSuperclass();
        }
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE;
    }

    public Class<?> getNativeType() {
        return this.myNativeType;
    }

    @Override
    public Class<? extends IBaseDatatype> getProfileOf() {
        return this.myProfileOfType;
    }

    @Override
    public boolean isProfileOf(Class<? extends IBaseDatatype> theType) {
        if (this.myProfileOfType != null) {
            if (this.myProfileOfType.equals(theType)) {
                return true;
            }
            if (this.myProfileOf instanceof IRuntimeDatatypeDefinition) {
                return ((IRuntimeDatatypeDefinition)((Object)this.myProfileOf)).isProfileOf(theType);
            }
        }
        return false;
    }

    @Override
    public boolean isSpecialization() {
        return this.mySpecialization;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
        if (this.myProfileOfType != null) {
            this.myProfileOf = theClassToElementDefinitions.get(this.myProfileOfType);
            if (this.myProfileOf == null) {
                StringBuilder b = new StringBuilder();
                b.append("Unknown profileOf value: ");
                b.append(this.myProfileOfType);
                b.append(" in type ");
                b.append(this.getImplementingClass().getName());
                b.append(" - Valid types: ");
                b.append(theClassToElementDefinitions.keySet());
                throw new ConfigurationException(b.toString());
            }
        }
    }
}

