/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class RuntimeChildChoiceDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private List<Class<? extends IBase>> myChoiceTypes;
    private Map<String, BaseRuntimeElementDefinition<?>> myNameToChildDefinition;
    private Map<Class<? extends IBase>, String> myDatatypeToElementName;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToElementDefinition;
    private String myReferenceSuffix;
    private List<Class<? extends IBaseResource>> myResourceTypes;

    public RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation, List<Class<? extends IBase>> theChoiceTypes) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
    }

    RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
    }

    void setChoiceTypes(List<Class<? extends IBase>> theChoiceTypes) {
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
    }

    public List<Class<? extends IBase>> getChoices() {
        return this.myChoiceTypes;
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myNameToChildDefinition.keySet();
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        assert (this.myNameToChildDefinition.containsKey(theName));
        return this.myNameToChildDefinition.get(theName);
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myNameToChildDefinition = new HashMap();
        this.myDatatypeToElementName = new HashMap<Class<? extends IBase>, String>();
        this.myDatatypeToElementDefinition = new HashMap();
        this.myResourceTypes = new ArrayList<Class<? extends IBaseResource>>();
        this.myReferenceSuffix = "Reference";
        for (Class<? extends IBase> next : this.myChoiceTypes) {
            BaseRuntimeElementDefinition<?> nextDef;
            String elementName = null;
            boolean nonPreferred = false;
            if (IBaseResource.class.isAssignableFrom(next)) {
                elementName = this.getElementName() + StringUtils.capitalize(next.getSimpleName());
                nextDef = this.findResourceReferenceDefinition(theClassToElementDefinitions);
                this.myNameToChildDefinition.put(this.getElementName() + "Reference", nextDef);
                this.myNameToChildDefinition.put(this.getElementName() + "Resource", nextDef);
                this.myResourceTypes.add(next);
            } else {
                IRuntimeDatatypeDefinition nextDefDatatype;
                BaseRuntimeElementDefinition<?> nextDefForChoice = nextDef = theClassToElementDefinitions.get(next);
                if (nextDef instanceof IRuntimeDatatypeDefinition && (nextDefDatatype = (IRuntimeDatatypeDefinition)((Object)nextDef)).getProfileOf() != null && !IPrimitiveType.class.isAssignableFrom(next)) {
                    nextDefForChoice = null;
                    nonPreferred = true;
                    Class<? extends IBaseDatatype> profileType = nextDefDatatype.getProfileOf();
                    BaseRuntimeElementDefinition<?> elementDef = theClassToElementDefinitions.get(profileType);
                    elementName = this.getElementName() + StringUtils.capitalize(elementDef.getName());
                }
                if (nextDefForChoice != null) {
                    elementName = this.getElementName() + StringUtils.capitalize(nextDefForChoice.getName());
                }
            }
            if (!(elementName == null || this.myNameToChildDefinition.containsKey(elementName) && nonPreferred)) {
                this.myNameToChildDefinition.put(elementName, nextDef);
            }
            if (IBaseResource.class.isAssignableFrom(next) || IBaseReference.class.isAssignableFrom(next)) {
                next = theContext.getVersion().getResourceReferenceType();
                elementName = this.getElementName() + this.myReferenceSuffix;
                this.myNameToChildDefinition.put(elementName, nextDef);
            }
            this.myDatatypeToElementDefinition.put(next, nextDef);
            if (this.myDatatypeToElementName.containsKey(next)) {
                String existing = this.myDatatypeToElementName.get(next);
                if (existing.equals(elementName)) continue;
                throw new ConfigurationException("Already have element name " + existing + " for datatype " + next.getSimpleName() + " in " + this.getElementName() + ", cannot add " + elementName);
            }
            this.myDatatypeToElementName.put(next, elementName);
        }
        this.myNameToChildDefinition = Collections.unmodifiableMap(this.myNameToChildDefinition);
        this.myDatatypeToElementName = Collections.unmodifiableMap(this.myDatatypeToElementName);
        this.myDatatypeToElementDefinition = Collections.unmodifiableMap(this.myDatatypeToElementDefinition);
        this.myResourceTypes = Collections.unmodifiableList(this.myResourceTypes);
    }

    public List<Class<? extends IBaseResource>> getResourceTypes() {
        return this.myResourceTypes;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        String retVal = this.myDatatypeToElementName.get(theDatatype);
        return retVal;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToElementDefinition.get(theDatatype);
    }

    public Set<Class<? extends IBase>> getValidChildTypes() {
        return Collections.unmodifiableSet(this.myDatatypeToElementDefinition.keySet());
    }
}

